/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import io.yunba.android.a.k;
import java.io.EOFException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.CommsCallback;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPersistableWireMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingReq;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingResp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRel;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class ClientState {
    private static final String PERSISTENCE_SENT_PREFIX;
    private static final String PERSISTENCE_CONFIRMED_PREFIX;
    private static final String PERSISTENCE_RECEIVED_PREFIX;
    private static final long MIN_MSG_ID = 1L;
    private static final long MAX_MSG_ID = Long.MAX_VALUE;
    private long nextMsgId = 0L;
    private Hashtable inUseMsgIds;
    private volatile Vector pendingMessages;
    private volatile Vector pendingFlows;
    private CommsTokenStore tokenStore;
    private ClientComms clientComms = null;
    private CommsCallback callback = null;
    private long keepAlive;
    private boolean cleanSession;
    private MqttClientPersistence persistence;
    private int maxInflight = 200;
    private int actualInFlight = 0;
    private int inFlightPubRels = 0;
    private Object queueLock = new Object();
    private Object quiesceLock = new Object();
    private boolean quiescing = false;
    private long lastOutboundActivity = 0L;
    private long lastInboundActivity = 0L;
    private MqttWireMessage pingCommand;
    private boolean pingOutstanding = false;
    private boolean connected = false;
    private Hashtable outboundQoS2 = null;
    private Hashtable outboundQoS1 = null;
    private Hashtable inboundQoS2 = null;
    private static final String className;
    private Logger log = LoggerFactory.getLogger(z[45], className);
    private static final String[] z;

    protected ClientState(MqttClientPersistence mqttClientPersistence, CommsTokenStore commsTokenStore, CommsCallback commsCallback, ClientComms clientComms) {
        this.log.setResourceName(clientComms.getClient().getClientId());
        this.log.finer(className, z[44], "");
        this.inUseMsgIds = new Hashtable();
        this.pendingMessages = new Vector(this.maxInflight);
        this.pendingFlows = new Vector();
        this.outboundQoS2 = new Hashtable();
        this.outboundQoS1 = new Hashtable();
        this.inboundQoS2 = new Hashtable();
        this.pingCommand = new MqttPingReq();
        this.inFlightPubRels = 0;
        this.actualInFlight = 0;
        this.persistence = mqttClientPersistence;
        this.callback = commsCallback;
        this.tokenStore = commsTokenStore;
        this.clientComms = clientComms;
        this.restoreState();
    }

    protected void setKeepAliveSecs(long l2) {
        this.keepAlive = l2 * 1000L;
    }

    protected long getKeepAlive() {
        return this.keepAlive;
    }

    protected void setCleanSession(boolean bl) {
        this.cleanSession = bl;
    }

    private String getSendPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_SENT_PREFIX + mqttWireMessage.getMessageId();
    }

    private String getSendConfirmPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_CONFIRMED_PREFIX + mqttWireMessage.getMessageId();
    }

    private String getReceivedPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_RECEIVED_PREFIX + mqttWireMessage.getMessageId();
    }

    protected void clearState() {
        this.log.fine(className, z[62], ">");
        this.persistence.clear();
        this.inUseMsgIds.clear();
        this.pendingMessages.clear();
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
    }

    private MqttWireMessage restoreMessage(String string, MqttPersistable mqttPersistable) {
        MqttWireMessage mqttWireMessage = null;
        try {
            mqttWireMessage = MqttWireMessage.createWireMessage(mqttPersistable);
        }
        catch (MqttException mqttException) {
            this.log.fine(className, z[29], z[31], new Object[]{string}, mqttException);
            if (mqttException.getCause() instanceof EOFException) {
                if (string != null) {
                    this.persistence.remove(string);
                }
            }
            throw mqttException;
        }
        this.log.fine(className, z[29], z[30], new Object[]{string, mqttWireMessage});
        return mqttWireMessage;
    }

    private void insertInOrder(Vector vector, MqttWireMessage mqttWireMessage) {
        long l2 = mqttWireMessage.getMessageId();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            MqttWireMessage mqttWireMessage2 = (MqttWireMessage)vector.elementAt(i2);
            long l3 = mqttWireMessage2.getMessageId();
            if (l3 <= l2) continue;
            vector.insertElementAt(mqttWireMessage, i2);
            return;
        }
        vector.addElement(mqttWireMessage);
    }

    private Vector reOrder(Vector vector) {
        int n2;
        Vector vector2 = new Vector();
        if (vector.size() == 0) {
            return vector2;
        }
        long l2 = 0L;
        long l3 = 0L;
        int n3 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            long l4 = ((MqttWireMessage)vector.elementAt(i2)).getMessageId();
            if (l4 - l2 > l3) {
                l3 = l4 - l2;
                n3 = i2;
            }
            l2 = l4;
        }
        long l5 = l2;
        long l6 = ((MqttWireMessage)vector.elementAt(0)).getMessageId();
        if (Long.MAX_VALUE - l5 + l6 > l3) {
            n3 = 0;
        }
        for (n2 = n3; n2 < vector.size(); ++n2) {
            vector2.addElement(vector.elementAt(n2));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            vector2.addElement(vector.elementAt(n2));
        }
        return vector2;
    }

    protected void restoreState() {
        String string;
        Enumeration enumeration = this.persistence.keys();
        long l2 = this.nextMsgId;
        Vector<String> vector = new Vector<String>();
        this.log.fine(className, z[53], z[50]);
        while (enumeration.hasMoreElements()) {
            MqttPersistableWireMessage mqttPersistableWireMessage;
            string = (String)enumeration.nextElement();
            Object object = this.persistence.get(string);
            if ((object = this.restoreMessage(string, (MqttPersistable)object)) == null) continue;
            if (string.startsWith(PERSISTENCE_RECEIVED_PREFIX)) {
                this.log.fine(className, z[53], z[49], new Object[]{string, object});
                this.inboundQoS2.put(new Long(((MqttWireMessage)object).getMessageId()), object);
                continue;
            }
            if (string.startsWith(PERSISTENCE_SENT_PREFIX)) {
                Object object2;
                mqttPersistableWireMessage = (MqttPublish)object;
                l2 = Math.max(mqttPersistableWireMessage.getMessageId(), l2);
                if (this.persistence.containsKey(this.getSendConfirmPersistenceKey(mqttPersistableWireMessage))) {
                    object2 = this.persistence.get(this.getSendConfirmPersistenceKey(mqttPersistableWireMessage));
                    if ((object2 = (MqttPubRel)this.restoreMessage(string, (MqttPersistable)object2)) != null) {
                        ((MqttWireMessage)object2).setDuplicate(true);
                        this.log.fine(className, z[53], z[47], new Object[]{string, object});
                        this.outboundQoS2.put(new Long(((MqttWireMessage)object2).getMessageId()), object2);
                    } else {
                        this.log.fine(className, z[53], z[52], new Object[]{string, object});
                    }
                } else {
                    mqttPersistableWireMessage.setDuplicate(true);
                    if (((MqttPublish)mqttPersistableWireMessage).getMessage().getQos() == 2) {
                        this.log.fine(className, z[53], z[51], new Object[]{string, object});
                        this.outboundQoS2.put(new Long(mqttPersistableWireMessage.getMessageId()), mqttPersistableWireMessage);
                    } else {
                        this.log.fine(className, z[53], z[48], new Object[]{string, object});
                        this.outboundQoS1.put(new Long(mqttPersistableWireMessage.getMessageId()), mqttPersistableWireMessage);
                    }
                }
                object2 = this.tokenStore.restoreToken((MqttPublish)mqttPersistableWireMessage);
                ((MqttDeliveryToken)object2).internalTok.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(new Long(mqttPersistableWireMessage.getMessageId()), new Long(mqttPersistableWireMessage.getMessageId()));
                continue;
            }
            if (!string.startsWith(PERSISTENCE_CONFIRMED_PREFIX) || this.persistence.containsKey(this.getSendPersistenceKey(mqttPersistableWireMessage = (MqttPubRel)object))) continue;
            vector.addElement(string);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.log.fine(className, z[53], z[46], new Object[]{string});
            this.persistence.remove(string);
        }
        this.nextMsgId = l2;
    }

    private void restoreInflightMessages() {
        Object object;
        Object k2;
        this.pendingMessages = new Vector(this.maxInflight);
        this.pendingFlows = new Vector();
        Enumeration enumeration = this.outboundQoS2.keys();
        while (enumeration.hasMoreElements()) {
            k2 = enumeration.nextElement();
            object = this.outboundQoS2.get(k2);
            if (object instanceof MqttPublish) {
                this.log.fine(className, z[17], z[18], new Object[]{k2});
                this.insertInOrder(this.pendingMessages, (MqttPublish)object);
                continue;
            }
            if (!(object instanceof MqttPubRel)) continue;
            this.log.fine(className, z[17], z[20], new Object[]{k2});
            this.insertInOrder(this.pendingFlows, (MqttPubRel)object);
        }
        enumeration = this.outboundQoS1.keys();
        while (enumeration.hasMoreElements()) {
            k2 = enumeration.nextElement();
            object = (MqttPublish)this.outboundQoS1.get(k2);
            this.log.fine(className, z[17], z[19], new Object[]{k2});
            this.insertInOrder(this.pendingMessages, (MqttWireMessage)object);
        }
        this.pendingFlows = this.reOrder(this.pendingFlows);
        this.pendingMessages = this.reOrder(this.pendingMessages);
    }

    public void send(MqttWireMessage mqttWireMessage, MqttToken mqttToken) {
        if (mqttWireMessage.isMessageIdRequired() && mqttWireMessage.getMessageId() == 0L) {
            mqttWireMessage.setMessageId(this.getNextMessageId());
        }
        if (mqttToken != null) {
            try {
                mqttToken.internalTok.setMessageID(mqttWireMessage.getMessageId());
            }
            catch (Exception exception) {}
        }
        if (mqttWireMessage instanceof MqttPublish) {
            Object object = this.queueLock;
            synchronized (object) {
                if (this.actualInFlight >= this.maxInflight) {
                    this.log.fine(className, z[75], z[76], new Object[]{new Integer(this.actualInFlight)});
                    throw new MqttException(32202);
                }
                MqttMessage mqttMessage = ((MqttPublish)mqttWireMessage).getMessage();
                this.log.fine(className, z[75], z[74], new Object[]{new Long(mqttWireMessage.getMessageId()), new Integer(mqttMessage.getQos()), mqttWireMessage});
                switch (mqttMessage.getQos()) {
                    case 2: {
                        this.outboundQoS2.put(new Long(mqttWireMessage.getMessageId()), mqttWireMessage);
                        this.persistence.put(this.getSendPersistenceKey(mqttWireMessage), (MqttPublish)mqttWireMessage);
                        break;
                    }
                    case 1: {
                        this.outboundQoS1.put(new Long(mqttWireMessage.getMessageId()), mqttWireMessage);
                        this.persistence.put(this.getSendPersistenceKey(mqttWireMessage), (MqttPublish)mqttWireMessage);
                    }
                }
                this.tokenStore.saveToken(mqttToken, mqttWireMessage);
                this.pendingMessages.addElement(mqttWireMessage);
                this.queueLock.notifyAll();
            }
        } else {
            this.log.fine(className, z[75], z[77], new Object[]{new Long(mqttWireMessage.getMessageId()), mqttWireMessage});
            if (mqttWireMessage instanceof MqttConnect) {
                Object object = this.queueLock;
                synchronized (object) {
                    this.tokenStore.saveToken(mqttToken, mqttWireMessage);
                    this.pendingFlows.insertElementAt(mqttWireMessage, 0);
                    this.queueLock.notifyAll();
                }
            } else {
                if (mqttWireMessage instanceof MqttPingReq) {
                    this.pingCommand = mqttWireMessage;
                } else if (mqttWireMessage instanceof MqttPubRel) {
                    this.outboundQoS2.put(new Long(mqttWireMessage.getMessageId()), mqttWireMessage);
                    this.persistence.put(this.getSendConfirmPersistenceKey(mqttWireMessage), (MqttPubRel)mqttWireMessage);
                } else if (mqttWireMessage instanceof MqttPubComp) {
                    this.persistence.remove(this.getReceivedPersistenceKey(mqttWireMessage));
                }
                Object object = this.queueLock;
                synchronized (object) {
                    if (!(mqttWireMessage instanceof MqttAck)) {
                        this.tokenStore.saveToken(mqttToken, mqttWireMessage);
                    }
                    this.pendingFlows.addElement(mqttWireMessage);
                    this.queueLock.notifyAll();
                    return;
                }
            }
        }
    }

    protected void undo(MqttPublish mqttPublish) {
        Object object = this.queueLock;
        synchronized (object) {
            this.log.fine(className, z[72], z[73], new Object[]{new Long(mqttPublish.getMessageId()), new Integer(mqttPublish.getMessage().getQos())});
            if (mqttPublish.getMessage().getQos() == 1) {
                this.outboundQoS1.remove(new Long(mqttPublish.getMessageId()));
            } else {
                this.outboundQoS2.remove(new Long(mqttPublish.getMessageId()));
            }
            this.pendingMessages.removeElement(mqttPublish);
            this.persistence.remove(this.getSendPersistenceKey(mqttPublish));
            this.tokenStore.removeToken(mqttPublish);
            this.checkQuiesceLock();
            return;
        }
    }

    private MqttWireMessage checkForActivity() {
        MqttWireMessage mqttWireMessage = null;
        if (this.keepAlive > 0L && (this.lastInboundActivity - this.lastOutboundActivity >= this.keepAlive || System.currentTimeMillis() - this.lastOutboundActivity >= this.keepAlive)) {
            if (this.pingOutstanding) {
                this.log.severe(className, z[41], z[39], new Object[]{new Long(this.keepAlive), new Long(this.lastOutboundActivity), new Long(this.lastInboundActivity)});
                throw ExceptionHelper.createMqttException(32000);
            }
            this.log.fine(className, z[41], z[40], new Object[]{new Long(this.keepAlive), new Long(this.lastOutboundActivity), new Long(this.lastInboundActivity)});
            this.pingOutstanding = true;
            mqttWireMessage = this.pingCommand;
            MqttToken mqttToken = new MqttToken(this.clientComms.getClient().getClientId());
            this.tokenStore.saveToken(mqttToken, mqttWireMessage);
        }
        return mqttWireMessage;
    }

    protected MqttWireMessage get() {
        MqttWireMessage mqttWireMessage = null;
        Object object = this.queueLock;
        synchronized (object) {
            while (mqttWireMessage == null) {
                if (this.pendingMessages.isEmpty() && this.pendingFlows.isEmpty()) {
                    try {
                        this.log.fine(className, z[60], z[57]);
                        this.queueLock.wait(this.getTimeUntilPing());
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!(this.connected || !this.pendingFlows.isEmpty() && (MqttWireMessage)this.pendingFlows.elementAt(0) instanceof MqttConnect)) {
                    this.log.fine(className, z[60], z[61]);
                    return null;
                }
                if (!this.pendingFlows.isEmpty()) {
                    mqttWireMessage = (MqttWireMessage)this.pendingFlows.elementAt(0);
                    this.pendingFlows.removeElementAt(0);
                    if (mqttWireMessage instanceof MqttPubRel) {
                        ++this.inFlightPubRels;
                        this.log.fine(className, z[60], z[59], new Object[]{new Integer(this.inFlightPubRels)});
                    }
                    this.checkQuiesceLock();
                } else if (!this.pendingMessages.isEmpty()) {
                    if (this.actualInFlight < this.maxInflight) {
                        mqttWireMessage = (MqttWireMessage)this.pendingMessages.elementAt(0);
                        this.pendingMessages.removeElementAt(0);
                        ++this.actualInFlight;
                        this.log.fine(className, z[60], z[58], new Object[]{new Integer(this.actualInFlight)});
                    } else {
                        this.log.fine(className, z[60], z[56]);
                    }
                }
                if (mqttWireMessage != null) continue;
                mqttWireMessage = this.checkForActivity();
            }
        }
        return mqttWireMessage;
    }

    public void setKeepAliveInterval(long l2) {
        this.keepAlive = l2;
    }

    long getTimeUntilPing() {
        long l2;
        if (this.getKeepAlive() == 0L) {
            return 0L;
        }
        long l3 = this.lastOutboundActivity;
        long l4 = System.currentTimeMillis();
        if (l3 == 0L) {
            l3 = l4;
        }
        if ((l2 = this.getKeepAlive() - (l4 - l3)) < 0L) {
            return 1L;
        }
        return l2;
    }

    protected void notifySent(MqttWireMessage mqttWireMessage) {
        this.lastOutboundActivity = System.currentTimeMillis();
        MqttToken mqttToken = this.tokenStore.getToken(mqttWireMessage);
        mqttToken.internalTok.notifySent();
        if (mqttWireMessage instanceof MqttPublish && ((MqttPublish)mqttWireMessage).getMessage().getQos() == 0) {
            mqttToken.internalTok.markComplete(null, null);
            this.callback.asyncOperationComplete(mqttToken);
            this.decrementInFlight();
            this.releaseMessageId(mqttWireMessage.getMessageId());
            this.tokenStore.removeToken(mqttWireMessage);
            this.checkQuiesceLock();
        }
    }

    private void decrementInFlight() {
        Object object = this.queueLock;
        synchronized (object) {
            --this.actualInFlight;
            this.log.fine(className, z[28], z[27], new Object[]{new Integer(this.actualInFlight)});
            if (!this.checkQuiesceLock()) {
                this.queueLock.notifyAll();
            }
            return;
        }
    }

    protected boolean checkQuiesceLock() {
        int n2 = this.tokenStore.count();
        if (this.quiescing && n2 == 0 && this.pendingFlows.size() == 0 && this.callback.isQuiesced()) {
            this.log.fine(className, z[16], z[15], new Object[]{new Boolean(this.quiescing), new Integer(this.actualInFlight), new Integer(this.pendingFlows.size()), new Integer(this.inFlightPubRels), new Boolean(this.callback.isQuiesced()), new Integer(n2)});
            Object object = this.quiesceLock;
            synchronized (object) {
                this.quiesceLock.notifyAll();
            }
            return true;
        }
        return false;
    }

    protected void notifyReceivedAck(MqttAck object) {
        this.lastInboundActivity = System.currentTimeMillis();
        this.log.fine(className, z[36], z[37], new Object[]{new Long(((MqttWireMessage)object).getMessageId()), object});
        MqttToken mqttToken = this.tokenStore.getToken((MqttWireMessage)object);
        if (object instanceof MqttPubRec) {
            MqttPubRel mqttPubRel = new MqttPubRel((MqttPubRec)object);
            this.send(mqttPubRel, mqttToken);
        } else if (object instanceof MqttPubAck || object instanceof MqttPubComp) {
            this.notifyResult((MqttWireMessage)object, mqttToken, null);
        } else if (object instanceof MqttPingResp) {
            this.pingOutstanding = false;
            this.notifyResult((MqttWireMessage)object, mqttToken, null);
            this.tokenStore.removeToken((MqttWireMessage)object);
        } else if (object instanceof MqttConnack) {
            Object object2;
            int n2 = ((MqttConnack)object).getReturnCode();
            String cfr_ignored_0 = z[38] + n2;
            k.b();
            if (n2 == 0) {
                object2 = this.queueLock;
                synchronized (object2) {
                    if (this.cleanSession) {
                        this.clearState();
                        this.tokenStore.saveToken(mqttToken, (MqttWireMessage)object);
                    }
                    this.inFlightPubRels = 0;
                    this.actualInFlight = 0;
                    this.restoreInflightMessages();
                    this.connected();
                }
            } else {
                object = ExceptionHelper.createMqttException(n2);
                throw object;
            }
            this.clientComms.connectComplete((MqttConnack)object, null);
            this.notifyResult((MqttWireMessage)object, mqttToken, null);
            this.tokenStore.removeToken((MqttWireMessage)object);
            object2 = this.queueLock;
            synchronized (object2) {
                this.queueLock.notifyAll();
            }
        } else {
            this.notifyResult((MqttWireMessage)object, mqttToken, null);
            this.releaseMessageId(((MqttWireMessage)object).getMessageId());
            this.tokenStore.removeToken((MqttWireMessage)object);
        }
        this.checkQuiesceLock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void notifyReceivedMsg(MqttWireMessage mqttWireMessage) {
        this.lastInboundActivity = System.currentTimeMillis();
        this.log.fine(className, z[69], z[70], new Object[]{new Long(mqttWireMessage.getMessageId()), mqttWireMessage});
        if (this.quiescing) return;
        if (mqttWireMessage instanceof MqttPublish) {
            MqttPublish mqttPublish = (MqttPublish)mqttWireMessage;
            switch (mqttPublish.getMessage().getQos()) {
                case 0: 
                case 1: {
                    if (this.callback == null) return;
                    this.callback.messageArrived(mqttPublish);
                    return;
                }
                case 2: {
                    this.persistence.put(this.getReceivedPersistenceKey(mqttWireMessage), (MqttPublish)mqttWireMessage);
                    this.inboundQoS2.put(new Long(mqttPublish.getMessageId()), mqttPublish);
                    this.send(new MqttPubRec(mqttPublish), null);
                }
                default: {
                    return;
                }
            }
        }
        if (!(mqttWireMessage instanceof MqttPubRel)) return;
        MqttPublish mqttPublish = (MqttPublish)this.inboundQoS2.get(new Long(mqttWireMessage.getMessageId()));
        if (mqttPublish != null) {
            if (this.callback == null) return;
            this.callback.messageArrived(mqttPublish);
            return;
        }
        mqttWireMessage = new MqttPubComp(mqttWireMessage.getMessageId());
        this.send(mqttWireMessage, null);
    }

    protected void notifyComplete(MqttToken object) {
        MqttWireMessage mqttWireMessage = ((MqttToken)object).internalTok.getWireMessage();
        if (mqttWireMessage != null && mqttWireMessage instanceof MqttAck) {
            this.log.fine(className, z[65], z[66], new Object[]{new Long(mqttWireMessage.getMessageId()), object, mqttWireMessage});
            object = (MqttAck)mqttWireMessage;
            if (object instanceof MqttPubAck) {
                this.persistence.remove(this.getSendPersistenceKey(mqttWireMessage));
                this.outboundQoS1.remove(new Long(((MqttWireMessage)object).getMessageId()));
                this.decrementInFlight();
                this.releaseMessageId(mqttWireMessage.getMessageId());
                this.tokenStore.removeToken(mqttWireMessage);
                this.log.fine(className, z[65], z[68], new Object[]{new Long(((MqttWireMessage)object).getMessageId())});
            } else if (object instanceof MqttPubComp) {
                this.persistence.remove(this.getSendPersistenceKey(mqttWireMessage));
                this.persistence.remove(this.getSendConfirmPersistenceKey(mqttWireMessage));
                this.outboundQoS2.remove(new Long(((MqttWireMessage)object).getMessageId()));
                --this.inFlightPubRels;
                this.decrementInFlight();
                this.releaseMessageId(mqttWireMessage.getMessageId());
                this.tokenStore.removeToken(mqttWireMessage);
                this.log.fine(className, z[65], z[67], new Object[]{new Long(((MqttWireMessage)object).getMessageId()), new Integer(this.inFlightPubRels)});
            }
            this.checkQuiesceLock();
        }
    }

    protected void notifyResult(MqttWireMessage mqttWireMessage, MqttToken mqttToken, MqttException mqttException) {
        try {
            mqttToken.internalTok.markComplete(mqttWireMessage, mqttException);
            if (mqttWireMessage != null && mqttWireMessage instanceof MqttAck && !(mqttWireMessage instanceof MqttPubRec)) {
                k.b();
                this.callback.asyncOperationComplete(mqttToken);
            }
            if (mqttWireMessage == null) {
                this.log.fine(className, z[42], z[43], new Object[]{mqttToken.internalTok.getKey(), mqttException});
                this.callback.asyncOperationComplete(mqttToken);
            }
            return;
        }
        catch (Exception exception) {
            k.h();
            return;
        }
    }

    public void connected() {
        this.log.fine(className, z[63], z[64]);
        this.connected = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Vector resolveOldTokens(MqttException serializable) {
        this.log.fine(className, z[35], z[34], new Object[]{serializable});
        Serializable serializable2 = serializable;
        if (serializable == null) {
            serializable2 = new MqttException(32102);
        }
        serializable = this.tokenStore.getOutstandingTokens();
        Enumeration enumeration = ((Vector)serializable).elements();
        while (enumeration.hasMoreElements()) {
            MqttToken mqttToken;
            MqttToken mqttToken2 = mqttToken = (MqttToken)enumeration.nextElement();
            // MONITORENTER : mqttToken
            if (!mqttToken.isComplete() && !mqttToken.internalTok.isCompletePending() && mqttToken.getException() == null) {
                mqttToken.internalTok.setException((MqttException)serializable2);
            }
            // MONITOREXIT : mqttToken2
            if (mqttToken instanceof MqttDeliveryToken) continue;
            this.tokenStore.removeToken(mqttToken.internalTok.getKey());
        }
        return serializable;
    }

    public void disconnected(MqttException mqttException) {
        this.log.fine(className, z[21], z[22], new Object[]{mqttException});
        this.connected = false;
        try {
            if (this.cleanSession) {
                this.clearState();
            }
            this.pendingMessages.clear();
            this.pendingFlows.clear();
            this.pingOutstanding = false;
            return;
        }
        catch (MqttException mqttException2) {
            return;
        }
    }

    private synchronized void releaseMessageId(long l2) {
        this.inUseMsgIds.remove(new Long(l2));
    }

    private synchronized long getNextMessageId() {
        try {
            do {
                long l2 = System.currentTimeMillis();
                long l3 = new Random().nextInt(0x7FFFFF);
                this.nextMsgId = l2 << 23 | l3;
            } while (this.inUseMsgIds.containsKey(this.nextMsgId));
            Long l4 = this.nextMsgId;
            this.inUseMsgIds.put(l4, l4);
            return this.nextMsgId;
        }
        catch (Exception exception) {
            String cfr_ignored_0 = z[71] + exception.getMessage();
            k.d();
            return System.currentTimeMillis() + (long)new Random().nextInt(0x7FFFFF);
        }
    }

    public void quiesce(long l2) {
        if (l2 > 0L) {
            this.log.fine(className, z[26], z[24], new Object[]{new Long(l2)});
            Object object = this.queueLock;
            synchronized (object) {
                this.quiescing = true;
            }
            this.callback.quiesce();
            this.notifyQueueLock();
            object = this.quiesceLock;
            synchronized (object) {
                try {
                    int n2 = this.tokenStore.count();
                    if (n2 > 0 || this.pendingFlows.size() > 0 || !this.callback.isQuiesced()) {
                        this.log.fine(className, z[26], z[23], new Object[]{new Integer(this.actualInFlight), new Integer(this.pendingFlows.size()), new Integer(this.inFlightPubRels), new Integer(n2)});
                        this.quiesceLock.wait(l2);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            object = this.queueLock;
            synchronized (object) {
                this.pendingMessages.clear();
                this.pendingFlows.clear();
                this.quiescing = false;
                this.actualInFlight = 0;
            }
            this.log.fine(className, z[26], z[25]);
        }
    }

    protected void notifyQueueLock() {
        Object object = this.queueLock;
        synchronized (object) {
            this.log.fine(className, z[55], z[54]);
            this.queueLock.notifyAll();
            return;
        }
    }

    protected void deliveryComplete(MqttPublish mqttPublish) {
        this.log.fine(className, z[32], z[33], new Object[]{new Long(mqttPublish.getMessageId())});
        this.persistence.remove(this.getReceivedPersistenceKey(mqttPublish));
        this.inboundQoS2.remove(new Long(mqttPublish.getMessageId()));
    }

    protected void close() {
        this.inUseMsgIds.clear();
        this.pendingMessages.clear();
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
        this.inUseMsgIds = null;
        this.pendingMessages = null;
        this.pendingFlows = null;
        this.outboundQoS2 = null;
        this.outboundQoS1 = null;
        this.inboundQoS2 = null;
        this.tokenStore = null;
        this.callback = null;
        this.clientComms = null;
        this.persistence = null;
        this.pingCommand = null;
    }

    public Properties getDebug() {
        Properties properties = new Properties();
        properties.put(z[13], this.inUseMsgIds);
        properties.put(z[9], this.pendingMessages);
        properties.put(z[5], this.pendingFlows);
        properties.put(z[11], new Integer(this.maxInflight));
        properties.put(z[7], new Long(this.nextMsgId));
        properties.put(z[2], new Integer(this.actualInFlight));
        properties.put(z[3], new Integer(this.inFlightPubRels));
        properties.put(z[1], new Boolean(this.quiescing));
        properties.put(z[10], new Boolean(this.pingOutstanding));
        properties.put(z[4], new Long(this.lastOutboundActivity));
        properties.put(z[12], new Long(this.lastInboundActivity));
        properties.put(z[14], this.outboundQoS2);
        properties.put(z[0], this.outboundQoS1);
        properties.put(z[8], this.inboundQoS2);
        properties.put(z[6], this.tokenStore);
        return properties;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[78];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = ".j";
        int n3 = 77;
        block89: while (true) {
            char[] cArray;
            block94: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block93: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block93;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block94;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 92;
                                break;
                            }
                            case 1: {
                                n9 = 71;
                                break;
                            }
                            case 2: {
                                n9 = 14;
                                break;
                            }
                            case 3: {
                                n9 = 38;
                                break;
                            }
                            default: {
                                n9 = 18;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 77: {
                    PERSISTENCE_RECEIVED_PREFIX = string.intern();
                    string2 = "/j";
                    n3 = 78;
                    continue block89;
                }
                case 78: {
                    PERSISTENCE_SENT_PREFIX = string.intern();
                    string2 = "\u001f+gC|(\u0014zGf9";
                    n3 = 79;
                    continue block89;
                }
                case 79: {
                    className = string.intern();
                    string2 = "/$#";
                    n3 = 80;
                    continue block89;
                }
                case 80: {
                    PERSISTENCE_CONFIRMED_PREFIX = string.intern();
                    string2 = "32zD}))jw}\u000fv";
                    n3 = -1;
                    continue block89;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "-2gCa?.`A";
                    n3 = 0;
                    continue block89;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "=$zSs0\u000e``~5 fR";
                    n3 = 1;
                    continue block89;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "5)HJ{;/zvg>\u0015kJa";
                    n3 = 2;
                    continue block89;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "0&}R])3lIg2#OEf51gRk";
                    n3 = 3;
                    continue block89;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = ",\"`B{2 HJ}+4";
                    n3 = 4;
                    continue block89;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "((eC|/";
                    n3 = 5;
                    continue block89;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "2\"vR_/ Gb";
                    n3 = 6;
                    continue block89;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "5)lIg2#_IAn";
                    n3 = 7;
                    continue block89;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = ",\"`B{2 CCa/&iCa";
                    n3 = 8;
                    continue block89;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = ",.`A})3}Rs2#gHu";
                    n3 = 9;
                    continue block89;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "1&vo|:+gAz(";
                    n3 = 10;
                    continue block89;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "0&}R[2%aS|8\u0006mR{*.z_";
                    n3 = 11;
                    continue block89;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0015).Sa9gcUu5#}";
                    n3 = 12;
                    continue block89;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "32zD}))jw}\u000fu";
                    n3 = 13;
                    continue block89;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "ju8";
                    n3 = 14;
                    continue block89;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "?/kEy\r2gCa?\"BIq7";
                    n3 = 15;
                    continue block89;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = ".\"}R}.\"GHt0.iNf\u0011\"}Us;\"}";
                    n3 = 16;
                    continue block89;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "jv>";
                    n3 = 17;
                    continue block89;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "jv<";
                    n3 = 18;
                    continue block89;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "jv?";
                    n3 = 19;
                    continue block89;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "8.}E}2)kEf9#";
                    n3 = 20;
                    continue block89;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "jt=";
                    n3 = 21;
                    continue block89;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "jt7";
                    n3 = 22;
                    continue block89;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "jt9";
                    n3 = 23;
                    continue block89;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "js>";
                    n3 = 24;
                    continue block89;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "-2gCa?\"";
                    n3 = 25;
                    continue block89;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "js8";
                    n3 = 26;
                    continue block89;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "8\"mTw1\"`R[2\u0001bOu43";
                    n3 = 27;
                    continue block89;
                }
                case 27: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 29;
                    string2 = ".\"}R}.\"CCa/&iC";
                    n3 = 28;
                    continue block89;
                }
                case 28: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 30;
                    string2 = "jw?";
                    n3 = 29;
                    continue block89;
                }
                case 29: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 31;
                    string2 = "jw<";
                    n3 = 30;
                    continue block89;
                }
                case 30: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 32;
                    string2 = "8\"bOd95we}17bCf9";
                    n3 = 31;
                    continue block89;
                }
                case 31: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 33;
                    string2 = "js?";
                    n3 = 32;
                    continue block89;
                }
                case 32: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 34;
                    string2 = "jt<";
                    n3 = 33;
                    continue block89;
                }
                case 33: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 35;
                    string2 = ".\"}I~*\"AJv\b(eC|/";
                    n3 = 34;
                    continue block89;
                }
                case 34: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 36;
                    string2 = "2(zOt%\u0015kEw51kBS?,";
                    n3 = 35;
                    continue block89;
                }
                case 35: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 37;
                    string2 = "ju9";
                    n3 = 36;
                    continue block89;
                }
                case 36: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 38;
                    string2 = "?(`Hw?3.Tw(2|H2+.zN2?(jC2ag";
                    n3 = 37;
                    continue block89;
                }
                case 37: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 39;
                    string2 = "jv7";
                    n3 = 38;
                    continue block89;
                }
                case 38: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 40;
                    string2 = "ju>";
                    n3 = 39;
                    continue block89;
                }
                case 39: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 41;
                    string2 = "?/kEy\u001a(|gq(.xOf%";
                    n3 = 40;
                    continue block89;
                }
                case 40: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 42;
                    string2 = "2(zOt%\u0015kUg03";
                    n3 = 41;
                    continue block89;
                }
                case 41: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 43;
                    string2 = "js7";
                    n3 = 42;
                    continue block89;
                }
                case 42: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 44;
                    string2 = "`\u000e`Ofb";
                    n3 = 43;
                    continue block89;
                }
                case 43: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 45;
                    string2 = "35i\bw?+gVa9i~Gz3imJ{9)z\b\u007f-3zP!r.`Rw.)oJ<2+}\b~3 mGf";
                    n3 = 44;
                    continue block89;
                }
                case 44: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 46;
                    string2 = "jw7";
                    n3 = 45;
                    continue block89;
                }
                case 45: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 47;
                    string2 = "jw;";
                    n3 = 46;
                    continue block89;
                }
                case 46: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 48;
                    string2 = "jw6";
                    n3 = 47;
                    continue block89;
                }
                case 47: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 49;
                    string2 = "jw:";
                    n3 = 48;
                    continue block89;
                }
                case 48: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 50;
                    string2 = "jw>";
                    n3 = 49;
                    continue block89;
                }
                case 49: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 51;
                    string2 = "jw9";
                    n3 = 50;
                    continue block89;
                }
                case 50: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 52;
                    string2 = "jw8";
                    n3 = 51;
                    continue block89;
                }
                case 51: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 53;
                    string2 = ".\"}R}.\"]Rs(\"";
                    n3 = 52;
                    continue block89;
                }
                case 52: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 54;
                    string2 = "jt6";
                    n3 = 53;
                    continue block89;
                }
                case 53: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 55;
                    string2 = "2(zOt%\u0016{Cg9\u000baEy";
                    n3 = 54;
                    continue block89;
                }
                case 54: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 56;
                    string2 = "ju<";
                    n3 = 55;
                    continue block89;
                }
                case 55: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 57;
                    string2 = "js:";
                    n3 = 56;
                    continue block89;
                }
                case 56: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 58;
                    string2 = "ju=";
                    n3 = 57;
                    continue block89;
                }
                case 57: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 59;
                    string2 = "jv9";
                    n3 = 58;
                    continue block89;
                }
                case 58: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 60;
                    string2 = ";\"z";
                    n3 = 59;
                    continue block89;
                }
                case 59: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 61;
                    string2 = "ju?";
                    n3 = 60;
                    continue block89;
                }
                case 60: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 62;
                    string2 = "?+kG`\u000f3oRw";
                    n3 = 61;
                    continue block89;
                }
                case 61: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 63;
                    string2 = "?(`Hw?3kB";
                    n3 = 62;
                    continue block89;
                }
                case 62: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 64;
                    string2 = "jt?";
                    n3 = 63;
                    continue block89;
                }
                case 63: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 65;
                    string2 = "2(zOt%\u0004aKb0\"zC";
                    n3 = 64;
                    continue block89;
                }
                case 64: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 66;
                    string2 = "ju7";
                    n3 = 65;
                    continue block89;
                }
                case 65: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 67;
                    string2 = "js;";
                    n3 = 66;
                    continue block89;
                }
                case 66: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 68;
                    string2 = "jr>";
                    n3 = 67;
                    continue block89;
                }
                case 67: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 69;
                    string2 = "2(zOt%\u0015kEw51kB_/ ";
                    n3 = 68;
                    continue block89;
                }
                case 68: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 70;
                    string2 = "jr?";
                    n3 = 69;
                    continue block89;
                }
                case 69: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 71;
                    string2 = "\u001b\"z\u0006|9?zka;\u000ej\u0006w.5aT(|";
                    n3 = 70;
                    continue block89;
                }
                case 70: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 72;
                    string2 = "))jI";
                    n3 = 71;
                    continue block89;
                }
                case 71: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 73;
                    string2 = "jv6";
                    n3 = 72;
                    continue block89;
                }
                case 72: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 74;
                    string2 = "ju6";
                    n3 = 73;
                    continue block89;
                }
                case 73: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 75;
                    string2 = "/\"`B";
                    n3 = 74;
                    continue block89;
                }
                case 74: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 76;
                    string2 = "jv=";
                    n3 = 75;
                    continue block89;
                }
                case 75: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 77;
                    string2 = "jv;";
                    n3 = 76;
                    continue block89;
                }
                case 76: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

