/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsTokenStore {
    private Hashtable tokens;
    private String logContext;
    private MqttException closedResponse = null;
    static final String className;
    Logger log = LoggerFactory.getLogger(z[15], className);
    private static final String[] z;

    public CommsTokenStore(String string) {
        this.log.setResourceName(string);
        this.tokens = new Hashtable();
        this.logContext = string;
        this.log.fine(className, z[14], z[13]);
    }

    public MqttToken getToken(MqttWireMessage object) {
        object = ((MqttWireMessage)object).getKey();
        return (MqttToken)this.tokens.get(object);
    }

    public MqttToken getToken(String string) {
        return (MqttToken)this.tokens.get(string);
    }

    public MqttToken removeToken(MqttWireMessage mqttWireMessage) {
        if (mqttWireMessage != null) {
            return this.removeToken(mqttWireMessage.getKey());
        }
        return null;
    }

    public MqttToken removeToken(String string) {
        this.log.fine(className, z[0], z[1], new Object[]{string});
        if (string != null) {
            Hashtable hashtable = this.tokens;
            synchronized (hashtable) {
                MqttToken mqttToken = (MqttToken)this.tokens.get(string);
                if (mqttToken != null) {
                    synchronized (mqttToken) {
                        return (MqttToken)this.tokens.remove(string);
                    }
                }
            }
        }
        return null;
    }

    protected MqttDeliveryToken restoreToken(MqttPublish mqttPublish) {
        MqttDeliveryToken mqttDeliveryToken;
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            String string = new Long(mqttPublish.getMessageId()).toString();
            if (this.tokens.containsKey(string)) {
                mqttDeliveryToken = (MqttDeliveryToken)this.tokens.get(string);
                this.log.fine(className, z[20], z[19], new Object[]{string, mqttPublish, mqttDeliveryToken});
            } else {
                mqttDeliveryToken = new MqttDeliveryToken(this.logContext);
                mqttDeliveryToken.internalTok.setKey(string);
                this.tokens.put(string, mqttDeliveryToken);
                this.log.fine(className, z[20], z[18], new Object[]{string, mqttPublish, mqttDeliveryToken});
            }
        }
        return mqttDeliveryToken;
    }

    protected void saveToken(MqttToken mqttToken, MqttWireMessage mqttWireMessage) {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            if (this.closedResponse != null) {
                throw this.closedResponse;
            }
            String string = mqttWireMessage.getKey();
            this.log.fine(className, z[3], z[2], new Object[]{string, mqttWireMessage});
            this.saveToken(mqttToken, string);
            return;
        }
    }

    protected void saveToken(MqttToken mqttToken, String string) {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(className, z[3], z[12], new Object[]{string, mqttToken.toString()});
            mqttToken.internalTok.setKey(string);
            this.tokens.put(string, mqttToken);
            return;
        }
    }

    protected void quiesce(MqttException mqttException) {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(className, z[16], z[17], new Object[]{mqttException});
            this.closedResponse = mqttException;
            return;
        }
    }

    public void open() {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(className, z[11], z[10]);
            this.closedResponse = null;
            return;
        }
    }

    public MqttDeliveryToken[] getOutstandingDelTokens() {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(className, z[6], z[7]);
            Vector<MqttToken> vector = new Vector<MqttToken>();
            MqttDeliveryToken[] mqttDeliveryTokenArray = this.tokens.elements();
            while (mqttDeliveryTokenArray.hasMoreElements()) {
                MqttToken mqttToken = (MqttToken)mqttDeliveryTokenArray.nextElement();
                if (mqttToken == null || !(mqttToken instanceof MqttDeliveryToken) || mqttToken.internalTok.isNotified()) continue;
                vector.addElement(mqttToken);
            }
            mqttDeliveryTokenArray = new MqttDeliveryToken[vector.size()];
            return vector.toArray(mqttDeliveryTokenArray);
        }
    }

    public Vector getOutstandingTokens() {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(className, z[4], z[5]);
            Vector<MqttToken> vector = new Vector<MqttToken>();
            Enumeration enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken mqttToken = (MqttToken)enumeration.nextElement();
                if (mqttToken == null) continue;
                vector.addElement(mqttToken);
            }
            return vector;
        }
    }

    public void clear() {
        this.log.fine(className, z[8], z[9], new Object[]{new Integer(this.tokens.size())});
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.tokens.clear();
            return;
        }
    }

    public int count() {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            return this.tokens.size();
        }
    }

    public String toString() {
        String string = System.getProperty(z[21], "\n");
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            Enumeration enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken mqttToken = (MqttToken)enumeration.nextElement();
                stringBuffer.append("{" + mqttToken.internalTok + "}" + string);
            }
            return stringBuffer.toString();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[22];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u000bN\fE\u0012\u001c\u007f\u000eA\u0001\u0017";
        int n3 = -1;
        block29: while (true) {
            char[] cArray;
            block34: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block33: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block33;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block34;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 121;
                                break;
                            }
                            case 1: {
                                n9 = 43;
                                break;
                            }
                            case 2: {
                                n9 = 97;
                                break;
                            }
                            case 3: {
                                n9 = 42;
                                break;
                            }
                            default: {
                                n9 = 100;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "J\u001bW";
                    n3 = 0;
                    continue block29;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "J\u001bQ";
                    n3 = 1;
                    continue block29;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\nJ\u0017O0\u0016@\u0004D";
                    n3 = 2;
                    continue block29;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u001eN\u0015e\u0011\rX\u0015K\n\u001dB\u000fM0\u0016@\u0004D\u0017";
                    n3 = 3;
                    continue block29;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "J\u001aS";
                    n3 = 4;
                    continue block29;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001eN\u0015e\u0011\rX\u0015K\n\u001dB\u000fM \u001cG5E\u000f\u001cE\u0012";
                    n3 = 5;
                    continue block29;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "J\u001aP";
                    n3 = 6;
                    continue block29;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u001aG\u0004K\u0016";
                    n3 = 7;
                    continue block29;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "J\u001bT";
                    n3 = 8;
                    continue block29;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "J\u001aQ";
                    n3 = 9;
                    continue block29;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0016[\u0004D";
                    n3 = 10;
                    continue block29;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "J\u001bV";
                    n3 = 11;
                    continue block29;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "J\u001bY";
                    n3 = 12;
                    continue block29;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "Eb\u000fC\u0010G";
                    n3 = 13;
                    continue block29;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u0016Y\u0006\u0004\u0001\u001aG\bZ\u0017\u001c\u0005\u0011K\f\u0016\u0005\u0002F\r\u001cE\u0015\u0004\t\b_\u0015\\WWB\u000f^\u0001\u000bE\u0000FJ\u0017G\u0012\u0004\b\u0016L\u0002K\u0010";
                    n3 = 14;
                    continue block29;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\b^\bO\u0017\u001aN";
                    n3 = 15;
                    continue block29;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "J\u001bX";
                    n3 = 16;
                    continue block29;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "J\u001bR";
                    n3 = 17;
                    continue block29;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "J\u001bS";
                    n3 = 18;
                    continue block29;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "\u000bN\u0012^\u000b\u000bN5E\u000f\u001cE";
                    n3 = 19;
                    continue block29;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "\u0015B\u000fOJ\nN\u0011K\u0016\u0018_\u000eX";
                    n3 = 20;
                    continue block29;
                }
                case 20: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        className = CommsTokenStore.class.getName();
    }
}

