/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.CountingInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPersistableWireMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttReceivedMessage;

public class MqttPublish
extends MqttPersistableWireMessage {
    private MqttMessage message;
    private String topicName;
    private byte[] encodedPayload = null;

    public MqttPublish(String string, MqttMessage mqttMessage) {
        super((byte)3);
        this.topicName = string;
        this.message = mqttMessage;
    }

    public MqttPublish(byte by, byte[] byArray) {
        super((byte)3);
        this.message = new MqttReceivedMessage();
        this.message.setQos(by >> 1 & 3);
        if ((by & 1) == 1) {
            this.message.setRetained(true);
        }
        if ((by & 8) == 8) {
            ((MqttReceivedMessage)this.message).setDuplicate(true);
        }
        Object object = new ByteArrayInputStream(byArray);
        object = new CountingInputStream((InputStream)object);
        DataInputStream dataInputStream = new DataInputStream((InputStream)object);
        this.topicName = this.decodeUTF8(dataInputStream);
        if (this.message.getQos() > 0) {
            this.msgId = dataInputStream.readLong();
        }
        object = new byte[byArray.length - ((CountingInputStream)object).getCounter()];
        dataInputStream.readFully((byte[])object);
        dataInputStream.close();
        this.message.setPayload((byte[])object);
    }

    @Override
    protected byte getMessageInfo() {
        byte by = (byte)(this.message.getQos() << 1);
        if (this.message.isRetained()) {
            by = (byte)(by | 1);
        }
        if (this.message.isDuplicate() || this.duplicate) {
            by = (byte)(by | 8);
        }
        return by;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public MqttMessage getMessage() {
        return this.message;
    }

    protected static byte[] encodePayload(MqttMessage mqttMessage) {
        return mqttMessage.getPayload();
    }

    @Override
    public byte[] getPayload() {
        if (this.encodedPayload == null) {
            this.encodedPayload = MqttPublish.encodePayload(this.message);
        }
        return this.encodedPayload;
    }

    @Override
    public int getPayloadLength() {
        int n2 = 0;
        try {
            n2 = this.getPayload().length;
        }
        catch (MqttException mqttException) {}
        return n2;
    }

    @Override
    public void setMessageId(long l2) {
        super.setMessageId(l2);
        if (this.message instanceof MqttReceivedMessage) {
            ((MqttReceivedMessage)this.message).setMessageId(l2);
        }
    }

    @Override
    protected byte[] getVariableHeader() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.encodeUTF8(dataOutputStream, this.topicName);
            if (this.message.getQos() > 0) {
                dataOutputStream.writeLong(this.msgId);
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(-106, (Throwable)iOException);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return true;
    }
}

