/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.paho.client.mqttv3.util.Debug;

public class MqttClient
implements IMqttClient {
    protected MqttAsyncClient aClient = null;
    protected long timeToWait = -1L;
    static final String className;
    public Logger log = LoggerFactory.getLogger(z, className);
    private static final String z;

    public MqttClient(String string, String string2) {
        this(string, string2, new MqttDefaultFilePersistence());
    }

    public MqttClient(String string, String string2, MqttClientPersistence mqttClientPersistence) {
        this.aClient = new MqttAsyncClient(string, string2, mqttClientPersistence);
    }

    @Override
    public void connect() {
        this.connect(new MqttConnectOptions());
    }

    @Override
    public void connect(MqttConnectOptions mqttConnectOptions) {
        this.aClient.connect(mqttConnectOptions, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public void disconnect() {
        this.disconnect(30000L);
    }

    @Override
    public void disconnect(long l2) {
        this.aClient.disconnect(l2, null, null).waitForCompletion();
    }

    @Override
    public void subscribe(String string) {
        this.subscribe(new String[]{string}, new int[]{1});
    }

    @Override
    public void subscribe(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = 1;
        }
        this.subscribe(stringArray, nArray);
    }

    @Override
    public void subscribe(String string, int n2) {
        this.subscribe(new String[]{string}, new int[]{n2});
    }

    @Override
    public void subscribe(String[] stringArray, int[] nArray) {
        this.aClient.subscribe(stringArray, nArray, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public void unsubscribe(String string) {
        this.unsubscribe(new String[]{string});
    }

    @Override
    public void unsubscribe(String[] stringArray) {
        this.aClient.unsubscribe(stringArray, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public void publish(String string, byte[] object, int n2, boolean bl) {
        MqttMessage mqttMessage = new MqttMessage((byte[])object);
        object = mqttMessage;
        mqttMessage.setQos(n2);
        ((MqttMessage)object).setRetained(bl);
        this.publish(string, (MqttMessage)object);
    }

    @Override
    public void publish(String string, MqttMessage mqttMessage) {
        this.aClient.publish(string, mqttMessage, null, null).waitForCompletion(this.getTimeToWait());
    }

    public void setTimeToWait(long l2) {
        if (this.timeToWait < -1L) {
            throw new IllegalArgumentException();
        }
        this.timeToWait = l2;
    }

    public long getTimeToWait() {
        return this.timeToWait;
    }

    @Override
    public void close() {
        this.aClient.close();
    }

    @Override
    public String getClientId() {
        return this.aClient.getClientId();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.aClient.getPendingDeliveryTokens();
    }

    @Override
    public String getServerURI() {
        return this.aClient.getServerURI();
    }

    @Override
    public MqttTopic getTopic(String string) {
        return this.aClient.getTopic(string);
    }

    @Override
    public boolean isConnected() {
        return this.aClient.isConnected();
    }

    @Override
    public void setCallback(MqttCallback mqttCallback) {
        this.aClient.setCallback(mqttCallback);
    }

    public static String generateClientId() {
        return MqttAsyncClient.generateClientId();
    }

    public Debug getDebug() {
        return this.aClient.getDebug();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "<\u000b\u000b\u001d&0\u0015\u0005C06W\u001cR+<W\u000f_*6\u0017\u0018\u001d.\"\r\u0018Ep}\u0010\u0002G&!\u0017\r_m=\u0015\u001f\u001d/<\u001e\u000fR7".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 83;
                            break;
                        }
                        case 1: {
                            n7 = 121;
                            break;
                        }
                        case 2: {
                            n7 = 108;
                            break;
                        }
                        case 3: {
                            n7 = 51;
                            break;
                        }
                        default: {
                            n7 = 67;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
        className = MqttClient.class.getName();
    }
}

