/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;

public class MqttTopic {
    private ClientComms comms;
    private String name;

    public MqttTopic(String string, ClientComms clientComms) {
        this.comms = clientComms;
        this.name = string;
    }

    public MqttDeliveryToken publish(byte[] object, int n2, boolean bl) {
        MqttMessage mqttMessage = new MqttMessage((byte[])object);
        object = mqttMessage;
        mqttMessage.setQos(n2);
        ((MqttMessage)object).setRetained(bl);
        return this.publish((MqttMessage)object);
    }

    public MqttDeliveryToken publish(MqttMessage mqttMessage) {
        MqttDeliveryToken mqttDeliveryToken = new MqttDeliveryToken(this.comms.getClient().getClientId());
        mqttDeliveryToken.setMessage(mqttMessage);
        this.comms.sendNoWait(this.createPublish(mqttMessage), mqttDeliveryToken);
        mqttDeliveryToken.internalTok.waitUntilSent();
        return mqttDeliveryToken;
    }

    public String getName() {
        return this.name;
    }

    private MqttPublish createPublish(MqttMessage mqttMessage) {
        return new MqttPublish(this.getName(), mqttMessage);
    }

    public String toString() {
        return this.getName();
    }
}

