/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttConnect
extends MqttWireMessage {
    private String clientId;
    private boolean cleanSession;
    private MqttMessage willMessage;
    private String userName;
    private char[] password;
    private int keepAliveInterval;
    private String willDestination;
    public static String KEY;
    private static final String z;

    public MqttConnect(String string, boolean bl, int n2, String string2, char[] cArray, MqttMessage mqttMessage, String string3) {
        super((byte)1);
        this.clientId = string;
        this.cleanSession = bl;
        this.keepAliveInterval = n2;
        this.userName = string2;
        this.password = cArray;
        this.willMessage = mqttMessage;
        this.willDestination = string3;
    }

    @Override
    protected byte getMessageInfo() {
        return 0;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    @Override
    protected byte[] getVariableHeader() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.encodeUTF8(dataOutputStream, z);
            dataOutputStream.write(19);
            int n2 = 0;
            if (this.cleanSession) {
                n2 = 2;
            }
            if (this.willMessage != null) {
                byte by = (byte)(n2 | 4);
                n2 = by;
                n2 = (byte)(by | this.willMessage.getQos() << 3);
                if (this.willMessage.isRetained()) {
                    n2 = (byte)(n2 | 0x20);
                }
            }
            if (this.userName != null) {
                n2 = (byte)(n2 | 0x80);
                if (this.password != null) {
                    n2 = (byte)(n2 | 0x40);
                }
            }
            dataOutputStream.write(n2);
            dataOutputStream.writeShort(this.keepAliveInterval);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(-116, (Throwable)iOException);
        }
    }

    @Override
    public byte[] getPayload() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.encodeUTF8(dataOutputStream, this.clientId);
            if (this.willMessage != null) {
                this.encodeUTF8(dataOutputStream, this.willDestination);
                dataOutputStream.writeShort(this.willMessage.getPayload().length);
                dataOutputStream.write(this.willMessage.getPayload());
            }
            if (this.userName != null) {
                this.encodeUTF8(dataOutputStream, this.userName);
                if (this.password != null) {
                    this.encodeUTF8(dataOutputStream, new String(this.password));
                }
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new MqttException(-115, (Throwable)exception);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return false;
    }

    @Override
    public String getKey() {
        return new String(KEY);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    static {
        v0 = "e\u001e\u0005m(X";
        v1 = -1;
        block9: while (true) {
            v2 = v0.toCharArray();
            var0 = 0;
            v3 = v2.length;
            v4 = v2;
            v5 = v3;
            if (v3 > 1) ** GOTO lbl41
            do {
                v6 = v4;
                v7 = v4;
                v8 = var0;
                while (true) {
                    v9 = v6[v8];
                    switch (var0 % 5) {
                        case 0: {
                            v10 = 40;
                            break;
                        }
                        case 1: {
                            v10 = 79;
                            break;
                        }
                        case 2: {
                            v10 = 76;
                            break;
                        }
                        case 3: {
                            v10 = 30;
                            break;
                        }
                        default: {
                            v10 = 76;
                        }
                    }
                    v6[v8] = (char)(v9 ^ v10);
                    ++var0;
                    v4 = v7;
                    v5 = v5;
                    if (v5 != 0) break;
                    v7 = v4;
                    v11 = v5;
                    v8 = v5;
                    v6 = v4;
                }
lbl41:
                // 2 sources

                v12 = v4;
                v11 = v5;
            } while (v5 > var0);
            v13 = new String(v12);
            switch (v1) {
                default: {
                    MqttConnect.z = v13.intern();
                    v0 = "k \"";
                    v1 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        MqttConnect.KEY = v13.intern();
    }
}

