/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.internal.FileLock;
import org.eclipse.paho.client.mqttv3.internal.MqttPersistentData;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence$1;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence$2;

public class MqttDefaultFilePersistence
implements MqttClientPersistence {
    private File dataDir;
    private File clientDir = null;
    private FileLock fileLock = null;
    private static final String MESSAGE_FILE_EXTENSION;
    private static final String MESSAGE_BACKUP_FILE_EXTENSION;
    private static final String LOCK_FILENAME;
    private static final FilenameFilter FILE_FILTER;
    private static final String[] z;

    public MqttDefaultFilePersistence() {
        this(System.getProperty(z[1]));
    }

    public MqttDefaultFilePersistence(String string) {
        this.dataDir = new File(string);
    }

    @Override
    public void open(String string, String string2) {
        char c2;
        int n2;
        if (this.dataDir.exists() && !this.dataDir.isDirectory()) {
            throw new MqttPersistenceException();
        }
        if (!this.dataDir.exists() && !this.dataDir.mkdirs()) {
            throw new MqttPersistenceException();
        }
        if (!this.dataDir.canWrite()) {
            throw new MqttPersistenceException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < string.length(); ++n2) {
            c2 = string.charAt(n2);
            if (!this.isSafeChar(c2)) continue;
            stringBuffer.append(c2);
        }
        stringBuffer.append("-");
        for (n2 = 0; n2 < string2.length(); ++n2) {
            c2 = string2.charAt(n2);
            if (!this.isSafeChar(c2)) continue;
            stringBuffer.append(c2);
        }
        String string3 = stringBuffer.toString();
        this.clientDir = new File(this.dataDir, string3);
        if (!this.clientDir.exists()) {
            this.clientDir.mkdir();
        }
        try {
            this.fileLock = new FileLock(this.clientDir, LOCK_FILENAME);
        }
        catch (Exception exception) {
            throw new MqttPersistenceException(32200);
        }
        this.restoreBackups(this.clientDir);
    }

    private void checkIsOpen() {
        if (this.clientDir == null) {
            throw new MqttPersistenceException();
        }
    }

    @Override
    public void close() {
        if (this.fileLock != null) {
            this.fileLock.release();
        }
        if (this.getFiles().length == 0) {
            this.clientDir.delete();
        }
        this.clientDir = null;
    }

    @Override
    public void put(String object, MqttPersistable mqttPersistable) {
        block8: {
            block9: {
                boolean bl;
                this.checkIsOpen();
                File file = new File(this.clientDir, (String)object + MESSAGE_FILE_EXTENSION);
                object = new File(this.clientDir, (String)object + z[0]);
                if (file.exists() && !(bl = file.renameTo((File)object))) {
                    ((File)object).delete();
                    file.renameTo((File)object);
                }
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(mqttPersistable.getHeaderBytes(), mqttPersistable.getHeaderOffset(), mqttPersistable.getHeaderLength());
                    if (mqttPersistable.getPayloadBytes() != null) {
                        fileOutputStream.write(mqttPersistable.getPayloadBytes(), mqttPersistable.getPayloadOffset(), mqttPersistable.getPayloadLength());
                    }
                    fileOutputStream.getFD().sync();
                    fileOutputStream.close();
                    if (((File)object).exists()) {
                        ((File)object).delete();
                    }
                    if (!((File)object).exists()) break block8;
                    boolean bl2 = ((File)object).renameTo(file);
                    if (bl2) break block9;
                    file.delete();
                }
                catch (IOException iOException) {
                    try {
                        throw new MqttPersistenceException(iOException);
                    }
                    catch (Throwable throwable) {
                        if (((File)object).exists() && !(bl = ((File)object).renameTo(file))) {
                            file.delete();
                            ((File)object).renameTo(file);
                        }
                        throw throwable;
                    }
                }
                ((File)object).renameTo(file);
            }
            return;
        }
    }

    @Override
    public MqttPersistable get(String object) {
        this.checkIsOpen();
        try {
            Object object2 = new File(this.clientDir, (String)object + MESSAGE_FILE_EXTENSION);
            object2 = new FileInputStream((File)object2);
            int n2 = ((FileInputStream)object2).available();
            byte[] byArray = new byte[n2];
            for (int i2 = 0; i2 < n2; i2 += ((FileInputStream)object2).read(byArray, i2, n2 - i2)) {
            }
            ((FileInputStream)object2).close();
            object = new MqttPersistentData((String)object, byArray, 0, byArray.length, null, 0, 0);
        }
        catch (IOException iOException) {
            throw new MqttPersistenceException(iOException);
        }
        return object;
    }

    @Override
    public void remove(String object) {
        this.checkIsOpen();
        object = new File(this.clientDir, (String)object + MESSAGE_FILE_EXTENSION);
        if (((File)object).exists()) {
            ((File)object).delete();
        }
    }

    @Override
    public Enumeration keys() {
        this.checkIsOpen();
        File[] fileArray = this.getFiles();
        Vector<String> vector = new Vector<String>(fileArray.length);
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            String string = fileArray[i2].getName();
            string = string.substring(0, string.length() - 4);
            vector.addElement(string);
        }
        return vector.elements();
    }

    private File[] getFiles() {
        this.checkIsOpen();
        File[] fileArray = this.clientDir.listFiles(FILE_FILTER);
        if (fileArray == null) {
            throw new MqttPersistenceException();
        }
        return fileArray;
    }

    private boolean isSafeChar(char c2) {
        return Character.isJavaIdentifierPart(c2) || c2 == '-';
    }

    private void restoreBackups(File file) {
        File[] fileArray = file.listFiles(new MqttDefaultFilePersistence$2(this));
        if (fileArray == null) {
            throw new MqttPersistenceException();
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = new File(file, fileArray[i2].getName().substring(0, fileArray[i2].getName().length() - 4));
            boolean bl = fileArray[i2].renameTo(file2);
            if (bl) continue;
            file2.delete();
            fileArray[i2].renameTo(file2);
        }
    }

    @Override
    public boolean containsKey(String object) {
        this.checkIsOpen();
        object = new File(this.clientDir, (String)object + MESSAGE_FILE_EXTENSION);
        return ((File)object).exists();
    }

    @Override
    public void clear() {
        this.checkIsOpen();
        File[] fileArray = this.getFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            fileArray[i2].delete();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u000fO\u0000a";
        int n3 = 1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 33;
                                break;
                            }
                            case 1: {
                                n9 = 34;
                                break;
                            }
                            case 2: {
                                n9 = 115;
                                break;
                            }
                            case 3: {
                                n9 = 6;
                                break;
                            }
                            default: {
                                n9 = 56;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 1: {
                    MESSAGE_FILE_EXTENSION = string.intern();
                    string2 = "\u000fN\u0010m";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    LOCK_FILENAME = string.intern();
                    string2 = "\u000f@\u0006v";
                    n3 = 3;
                    continue block12;
                }
                case 3: {
                    MESSAGE_BACKUP_FILE_EXTENSION = string.intern();
                    string2 = "\u000fO\u0000a\u0016CW\u0003";
                    n3 = -1;
                    continue block12;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "TQ\u0016t\u0016EK\u0001";
                    n3 = 0;
                    continue block12;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        FILE_FILTER = new MqttDefaultFilePersistence$1();
    }
}

