/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import io.yunba.android.a.k;

public class MqttMessage {
    private boolean mutable = true;
    private byte[] payload;
    private int qos = 1;
    private boolean retained = false;
    private boolean dup = false;
    private static final String z;

    public static boolean validateQos(int n2) {
        return n2 >= 0 && n2 <= 2;
    }

    public MqttMessage() {
        this.setPayload(new byte[0]);
    }

    public MqttMessage(byte[] byArray) {
        this.setPayload(byArray);
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void clearPayload() {
        this.checkMutable();
        this.payload = new byte[0];
    }

    public void setPayload(byte[] byArray) {
        this.checkMutable();
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.payload = byArray;
    }

    public boolean isRetained() {
        return this.retained;
    }

    public void setRetained(boolean bl) {
        this.checkMutable();
        this.retained = bl;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int n2) {
        this.checkMutable();
        if (MqttMessage.validateQos(n2)) {
            this.qos = n2;
            return;
        }
        String cfr_ignored_0 = z + n2;
        k.d();
        this.qos = 1;
    }

    public String toString() {
        return new String(this.payload);
    }

    protected void setMutable(boolean bl) {
        this.mutable = bl;
    }

    protected void checkMutable() {
        if (!this.mutable) {
            throw new IllegalStateException();
        }
    }

    protected void setDuplicate(boolean bl) {
        this.dup = bl;
    }

    public boolean isDuplicate() {
        return this.dup;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "TI!\u001d\u007fORdT}\u0000H*KoLH \u001d3\u0000".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 32;
                            break;
                        }
                        case 1: {
                            n7 = 33;
                            break;
                        }
                        case 2: {
                            n7 = 68;
                            break;
                        }
                        case 3: {
                            n7 = 61;
                            break;
                        }
                        default: {
                            n7 = 14;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
    }
}

