/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import io.yunba.android.a.k;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientComms$ConnectBG;
import org.eclipse.paho.client.mqttv3.internal.ClientComms$DisconnectBG;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsCallback;
import org.eclipse.paho.client.mqttv3.internal.CommsReceiver;
import org.eclipse.paho.client.mqttv3.internal.CommsSender;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class ClientComms {
    public static String VERSION;
    public static String BUILD_LEVEL;
    private IMqttAsyncClient client;
    NetworkModule networkModule;
    CommsReceiver receiver;
    CommsSender sender;
    CommsCallback callback;
    ClientState clientState;
    MqttConnectOptions conOptions;
    private MqttClientPersistence persistence;
    CommsTokenStore tokenStore;
    boolean stoppingComms = false;
    static final byte CONNECTED = 0;
    static final byte CONNECTING = 1;
    static final byte DISCONNECTING = 2;
    static final byte DISCONNECTED = 3;
    static final byte CLOSED = 4;
    private byte conState = (byte)3;
    Object conLock = new Object();
    private boolean closePending = false;
    static final String className;
    Logger log = LoggerFactory.getLogger(z[6], className);
    private static final String[] z;

    public ClientComms(IMqttAsyncClient iMqttAsyncClient, MqttClientPersistence mqttClientPersistence) {
        this.conState = (byte)3;
        this.client = iMqttAsyncClient;
        this.persistence = mqttClientPersistence;
        this.tokenStore = new CommsTokenStore(this.getClient().getClientId());
        this.callback = new CommsCallback(this);
        this.clientState = new ClientState(mqttClientPersistence, this.tokenStore, this.callback, this);
        this.callback.setClientState(this.clientState);
        this.log.setResourceName(this.getClient().getClientId());
    }

    void internalSend(MqttWireMessage mqttWireMessage, MqttToken mqttToken) {
        if (mqttToken.getClient() != null) {
            this.log.fine(className, z[13], z[14], new Object[]{mqttWireMessage.getKey(), mqttWireMessage, mqttToken});
            throw new MqttException(32201);
        }
        mqttToken.internalTok.setClient(this.getClient());
        try {
            this.clientState.send(mqttWireMessage, mqttToken);
            return;
        }
        catch (MqttException mqttException) {
            if (mqttWireMessage instanceof MqttPublish) {
                this.clientState.undo((MqttPublish)mqttWireMessage);
            }
            throw mqttException;
        }
    }

    public void sendNoWait(MqttWireMessage mqttWireMessage, MqttToken mqttToken) {
        if (this.isConnected() || !this.isConnected() && mqttWireMessage instanceof MqttConnect || this.isDisconnecting() && mqttWireMessage instanceof MqttDisconnect) {
            this.internalSend(mqttWireMessage, mqttToken);
            return;
        }
        this.log.fine(className, z[26], z[25]);
        throw ExceptionHelper.createMqttException(32104);
    }

    public void destroy() {
        try {
            if (this.callback != null) {
                this.callback.destory();
            }
            if (this.networkModule != null) {
                this.networkModule.stop();
            }
            if (this.receiver != null) {
                this.receiver.destory();
            }
            if (this.sender != null) {
                this.sender.destory();
            }
            try {
                if (this.persistence != null) {
                    this.persistence.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {}
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isClosed()) {
                if (!this.isDisconnected() && !this.isConnecting() && !this.isConnected() && this.isDisconnecting()) {
                    this.closePending = true;
                    return;
                }
                this.conState = (byte)4;
                this.clientState.close();
                this.clientState = null;
                this.callback = null;
                this.persistence = null;
                this.sender = null;
                this.receiver = null;
                this.networkModule = null;
                this.conOptions = null;
                this.tokenStore = null;
            }
            return;
        }
    }

    public void close() {
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isClosed()) {
                if (!this.isDisconnected()) {
                    this.log.fine(className, z[8], z[7]);
                    if (this.isConnecting()) {
                        throw new MqttException(32110);
                    }
                    if (this.isConnected()) {
                        throw ExceptionHelper.createMqttException(32100);
                    }
                    if (this.isDisconnecting()) {
                        this.closePending = true;
                        return;
                    }
                }
                this.conState = (byte)4;
                this.clientState.close();
                this.clientState = null;
                this.callback = null;
                this.persistence = null;
                this.sender = null;
                this.receiver = null;
                this.networkModule = null;
                this.conOptions = null;
                this.tokenStore = null;
            }
            return;
        }
    }

    public void connect(MqttConnectOptions object, MqttToken mqttToken) {
        Object object2 = this.conLock;
        synchronized (object2) {
            if (!this.isDisconnected() || this.closePending) {
                this.log.fine(className, z[24], z[22], new Object[]{new Byte(this.conState)});
                if (this.isClosed() || this.closePending) {
                    throw new MqttException(32111);
                }
                if (this.isConnecting()) {
                    throw new MqttException(32110);
                }
                if (this.isDisconnecting()) {
                    throw new MqttException(32102);
                }
                throw ExceptionHelper.createMqttException(32100);
            }
            this.log.fine(className, z[24], z[23]);
            this.conState = 1;
            this.conOptions = object;
            MqttConnect mqttConnect = new MqttConnect(this.client.getClientId(), ((MqttConnectOptions)object).isCleanSession(), ((MqttConnectOptions)object).getKeepAliveInterval(), ((MqttConnectOptions)object).getUserName(), ((MqttConnectOptions)object).getPassword(), ((MqttConnectOptions)object).getWillMessage(), ((MqttConnectOptions)object).getWillDestination());
            this.clientState.setKeepAliveSecs(((MqttConnectOptions)object).getKeepAliveInterval());
            this.clientState.setCleanSession(((MqttConnectOptions)object).isCleanSession());
            this.tokenStore.open();
            object = new ClientComms$ConnectBG(this, this, mqttToken, mqttConnect);
            ((ClientComms$ConnectBG)object).start();
            return;
        }
    }

    public void connectComplete(MqttConnack mqttConnack, MqttException mqttException) {
        int n2 = mqttConnack.getReturnCode();
        Object object = this.conLock;
        synchronized (object) {
            if (n2 == 0) {
                this.log.fine(className, z[21], z[20]);
                this.conState = 0;
                return;
            }
        }
        this.log.fine(className, z[21], z[19], new Object[]{new Integer(n2)});
        throw mqttException;
    }

    public void shutdownConnection(MqttToken mqttToken, MqttException mqttException) {
        String cfr_ignored_0 = z[10] + mqttException;
        k.b();
        try {
            boolean bl;
            Object object = this.conLock;
            synchronized (object) {
                if (this.stoppingComms || this.closePending) {
                    return;
                }
                this.stoppingComms = true;
                this.log.fine(className, z[12], z[9]);
                bl = this.isConnected() || this.isDisconnecting();
                this.conState = (byte)2;
            }
            if (mqttToken != null && !mqttToken.isComplete()) {
                mqttToken.internalTok.setException(mqttException);
            }
            if (this.callback != null) {
                this.callback.stop();
            }
            try {
                if (this.networkModule != null) {
                    this.networkModule.stop();
                }
            }
            catch (Exception exception) {}
            if (this.receiver != null) {
                this.receiver.stop();
            }
            this.tokenStore.quiesce(new MqttException(32102));
            mqttToken = this.handleOldTokens(mqttToken, mqttException);
            try {
                this.clientState.disconnected(mqttException);
            }
            catch (Exception exception) {}
            if (this.sender != null) {
                this.sender.stop();
            }
            try {
                if (this.persistence != null) {
                    this.persistence.close();
                }
            }
            catch (Exception exception) {}
            object = this.conLock;
            synchronized (object) {
                this.log.fine(className, z[12], z[11]);
                this.conState = (byte)3;
                this.stoppingComms = false;
            }
            if (mqttToken != null & this.callback != null) {
                this.callback.asyncOperationComplete(mqttToken);
            }
            if (bl && this.callback != null) {
                this.callback.connectionLost(mqttException);
            }
            object = this.conLock;
            synchronized (object) {
                if (this.closePending) {
                    try {
                        this.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            k.h();
        }
    }

    private MqttToken handleOldTokens(MqttToken enumeration, MqttException object) {
        k.b();
        Object object2 = null;
        try {
            if (enumeration != null && this.tokenStore.getToken(((MqttToken)((Object)enumeration)).internalTok.getKey()) == null) {
                this.tokenStore.saveToken((MqttToken)((Object)enumeration), ((MqttToken)((Object)enumeration)).internalTok.getKey());
            }
            enumeration = this.clientState.resolveOldTokens((MqttException)object);
            enumeration = ((Vector)((Object)enumeration)).elements();
            while (enumeration.hasMoreElements()) {
                object = (MqttToken)enumeration.nextElement();
                if (((MqttToken)object).internalTok.getKey().equals(MqttDisconnect.KEY) || ((MqttToken)object).internalTok.getKey().equals(MqttConnect.KEY)) {
                    object2 = object;
                    continue;
                }
                this.callback.asyncOperationComplete((MqttToken)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object2;
    }

    public void disconnect(MqttDisconnect object, long l2, MqttToken mqttToken) {
        Object object2 = this.conLock;
        synchronized (object2) {
            if (this.isClosed()) {
                this.log.fine(className, z[0], z[4]);
                throw ExceptionHelper.createMqttException(32111);
            }
            if (this.isDisconnected()) {
                this.log.fine(className, z[0], z[1]);
                throw ExceptionHelper.createMqttException(32101);
            }
            if (this.isDisconnecting()) {
                this.log.fine(className, z[0], z[5]);
                throw ExceptionHelper.createMqttException(32102);
            }
            if (Thread.currentThread() == this.callback.getThread()) {
                this.log.fine(className, z[0], z[3]);
                throw ExceptionHelper.createMqttException(32107);
            }
            this.log.fine(className, z[0], z[2]);
            this.conState = (byte)2;
            object = new ClientComms$DisconnectBG(this, (MqttDisconnect)object, l2, mqttToken);
            ((ClientComms$DisconnectBG)object).start();
            return;
        }
    }

    public boolean isConnected() {
        return this.conState == 0;
    }

    public boolean isConnecting() {
        return this.conState == 1;
    }

    public boolean isDisconnected() {
        return this.conState == 3;
    }

    public boolean isDisconnecting() {
        return this.conState == 2;
    }

    public boolean isClosed() {
        return this.conState == 4;
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback.setCallback(mqttCallback);
    }

    protected MqttTopic getTopic(String string) {
        return new MqttTopic(string, this);
    }

    public void setNetworkModule(NetworkModule networkModule) {
        this.networkModule = networkModule;
    }

    public MqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.tokenStore.getOutstandingDelTokens();
    }

    protected void deliveryComplete(MqttPublish mqttPublish) {
        this.clientState.deliveryComplete(mqttPublish);
    }

    public IMqttAsyncClient getClient() {
        return this.client;
    }

    public long getKeepAlive() {
        return this.clientState.getKeepAlive();
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public MqttConnectOptions getConOptions() {
        return this.conOptions;
    }

    public Properties getDebug() {
        Properties properties = new Properties();
        properties.put(z[17], new Integer(this.conState));
        properties.put(z[16], this.getClient().getServerURI());
        properties.put(z[15], this.callback);
        properties.put(z[18], new Boolean(this.stoppingComms));
        return properties;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        int n2;
        String[] stringArray = new String[27];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n3 = 0;
        String string2 = "L\u0013's\"{<!{!|";
        int n4 = 26;
        block44: while (true) {
            char[] cArray;
            block53: {
                int n5;
                int n6;
                char[] cArray2;
                block52: {
                    char[] cArray3 = string2.toCharArray();
                    n2 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n6 = n7;
                    if (n7 <= 1) break block52;
                    cArray = cArray2;
                    n5 = n6;
                    if (n6 <= n2) break block53;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n2;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n2 % 5) {
                            case 0: {
                                n9 = 15;
                                break;
                            }
                            case 1: {
                                n9 = 127;
                                break;
                            }
                            case 2: {
                                n9 = 78;
                                break;
                            }
                            case 3: {
                                n9 = 22;
                                break;
                            }
                            default: {
                                n9 = 76;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n2;
                        cArray2 = cArray5;
                        n6 = n6;
                        if (n6 != 0) break;
                        cArray5 = cArray2;
                        n5 = n6;
                        n8 = n6;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n5 = n6;
                } while (n6 > n2);
            }
            string = new String(cArray);
            switch (n4) {
                case 26: {
                    className = string.intern();
                    string2 = "k\u0016=u#a\u0011+u8";
                    n4 = -1;
                    continue block44;
                }
                default: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 1;
                    string2 = "=N\u007f";
                    n4 = 0;
                    continue block44;
                }
                case 0: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 2;
                    string2 = "=Nv";
                    n4 = 1;
                    continue block44;
                }
                case 1: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 3;
                    string2 = "=N~";
                    n4 = 2;
                    continue block44;
                }
                case 2: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 4;
                    string2 = "=M}";
                    n4 = 3;
                    continue block44;
                }
                case 3: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 5;
                    string2 = "=Nw";
                    n4 = 4;
                    continue block44;
                }
                case 4: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 6;
                    string2 = "`\r)8)l\u0013'f?jQ>w$`Q-z%j\u0011:8!~\u000b:`\u007f!\u0016 b)}\u0011/zba\u0013=8 `\u0018-w8";
                    n4 = 5;
                    continue block44;
                }
                case 5: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 7;
                    string2 = "=Mz";
                    n4 = 6;
                    continue block44;
                }
                case 6: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 8;
                    string2 = "l\u0013!e)";
                    n4 = 7;
                    continue block44;
                }
                case 7: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 9;
                    string2 = "=Nx";
                    n4 = 8;
                    continue block44;
                }
                case 8: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 10;
                    string2 = "N\u001c:\u007f%`\u0011ne$z\u000b*y;a<!x\"j\u001c:\u007f#a_9\u007f8g_<s-|\u0010 ";
                    n4 = 9;
                    continue block44;
                }
                case 9: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 11;
                    string2 = "=Ny";
                    n4 = 10;
                    continue block44;
                }
                case 10: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 12;
                    string2 = "|\u0017;b(`\b U#a\u0011+u8f\u0010 ";
                    n4 = 11;
                    continue block44;
                }
                case 11: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 13;
                    string2 = "f\u0011:s>a\u001e\"E)a\u001b";
                    n4 = 12;
                    continue block44;
                }
                case 12: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 14;
                    string2 = "=N}";
                    n4 = 13;
                    continue block44;
                }
                case 13: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 15;
                    string2 = "l\u001e\"z.n\u001c%";
                    n4 = 14;
                    continue block44;
                }
                case 14: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 16;
                    string2 = "|\u001a<`)}*\u001c_";
                    n4 = 15;
                    continue block44;
                }
                case 15: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 17;
                    string2 = "l\u0010 E8n\u000b+";
                    n4 = 16;
                    continue block44;
                }
                case 16: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 18;
                    string2 = "|\u000b!f<f\u0011)U#b\u0012=";
                    n4 = 17;
                    continue block44;
                }
                case 17: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 19;
                    string2 = "=Oz";
                    n4 = 18;
                    continue block44;
                }
                case 18: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 20;
                    string2 = "=N{";
                    n4 = 19;
                    continue block44;
                }
                case 19: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 21;
                    string2 = "l\u0010 x)l\u000b\ry!\u007f\u0013+b)";
                    n4 = 20;
                    continue block44;
                }
                case 20: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 22;
                    string2 = "=Oy";
                    n4 = 21;
                    continue block44;
                }
                case 21: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 23;
                    string2 = "=Nz";
                    n4 = 22;
                    continue block44;
                }
                case 22: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 24;
                    string2 = "l\u0010 x)l\u000b";
                    n4 = 23;
                    continue block44;
                }
                case 23: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 25;
                    string2 = "=Ov";
                    n4 = 24;
                    continue block44;
                }
                case 24: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 26;
                    string2 = "|\u001a r\u0002`(/\u007f8";
                    n4 = 25;
                    continue block44;
                }
                case 25: 
            }
            break;
        }
        stringArray2[n3] = string.intern();
        z = stringArray3;
        String string3 = "O?\u0018S\u001e\\6\u0001X\fO";
        int n10 = -1;
        block47: while (true) {
            char[] cArray;
            block55: {
                int n11;
                int n12;
                char[] cArray6;
                block54: {
                    char[] cArray7 = string3.toCharArray();
                    n2 = 0;
                    int n13 = cArray7.length;
                    cArray6 = cArray7;
                    n12 = n13;
                    if (n13 <= 1) break block54;
                    cArray = cArray6;
                    n11 = n12;
                    if (n12 <= n2) break block55;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n14 = n2;
                    while (true) {
                        int n15;
                        char c3 = cArray8[n14];
                        switch (n2 % 5) {
                            case 0: {
                                n15 = 15;
                                break;
                            }
                            case 1: {
                                n15 = 127;
                                break;
                            }
                            case 2: {
                                n15 = 78;
                                break;
                            }
                            case 3: {
                                n15 = 22;
                                break;
                            }
                            default: {
                                n15 = 76;
                            }
                        }
                        cArray8[n14] = (char)(c3 ^ n15);
                        ++n2;
                        cArray6 = cArray9;
                        n12 = n12;
                        if (n12 != 0) break;
                        cArray9 = cArray6;
                        n11 = n12;
                        n14 = n12;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n11 = n12;
                } while (n12 > n2);
            }
            switch (n10) {
                default: {
                    VERSION = new String(cArray).intern();
                    string3 = "O?\fC\u0005C;\u0002S\u001aJ3\u000eV";
                    n10 = 0;
                    continue block47;
                }
                case 0: 
            }
            break;
        }
        BUILD_LEVEL = VERSION;
    }
}

