/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttInputStream
extends InputStream {
    private DataInputStream in;

    public MqttInputStream(InputStream inputStream) {
        this.in = new DataInputStream(inputStream);
    }

    @Override
    public int read() {
        return this.in.read();
    }

    @Override
    public int available() {
        return this.in.available();
    }

    @Override
    public void close() {
        this.in.close();
    }

    public MqttWireMessage readMqttWireMessage() {
        Object object = new ByteArrayOutputStream();
        byte by = this.in.readByte();
        byte by2 = (byte)(by >>> 4 & 0xF);
        if (by2 <= 0 || by2 > 15) {
            throw ExceptionHelper.createMqttException(32108);
        }
        long l2 = MqttWireMessage.readMBI(this.in).getValue();
        ((ByteArrayOutputStream)object).write(by);
        ((OutputStream)object).write(MqttWireMessage.encodeMBI(l2));
        byte[] byArray = new byte[(int)((long)((ByteArrayOutputStream)object).size() + l2)];
        this.in.readFully(byArray, ((ByteArrayOutputStream)object).size(), byArray.length - ((ByteArrayOutputStream)object).size());
        byte[] byArray2 = ((ByteArrayOutputStream)object).toByteArray();
        object = byArray2;
        System.arraycopy(byArray2, 0, byArray, 0, ((Object)object).length);
        object = MqttWireMessage.createWireMessage(byArray);
        return object;
    }
}

