/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.MemoryHandler;
import org.eclipse.paho.client.mqttv3.logging.Logger;

public class JSR47Logger
implements Logger {
    private java.util.logging.Logger julLogger = null;
    private ResourceBundle logMessageCatalog = null;
    private ResourceBundle traceMessageCatalog = null;
    private String catalogID = null;
    private String resourceName = null;
    private String loggerName = null;
    private static final boolean DEBUG_PUSH = false;
    private static final String[] z;

    @Override
    public void initialise(ResourceBundle resourceBundle, String string, String string2) {
        this.traceMessageCatalog = this.logMessageCatalog;
        this.resourceName = string2;
        this.loggerName = string;
        this.julLogger = java.util.logging.Logger.getLogger(this.loggerName);
        this.logMessageCatalog = resourceBundle;
        this.traceMessageCatalog = resourceBundle;
        this.catalogID = this.logMessageCatalog.getString("0");
    }

    @Override
    public void setResourceName(String string) {
        this.resourceName = string;
    }

    @Override
    public boolean isLoggable(int n2) {
        return this.julLogger.isLoggable(this.mapJULLevel(n2));
    }

    @Override
    public void severe(String string, String string2, String string3) {
        this.log(1, string, string2, string3, null, null);
    }

    @Override
    public void severe(String string, String string2, String string3, Object[] objectArray) {
        this.log(1, string, string2, string3, objectArray, null);
    }

    @Override
    public void severe(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.log(1, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void warning(String string, String string2, String string3) {
        this.log(2, string, string2, string3, null, null);
    }

    @Override
    public void warning(String string, String string2, String string3, Object[] objectArray) {
        this.log(2, string, string2, string3, objectArray, null);
    }

    @Override
    public void warning(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.log(2, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void info(String string, String string2, String string3) {
        this.log(3, string, string2, string3, null, null);
    }

    @Override
    public void info(String string, String string2, String string3, Object[] objectArray) {
        this.log(3, string, string2, string3, objectArray, null);
    }

    @Override
    public void info(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.log(3, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void config(String string, String string2, String string3) {
        this.log(4, string, string2, string3, null, null);
    }

    @Override
    public void config(String string, String string2, String string3, Object[] objectArray) {
        this.log(4, string, string2, string3, objectArray, null);
    }

    @Override
    public void config(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.log(4, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void log(int n2, String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        Level level = this.mapJULLevel(n2);
        if (this.julLogger.isLoggable(level)) {
            this.logToJsr47(level, string, string2, this.catalogID, this.logMessageCatalog, string3, objectArray, throwable);
        }
    }

    @Override
    public void fine(String string, String string2, String string3) {
        this.trace(5, string, string2, string3, null, null);
    }

    @Override
    public void fine(String string, String string2, String string3, Object[] objectArray) {
        this.trace(5, string, string2, string3, objectArray, null);
    }

    @Override
    public void fine(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.trace(5, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void finer(String string, String string2, String string3) {
        this.trace(6, string, string2, string3, null, null);
    }

    @Override
    public void finer(String string, String string2, String string3, Object[] objectArray) {
        this.trace(6, string, string2, string3, objectArray, null);
    }

    @Override
    public void finer(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.trace(6, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void finest(String string, String string2, String string3) {
        this.trace(7, string, string2, string3, null, null);
    }

    @Override
    public void finest(String string, String string2, String string3, Object[] objectArray) {
        this.trace(7, string, string2, string3, objectArray, null);
    }

    @Override
    public void finest(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.trace(7, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void trace(int n2, String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        Level level = this.mapJULLevel(n2);
        boolean bl = this.julLogger.isLoggable(level);
        if (throwable != null) {
            throwable.getMessage();
        }
        if (string3.indexOf(z[0]) == -1) {
            MessageFormat.format(this.getResourceMessage(this.traceMessageCatalog, string3), objectArray);
        }
        if (bl) {
            this.logToJsr47(level, string, string2, this.catalogID, this.traceMessageCatalog, string3, objectArray, throwable);
        }
    }

    private String getResourceMessage(ResourceBundle object, String string) {
        try {
            object = ((ResourceBundle)object).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            object = string;
        }
        return object;
    }

    private void logToJsr47(Level serializable, String string, String string2, String string3, ResourceBundle resourceBundle, String string4, Object[] objectArray, Throwable throwable) {
        string3 = string4;
        if (string4.indexOf(z[0]) == -1) {
            string3 = MessageFormat.format(this.getResourceMessage(resourceBundle, string4), objectArray);
        }
        serializable = new LogRecord((Level)serializable, this.resourceName + z[1] + string3);
        ((LogRecord)serializable).setSourceClassName(string);
        ((LogRecord)serializable).setSourceMethodName(string2);
        ((LogRecord)serializable).setLoggerName(this.loggerName);
        if (throwable != null) {
            ((LogRecord)serializable).setThrown(throwable);
        }
        this.julLogger.log((LogRecord)serializable);
    }

    private Level mapJULLevel(int n2) {
        Level level = null;
        switch (n2) {
            case 1: {
                level = Level.SEVERE;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            case 3: {
                level = Level.INFO;
                break;
            }
            case 4: {
                level = Level.CONFIG;
                break;
            }
            case 5: {
                level = Level.FINE;
                break;
            }
            case 6: {
                level = Level.FINER;
                break;
            }
            case 7: {
                level = Level.FINEST;
            }
        }
        return level;
    }

    @Override
    public String formatMessage(String string, Object[] object) {
        try {
            object = this.logMessageCatalog.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            object = string;
        }
        return object;
    }

    @Override
    public void dumpTrace() {
        JSR47Logger.dumpMemoryTrace47(this.julLogger);
    }

    protected static void dumpMemoryTrace47(java.util.logging.Logger object) {
        while (true) {
            Object object2 = null;
            if (object == null) break;
            object2 = ((java.util.logging.Logger)object).getHandlers();
            for (int i2 = 0; i2 < ((Handler[])object2).length; ++i2) {
                if (!(object2[i2] instanceof MemoryHandler)) continue;
                object = object2[i2];
                synchronized (object) {
                    object2 = (MemoryHandler)object2[i2];
                    object2.push();
                    return;
                }
            }
            object = ((java.util.logging.Logger)object).getParent();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u000e<(P\u0017";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 51;
                                break;
                            }
                            case 1: {
                                n9 = 1;
                                break;
                            }
                            case 2: {
                                n9 = 21;
                                break;
                            }
                            case 3: {
                                n9 = 109;
                                break;
                            }
                            default: {
                                n9 = 42;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\t!";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

