/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import io.yunba.android.a.k;
import io.yunba.android.core.YunBaService;
import io.yunba.android.core.a;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsReceiver$1;
import org.eclipse.paho.client.mqttv3.internal.CommsReceiver$2;
import org.eclipse.paho.client.mqttv3.internal.CommsReceiver$3;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttExpandAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRel;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;
import org.json.JSONObject;

public class CommsReceiver
implements Runnable {
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;
    private static final String className;
    private Logger log = LoggerFactory.getLogger(z[10], className);
    private static final String[] z;

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore commsTokenStore, InputStream inputStream) {
        this.in = new MqttInputStream(inputStream);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = commsTokenStore;
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    public void start(String string) {
        this.log.fine(className, z[11], z[12]);
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.recThread = new Thread((Runnable)this, string);
                this.recThread.start();
            }
            return;
        }
    }

    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            this.log.fine(className, z[9], z[8]);
            if (this.running) {
                this.running = false;
                if (!Thread.currentThread().equals(this.recThread)) {
                    try {
                        this.recThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        this.recThread = null;
        this.log.fine(className, z[9], z[7]);
    }

    public void destory() {
        this.running = false;
        try {
            this.recThread.interrupt();
        }
        catch (Exception exception) {
            k.h();
        }
        this.recThread = null;
    }

    @Override
    public void run() {
        MqttToken mqttToken = null;
        while (this.running && this.in != null) {
            try {
                this.log.fine(className, z[3], z[6]);
                MqttWireMessage mqttWireMessage = this.in.readMqttWireMessage();
                if (mqttWireMessage != null) {
                    String cfr_ignored_0 = z[5] + mqttWireMessage.getKey() + z[1] + mqttWireMessage.getMessageId() + z[4] + mqttWireMessage.getType();
                    k.b();
                }
                if (mqttWireMessage instanceof MqttAck) {
                    Object object;
                    mqttToken = this.tokenStore.getToken(mqttWireMessage);
                    if (mqttToken != null) {
                        object = mqttToken;
                        synchronized (object) {
                            if (mqttWireMessage instanceof MqttExpandAck) {
                                mqttWireMessage = (MqttExpandAck)mqttWireMessage;
                                this.handleExpand((MqttExpandAck)mqttWireMessage, mqttToken);
                            } else {
                                this.clientState.notifyReceivedAck((MqttAck)mqttWireMessage);
                            }
                            continue;
                        }
                    }
                    k.d();
                    if (!(mqttWireMessage instanceof MqttPubRec)) continue;
                    k.b();
                    object = (MqttPubRec)mqttWireMessage;
                    new MqttPubRel((MqttPubRec)object);
                    MqttToken mqttToken2 = new MqttToken(YunBaService.f);
                    this.tokenStore.saveToken(mqttToken2, mqttWireMessage);
                    continue;
                }
                this.clientState.notifyReceivedMsg(mqttWireMessage);
            }
            catch (MqttException mqttException) {
                k.h();
                this.running = false;
                if (this.clientComms == null) continue;
                this.clientComms.shutdownConnection(mqttToken, mqttException);
            }
            catch (IOException iOException) {
                k.h();
                this.running = false;
                if (this.clientComms.isDisconnecting() || this.clientComms == null) continue;
                this.clientComms.shutdownConnection(mqttToken, new MqttException(32109, (Throwable)iOException));
            }
            catch (Throwable throwable) {
                this.log.fine(className, z[3], z[2]);
                k.h();
                this.running = false;
                if (this.clientComms == null) continue;
                this.clientComms.shutdownConnection(mqttToken, new MqttException(0, throwable));
            }
        }
        this.log.fine(className, z[3], z[0]);
    }

    private void handleExpand(MqttExpandAck mqttExpandAck, MqttToken mqttToken) {
        k.b();
        mqttExpandAck.toString();
        k.b();
        int n2 = (Integer)mqttToken.getUserContext();
        IMqttActionListener iMqttActionListener = a.a(n2);
        if (iMqttActionListener != null) {
            switch (mqttExpandAck.status) {
                case 0: {
                    try {
                        if (mqttExpandAck.command != 8) {
                            JSONObject jSONObject = new JSONObject(mqttExpandAck.result);
                            mqttToken.setResult(jSONObject);
                        }
                        new Thread(new CommsReceiver$1(this, mqttToken, iMqttActionListener)).start();
                    }
                    catch (Exception exception) {
                        new Thread(new CommsReceiver$2(this, iMqttActionListener)).start();
                    }
                    break;
                }
                default: {
                    new Thread(new CommsReceiver$3(this, iMqttActionListener, mqttExpandAck)).start();
                }
            }
        }
        this.tokenStore.removeToken(mqttExpandAck);
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[13];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0011A\fLK\u0000K\u0002DQ$K\u0013";
        int n3 = 12;
        block21: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block25: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block25;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 82;
                                break;
                            }
                            case 1: {
                                n9 = 46;
                                break;
                            }
                            case 2: {
                                n9 = 97;
                                break;
                            }
                            case 3: {
                                n9 = 33;
                                break;
                            }
                            default: {
                                n9 = 56;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 12: {
                    className = string.intern();
                    string2 = "j\u001bU";
                    n3 = -1;
                    continue block21;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "rC\u0012Fq\u0016\u000e\\\u0001";
                    n3 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "j\u001bR";
                    n3 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = " [\u000f";
                    n3 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "rI\u0004Ul+^\u0004\u0001\u0005r";
                    n3 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "9K\u0018\u0001\u0005r";
                    n3 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "j\u001bS";
                    n3 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "j\u001bP";
                    n3 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "j\u001bQ";
                    n3 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "!Z\u000eQ";
                    n3 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "=\\\u0006\u000f]1B\bQK7\u0000\u0011@P=\u0000\u0002MQ7@\u0015\u000fU#Z\u0015W\u000b|G\u000fU] @\u0000M\u0016<B\u0012\u000fT=I\u0002@L";
                    n3 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "!Z\u0000SL";
                    n3 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "j\u001bT";
                    n3 = 11;
                    continue block21;
                }
                case 11: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

