/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class Token {
    private volatile boolean completed = false;
    private boolean pendingComplete = false;
    private boolean sent = false;
    private Object responseLock = new Object();
    private Object sentLock = new Object();
    protected MqttMessage message = null;
    private MqttWireMessage response = null;
    private MqttException exception = null;
    private String[] topics = null;
    private String key;
    private IMqttAsyncClient client = null;
    private IMqttActionListener callback = null;
    private Object userContext = null;
    public long messageID = 0L;
    public boolean notified = false;
    static final String className;
    Logger log = LoggerFactory.getLogger(z[0], className);
    private static final String[] z;

    public Token(String string) {
        this.log.setResourceName(string);
    }

    public long getMessageID() {
        return this.messageID;
    }

    public void setMessageID(long l2) {
        this.messageID = l2;
    }

    public boolean checkResult() {
        if (this.getException() != null) {
            throw this.getException();
        }
        return true;
    }

    public MqttException getException() {
        return this.exception;
    }

    public boolean isComplete() {
        return this.completed;
    }

    protected boolean isCompletePending() {
        return this.pendingComplete;
    }

    protected boolean isInUse() {
        return this.getClient() != null && !this.isComplete();
    }

    public void setActionCallback(IMqttActionListener iMqttActionListener) {
        this.callback = iMqttActionListener;
    }

    public IMqttActionListener getActionCallback() {
        return this.callback;
    }

    public void waitForCompletion() {
        this.waitForCompletion(-1L);
    }

    public void waitForCompletion(long l2) {
        this.log.fine(className, z[26], z[24], new Object[]{this.getKey(), new Long(l2), this});
        MqttWireMessage mqttWireMessage = this.waitForResponse(l2);
        if (mqttWireMessage == null && !this.completed) {
            this.log.fine(className, z[26], z[25], new Object[]{this.getKey(), this});
            throw new MqttException(32000);
        }
        this.checkResult();
    }

    protected MqttWireMessage waitForResponse() {
        return this.waitForResponse(-1L);
    }

    protected MqttWireMessage waitForResponse(long l2) {
        Object object = this.responseLock;
        synchronized (object) {
            this.log.fine(className, z[8], z[9], new Object[]{this.getKey(), new Long(l2), new Boolean(this.sent), new Boolean(this.completed), this.exception == null ? z[7] : z[6], this.response, this}, this.exception);
            if (!this.completed) {
                if (this.exception == null) {
                    try {
                        this.log.fine(className, z[8], z[11], new Object[]{this.getKey(), new Long(l2)});
                        if (l2 == -1L) {
                            this.responseLock.wait();
                        } else {
                            this.responseLock.wait(l2);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.exception = new MqttException(-100, (Throwable)interruptedException);
                    }
                }
                if (!this.completed && this.exception != null) {
                    this.log.fine(className, z[8], z[5], null, this.exception);
                    throw this.exception;
                }
            }
        }
        this.log.fine(className, z[8], z[10], new Object[]{this.getKey(), this.response});
        return this.response;
    }

    protected void markComplete(MqttWireMessage mqttWireMessage, MqttException mqttException) {
        this.log.fine(className, z[2], z[1], new Object[]{this.getKey(), mqttWireMessage, mqttException});
        Object object = this.responseLock;
        synchronized (object) {
            if (mqttWireMessage instanceof MqttAck) {
                this.message = null;
            }
            this.pendingComplete = true;
            this.response = mqttWireMessage;
            this.exception = mqttException;
            return;
        }
    }

    protected void notifyComplete() {
        this.log.fine(className, z[27], z[1], new Object[]{this.getKey(), this.response, this.exception});
        Object object = this.responseLock;
        synchronized (object) {
            if (this.exception == null && this.pendingComplete) {
                this.completed = true;
            }
            this.pendingComplete = false;
            this.responseLock.notifyAll();
        }
        object = this.sentLock;
        synchronized (object) {
            this.sent = true;
            this.sentLock.notifyAll();
            return;
        }
    }

    public void waitUntilSent() {
        Object object = this.sentLock;
        synchronized (object) {
            Object object2 = this.responseLock;
            synchronized (object2) {
                if (this.exception != null) {
                    throw this.exception;
                }
            }
            if (!this.sent) {
                try {
                    this.log.fine(className, z[13], z[12], new Object[]{this.getKey()});
                    this.sentLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.sent) {
                if (this.exception == null) {
                    throw ExceptionHelper.createMqttException(6);
                }
                throw this.exception;
            }
            return;
        }
    }

    public void waitUntilSent(int n2) {
        Object object = this.sentLock;
        synchronized (object) {
            Object object2 = this.responseLock;
            synchronized (object2) {
                if (this.exception != null) {
                    throw this.exception;
                }
            }
            if (!this.sent) {
                try {
                    this.log.fine(className, z[13], z[12], new Object[]{this.getKey()});
                    this.sentLock.wait(n2);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.sent) {
                if (this.exception == null) {
                    throw ExceptionHelper.createMqttException(6);
                }
                throw this.exception;
            }
            return;
        }
    }

    protected void notifySent() {
        this.log.fine(className, z[3], z[4], new Object[]{this.getKey()});
        Object object = this.responseLock;
        synchronized (object) {
            this.response = null;
            this.completed = false;
        }
        object = this.sentLock;
        synchronized (object) {
            this.sent = true;
            this.sentLock.notifyAll();
            return;
        }
    }

    public IMqttAsyncClient getClient() {
        return this.client;
    }

    protected void setClient(IMqttAsyncClient iMqttAsyncClient) {
        this.client = iMqttAsyncClient;
    }

    public void reset() {
        if (this.isInUse()) {
            throw new MqttException(32201);
        }
        this.log.fine(className, z[22], z[23], new Object[]{this.getKey()});
        this.client = null;
        this.completed = false;
        this.response = null;
        this.sent = false;
        this.exception = null;
        this.userContext = null;
    }

    public MqttMessage getMessage() {
        return this.message;
    }

    public MqttWireMessage getWireMessage() {
        return this.response;
    }

    public void setMessage(MqttMessage mqttMessage) {
        this.message = mqttMessage;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public void setTopics(String[] stringArray) {
        this.topics = stringArray;
    }

    public Object getUserContext() {
        return this.userContext;
    }

    public void setUserContext(Object object) {
        this.userContext = object;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public void setException(MqttException mqttException) {
        Object object = this.responseLock;
        synchronized (object) {
            this.exception = mqttException;
            return;
        }
    }

    public boolean isNotified() {
        return this.notified;
    }

    public void setNotified(boolean bl) {
        this.notified = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(z[17] + this.getKey());
        stringBuffer.append(z[19]);
        if (this.getTopics() != null) {
            for (int i2 = 0; i2 < this.getTopics().length; ++i2) {
                stringBuffer.append(this.getTopics()[i2] + z[18]);
            }
        }
        stringBuffer.append(z[21] + this.getUserContext());
        stringBuffer.append(z[20] + this.isComplete());
        stringBuffer.append(z[16] + this.isNotified());
        stringBuffer.append(z[15] + this.getException());
        stringBuffer.append(z[14] + this.getActionCallback());
        return stringBuffer.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[28];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\"T\r\u0001S.J\u0003_E(\b\u001aN^\"\b\tC_(H\u001e\u0001[<R\u001eY\u0005cO\u0004[S?H\u000bC\u0018#J\u0019\u0001Z\"A\tNB";
        int n3 = -1;
        block35: while (true) {
            char[] cArray;
            block40: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block39: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block39;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block40;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 77;
                                break;
                            }
                            case 1: {
                                n9 = 38;
                                break;
                            }
                            case 2: {
                                n9 = 106;
                                break;
                            }
                            case 3: {
                                n9 = 47;
                                break;
                            }
                            default: {
                                n9 = 54;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "y\u0016^";
                    n3 = 0;
                    continue block35;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = " G\u0018Du\"K\u001aCS9C";
                    n3 = 1;
                    continue block35;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "#I\u001eFP4u\u000fAB";
                    n3 = 2;
                    continue block35;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "y\u0016Y";
                    n3 = 3;
                    continue block35;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "y\u0016[";
                    n3 = 4;
                    continue block35;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "9T\u001fJ";
                    n3 = 5;
                    continue block35;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "+G\u0006\\S";
                    n3 = 6;
                    continue block35;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ":G\u0003[p\"T8JE=I\u0004\\S";
                    n3 = 7;
                    continue block35;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "y\u0016Z";
                    n3 = 8;
                    continue block35;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "y\u0016X";
                    n3 = 9;
                    continue block35;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "y\u0016R";
                    n3 = 10;
                    continue block35;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "y\u0016S";
                    n3 = 11;
                    continue block35;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = ":G\u0003[c#R\u0003Ce(H\u001e";
                    n3 = 12;
                    continue block35;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "m\n\u000bLB$I\u0004LW!J\bNU&\u001b";
                    n3 = 13;
                    continue block35;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "m\n\u000fWU(V\u001eFY#\u001b";
                    n3 = 14;
                    continue block35;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "m\n\u0003\\x\"R\u0003I_(BW";
                    n3 = 15;
                    continue block35;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "&C\u0013\u0012";
                    n3 = 16;
                    continue block35;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "a\u0006";
                    n3 = 17;
                    continue block35;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "m\n\u001e@F$E\u0019\u0012";
                    n3 = 18;
                    continue block35;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "m\n\u0003\\u\"K\u001aCS9CW";
                    n3 = 19;
                    continue block35;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "m\n\u001f\\S?E\u0005AB(^\u001e\u0012";
                    n3 = 20;
                    continue block35;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "?C\u0019JB";
                    n3 = 21;
                    continue block35;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "y\u0017Z";
                    n3 = 22;
                    continue block35;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "y\u0016]";
                    n3 = 23;
                    continue block35;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "y\u0016\\";
                    n3 = 24;
                    continue block35;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = ":G\u0003[p\"T)@[=J\u000f[_\"H";
                    n3 = 25;
                    continue block35;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "#I\u001eFP4e\u0005BF!C\u001eJ";
                    n3 = 26;
                    continue block35;
                }
                case 26: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        className = Token.class.getName();
    }
}

