package com.zdwl.test.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zdwl.test.utils.Child;

import cn.coder.struts.util.StringUtils;

/**
 * 公共服务类
 * @author yydf
 */
public class GlobalService {

	/**
	 * 日志记录
	 */
	//private static final Logger logger = Logger.getLogger(GlobalService.class);

	public String sendMessage(String userMobile, String templete) {
		return "";
	}
	
	protected static int nullToZero(Integer num) {
		if(num == null)
			return 0;
		return num;
	}
	
	protected static String nullToDefault(String str, String defaultValue) {
		if(StringUtils.isEmpty(str))
			return defaultValue;
		return str;
	}
	
	protected static boolean nullToFalse(Boolean flag) {
		if(flag == null)
			return false;
		return flag;
	}

	/**
	 * 赋值子节点
	 * @param list
	 * @param a
	 * @return
	 */
	protected static <T> List<T> children(List<T> list, Child<T> child) {
		List<T> newList = new ArrayList<>();
		if (!list.isEmpty()) {
			Integer parentId;
			Map<Integer, List<T>> children = new HashMap<>();
			for (T t : list) {
				parentId = child.getParentId(t);
				if (parentId > 0) {
					if (children.containsKey(parentId))
						children.get(parentId).add(t);
					else {
						List<T> arr = new ArrayList<>();
						arr.add(t);
						children.put(parentId, arr);
					}
				} else
					newList.add(t);
			}
			list.clear();
			// 赋值子节点
			for (T vo : newList) {
				child.setChildren(vo, children.get(child.getId(vo)));
			}
			children.clear();
		}
		return newList;
	}
}