package com.zdwl.test.base;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;

import com.zdwl.test.utils.DESUtils;

import cn.coder.struts.annotation.Request;
import cn.coder.struts.annotation.Request.HttpMethod;
import cn.coder.struts.support.ActionSupport;
import cn.coder.struts.view.JSONMap;
import cn.coder.struts.view.MultipartFile;

/**
 * 公共控制类
 * 
 * @author YYDF
 *
 */
public class GlobalController extends ActionSupport {

	// private static final Logger logger =
	// Logger.getLogger(GlobalController.class);
	
	@Override
	public String processMultipartFile(MultipartFile file) {
		file.transferTo(new File("d:/aasssssssss" + file.getFieldName() + ".jpg"));
		return file.getFieldName();
	}

	@Request(value = "/upload", method = HttpMethod.POST)
	public void test() {
		MultipartFile file = getMultipartFile("upload=2");
		System.out.println(file);
	}

	protected Integer getMgrId() {
		Object obj = getSession("mgrId");
		if (obj == null)
			return null;
		return Integer.valueOf(obj.toString());
	}

	protected String getOpenId() {
		Object obj = getSession("openId");
		if (obj == null)
			return null;
		return obj.toString();
	}

	protected Integer getUserType() {
		Object obj = getSession("userType");
		if (obj == null)
			return null;
		return Integer.valueOf(obj.toString());
	}

	protected JSONMap getOK(Object... obj) {
		JSONMap jsonMap = JSONMap.success();
		String key = "";
		for (int i = 0; i < obj.length; i++) {
			if (i % 2 == 0) {
				key = (String) obj[i];
			} else {
				jsonMap.put(key, obj[i]);
			}
		}
		return jsonMap;
	}

	protected String getData(Object... objs) {
		return "var data = " + getOK(objs).toString() + ";";
	}

	protected JSONMap getError() {
		return getError(999001);
	}

	protected JSONMap getError(int errId) {
		return getError(errId, ERROR.nameOf(errId));
	}

	protected String getError(String errmsg) {
		try {
			return "location.replace('http://wx.tianjizhigu.com/error.html?e=" + URLEncoder.encode(errmsg, "utf-8")
					+ "');";
		} catch (IOException e) {
		}
		return errmsg;
	}

	protected JSONMap getError(int errId, String msg) {
		return JSONMap.error(errId, msg);
	}

	protected static String createToken(String key, Object... args) throws Exception {
		StringBuilder str = new StringBuilder();
		for (int i = 0; i < args.length; i++) {
			str.append(args[i]).append(",");
		}
		str.append(System.currentTimeMillis());
		String token = DESUtils.encrypt(str.toString(), key);
		return URLEncoder.encode(token, "utf-8");
	}

	protected static void saveFile(File file, String json) throws IOException {
		FileOutputStream out = new FileOutputStream(file);
		out.write(json.getBytes("utf-8"));
		out.close();
	}

	public static final int PAGE_SIZE = 15;

}