package com.zdwl.test.controller;

import javax.annotation.Resource;

import cn.coder.struts.annotation.Request;
import cn.coder.struts.annotation.Request.HttpMethod;
import cn.coder.struts.util.StringUtils;
import cn.coder.struts.view.JSONMap;
import cn.coder.jdbc.support.PageResult;

import com.zdwl.test.base.GlobalController;
import com.zdwl.test.entity.Weike;
import com.zdwl.test.service.WeikeService;

@Request("/weike")
public class WeikeController extends GlobalController {

	@Resource
	private WeikeService service;

	@Request(value = "/list", method = HttpMethod.GET)
	public JSONMap getWeikeList() {
		service.test();
		String words = getParameter("words");
		Integer page = getParameter(Integer.class, "page");
		if (StringUtils.isEmpty(page)) 
			return getOK("vos", service.getWeikeList(words));
		PageResult result = new PageResult(getParameter("page"), PAGE_SIZE);
		return getOK("vos", service.getWeikeByPage(words, result), "page", result);
	}

	@Request("/page.js")
	public String getWeikePageJS() {
		String words = getParameter("words");
		PageResult result = new PageResult(getParameter("page"), PAGE_SIZE);
		return getData("vos", service.getWeikeByPage(words, result), "page", result);
	}

	@Request("/info")
	public JSONMap getWeikeVo() {
		String id = getParameter("id");
		return getOK("vo", service.getWeikeVo(id));
	}

	@Request("/info.js")
	public String getWeikeVoJS() {
		String id = getParameter("id");
		return getData("vo", service.getWeikeVo(id));
	}

	@Request("/move")
	public JSONMap moveWeike() {
		String id = getParameter("id");
		String direction = getParameter("d");
		if (service.moveWeike(id, direction))
			return getOK();
		if("0".equals(direction))
			return getError(999006);
		return getError(999007);
	}
	
	@Request(value = "/add", method = HttpMethod.POST)
	public JSONMap saveWeike() {
		Weike entity = getPostData(Weike.class);
		if (service.saveWeike(entity))
			return getOK();
		return getError();
	}

	@Request("/del")
	public JSONMap delWeike() {
		String id = getParameter("id");
		if (service.delWeike(id))
			return getOK();
		return getError();
	}

	@Request("/status")
	public JSONMap changeStatus() {
		String id = getParameter("id");
		String status = getParameter("status");
		String reason = getParameter("reason");
		if (service.changeStatus(id, status, reason))
			return getOK();
		return getError();
	}
}