package com.zdwl.test.service;

import java.util.List;

import javax.annotation.Resource;

import cn.coder.struts.util.StringUtils;
import cn.coder.jdbc.support.MulitResult;
import cn.coder.jdbc.support.PageResult;
import com.zdwl.test.base.GlobalService;
import com.zdwl.test.dao.WeikeDao;
import com.zdwl.test.entity.Weike;
import com.zdwl.test.model.WeikeVo;

public class WeikeService extends GlobalService {

	@Resource
	private WeikeDao dao;

	// 获取列表
	public List<WeikeVo> getWeikeList(String words) {
		if (StringUtils.isEmpty(words))
			return dao.getWeikeList();
		return dao.getWeikeList(words);
	}

	// 获取分页列表
	public List<WeikeVo> getWeikeByPage(String words, PageResult result) {
		if (StringUtils.isEmpty(words))
			return dao.getWeikeByPage(result);
		return dao.getWeikeByPage(words, result);
	}

	// 获取单个对象
	public WeikeVo getWeikeVo(String id) {
		WeikeVo vo = dao.getWeikeVo(id);
		if (vo != null) {
			// vo赋值
		}
		return vo;
	}

	// 排序实现
	public boolean moveWeike(String data, String direction) {
		List<WeikeVo> sortList = dao.getSortedList(direction, dao.getWeikeVo(data));
		if (sortList.size() < 2)
			return false;
		return dao.moveWeike(sortList.get(0), sortList.get(1));
	}

	// 保存对象
	public boolean saveWeike(Weike entity) {
		if (entity.getId() == null) {
			// vo赋值
			// entity.setWeikeSort(dao.getWeikeSort());
			// entity.setWeikeAddtime(new Date());
			return dao.insert(entity);
		}
		return dao.update(entity);
	}

	// 删除对象
	public boolean delWeike(String id) {
		return dao.delWeike(id);
	}

	// 更新状态
	public boolean changeStatus(String id, String status, String reason) {
		if (StringUtils.isEmpty(reason))
			reason = "ok";
		return dao.changeStatus(id, status, reason);
	}

	public void test() {
		MulitResult mr = dao.test();
		if (mr != null) {
			WeikeVo vo = (WeikeVo) mr.getResult(0);
			System.out.println(vo.getTitle());
			mr.getResultList(1);
		}
	}
}