package com.zdwl.test.dao;

import java.util.List;

import cn.coder.jdbc.SqlSession;
import cn.coder.jdbc.support.MulitResult;
import cn.coder.jdbc.support.PageResult;

import com.zdwl.test.base.GlobalDao;
import com.zdwl.test.model.WeikeVo;

/**
 * Weike_Dao
 * 
 * @author YYDF
 * @since 1.8
 *
 */
public class WeikeDao extends GlobalDao {

	public List<WeikeVo> getWeikeList() {
		return jdbc().selectList(WeikeVo.class, "select * from weike");
	}

	public List<WeikeVo> getWeikeList(String words) {
		words = "%" + words + "%";
		return jdbc().selectList(WeikeVo.class, "select * from weike", words);
	}

	private static final String SQL_DATA_LIST = "select * from weike";
	private static final String SQL_DATA_NUM = "select count(1) from weike";

	public List<WeikeVo> getWeikeByPage(PageResult result) {
		return jdbc().selectPage(WeikeVo.class, result, SQL_DATA_LIST, SQL_DATA_NUM);
	}

	private static final String SQL_SEARCH_LIST = "select * from weike";
	private static final String SQL_SEARCH_NUM = "select count(1) from weike";

	public List<WeikeVo> getWeikeByPage(String words, PageResult result) {
		words = "%" + words + "%";
		return jdbc().selectPage(WeikeVo.class, result, SQL_SEARCH_LIST, SQL_SEARCH_NUM, words);
	}

	public WeikeVo getWeikeVo(String id) {
		return jdbc().selectOne(WeikeVo.class, "select * from weike where id=?", id);
	}

	public Integer getWeikeSort() {
		/*
		 * 获取排序数 Integer num = jdbc().selectOne(Integer.class,
		 * "select max(sort) from weike"); if(num != null) return num + 1;
		 */
		return 0;
	}

	public List<WeikeVo> getSortedList(String direction, WeikeVo vo) {
		/*
		 * 获取要排序的两行 if("0".equals(direction)) return
		 * jdbc().selectList(WeikeVo.class,
		 * "SELECT * FROM weike WHERE sort<=? ORDER BY sort DESC LIMIT 0,2",
		 * vo.getWeikeSort()); return jdbc().selectList(WeikeVo.class,
		 * "SELECT * FROM weike WHERE sort>=? ORDER BY sort LIMIT 0,2",
		 * vo.getWeikeSort());
		 */
		return null;
	}

	// 实现上下移动
	public boolean moveWeike(WeikeVo vo1, WeikeVo vo2) {
		return tran(new Run() {
			@Override
			public void exec(SqlSession tran) {
				// jdbc().execute(tran, "update weike set sort=? where id=?",
				// vo1.getWeikeSort(), vo1.getWeikeId());
				// jdbc().execute(tran, "update weike set sort=? where id=?",
				// vo2.getWeikeSort(), vo2.getWeikeId());
			}
		});
	}

	public boolean delWeike(String id) {
		return jdbc().execute("delete from weike where id=?", id) > 0;
	}

	public boolean changeStatus(String id, String status, String reason) {
		return jdbc().execute("update weike set status=?,reason=? where id=?", status, reason, id) > 0;
	}

	public MulitResult test() {
		MulitResult mr = new MulitResult();
		mr.add(WeikeVo.class, "select * from weike where id=?", 2).add(WeikeVo.class, "select * from weike where id=?", 4);
		if(jdbc().selectMulit(mr)){
			return mr;
		}
		return null;
	}

}