var csInterface = new CSInterface();
var fs = require('fs');
var nodePath = require("path");
var zlib = require('zlib');
var spawn = require('child_process');
var request = require('request');

var outPutPath;
var inputPath;

var player;
var parser;

var workPath;

var storageCounter;

var CURRENT_SOURCE_PATH;
var CURRENT_SOURCE_NAME;
var CURRENT_FILE_PATH;
var CURRENT_PROJECT_PATH = csInterface.getSystemPath(SystemPath.APPLICATION);
var TEMP_SOURCE_PATH = nodePath.join(csInterface.getSystemPath(SystemPath.MY_DOCUMENTS), '_WORKINGTEMP_');
var CURRENT_OUTPUT_VERSION = "2.0";

// 关闭窗口的时候关闭服务器
window.onunload = function () {
    // 删除临时文件目录
    deleteFlider(TEMP_SOURCE_PATH, true, true, function () { });
}

function updateInfo(callback) {
    csInterface.evalScript("getActiveInfo()", function (result) {

        storageCounter = 0;
        var infoArr = result.split('_and_');
        CURRENT_FILE_PATH = infoArr[0];
        var pathArr = infoArr[0].split(nodePath.sep);
        pathArr.pop();
        CURRENT_SOURCE_PATH = pathArr.join(nodePath.sep);
        CURRENT_SOURCE_NAME = infoArr[1];

        callback();
    });
}

function selectPath() {

    updateInfo(function () {
        var result = window.cep.fs.showSaveDialogEx("选择保存目录", CURRENT_SOURCE_PATH, ["svga"], CURRENT_SOURCE_NAME + '.svga', '');

        if (result.data) {
            outPutPath = result.data;

            var startConvertBtn = document.getElementById("startConvertBtn");
            startConvertBtn.disabled = false;
            var dropDownBtn = document.getElementById("dropDownBtn");
            dropDownBtn.disabled = false;
        }
    });
}

function openMenu() {

    document.getElementById("dropGroupDiv").className = document.getElementById("dropGroupDiv").className == "col-md-5 btn-group" ? "col-md-5 btn-group open" : "col-md-5 btn-group";

}

function startConvert() {

    if (outPutPath == null || outPutPath == undefined || outPutPath == '') {
        alertMessages("请先选择输出路径...");

    } else {
        createTempFolder(function () {
            var startConvertBtn = document.getElementById("startConvertBtn");
            startConvertBtn.disabled = true;

            var dropDownBtn = document.getElementById("dropDownBtn");
            dropDownBtn.disabled = true;

            var tempPath = nodePath.join(TEMP_SOURCE_PATH, 'Temp.aep');
            var OSVersion = csInterface.getOSInformation();
            if (OSVersion.indexOf("Windows") >= 0) {

                tempPath = tempPath.split("\\").join("\\\\");
                CURRENT_FILE_PATH = CURRENT_FILE_PATH.split("\\").join("\\\\");
            }
            csInterface.evalScript("correctMessage('" + tempPath + "');", function (result) {

                csInterface.evalScript("startConvert('" + nodePath.join(TEMP_SOURCE_PATH, 'svga_works') + "');", function (result) {

                    csInterface.evalScript("openProject('" + CURRENT_FILE_PATH + "');");
                    var imagePath = result;
                    workPath = result;

                    //获取图片资源列表
                    fs.readdir(imagePath, function (err, files) {

                        for (var i = 0; i < files.length; i++) {
                            if (files[i] == "movie.spec") {
                                files.splice(i, 1);
                            }
                        }
                        var imageList = files;

                        if (CURRENT_OUTPUT_VERSION == "2.0") {
                            copyToBinary(imagePath, imageList);
                        } else {
                            for (var i = 0; i < files.length; i++) {
                                if (files[i].indexOf(".mp3") > 0) {
                                    files.splice(i, 1);
                                }
                            }
                            imageList = files;
                            copyToZip(imagePath, imageList);
                        }
                    });
                });
            });
        });
    }
}

function changeToVersion(version) {
    CURRENT_OUTPUT_VERSION = version;
    var startConvertBtn = document.getElementById("startConvertBtn");
    startConvertBtn.innerHTML = "开始转换 - " + version;
}

function selectFile() {

    csInterface.evalScript("browseFolder()", function (result) {

        if (result != 'undefined') {
            inputPath = result;

            preview(result);
        }
    });
}

function createTempFolder(callback) {

    // 删除临时文件目录
    deleteFlider(TEMP_SOURCE_PATH, true, true, function () {

        // 创建 temp 文件夹
        fs.mkdir(TEMP_SOURCE_PATH, function () {
            callback();
        });
    });
}

function preview(filePath) {

    var fileName = filePath;

    parser.load(fileName, function (videoItem) {
        player.setContentMode("AspectFit");
        player.setClipsToBounds(true);

        player.setVideoItem(videoItem);
        player.startAnimation();
    })
}

function copyToBinary(zipPath, imageList) {
    var fileMapping = {};
    // 判断是否有图片
    if (imageList.length) {

        stepToBinary(fileMapping, 0, imageList, zipPath);
    } else {
        // 没有图片
        var spec = JSON.parse(fs.readFileSync(zipPath + '/movie.spec', { encoding: "utf-8" }));

        var stream = new Buffer(SVGAProtoHelper_2_0_0.convertToProto(spec, fileMapping));
        fs.writeFileSync(outPutPath, zlib.deflateSync(stream));
        // 删除临时文件目录
        deleteFlider(workPath, true, true, function () {
        });
        document.getElementById('storageCounter').innerHTML = "内存占用：0 M";
        preview(outPutPath);
        outPutPath = undefined;
    }
}

function stepToBinary(fileMapping, currentIndex, imageList, zipPath, callback) {
    var imageName = imageList[currentIndex].toString();
    var imagePath = nodePath.join(zipPath, imageName);

    var pngquantAndZip = function (imagePath) {

        pngquantImage(imagePath, imagePath, function () {

            waitForFileIfExist(imagePath, function () {

                fs.readFile(imagePath, function (err, data) {

                    var arrayBufferData = toArrayBuffer(data);

                    fileMapping[imageName.split('.')[0]] = arrayBufferData;

                    var data = new Uint8Array(arrayBufferData);
                    var width = data[18] * 256 + data[19];
                    var height = data[22] * 256 + data[23];

                    storageCounter += (width * height * 4);

                    if (currentIndex == imageList.length - 1) {

                        var spec = JSON.parse(fs.readFileSync(zipPath + '/movie.spec', { encoding: "utf-8" }));
                        var stream = new Buffer(SVGAProtoHelper_2_0_0.convertToProto(spec, fileMapping));

                        fs.writeFileSync(outPutPath, zlib.deflateSync(stream));
                        // 删除临时文件目录
                        deleteFlider(workPath, true, true, function () { });
                        if (storageCounter == undefined || storageCounter == "undefined") {
                            document.getElementById('storageCounter').innerHTML = "内存占用：0 M";
                        } else {
                            document.getElementById('storageCounter').innerHTML = "内存占用：" + Math.round((storageCounter / 1048576) * 100) / 100 + " M";
                            if (storageCounter > 8388608) {
                                alertMessages("内存占用超过8M，可能导致目标应用崩溃！");
                            }
                        }
                        preview(outPutPath);
                        outPutPath = undefined;

                    } else {
                        stepToBinary(fileMapping, ++currentIndex, imageList, zipPath);
                    }
                });
            });
        });
    };

    // 判断照片中是否有 jpg 图片
    if (imageName.split('.').pop() == 'jpg') {

        convertJPGToPNG(imagePath, null, pngquantAndZip(imagePath));

    } else if (imageName.split('.').pop() == 'png') {

        pngquantAndZip(imagePath);
    }
    else if (imageName.split('.').pop() == 'mp3') {
        fs.readFile(imagePath, function (err, data) {
            var arrayBufferData = toArrayBuffer(data);
            fileMapping[imageName.split('.')[0]] = arrayBufferData;
            if (currentIndex == imageList.length - 1) {
                var spec = JSON.parse(fs.readFileSync(zipPath + '/movie.spec', { encoding: "utf-8" }));
                var stream = new Buffer(SVGAProtoHelper_2_0_0.convertToProto(spec, fileMapping));
                fs.writeFileSync(outPutPath, zlib.deflateSync(stream));
                // 删除临时文件目录
                deleteFlider(workPath, true, true, function () {
                });
                if (storageCounter == undefined || storageCounter == "undefined") {
                    document.getElementById('storageCounter').innerHTML = "内存占用：0 M";
                } else {
                    document.getElementById('storageCounter').innerHTML = "内存占用：" + Math.round((storageCounter / 1048576) * 100) / 100 + " M";
                    if (storageCounter > 8388608) {
                        alertMessages("内存占用超过8M，可能导致目标应用崩溃！");
                    }
                }
                preview(outPutPath);
                outPutPath = undefined;

            } else {
                stepToBinary(fileMapping, ++currentIndex, imageList, zipPath);
            }
        })
    } else {

        if (currentIndex == imageList - 1) {
            var spec = JSON.parse(fs.readFileSync(zipPath + '/movie.spec', { encoding: "utf-8" }));
            var stream = new Buffer(SVGAProtoHelper_2_0_0.convertToProto(spec, fileMapping));
            fs.writeFileSync(outPutPath, zlib.deflateSync(stream));
            // 删除临时文件目录
            deleteFlider(workPath, true, true, function () {
            });
            if (storageCounter == undefined || storageCounter == "undefined") {
                document.getElementById('storageCounter').innerHTML = "内存占用：0 M";
            } else {
                document.getElementById('storageCounter').innerHTML = "内存占用：" + Math.round((storageCounter / 1048576) * 100) / 100 + " M";
                if (storageCounter > 8388608) {
                    alertMessages("内存占用超过8M，可能导致目标应用崩溃！");
                }
            }
            preview(outPutPath);
            outPutPath = undefined;

        } else {
            stepToBinary(fileMapping, ++currentIndex, imageList, zipPath);
        }
    }
}

function copyToZip(zipPath, imageList) {
    var zip = new JSZip();

    // 判断是否有图片
    if (imageList.length) {

        stepToZip(zip, 0, imageList, zipPath);
    } else {

        // 没有图片
        var movin = window.cep.fs.readFile(zipPath + '/movie.spec', 'Base64');
        var movinUTF8 = cep.encoding.convertion.b64_to_utf8(movin.data);
        var movinObject = JSON.parse(movinUTF8);
        zip.file("movie.spec", movinUTF8);
        if (CURRENT_OUTPUT_VERSION == "1.5") {
            var movinProtoBuf = new Buffer(SVGAProtoHelper_1_5_0.convertToProto(movinObject));
            zip.file("movie.binary", movinProtoBuf);
        }

        zip.generateAsync({ type: "Base64", compression: "DEFLATE" })
            .then(function (content) {

                // 将文件写入本地
                fs.writeFile(outPutPath, content, 'Base64', function (err) {

                    document.getElementById('storageCounter').innerHTML = "内存占用：0 M";
                    // 删除 temp 目录
                    deleteFlider(TEMP_SOURCE_PATH, true, true, function () { });
                    preview(outPutPath);
                    outPutPath = undefined;
                });
            });
    }
}

function stepToZip(zip, currentIndex, imageList, zipPath, callback) {

    var imageName = imageList[currentIndex].toString();
    var imagePath = nodePath.join(zipPath, imageName);

    var pngquantAndZip = function (imagePath) {

        pngquantImage(imagePath, imagePath, function () {

            waitForFileIfExist(imagePath, function () {

                fs.readFile(imagePath, 'Base64', function (err, data) {

                    zip.file(imageName, data, { base64: true });

                    try {
                        var dataArray = dataURLtoUint8(data);

                    } catch (e) {
                        alert(e);
                    }
                    var width = dataArray[18] * 256 + dataArray[19];
                    var height = dataArray[22] * 256 + dataArray[23];

                    storageCounter += (width * height * 4);

                    if (currentIndex == imageList.length - 1) {

                        var movin = window.cep.fs.readFile(zipPath + '/movie.spec', 'Base64');
                        var movinUTF8 = cep.encoding.convertion.b64_to_utf8(movin.data);
                        var movinObject = JSON.parse(movinUTF8);
                        zip.file("movie.spec", movinUTF8);

                        if (CURRENT_OUTPUT_VERSION == "1.5") {
                            var movinProtoBuf = new Buffer(SVGAProtoHelper_1_5_0.convertToProto(movinObject));
                            zip.file("movie.binary", movinProtoBuf);
                        }

                        zip.generateAsync({ type: "Base64", compression: "DEFLATE" })
                            .then(function (content) {

                                // 将文件写入本地
                                fs.writeFile(outPutPath, content, 'Base64', function (err) {

                                    deleteFlider(TEMP_SOURCE_PATH, true, true, function () { });
                                    if (storageCounter == undefined || storageCounter == "undefined") {
                                        document.getElementById('storageCounter').innerHTML = "内存占用：0 M";
                                    } else {
                                        document.getElementById('storageCounter').innerHTML = "内存占用：" + Math.round((storageCounter / 1048576) * 100) / 100 + " M";
                                        if (storageCounter > 8388608) {
                                            alertMessages("内存占用超过8M，可能导致目标应用崩溃！");
                                        }
                                    }
                                    preview(outPutPath);
                                    outPutPath = undefined;
                                });
                            });

                    } else {
                        stepToZip(zip, ++currentIndex, imageList, zipPath);
                    }
                });
            });
        });
    };

    // 判断照片中是否有 jpg 图片
    if (imageName.split('.').pop() == 'jpg') {

        convertJPGToPNG(imagePath, null, pngquantAndZip(imagePath));

    } else if (imageName.split('.').pop() == 'png') {

        pngquantAndZip(imagePath);
    } else {

        if (currentIndex == imageList - 1) {

            var movin = window.cep.fs.readFile(zipPath + '/movie.spec', 'Base64');
            var movinUTF8 = cep.encoding.convertion.b64_to_utf8(movin.data);
            var movinObject = JSON.parse(movinUTF8);
            zip.file("movie.spec", movinUTF8);

            if (CURRENT_OUTPUT_VERSION == "1.5") {
                var movinProtoBuf = new Buffer(SVGAProtoHelper_1_5_0.convertToProto(movinObject));
                zip.file("movie.binary", movinProtoBuf);
            }

            zip.generateAsync({ type: "Base64", compression: "DEFLATE" })
                .then(function (content) {

                    // 将文件写入本地
                    fs.writeFile(outPutPath, content, 'Base64', function (err) {
                        if (storageCounter == undefined || storageCounter == "undefined") {
                            document.getElementById('storageCounter').innerHTML = "内存占用：0 M";
                        } else {
                            document.getElementById('storageCounter').innerHTML = "内存占用：" + Math.round((storageCounter / 1048576) * 100) / 100 + " M";
                            if (storageCounter > 8388608) {
                                alertMessages("内存占用超过8M，可能导致目标应用崩溃！");
                            }
                        }
                        deleteFlider(TEMP_SOURCE_PATH, true, true, function () { });
                        preview(outPutPath);
                        outPutPath = undefined;

                    });
                });
        } else {
            stepToZip(zip, ++currentIndex, imageList, zipPath);
        }
    }
}

function deleteFlider(path, isFirstFolder, delFirstFolder, callback) {

    if (fs.existsSync(path)) {
        fs.readdirSync(path).forEach(function (file) {

            var curPath = nodePath.join(path, file);
            if (fs.statSync(curPath).isDirectory()) { // recurse
                deleteFlider(curPath, false, true);
            } else { // delete file
                fs.unlinkSync(curPath);
            }
        });
        if (!isFirstFolder || delFirstFolder) {
            fs.rmdirSync(path);
        }
    }
    if (isFirstFolder) {
        callback();
    }
}

function waitForFileIfExist(filePath, callback) {

    // 判断是否有这个文件
    fs.exists(filePath, function (exists) {
        if (exists) {
            callback();
        } else {
            // 如果没有 500 ms 后重新查看
            setTimeout(waitForFileIfExist(filePath, callback), 500);
        }
    });
}

function convertJPGToPNG(imageInputPath, imageOutputPath, callback) {

    var img = new Image();
    img.onload = function () {

        var canvas = document.createElement("canvas");
        canvas.width = img.width;
        canvas.height = img.height;
        canvas.getContext("2d").drawImage(img, 0, 0);

        if (imageOutputPath == null) {

            callback(canvas.toDataURL("image/png").split(',').pop(), nodePath.basename(result, '.jpg'));

        } else {
            fs.writeFile(imageOutputPath, canvas.toDataURL("image/png").split(',').pop(), "Base64", function (err) {
                callback(imageOutputPath);
            });
        }
    };
    img.src = imageInputPath;

}

function toArrayBuffer(buf) {
    var ab = new ArrayBuffer(buf.length);
    var view = new Uint8Array(ab);
    for (var i = 0; i < buf.length; ++i) {
        view[i] = buf[i];
    }
    return ab;
}

function dataURLtoUint8(dataurl) {
    var arr = dataurl.split(','),
        bstr = atob(arr.pop()),
        n = bstr.length,
        u8arr = new Uint8Array(n);
    while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
    }
    return u8arr;
}

function pngquantImage(inImgPath, outImgPath, callback) {

    var program;

    // 判断当前系统
    var OSVersion = csInterface.getOSInformation();
    if (OSVersion.indexOf("Windows") >= 0) {

        program = nodePath.join(CURRENT_PROJECT_PATH, 'pngquant', 'WINDOWS', 'pngquant.exe');
        program = '\"' + program + '\"';

    } else if (OSVersion.indexOf("Mac") >= 0) {

        program = nodePath.join(CURRENT_PROJECT_PATH, 'pngquant', 'OSX', 'pngquant').replace('Application ', 'Application\\ ');
    }

    var args = [

        '--quality=0-100',
        '--speed 2',
        inImgPath,
        '--output',
        outImgPath,
        '--force'
    ];

    spawn.exec(program + ' ' + args.join(' '), function () {
        callback();
    });
}

function exportBlendMode(){ 
    csInterface.evalScript("exportBlendMode('" + TEMP_SOURCE_PATH + "');", function (result) {});
}

!function (e) { function t(o) { if (r[o]) return r[o].exports; var n = r[o] = { i: o, l: !1, exports: {} }; return e[o].call(n.exports, n, n.exports, t), n.l = !0, n.exports } var r = {}; t.m = e, t.c = r, t.d = function (e, r, o) { t.o(e, r) || Object.defineProperty(e, r, { configurable: !1, enumerable: !0, get: o }) }, t.n = function (e) { var r = e && e.__esModule ? function () { return e.default } : function () { return e }; return t.d(r, "a", r), r }, t.o = function (e, t) { return Object.prototype.hasOwnProperty.call(e, t) }, t.p = "", t(t.s = 1) }([function (e, t) { var r; r = function () { return this }(); try { r = r || Function("return this")() || (0, eval)("this") } catch (e) { "object" == typeof window && (r = window) } e.exports = r }, function (e, t, r) { "use strict"; function o(e, t) { if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function") } function n(e) { for (var t = new ArrayBuffer(e.length), r = new Uint8Array(t), o = 0, n = e.length; o < n; o++)r[o] = e.charCodeAt(o); return t } var s = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (e) { return typeof e } : function (e) { return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e }, i = function () { function e(e, t) { for (var r = 0; r < t.length; r++) { var o = t[r]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, o.key, o) } } return function (t, r, o) { return r && e(t.prototype, r), o && e(t, o), t } }(), a = r(2), g = function () { function e() { o(this, e) } return i(e, null, [{ key: "convertToProto", value: function (e) { var t = new a.MovieEntity; t.setVersion("1.5.0"); var r = new a.MovieParams; r.setViewboxwidth(e.movie.viewBox.width), r.setViewboxheight(e.movie.viewBox.height), r.setFps(e.movie.fps), r.setFrames(e.movie.frames), t.setParams(r); var o = t.getImagesMap(); for (var i in e.images) { var g = e.images[i]; o.set(i, n(g)) } var p = t.getSpritesList(); return e.sprites.forEach(function (e) { var t = new a.SpriteEntity; t.setImagekey(e.imageKey); var r = t.getFramesList(); e.frames.forEach(function (e) { var t = new a.FrameEntity; if ("number" == typeof e.alpha && t.setAlpha(e.alpha || 1), "object" === s(e.layout) && t.setLayout(function (e) { var t = new a.Layout; return t.setX(e.x), t.setY(e.y), t.setWidth(e.width), t.setHeight(e.height), t }(e.layout)), "object" === s(e.transform) && t.setTransform(function (e) { var t = new a.Transform; return t.setA(e.a), t.setB(e.b), t.setC(e.c), t.setD(e.d), t.setTx(e.tx), t.setTy(e.ty), t }(e.transform)), "string" == typeof e.clipPath && t.setClippath(e.clipPath), "object" === s(e.shapes)) { var o = t.getShapesList(); e.shapes.forEach(function (e) { var t = new a.ShapeEntity; if (t.setType(function () { return "shape" === e.type ? a.ShapeEntity.ShapeType.SHAPE : "rect" === e.type ? a.ShapeEntity.ShapeType.RECT : "ellipse" === e.type ? a.ShapeEntity.ShapeType.ELLIPSE : "keep" === e.type ? a.ShapeEntity.ShapeType.KEEP : void 0 }(e.type)), "object" === s(e.args)) if ("shape" === e.type) { var r = new a.ShapeEntity.ShapeArgs; "string" == typeof e.args.d && r.setD(e.args.d), t.setShape(r) } else if ("rect" === e.type) { var n = new a.ShapeEntity.RectArgs; "number" == typeof e.args.x && n.setX(e.args.x), "number" == typeof e.args.y && n.setY(e.args.y), "number" == typeof e.args.width && n.setWidth(e.args.width), "number" == typeof e.args.height && n.setHeight(e.args.height), "number" == typeof e.args.cornerRadius && n.setCornerradius(e.args.cornerRadius), t.setRect(n) } else if ("ellipse" === e.type) { var i = new a.ShapeEntity.EllipseArgs; "number" == typeof e.args.x && i.setX(e.args.x), "number" == typeof e.args.y && i.setY(e.args.y), "number" == typeof e.args.radiusX && i.setRadiusx(e.args.radiusX), "number" == typeof e.args.radiusY && i.setRadiusy(e.args.radiusY), t.setEllipse(i) } if ("object" === s(e.styles)) { var g = new a.ShapeEntity.ShapeStyle; if ("object" === s(e.styles.fill)) { var p = new a.ShapeEntity.ShapeStyle.RGBAColor; p.setR(e.styles.fill[0]), p.setG(e.styles.fill[1]), p.setB(e.styles.fill[2]), p.setA(e.styles.fill[3]), g.setFill(p) } if ("object" === s(e.styles.stroke)) { var u = new a.ShapeEntity.ShapeStyle.RGBAColor; u.setR(e.styles.stroke[0]), u.setG(e.styles.stroke[1]), u.setB(e.styles.stroke[2]), u.setA(e.styles.stroke[3]), g.setStroke(u) } "number" == typeof e.styles.strokeWidth && g.setStrokewidth(e.styles.strokeWidth), "string" == typeof e.styles.lineCap && ("butt" === e.styles.lineCap ? g.setLinecap(a.ShapeEntity.ShapeStyle.LineCap.LINECAP_BUTT) : "round" === e.styles.lineCap ? g.setLinecap(a.ShapeEntity.ShapeStyle.LineCap.LINECAP_ROUND) : "square" === e.styles.lineCap && g.setLinecap(a.ShapeEntity.ShapeStyle.LineCap.LINECAP_SQUARE)), "string" == typeof e.styles.lineJoin && ("miter" === e.styles.lineJoin ? g.setLinejoin(a.ShapeEntity.ShapeStyle.LineJoin.LINEJOIN_MITER) : "round" === e.styles.lineJoin ? g.setLinejoin(a.ShapeEntity.ShapeStyle.LineJoin.LINEJOIN_ROUND) : "bevel" === e.styles.lineJoin && g.setLinejoin(a.ShapeEntity.ShapeStyle.LineJoin.LINEJOIN_BEVEL)), "number" == typeof e.styles.miterLimit && g.setMiterlimit(e.styles.miterLimit), "object" === s(e.styles.lineDash) && ("number" == typeof e.styles.lineDash[0] && g.setLinedashi(e.styles.lineDash[0]), "number" == typeof e.styles.lineDash[1] && g.setLinedashii(e.styles.lineDash[1]), "number" == typeof e.styles.lineDash[2] && g.setLinedashiii(e.styles.lineDash[2])), t.setStyles(g) } "object" === s(e.transform) && t.setTransform(function (e) { var t = new a.Transform; return t.setA(e.a), t.setB(e.b), t.setC(e.c), t.setD(e.d), t.setTx(e.tx), t.setTy(e.ty), t }(e.transform)), o.push(t) }) } r.push(t) }), p.push(t) }), t.serializeBinary() } }]), e }(), p = function () { function e() { o(this, e) } return i(e, null, [{ key: "convertToProto", value: function (e, t) { var r = new a.MovieEntity; r.setVersion("2.1.0"); var o = new a.MovieParams; o.setViewboxwidth(e.movie.viewBox.width), o.setViewboxheight(e.movie.viewBox.height), o.setFps(e.movie.fps), o.setFrames(e.movie.frames), r.setParams(o); var n = r.getImagesMap(); for (var i in t) "object" === s(t[i]) && n.set(i, t[i]); var g = r.getSpritesList(); e.sprites.forEach(function (e) { var t = new a.SpriteEntity; t.setImagekey(e.imageKey); var r = t.getFramesList(); e.frames.forEach(function (e) { var t = new a.FrameEntity; if ("number" == typeof e.alpha && t.setAlpha(e.alpha || 1), "object" === s(e.layout) && t.setLayout(function (e) { var t = new a.Layout; return t.setX(e.x), t.setY(e.y), t.setWidth(e.width), t.setHeight(e.height), t }(e.layout)), "object" === s(e.transform) && t.setTransform(function (e) { var t = new a.Transform; return t.setA(e.a), t.setB(e.b), t.setC(e.c), t.setD(e.d), t.setTx(e.tx), t.setTy(e.ty), t }(e.transform)), "string" == typeof e.clipPath && t.setClippath(e.clipPath), "object" === s(e.shapes)) { var o = t.getShapesList(); e.shapes.forEach(function (e) { var t = new a.ShapeEntity; if (t.setType(function () { return "shape" === e.type ? a.ShapeEntity.ShapeType.SHAPE : "rect" === e.type ? a.ShapeEntity.ShapeType.RECT : "ellipse" === e.type ? a.ShapeEntity.ShapeType.ELLIPSE : "keep" === e.type ? a.ShapeEntity.ShapeType.KEEP : void 0 }(e.type)), "object" === s(e.args)) if ("shape" === e.type) { var r = new a.ShapeEntity.ShapeArgs; "string" == typeof e.args.d && r.setD(e.args.d), t.setShape(r) } else if ("rect" === e.type) { var n = new a.ShapeEntity.RectArgs; "number" == typeof e.args.x && n.setX(e.args.x), "number" == typeof e.args.y && n.setY(e.args.y), "number" == typeof e.args.width && n.setWidth(e.args.width), "number" == typeof e.args.height && n.setHeight(e.args.height), "number" == typeof e.args.cornerRadius && n.setCornerradius(e.args.cornerRadius), t.setRect(n) } else if ("ellipse" === e.type) { var i = new a.ShapeEntity.EllipseArgs; "number" == typeof e.args.x && i.setX(e.args.x), "number" == typeof e.args.y && i.setY(e.args.y), "number" == typeof e.args.radiusX && i.setRadiusx(e.args.radiusX), "number" == typeof e.args.radiusY && i.setRadiusy(e.args.radiusY), t.setEllipse(i) } if ("object" === s(e.styles)) { var g = new a.ShapeEntity.ShapeStyle; if ("object" === s(e.styles.fill)) { var p = new a.ShapeEntity.ShapeStyle.RGBAColor; p.setR(e.styles.fill[0]), p.setG(e.styles.fill[1]), p.setB(e.styles.fill[2]), p.setA(e.styles.fill[3]), g.setFill(p) } if ("object" === s(e.styles.stroke)) { var u = new a.ShapeEntity.ShapeStyle.RGBAColor; u.setR(e.styles.stroke[0]), u.setG(e.styles.stroke[1]), u.setB(e.styles.stroke[2]), u.setA(e.styles.stroke[3]), g.setStroke(u) } "number" == typeof e.styles.strokeWidth && g.setStrokewidth(e.styles.strokeWidth), "string" == typeof e.styles.lineCap && ("butt" === e.styles.lineCap ? g.setLinecap(a.ShapeEntity.ShapeStyle.LineCap.LINECAP_BUTT) : "round" === e.styles.lineCap ? g.setLinecap(a.ShapeEntity.ShapeStyle.LineCap.LINECAP_ROUND) : "square" === e.styles.lineCap && g.setLinecap(a.ShapeEntity.ShapeStyle.LineCap.LINECAP_SQUARE)), "string" == typeof e.styles.lineJoin && ("miter" === e.styles.lineJoin ? g.setLinejoin(a.ShapeEntity.ShapeStyle.LineJoin.LINEJOIN_MITER) : "round" === e.styles.lineJoin ? g.setLinejoin(a.ShapeEntity.ShapeStyle.LineJoin.LINEJOIN_ROUND) : "bevel" === e.styles.lineJoin && g.setLinejoin(a.ShapeEntity.ShapeStyle.LineJoin.LINEJOIN_BEVEL)), "number" == typeof e.styles.miterLimit && g.setMiterlimit(e.styles.miterLimit), "object" === s(e.styles.lineDash) && ("number" == typeof e.styles.lineDash[0] && g.setLinedashi(e.styles.lineDash[0]), "number" == typeof e.styles.lineDash[1] && g.setLinedashii(e.styles.lineDash[1]), "number" == typeof e.styles.lineDash[2] && g.setLinedashiii(e.styles.lineDash[2])), t.setStyles(g) } "object" === s(e.transform) && t.setTransform(function (e) { var t = new a.Transform; return t.setA(e.a), t.setB(e.b), t.setC(e.c), t.setD(e.d), t.setTx(e.tx), t.setTy(e.ty), t }(e.transform)), o.push(t) }) } r.push(t) }), g.push(t) }); var p = r.getAudiosList(); return e.audios instanceof Array && e.audios.forEach(function (e) { var t = new a.AudioEntity; t.setAudiokey(e.audioKey), t.setStartframe(e.startFrame), t.setEndframe(e.endFrame), t.setStarttime(e.startTime), t.setTotaltime(e.totalTime), p.push(t) }), r.serializeBinary() } }]), e }(); "object" === ("undefined" == typeof window ? "undefined" : s(window)) && (window.SVGAProtoHelper_1_5_0 = g, window.SVGAProtoHelper_2_0_0 = p), t.SVGAProtoHelper_1_5_0 = g, t.SVGAProtoHelper_2_0_0 = p }, function (e, t, r) { var o = r(3), n = o, s = Function("return this")(); n.exportSymbol("proto.com.opensource.svga.AudioEntity", null, s), n.exportSymbol("proto.com.opensource.svga.FrameEntity", null, s), n.exportSymbol("proto.com.opensource.svga.Layout", null, s), n.exportSymbol("proto.com.opensource.svga.MovieEntity", null, s), n.exportSymbol("proto.com.opensource.svga.MovieParams", null, s), n.exportSymbol("proto.com.opensource.svga.ShapeEntity", null, s), n.exportSymbol("proto.com.opensource.svga.ShapeEntity.EllipseArgs", null, s), n.exportSymbol("proto.com.opensource.svga.ShapeEntity.RectArgs", null, s), n.exportSymbol("proto.com.opensource.svga.ShapeEntity.ShapeArgs", null, s), n.exportSymbol("proto.com.opensource.svga.ShapeEntity.ShapeStyle", null, s), n.exportSymbol("proto.com.opensource.svga.ShapeEntity.ShapeStyle.LineCap", null, s), n.exportSymbol("proto.com.opensource.svga.ShapeEntity.ShapeStyle.LineJoin", null, s), n.exportSymbol("proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor", null, s), n.exportSymbol("proto.com.opensource.svga.ShapeEntity.ShapeType", null, s), n.exportSymbol("proto.com.opensource.svga.SpriteEntity", null, s), n.exportSymbol("proto.com.opensource.svga.Transform", null, s), proto.com.opensource.svga.MovieParams = function (e) { o.Message.initialize(this, e, 0, -1, null, null) }, n.inherits(proto.com.opensource.svga.MovieParams, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.MovieParams.displayName = "proto.com.opensource.svga.MovieParams"), o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.MovieParams.prototype.toObject = function (e) { return proto.com.opensource.svga.MovieParams.toObject(e, this) }, proto.com.opensource.svga.MovieParams.toObject = function (e, t) { var r = { viewboxwidth: +o.Message.getFieldWithDefault(t, 1, 0), viewboxheight: +o.Message.getFieldWithDefault(t, 2, 0), fps: o.Message.getFieldWithDefault(t, 3, 0), frames: o.Message.getFieldWithDefault(t, 4, 0) }; return e && (r.$jspbMessageInstance = t), r }), proto.com.opensource.svga.MovieParams.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.MovieParams; return proto.com.opensource.svga.MovieParams.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.MovieParams.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readFloat(); e.setViewboxwidth(r); break; case 2: var r = t.readFloat(); e.setViewboxheight(r); break; case 3: var r = t.readInt32(); e.setFps(r); break; case 4: var r = t.readInt32(); e.setFrames(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.MovieParams.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.MovieParams.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.MovieParams.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getViewboxwidth(), 0 !== r && t.writeFloat(1, r), r = e.getViewboxheight(), 0 !== r && t.writeFloat(2, r), r = e.getFps(), 0 !== r && t.writeInt32(3, r), 0 !== (r = e.getFrames()) && t.writeInt32(4, r) }, proto.com.opensource.svga.MovieParams.prototype.getViewboxwidth = function () { return +o.Message.getFieldWithDefault(this, 1, 0) }, proto.com.opensource.svga.MovieParams.prototype.setViewboxwidth = function (e) { o.Message.setProto3FloatField(this, 1, e) }, proto.com.opensource.svga.MovieParams.prototype.getViewboxheight = function () { return +o.Message.getFieldWithDefault(this, 2, 0) }, proto.com.opensource.svga.MovieParams.prototype.setViewboxheight = function (e) { o.Message.setProto3FloatField(this, 2, e) }, proto.com.opensource.svga.MovieParams.prototype.getFps = function () { return o.Message.getFieldWithDefault(this, 3, 0) }, proto.com.opensource.svga.MovieParams.prototype.setFps = function (e) { o.Message.setProto3IntField(this, 3, e) }, proto.com.opensource.svga.MovieParams.prototype.getFrames = function () { return o.Message.getFieldWithDefault(this, 4, 0) }, proto.com.opensource.svga.MovieParams.prototype.setFrames = function (e) { o.Message.setProto3IntField(this, 4, e) }, proto.com.opensource.svga.SpriteEntity = function (e) { o.Message.initialize(this, e, 0, -1, proto.com.opensource.svga.SpriteEntity.repeatedFields_, null) }, n.inherits(proto.com.opensource.svga.SpriteEntity, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.SpriteEntity.displayName = "proto.com.opensource.svga.SpriteEntity"), proto.com.opensource.svga.SpriteEntity.repeatedFields_ = [2], o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.SpriteEntity.prototype.toObject = function (e) { return proto.com.opensource.svga.SpriteEntity.toObject(e, this) }, proto.com.opensource.svga.SpriteEntity.toObject = function (e, t) { var r = { imagekey: o.Message.getFieldWithDefault(t, 1, ""), framesList: o.Message.toObjectList(t.getFramesList(), proto.com.opensource.svga.FrameEntity.toObject, e) }; return e && (r.$jspbMessageInstance = t), r }), proto.com.opensource.svga.SpriteEntity.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.SpriteEntity; return proto.com.opensource.svga.SpriteEntity.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.SpriteEntity.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readString(); e.setImagekey(r); break; case 2: var r = new proto.com.opensource.svga.FrameEntity; t.readMessage(r, proto.com.opensource.svga.FrameEntity.deserializeBinaryFromReader), e.addFrames(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.SpriteEntity.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.SpriteEntity.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.SpriteEntity.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getImagekey(), r.length > 0 && t.writeString(1, r), r = e.getFramesList(), r.length > 0 && t.writeRepeatedMessage(2, r, proto.com.opensource.svga.FrameEntity.serializeBinaryToWriter) }, proto.com.opensource.svga.SpriteEntity.prototype.getImagekey = function () { return o.Message.getFieldWithDefault(this, 1, "") }, proto.com.opensource.svga.SpriteEntity.prototype.setImagekey = function (e) { o.Message.setProto3StringField(this, 1, e) }, proto.com.opensource.svga.SpriteEntity.prototype.getFramesList = function () { return o.Message.getRepeatedWrapperField(this, proto.com.opensource.svga.FrameEntity, 2) }, proto.com.opensource.svga.SpriteEntity.prototype.setFramesList = function (e) { o.Message.setRepeatedWrapperField(this, 2, e) }, proto.com.opensource.svga.SpriteEntity.prototype.addFrames = function (e, t) { return o.Message.addToRepeatedWrapperField(this, 2, e, proto.com.opensource.svga.FrameEntity, t) }, proto.com.opensource.svga.SpriteEntity.prototype.clearFramesList = function () { this.setFramesList([]) }, proto.com.opensource.svga.AudioEntity = function (e) { o.Message.initialize(this, e, 0, -1, null, null) }, n.inherits(proto.com.opensource.svga.AudioEntity, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.AudioEntity.displayName = "proto.com.opensource.svga.AudioEntity"), o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.AudioEntity.prototype.toObject = function (e) { return proto.com.opensource.svga.AudioEntity.toObject(e, this) }, proto.com.opensource.svga.AudioEntity.toObject = function (e, t) { var r = { audiokey: o.Message.getFieldWithDefault(t, 1, ""), startframe: o.Message.getFieldWithDefault(t, 2, 0), endframe: o.Message.getFieldWithDefault(t, 3, 0), starttime: o.Message.getFieldWithDefault(t, 4, 0), totaltime: o.Message.getFieldWithDefault(t, 5, 0) }; return e && (r.$jspbMessageInstance = t), r }), proto.com.opensource.svga.AudioEntity.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.AudioEntity; return proto.com.opensource.svga.AudioEntity.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.AudioEntity.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readString(); e.setAudiokey(r); break; case 2: var r = t.readInt32(); e.setStartframe(r); break; case 3: var r = t.readInt32(); e.setEndframe(r); break; case 4: var r = t.readInt32(); e.setStarttime(r); break; case 5: var r = t.readInt32(); e.setTotaltime(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.AudioEntity.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.AudioEntity.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.AudioEntity.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getAudiokey(), r.length > 0 && t.writeString(1, r), r = e.getStartframe(), 0 !== r && t.writeInt32(2, r), r = e.getEndframe(), 0 !== r && t.writeInt32(3, r), r = e.getStarttime(), 0 !== r && t.writeInt32(4, r), 0 !== (r = e.getTotaltime()) && t.writeInt32(5, r) }, proto.com.opensource.svga.AudioEntity.prototype.getAudiokey = function () { return o.Message.getFieldWithDefault(this, 1, "") }, proto.com.opensource.svga.AudioEntity.prototype.setAudiokey = function (e) { o.Message.setProto3StringField(this, 1, e) }, proto.com.opensource.svga.AudioEntity.prototype.getStartframe = function () { return o.Message.getFieldWithDefault(this, 2, 0) }, proto.com.opensource.svga.AudioEntity.prototype.setStartframe = function (e) { o.Message.setProto3IntField(this, 2, e) }, proto.com.opensource.svga.AudioEntity.prototype.getEndframe = function () { return o.Message.getFieldWithDefault(this, 3, 0) }, proto.com.opensource.svga.AudioEntity.prototype.setEndframe = function (e) { o.Message.setProto3IntField(this, 3, e) }, proto.com.opensource.svga.AudioEntity.prototype.getStarttime = function () { return o.Message.getFieldWithDefault(this, 4, 0) }, proto.com.opensource.svga.AudioEntity.prototype.setStarttime = function (e) { o.Message.setProto3IntField(this, 4, e) }, proto.com.opensource.svga.AudioEntity.prototype.getTotaltime = function () { return o.Message.getFieldWithDefault(this, 5, 0) }, proto.com.opensource.svga.AudioEntity.prototype.setTotaltime = function (e) { o.Message.setProto3IntField(this, 5, e) }, proto.com.opensource.svga.Layout = function (e) { o.Message.initialize(this, e, 0, -1, null, null) }, n.inherits(proto.com.opensource.svga.Layout, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.Layout.displayName = "proto.com.opensource.svga.Layout"), o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.Layout.prototype.toObject = function (e) { return proto.com.opensource.svga.Layout.toObject(e, this) }, proto.com.opensource.svga.Layout.toObject = function (e, t) { var r = { x: +o.Message.getFieldWithDefault(t, 1, 0), y: +o.Message.getFieldWithDefault(t, 2, 0), width: +o.Message.getFieldWithDefault(t, 3, 0), height: +o.Message.getFieldWithDefault(t, 4, 0) }; return e && (r.$jspbMessageInstance = t), r }), proto.com.opensource.svga.Layout.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.Layout; return proto.com.opensource.svga.Layout.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.Layout.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readFloat(); e.setX(r); break; case 2: var r = t.readFloat(); e.setY(r); break; case 3: var r = t.readFloat(); e.setWidth(r); break; case 4: var r = t.readFloat(); e.setHeight(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.Layout.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.Layout.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.Layout.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getX(), 0 !== r && t.writeFloat(1, r), r = e.getY(), 0 !== r && t.writeFloat(2, r), r = e.getWidth(), 0 !== r && t.writeFloat(3, r), 0 !== (r = e.getHeight()) && t.writeFloat(4, r) }, proto.com.opensource.svga.Layout.prototype.getX = function () { return +o.Message.getFieldWithDefault(this, 1, 0) }, proto.com.opensource.svga.Layout.prototype.setX = function (e) { o.Message.setProto3FloatField(this, 1, e) }, proto.com.opensource.svga.Layout.prototype.getY = function () { return +o.Message.getFieldWithDefault(this, 2, 0) }, proto.com.opensource.svga.Layout.prototype.setY = function (e) { o.Message.setProto3FloatField(this, 2, e) }, proto.com.opensource.svga.Layout.prototype.getWidth = function () { return +o.Message.getFieldWithDefault(this, 3, 0) }, proto.com.opensource.svga.Layout.prototype.setWidth = function (e) { o.Message.setProto3FloatField(this, 3, e) }, proto.com.opensource.svga.Layout.prototype.getHeight = function () { return +o.Message.getFieldWithDefault(this, 4, 0) }, proto.com.opensource.svga.Layout.prototype.setHeight = function (e) { o.Message.setProto3FloatField(this, 4, e) }, proto.com.opensource.svga.Transform = function (e) { o.Message.initialize(this, e, 0, -1, null, null) }, n.inherits(proto.com.opensource.svga.Transform, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.Transform.displayName = "proto.com.opensource.svga.Transform"), o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.Transform.prototype.toObject = function (e) { return proto.com.opensource.svga.Transform.toObject(e, this) }, proto.com.opensource.svga.Transform.toObject = function (e, t) { var r = { a: +o.Message.getFieldWithDefault(t, 1, 0), b: +o.Message.getFieldWithDefault(t, 2, 0), c: +o.Message.getFieldWithDefault(t, 3, 0), d: +o.Message.getFieldWithDefault(t, 4, 0), tx: +o.Message.getFieldWithDefault(t, 5, 0), ty: +o.Message.getFieldWithDefault(t, 6, 0) }; return e && (r.$jspbMessageInstance = t), r }), proto.com.opensource.svga.Transform.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.Transform; return proto.com.opensource.svga.Transform.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.Transform.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readFloat(); e.setA(r); break; case 2: var r = t.readFloat(); e.setB(r); break; case 3: var r = t.readFloat(); e.setC(r); break; case 4: var r = t.readFloat(); e.setD(r); break; case 5: var r = t.readFloat(); e.setTx(r); break; case 6: var r = t.readFloat(); e.setTy(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.Transform.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.Transform.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.Transform.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getA(), 0 !== r && t.writeFloat(1, r), r = e.getB(), 0 !== r && t.writeFloat(2, r), r = e.getC(), 0 !== r && t.writeFloat(3, r), r = e.getD(), 0 !== r && t.writeFloat(4, r), r = e.getTx(), 0 !== r && t.writeFloat(5, r), 0 !== (r = e.getTy()) && t.writeFloat(6, r) }, proto.com.opensource.svga.Transform.prototype.getA = function () { return +o.Message.getFieldWithDefault(this, 1, 0) }, proto.com.opensource.svga.Transform.prototype.setA = function (e) { o.Message.setProto3FloatField(this, 1, e) }, proto.com.opensource.svga.Transform.prototype.getB = function () { return +o.Message.getFieldWithDefault(this, 2, 0) }, proto.com.opensource.svga.Transform.prototype.setB = function (e) { o.Message.setProto3FloatField(this, 2, e) }, proto.com.opensource.svga.Transform.prototype.getC = function () { return +o.Message.getFieldWithDefault(this, 3, 0) }, proto.com.opensource.svga.Transform.prototype.setC = function (e) { o.Message.setProto3FloatField(this, 3, e) }, proto.com.opensource.svga.Transform.prototype.getD = function () { return +o.Message.getFieldWithDefault(this, 4, 0) }, proto.com.opensource.svga.Transform.prototype.setD = function (e) { o.Message.setProto3FloatField(this, 4, e) }, proto.com.opensource.svga.Transform.prototype.getTx = function () { return +o.Message.getFieldWithDefault(this, 5, 0) }, proto.com.opensource.svga.Transform.prototype.setTx = function (e) { o.Message.setProto3FloatField(this, 5, e) }, proto.com.opensource.svga.Transform.prototype.getTy = function () { return +o.Message.getFieldWithDefault(this, 6, 0) }, proto.com.opensource.svga.Transform.prototype.setTy = function (e) { o.Message.setProto3FloatField(this, 6, e) }, proto.com.opensource.svga.ShapeEntity = function (e) { o.Message.initialize(this, e, 0, -1, null, proto.com.opensource.svga.ShapeEntity.oneofGroups_) }, n.inherits(proto.com.opensource.svga.ShapeEntity, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.ShapeEntity.displayName = "proto.com.opensource.svga.ShapeEntity"), proto.com.opensource.svga.ShapeEntity.oneofGroups_ = [[2, 3, 4]], proto.com.opensource.svga.ShapeEntity.ArgsCase = { ARGS_NOT_SET: 0, SHAPE: 2, RECT: 3, ELLIPSE: 4 }, proto.com.opensource.svga.ShapeEntity.prototype.getArgsCase = function () { return o.Message.computeOneofCase(this, proto.com.opensource.svga.ShapeEntity.oneofGroups_[0]) }, o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.ShapeEntity.prototype.toObject = function (e) { return proto.com.opensource.svga.ShapeEntity.toObject(e, this) }, proto.com.opensource.svga.ShapeEntity.toObject = function (e, t) { var r, n = { type: o.Message.getFieldWithDefault(t, 1, 0), shape: (r = t.getShape()) && proto.com.opensource.svga.ShapeEntity.ShapeArgs.toObject(e, r), rect: (r = t.getRect()) && proto.com.opensource.svga.ShapeEntity.RectArgs.toObject(e, r), ellipse: (r = t.getEllipse()) && proto.com.opensource.svga.ShapeEntity.EllipseArgs.toObject(e, r), styles: (r = t.getStyles()) && proto.com.opensource.svga.ShapeEntity.ShapeStyle.toObject(e, r), transform: (r = t.getTransform()) && proto.com.opensource.svga.Transform.toObject(e, r) }; return e && (n.$jspbMessageInstance = t), n }), proto.com.opensource.svga.ShapeEntity.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.ShapeEntity; return proto.com.opensource.svga.ShapeEntity.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.ShapeEntity.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readEnum(); e.setType(r); break; case 2: var r = new proto.com.opensource.svga.ShapeEntity.ShapeArgs; t.readMessage(r, proto.com.opensource.svga.ShapeEntity.ShapeArgs.deserializeBinaryFromReader), e.setShape(r); break; case 3: var r = new proto.com.opensource.svga.ShapeEntity.RectArgs; t.readMessage(r, proto.com.opensource.svga.ShapeEntity.RectArgs.deserializeBinaryFromReader), e.setRect(r); break; case 4: var r = new proto.com.opensource.svga.ShapeEntity.EllipseArgs; t.readMessage(r, proto.com.opensource.svga.ShapeEntity.EllipseArgs.deserializeBinaryFromReader), e.setEllipse(r); break; case 10: var r = new proto.com.opensource.svga.ShapeEntity.ShapeStyle; t.readMessage(r, proto.com.opensource.svga.ShapeEntity.ShapeStyle.deserializeBinaryFromReader), e.setStyles(r); break; case 11: var r = new proto.com.opensource.svga.Transform; t.readMessage(r, proto.com.opensource.svga.Transform.deserializeBinaryFromReader), e.setTransform(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.ShapeEntity.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.ShapeEntity.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.ShapeEntity.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getType(), 0 !== r && t.writeEnum(1, r), r = e.getShape(), null != r && t.writeMessage(2, r, proto.com.opensource.svga.ShapeEntity.ShapeArgs.serializeBinaryToWriter), r = e.getRect(), null != r && t.writeMessage(3, r, proto.com.opensource.svga.ShapeEntity.RectArgs.serializeBinaryToWriter), r = e.getEllipse(), null != r && t.writeMessage(4, r, proto.com.opensource.svga.ShapeEntity.EllipseArgs.serializeBinaryToWriter), r = e.getStyles(), null != r && t.writeMessage(10, r, proto.com.opensource.svga.ShapeEntity.ShapeStyle.serializeBinaryToWriter), null != (r = e.getTransform()) && t.writeMessage(11, r, proto.com.opensource.svga.Transform.serializeBinaryToWriter) }, proto.com.opensource.svga.ShapeEntity.ShapeType = { SHAPE: 0, RECT: 1, ELLIPSE: 2, KEEP: 3 }, proto.com.opensource.svga.ShapeEntity.ShapeArgs = function (e) { o.Message.initialize(this, e, 0, -1, null, null) }, n.inherits(proto.com.opensource.svga.ShapeEntity.ShapeArgs, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.ShapeEntity.ShapeArgs.displayName = "proto.com.opensource.svga.ShapeEntity.ShapeArgs"), o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.ShapeEntity.ShapeArgs.prototype.toObject = function (e) { return proto.com.opensource.svga.ShapeEntity.ShapeArgs.toObject(e, this) }, proto.com.opensource.svga.ShapeEntity.ShapeArgs.toObject = function (e, t) { var r = { d: o.Message.getFieldWithDefault(t, 1, "") }; return e && (r.$jspbMessageInstance = t), r }), proto.com.opensource.svga.ShapeEntity.ShapeArgs.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.ShapeEntity.ShapeArgs; return proto.com.opensource.svga.ShapeEntity.ShapeArgs.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.ShapeEntity.ShapeArgs.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readString(); e.setD(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.ShapeEntity.ShapeArgs.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.ShapeEntity.ShapeArgs.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.ShapeEntity.ShapeArgs.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getD(), r.length > 0 && t.writeString(1, r) }, proto.com.opensource.svga.ShapeEntity.ShapeArgs.prototype.getD = function () { return o.Message.getFieldWithDefault(this, 1, "") }, proto.com.opensource.svga.ShapeEntity.ShapeArgs.prototype.setD = function (e) { o.Message.setProto3StringField(this, 1, e) }, proto.com.opensource.svga.ShapeEntity.RectArgs = function (e) { o.Message.initialize(this, e, 0, -1, null, null) }, n.inherits(proto.com.opensource.svga.ShapeEntity.RectArgs, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.ShapeEntity.RectArgs.displayName = "proto.com.opensource.svga.ShapeEntity.RectArgs"), o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.toObject = function (e) { return proto.com.opensource.svga.ShapeEntity.RectArgs.toObject(e, this) }, proto.com.opensource.svga.ShapeEntity.RectArgs.toObject = function (e, t) { var r = { x: +o.Message.getFieldWithDefault(t, 1, 0), y: +o.Message.getFieldWithDefault(t, 2, 0), width: +o.Message.getFieldWithDefault(t, 3, 0), height: +o.Message.getFieldWithDefault(t, 4, 0), cornerradius: +o.Message.getFieldWithDefault(t, 5, 0) }; return e && (r.$jspbMessageInstance = t), r }), proto.com.opensource.svga.ShapeEntity.RectArgs.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.ShapeEntity.RectArgs; return proto.com.opensource.svga.ShapeEntity.RectArgs.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.ShapeEntity.RectArgs.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readFloat(); e.setX(r); break; case 2: var r = t.readFloat(); e.setY(r); break; case 3: var r = t.readFloat(); e.setWidth(r); break; case 4: var r = t.readFloat(); e.setHeight(r); break; case 5: var r = t.readFloat(); e.setCornerradius(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.ShapeEntity.RectArgs.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.ShapeEntity.RectArgs.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getX(), 0 !== r && t.writeFloat(1, r), r = e.getY(), 0 !== r && t.writeFloat(2, r), r = e.getWidth(), 0 !== r && t.writeFloat(3, r), r = e.getHeight(), 0 !== r && t.writeFloat(4, r), 0 !== (r = e.getCornerradius()) && t.writeFloat(5, r) }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.getX = function () { return +o.Message.getFieldWithDefault(this, 1, 0) }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.setX = function (e) { o.Message.setProto3FloatField(this, 1, e) }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.getY = function () { return +o.Message.getFieldWithDefault(this, 2, 0) }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.setY = function (e) { o.Message.setProto3FloatField(this, 2, e) }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.getWidth = function () { return +o.Message.getFieldWithDefault(this, 3, 0) }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.setWidth = function (e) { o.Message.setProto3FloatField(this, 3, e) }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.getHeight = function () { return +o.Message.getFieldWithDefault(this, 4, 0) }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.setHeight = function (e) { o.Message.setProto3FloatField(this, 4, e) }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.getCornerradius = function () { return +o.Message.getFieldWithDefault(this, 5, 0) }, proto.com.opensource.svga.ShapeEntity.RectArgs.prototype.setCornerradius = function (e) { o.Message.setProto3FloatField(this, 5, e) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs = function (e) { o.Message.initialize(this, e, 0, -1, null, null) }, n.inherits(proto.com.opensource.svga.ShapeEntity.EllipseArgs, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.ShapeEntity.EllipseArgs.displayName = "proto.com.opensource.svga.ShapeEntity.EllipseArgs"), o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.ShapeEntity.EllipseArgs.prototype.toObject = function (e) { return proto.com.opensource.svga.ShapeEntity.EllipseArgs.toObject(e, this) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.toObject = function (e, t) { var r = { x: +o.Message.getFieldWithDefault(t, 1, 0), y: +o.Message.getFieldWithDefault(t, 2, 0), radiusx: +o.Message.getFieldWithDefault(t, 3, 0), radiusy: +o.Message.getFieldWithDefault(t, 4, 0) }; return e && (r.$jspbMessageInstance = t), r }), proto.com.opensource.svga.ShapeEntity.EllipseArgs.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.ShapeEntity.EllipseArgs; return proto.com.opensource.svga.ShapeEntity.EllipseArgs.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readFloat(); e.setX(r); break; case 2: var r = t.readFloat(); e.setY(r); break; case 3: var r = t.readFloat(); e.setRadiusx(r); break; case 4: var r = t.readFloat(); e.setRadiusy(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.ShapeEntity.EllipseArgs.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getX(), 0 !== r && t.writeFloat(1, r), r = e.getY(), 0 !== r && t.writeFloat(2, r), r = e.getRadiusx(), 0 !== r && t.writeFloat(3, r), 0 !== (r = e.getRadiusy()) && t.writeFloat(4, r) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.prototype.getX = function () { return +o.Message.getFieldWithDefault(this, 1, 0) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.prototype.setX = function (e) { o.Message.setProto3FloatField(this, 1, e) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.prototype.getY = function () { return +o.Message.getFieldWithDefault(this, 2, 0) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.prototype.setY = function (e) { o.Message.setProto3FloatField(this, 2, e) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.prototype.getRadiusx = function () { return +o.Message.getFieldWithDefault(this, 3, 0) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.prototype.setRadiusx = function (e) { o.Message.setProto3FloatField(this, 3, e) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.prototype.getRadiusy = function () { return +o.Message.getFieldWithDefault(this, 4, 0) }, proto.com.opensource.svga.ShapeEntity.EllipseArgs.prototype.setRadiusy = function (e) { o.Message.setProto3FloatField(this, 4, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle = function (e) { o.Message.initialize(this, e, 0, -1, null, null) }, n.inherits(proto.com.opensource.svga.ShapeEntity.ShapeStyle, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.ShapeEntity.ShapeStyle.displayName = "proto.com.opensource.svga.ShapeEntity.ShapeStyle"), o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.toObject = function (e) { return proto.com.opensource.svga.ShapeEntity.ShapeStyle.toObject(e, this) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.toObject = function (e, t) { var r, n = { fill: (r = t.getFill()) && proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.toObject(e, r), stroke: (r = t.getStroke()) && proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.toObject(e, r), strokewidth: +o.Message.getFieldWithDefault(t, 3, 0), linecap: o.Message.getFieldWithDefault(t, 4, 0), linejoin: o.Message.getFieldWithDefault(t, 5, 0), miterlimit: +o.Message.getFieldWithDefault(t, 6, 0), linedashi: +o.Message.getFieldWithDefault(t, 7, 0), linedashii: +o.Message.getFieldWithDefault(t, 8, 0), linedashiii: +o.Message.getFieldWithDefault(t, 9, 0) }; return e && (n.$jspbMessageInstance = t), n }), proto.com.opensource.svga.ShapeEntity.ShapeStyle.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.ShapeEntity.ShapeStyle; return proto.com.opensource.svga.ShapeEntity.ShapeStyle.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = new proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor; t.readMessage(r, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.deserializeBinaryFromReader), e.setFill(r); break; case 2: var r = new proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor; t.readMessage(r, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.deserializeBinaryFromReader), e.setStroke(r); break; case 3: var r = t.readFloat(); e.setStrokewidth(r); break; case 4: var r = t.readEnum(); e.setLinecap(r); break; case 5: var r = t.readEnum(); e.setLinejoin(r); break; case 6: var r = t.readFloat(); e.setMiterlimit(r); break; case 7: var r = t.readFloat(); e.setLinedashi(r); break; case 8: var r = t.readFloat(); e.setLinedashii(r); break; case 9: var r = t.readFloat(); e.setLinedashiii(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.ShapeEntity.ShapeStyle.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getFill(), null != r && t.writeMessage(1, r, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.serializeBinaryToWriter), r = e.getStroke(), null != r && t.writeMessage(2, r, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.serializeBinaryToWriter), r = e.getStrokewidth(), 0 !== r && t.writeFloat(3, r), r = e.getLinecap(), 0 !== r && t.writeEnum(4, r), r = e.getLinejoin(), 0 !== r && t.writeEnum(5, r), r = e.getMiterlimit(), 0 !== r && t.writeFloat(6, r), r = e.getLinedashi(), 0 !== r && t.writeFloat(7, r), r = e.getLinedashii(), 0 !== r && t.writeFloat(8, r), 0 !== (r = e.getLinedashiii()) && t.writeFloat(9, r) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.LineCap = { LINECAP_BUTT: 0, LINECAP_ROUND: 1, LINECAP_SQUARE: 2 }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.LineJoin = { LINEJOIN_MITER: 0, LINEJOIN_ROUND: 1, LINEJOIN_BEVEL: 2 }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor = function (e) { o.Message.initialize(this, e, 0, -1, null, null) }, n.inherits(proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.displayName = "proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor"), o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.prototype.toObject = function (e) { return proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.toObject(e, this) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.toObject = function (e, t) { var r = { r: +o.Message.getFieldWithDefault(t, 1, 0), g: +o.Message.getFieldWithDefault(t, 2, 0), b: +o.Message.getFieldWithDefault(t, 3, 0), a: +o.Message.getFieldWithDefault(t, 4, 0) }; return e && (r.$jspbMessageInstance = t), r }), proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor; return proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readFloat(); e.setR(r); break; case 2: var r = t.readFloat(); e.setG(r); break; case 3: var r = t.readFloat(); e.setB(r); break; case 4: var r = t.readFloat(); e.setA(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getR(), 0 !== r && t.writeFloat(1, r), r = e.getG(), 0 !== r && t.writeFloat(2, r), r = e.getB(), 0 !== r && t.writeFloat(3, r), 0 !== (r = e.getA()) && t.writeFloat(4, r) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.prototype.getR = function () { return +o.Message.getFieldWithDefault(this, 1, 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.prototype.setR = function (e) { o.Message.setProto3FloatField(this, 1, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.prototype.getG = function () { return +o.Message.getFieldWithDefault(this, 2, 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.prototype.setG = function (e) { o.Message.setProto3FloatField(this, 2, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.prototype.getB = function () { return +o.Message.getFieldWithDefault(this, 3, 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.prototype.setB = function (e) { o.Message.setProto3FloatField(this, 3, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.prototype.getA = function () { return +o.Message.getFieldWithDefault(this, 4, 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor.prototype.setA = function (e) { o.Message.setProto3FloatField(this, 4, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.getFill = function () { return o.Message.getWrapperField(this, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor, 1) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.setFill = function (e) { o.Message.setWrapperField(this, 1, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.clearFill = function () { this.setFill(void 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.hasFill = function () { return null != o.Message.getField(this, 1) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.getStroke = function () { return o.Message.getWrapperField(this, proto.com.opensource.svga.ShapeEntity.ShapeStyle.RGBAColor, 2) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.setStroke = function (e) { o.Message.setWrapperField(this, 2, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.clearStroke = function () { this.setStroke(void 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.hasStroke = function () { return null != o.Message.getField(this, 2) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.getStrokewidth = function () { return +o.Message.getFieldWithDefault(this, 3, 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.setStrokewidth = function (e) { o.Message.setProto3FloatField(this, 3, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.getLinecap = function () { return o.Message.getFieldWithDefault(this, 4, 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.setLinecap = function (e) { o.Message.setProto3EnumField(this, 4, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.getLinejoin = function () { return o.Message.getFieldWithDefault(this, 5, 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.setLinejoin = function (e) { o.Message.setProto3EnumField(this, 5, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.getMiterlimit = function () { return +o.Message.getFieldWithDefault(this, 6, 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.setMiterlimit = function (e) { o.Message.setProto3FloatField(this, 6, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.getLinedashi = function () { return +o.Message.getFieldWithDefault(this, 7, 0) }; proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.setLinedashi = function (e) { o.Message.setProto3FloatField(this, 7, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.getLinedashii = function () { return +o.Message.getFieldWithDefault(this, 8, 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.setLinedashii = function (e) { o.Message.setProto3FloatField(this, 8, e) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.getLinedashiii = function () { return +o.Message.getFieldWithDefault(this, 9, 0) }, proto.com.opensource.svga.ShapeEntity.ShapeStyle.prototype.setLinedashiii = function (e) { o.Message.setProto3FloatField(this, 9, e) }, proto.com.opensource.svga.ShapeEntity.prototype.getType = function () { return o.Message.getFieldWithDefault(this, 1, 0) }, proto.com.opensource.svga.ShapeEntity.prototype.setType = function (e) { o.Message.setProto3EnumField(this, 1, e) }, proto.com.opensource.svga.ShapeEntity.prototype.getShape = function () { return o.Message.getWrapperField(this, proto.com.opensource.svga.ShapeEntity.ShapeArgs, 2) }, proto.com.opensource.svga.ShapeEntity.prototype.setShape = function (e) { o.Message.setOneofWrapperField(this, 2, proto.com.opensource.svga.ShapeEntity.oneofGroups_[0], e) }, proto.com.opensource.svga.ShapeEntity.prototype.clearShape = function () { this.setShape(void 0) }, proto.com.opensource.svga.ShapeEntity.prototype.hasShape = function () { return null != o.Message.getField(this, 2) }, proto.com.opensource.svga.ShapeEntity.prototype.getRect = function () { return o.Message.getWrapperField(this, proto.com.opensource.svga.ShapeEntity.RectArgs, 3) }, proto.com.opensource.svga.ShapeEntity.prototype.setRect = function (e) { o.Message.setOneofWrapperField(this, 3, proto.com.opensource.svga.ShapeEntity.oneofGroups_[0], e) }, proto.com.opensource.svga.ShapeEntity.prototype.clearRect = function () { this.setRect(void 0) }, proto.com.opensource.svga.ShapeEntity.prototype.hasRect = function () { return null != o.Message.getField(this, 3) }, proto.com.opensource.svga.ShapeEntity.prototype.getEllipse = function () { return o.Message.getWrapperField(this, proto.com.opensource.svga.ShapeEntity.EllipseArgs, 4) }, proto.com.opensource.svga.ShapeEntity.prototype.setEllipse = function (e) { o.Message.setOneofWrapperField(this, 4, proto.com.opensource.svga.ShapeEntity.oneofGroups_[0], e) }, proto.com.opensource.svga.ShapeEntity.prototype.clearEllipse = function () { this.setEllipse(void 0) }, proto.com.opensource.svga.ShapeEntity.prototype.hasEllipse = function () { return null != o.Message.getField(this, 4) }, proto.com.opensource.svga.ShapeEntity.prototype.getStyles = function () { return o.Message.getWrapperField(this, proto.com.opensource.svga.ShapeEntity.ShapeStyle, 10) }, proto.com.opensource.svga.ShapeEntity.prototype.setStyles = function (e) { o.Message.setWrapperField(this, 10, e) }, proto.com.opensource.svga.ShapeEntity.prototype.clearStyles = function () { this.setStyles(void 0) }, proto.com.opensource.svga.ShapeEntity.prototype.hasStyles = function () { return null != o.Message.getField(this, 10) }, proto.com.opensource.svga.ShapeEntity.prototype.getTransform = function () { return o.Message.getWrapperField(this, proto.com.opensource.svga.Transform, 11) }, proto.com.opensource.svga.ShapeEntity.prototype.setTransform = function (e) { o.Message.setWrapperField(this, 11, e) }, proto.com.opensource.svga.ShapeEntity.prototype.clearTransform = function () { this.setTransform(void 0) }, proto.com.opensource.svga.ShapeEntity.prototype.hasTransform = function () { return null != o.Message.getField(this, 11) }, proto.com.opensource.svga.FrameEntity = function (e) { o.Message.initialize(this, e, 0, -1, proto.com.opensource.svga.FrameEntity.repeatedFields_, null) }, n.inherits(proto.com.opensource.svga.FrameEntity, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.FrameEntity.displayName = "proto.com.opensource.svga.FrameEntity"), proto.com.opensource.svga.FrameEntity.repeatedFields_ = [5], o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.FrameEntity.prototype.toObject = function (e) { return proto.com.opensource.svga.FrameEntity.toObject(e, this) }, proto.com.opensource.svga.FrameEntity.toObject = function (e, t) { var r, n = { alpha: +o.Message.getFieldWithDefault(t, 1, 0), layout: (r = t.getLayout()) && proto.com.opensource.svga.Layout.toObject(e, r), transform: (r = t.getTransform()) && proto.com.opensource.svga.Transform.toObject(e, r), clippath: o.Message.getFieldWithDefault(t, 4, ""), shapesList: o.Message.toObjectList(t.getShapesList(), proto.com.opensource.svga.ShapeEntity.toObject, e) }; return e && (n.$jspbMessageInstance = t), n }), proto.com.opensource.svga.FrameEntity.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.FrameEntity; return proto.com.opensource.svga.FrameEntity.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.FrameEntity.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readFloat(); e.setAlpha(r); break; case 2: var r = new proto.com.opensource.svga.Layout; t.readMessage(r, proto.com.opensource.svga.Layout.deserializeBinaryFromReader), e.setLayout(r); break; case 3: var r = new proto.com.opensource.svga.Transform; t.readMessage(r, proto.com.opensource.svga.Transform.deserializeBinaryFromReader), e.setTransform(r); break; case 4: var r = t.readString(); e.setClippath(r); break; case 5: var r = new proto.com.opensource.svga.ShapeEntity; t.readMessage(r, proto.com.opensource.svga.ShapeEntity.deserializeBinaryFromReader), e.addShapes(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.FrameEntity.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.FrameEntity.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.FrameEntity.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getAlpha(), 0 !== r && t.writeFloat(1, r), r = e.getLayout(), null != r && t.writeMessage(2, r, proto.com.opensource.svga.Layout.serializeBinaryToWriter), r = e.getTransform(), null != r && t.writeMessage(3, r, proto.com.opensource.svga.Transform.serializeBinaryToWriter), r = e.getClippath(), r.length > 0 && t.writeString(4, r), r = e.getShapesList(), r.length > 0 && t.writeRepeatedMessage(5, r, proto.com.opensource.svga.ShapeEntity.serializeBinaryToWriter) }, proto.com.opensource.svga.FrameEntity.prototype.getAlpha = function () { return +o.Message.getFieldWithDefault(this, 1, 0) }, proto.com.opensource.svga.FrameEntity.prototype.setAlpha = function (e) { o.Message.setProto3FloatField(this, 1, e) }, proto.com.opensource.svga.FrameEntity.prototype.getLayout = function () { return o.Message.getWrapperField(this, proto.com.opensource.svga.Layout, 2) }, proto.com.opensource.svga.FrameEntity.prototype.setLayout = function (e) { o.Message.setWrapperField(this, 2, e) }, proto.com.opensource.svga.FrameEntity.prototype.clearLayout = function () { this.setLayout(void 0) }, proto.com.opensource.svga.FrameEntity.prototype.hasLayout = function () { return null != o.Message.getField(this, 2) }, proto.com.opensource.svga.FrameEntity.prototype.getTransform = function () { return o.Message.getWrapperField(this, proto.com.opensource.svga.Transform, 3) }, proto.com.opensource.svga.FrameEntity.prototype.setTransform = function (e) { o.Message.setWrapperField(this, 3, e) }, proto.com.opensource.svga.FrameEntity.prototype.clearTransform = function () { this.setTransform(void 0) }, proto.com.opensource.svga.FrameEntity.prototype.hasTransform = function () { return null != o.Message.getField(this, 3) }, proto.com.opensource.svga.FrameEntity.prototype.getClippath = function () { return o.Message.getFieldWithDefault(this, 4, "") }, proto.com.opensource.svga.FrameEntity.prototype.setClippath = function (e) { o.Message.setProto3StringField(this, 4, e) }, proto.com.opensource.svga.FrameEntity.prototype.getShapesList = function () { return o.Message.getRepeatedWrapperField(this, proto.com.opensource.svga.ShapeEntity, 5) }, proto.com.opensource.svga.FrameEntity.prototype.setShapesList = function (e) { o.Message.setRepeatedWrapperField(this, 5, e) }, proto.com.opensource.svga.FrameEntity.prototype.addShapes = function (e, t) { return o.Message.addToRepeatedWrapperField(this, 5, e, proto.com.opensource.svga.ShapeEntity, t) }, proto.com.opensource.svga.FrameEntity.prototype.clearShapesList = function () { this.setShapesList([]) }, proto.com.opensource.svga.MovieEntity = function (e) { o.Message.initialize(this, e, 0, -1, proto.com.opensource.svga.MovieEntity.repeatedFields_, null) }, n.inherits(proto.com.opensource.svga.MovieEntity, o.Message), n.DEBUG && !COMPILED && (proto.com.opensource.svga.MovieEntity.displayName = "proto.com.opensource.svga.MovieEntity"), proto.com.opensource.svga.MovieEntity.repeatedFields_ = [4, 5], o.Message.GENERATE_TO_OBJECT && (proto.com.opensource.svga.MovieEntity.prototype.toObject = function (e) { return proto.com.opensource.svga.MovieEntity.toObject(e, this) }, proto.com.opensource.svga.MovieEntity.toObject = function (e, t) { var r, n = { version: o.Message.getFieldWithDefault(t, 1, ""), params: (r = t.getParams()) && proto.com.opensource.svga.MovieParams.toObject(e, r), imagesMap: (r = t.getImagesMap()) ? r.toObject(e, void 0) : [], spritesList: o.Message.toObjectList(t.getSpritesList(), proto.com.opensource.svga.SpriteEntity.toObject, e), audiosList: o.Message.toObjectList(t.getAudiosList(), proto.com.opensource.svga.AudioEntity.toObject, e) }; return e && (n.$jspbMessageInstance = t), n }), proto.com.opensource.svga.MovieEntity.deserializeBinary = function (e) { var t = new o.BinaryReader(e), r = new proto.com.opensource.svga.MovieEntity; return proto.com.opensource.svga.MovieEntity.deserializeBinaryFromReader(r, t) }, proto.com.opensource.svga.MovieEntity.deserializeBinaryFromReader = function (e, t) { for (; t.nextField() && !t.isEndGroup();) { switch (t.getFieldNumber()) { case 1: var r = t.readString(); e.setVersion(r); break; case 2: var r = new proto.com.opensource.svga.MovieParams; t.readMessage(r, proto.com.opensource.svga.MovieParams.deserializeBinaryFromReader), e.setParams(r); break; case 3: var r = e.getImagesMap(); t.readMessage(r, function (e, t) { o.Map.deserializeBinary(e, t, o.BinaryReader.prototype.readString, o.BinaryReader.prototype.readBytes, null, "") }); break; case 4: var r = new proto.com.opensource.svga.SpriteEntity; t.readMessage(r, proto.com.opensource.svga.SpriteEntity.deserializeBinaryFromReader), e.addSprites(r); break; case 5: var r = new proto.com.opensource.svga.AudioEntity; t.readMessage(r, proto.com.opensource.svga.AudioEntity.deserializeBinaryFromReader), e.addAudios(r); break; default: t.skipField() } } return e }, proto.com.opensource.svga.MovieEntity.prototype.serializeBinary = function () { var e = new o.BinaryWriter; return proto.com.opensource.svga.MovieEntity.serializeBinaryToWriter(this, e), e.getResultBuffer() }, proto.com.opensource.svga.MovieEntity.serializeBinaryToWriter = function (e, t) { var r = void 0; r = e.getVersion(), r.length > 0 && t.writeString(1, r), r = e.getParams(), null != r && t.writeMessage(2, r, proto.com.opensource.svga.MovieParams.serializeBinaryToWriter), r = e.getImagesMap(!0), r && r.getLength() > 0 && r.serializeBinary(3, t, o.BinaryWriter.prototype.writeString, o.BinaryWriter.prototype.writeBytes), r = e.getSpritesList(), r.length > 0 && t.writeRepeatedMessage(4, r, proto.com.opensource.svga.SpriteEntity.serializeBinaryToWriter), r = e.getAudiosList(), r.length > 0 && t.writeRepeatedMessage(5, r, proto.com.opensource.svga.AudioEntity.serializeBinaryToWriter) }, proto.com.opensource.svga.MovieEntity.prototype.getVersion = function () { return o.Message.getFieldWithDefault(this, 1, "") }, proto.com.opensource.svga.MovieEntity.prototype.setVersion = function (e) { o.Message.setProto3StringField(this, 1, e) }, proto.com.opensource.svga.MovieEntity.prototype.getParams = function () { return o.Message.getWrapperField(this, proto.com.opensource.svga.MovieParams, 2) }, proto.com.opensource.svga.MovieEntity.prototype.setParams = function (e) { o.Message.setWrapperField(this, 2, e) }, proto.com.opensource.svga.MovieEntity.prototype.clearParams = function () { this.setParams(void 0) }, proto.com.opensource.svga.MovieEntity.prototype.hasParams = function () { return null != o.Message.getField(this, 2) }, proto.com.opensource.svga.MovieEntity.prototype.getImagesMap = function (e) { return o.Message.getMapField(this, 3, e, null) }, proto.com.opensource.svga.MovieEntity.prototype.clearImagesMap = function () { this.getImagesMap().clear() }, proto.com.opensource.svga.MovieEntity.prototype.getSpritesList = function () { return o.Message.getRepeatedWrapperField(this, proto.com.opensource.svga.SpriteEntity, 4) }, proto.com.opensource.svga.MovieEntity.prototype.setSpritesList = function (e) { o.Message.setRepeatedWrapperField(this, 4, e) }, proto.com.opensource.svga.MovieEntity.prototype.addSprites = function (e, t) { return o.Message.addToRepeatedWrapperField(this, 4, e, proto.com.opensource.svga.SpriteEntity, t) }, proto.com.opensource.svga.MovieEntity.prototype.clearSpritesList = function () { this.setSpritesList([]) }, proto.com.opensource.svga.MovieEntity.prototype.getAudiosList = function () { return o.Message.getRepeatedWrapperField(this, proto.com.opensource.svga.AudioEntity, 5) }, proto.com.opensource.svga.MovieEntity.prototype.setAudiosList = function (e) { o.Message.setRepeatedWrapperField(this, 5, e) }, proto.com.opensource.svga.MovieEntity.prototype.addAudios = function (e, t) { return o.Message.addToRepeatedWrapperField(this, 5, e, proto.com.opensource.svga.AudioEntity, t) }, proto.com.opensource.svga.MovieEntity.prototype.clearAudiosList = function () { this.setAudiosList([]) }, n.object.extend(t, proto.com.opensource.svga) }, function (module, exports, __webpack_require__) { (function (global, Buffer) { var $jscomp = { scope: {}, getGlobal: function (e) { return "undefined" != typeof window && window === e ? e : void 0 !== global ? global : e } }; $jscomp.global = $jscomp.getGlobal(this), $jscomp.initSymbol = function () { $jscomp.global.Symbol || ($jscomp.global.Symbol = $jscomp.Symbol), $jscomp.initSymbol = function () { } }, $jscomp.symbolCounter_ = 0, $jscomp.Symbol = function (e) { return "jscomp_symbol_" + e + $jscomp.symbolCounter_++ }, $jscomp.initSymbolIterator = function () { $jscomp.initSymbol(), $jscomp.global.Symbol.iterator || ($jscomp.global.Symbol.iterator = $jscomp.global.Symbol("iterator")), $jscomp.initSymbolIterator = function () { } }, $jscomp.makeIterator = function (e) { $jscomp.initSymbolIterator(), $jscomp.initSymbol(), $jscomp.initSymbolIterator(); var t = e[Symbol.iterator]; if (t) return t.call(e); var r = 0; return { next: function () { return r < e.length ? { done: !1, value: e[r++] } : { done: !0 } } } }, $jscomp.arrayFromIterator = function (e) { for (var t, r = []; !(t = e.next()).done;)r.push(t.value); return r }, $jscomp.arrayFromIterable = function (e) { return e instanceof Array ? e : $jscomp.arrayFromIterator($jscomp.makeIterator(e)) }, $jscomp.inherits = function (e, t) { function r() { } r.prototype = t.prototype, e.prototype = new r, e.prototype.constructor = e; for (var o in t) if (Object.defineProperties) { var n = Object.getOwnPropertyDescriptor(t, o); n && Object.defineProperty(e, o, n) } else e[o] = t[o] }, $jscomp.array = $jscomp.array || {}, $jscomp.iteratorFromArray = function (e, t) { $jscomp.initSymbolIterator(), e instanceof String && (e += ""); var r = 0, o = { next: function () { if (r < e.length) { var n = r++; return { value: t(n, e[n]), done: !1 } } return o.next = function () { return { done: !0, value: void 0 } }, o.next() } }; return $jscomp.initSymbol(), $jscomp.initSymbolIterator(), o[Symbol.iterator] = function () { return o }, o }, $jscomp.findInternal = function (e, t, r) { e instanceof String && (e = String(e)); for (var o = e.length, n = 0; n < o; n++) { var s = e[n]; if (t.call(r, s, n, e)) return { i: n, v: s } } return { i: -1, v: void 0 } }, $jscomp.array.from = function (e, t, r) { $jscomp.initSymbolIterator(), t = null != t ? t : function (e) { return e }; var o = []; $jscomp.initSymbol(), $jscomp.initSymbolIterator(); var n = e[Symbol.iterator]; if ("function" == typeof n && (e = n.call(e)), "function" == typeof e.next) for (; !(n = e.next()).done;)o.push(t.call(r, n.value)); else for (var n = e.length, s = 0; s < n; s++)o.push(t.call(r, e[s])); return o }, $jscomp.array.of = function (e) { return $jscomp.array.from(arguments) }, $jscomp.array.entries = function () { return $jscomp.iteratorFromArray(this, function (e, t) { return [e, t] }) }, $jscomp.array.installHelper_ = function (e, t) { !Array.prototype[e] && Object.defineProperties && Object.defineProperty && Object.defineProperty(Array.prototype, e, { configurable: !0, enumerable: !1, writable: !0, value: t }) }, $jscomp.array.entries$install = function () { $jscomp.array.installHelper_("entries", $jscomp.array.entries) }, $jscomp.array.keys = function () { return $jscomp.iteratorFromArray(this, function (e) { return e }) }, $jscomp.array.keys$install = function () { $jscomp.array.installHelper_("keys", $jscomp.array.keys) }, $jscomp.array.values = function () { return $jscomp.iteratorFromArray(this, function (e, t) { return t }) }, $jscomp.array.values$install = function () { $jscomp.array.installHelper_("values", $jscomp.array.values) }, $jscomp.array.copyWithin = function (e, t, r) { var o = this.length; if (e = Number(e), t = Number(t), r = Number(null != r ? r : o), e < t) for (r = Math.min(r, o); t < r;)t in this ? this[e++] = this[t++] : (delete this[e++], t++); else for (r = Math.min(r, o + t - e), e += r - t; r > t;)--r in this ? this[--e] = this[r] : delete this[e]; return this }, $jscomp.array.copyWithin$install = function () { $jscomp.array.installHelper_("copyWithin", $jscomp.array.copyWithin) }, $jscomp.array.fill = function (e, t, r) { var o = this.length || 0; for (0 > t && (t = Math.max(0, o + t)), (null == r || r > o) && (r = o), r = Number(r), 0 > r && (r = Math.max(0, o + r)), t = Number(t || 0); t < r; t++)this[t] = e; return this }, $jscomp.array.fill$install = function () { $jscomp.array.installHelper_("fill", $jscomp.array.fill) }, $jscomp.array.find = function (e, t) { return $jscomp.findInternal(this, e, t).v }, $jscomp.array.find$install = function () { $jscomp.array.installHelper_("find", $jscomp.array.find) }, $jscomp.array.findIndex = function (e, t) { return $jscomp.findInternal(this, e, t).i }, $jscomp.array.findIndex$install = function () { $jscomp.array.installHelper_("findIndex", $jscomp.array.findIndex) }, $jscomp.ASSUME_NO_NATIVE_MAP = !1, $jscomp.Map$isConformant = function () { if ($jscomp.ASSUME_NO_NATIVE_MAP) return !1; var e = $jscomp.global.Map; if (!e || !e.prototype.entries || "function" != typeof Object.seal) return !1; try { var t = Object.seal({ x: 4 }), r = new e($jscomp.makeIterator([[t, "s"]])); if ("s" != r.get(t) || 1 != r.size || r.get({ x: 4 }) || r.set({ x: 4 }, "t") != r || 2 != r.size) return !1; var o = r.entries(), n = o.next(); return !n.done && n.value[0] == t && "s" == n.value[1] && (n = o.next(), !(n.done || 4 != n.value[0].x || "t" != n.value[1] || !o.next().done)) } catch (e) { return !1 } }, $jscomp.Map = function (e) { if (this.data_ = {}, this.head_ = $jscomp.Map.createHead(), this.size = 0, e) { e = $jscomp.makeIterator(e); for (var t; !(t = e.next()).done;)t = t.value, this.set(t[0], t[1]) } }, $jscomp.Map.prototype.set = function (e, t) { var r = $jscomp.Map.maybeGetEntry(this, e); return r.list || (r.list = this.data_[r.id] = []), r.entry ? r.entry.value = t : (r.entry = { next: this.head_, previous: this.head_.previous, head: this.head_, key: e, value: t }, r.list.push(r.entry), this.head_.previous.next = r.entry, this.head_.previous = r.entry, this.size++), this }, $jscomp.Map.prototype.delete = function (e) { return e = $jscomp.Map.maybeGetEntry(this, e), !(!e.entry || !e.list) && (e.list.splice(e.index, 1), e.list.length || delete this.data_[e.id], e.entry.previous.next = e.entry.next, e.entry.next.previous = e.entry.previous, e.entry.head = null, this.size-- , !0) }, $jscomp.Map.prototype.clear = function () { this.data_ = {}, this.head_ = this.head_.previous = $jscomp.Map.createHead(), this.size = 0 }, $jscomp.Map.prototype.has = function (e) { return !!$jscomp.Map.maybeGetEntry(this, e).entry }, $jscomp.Map.prototype.get = function (e) { return (e = $jscomp.Map.maybeGetEntry(this, e).entry) && e.value }, $jscomp.Map.prototype.entries = function () { return $jscomp.Map.makeIterator_(this, function (e) { return [e.key, e.value] }) }, $jscomp.Map.prototype.keys = function () { return $jscomp.Map.makeIterator_(this, function (e) { return e.key }) }, $jscomp.Map.prototype.values = function () { return $jscomp.Map.makeIterator_(this, function (e) { return e.value }) }, $jscomp.Map.prototype.forEach = function (e, t) { for (var r, o = this.entries(); !(r = o.next()).done;)r = r.value, e.call(t, r[1], r[0], this) }, $jscomp.Map.maybeGetEntry = function (e, t) { var r = $jscomp.Map.getId(t), o = e.data_[r]; if (o && Object.prototype.hasOwnProperty.call(e.data_, r)) for (var n = 0; n < o.length; n++) { var s = o[n]; if (t !== t && s.key !== s.key || t === s.key) return { id: r, list: o, index: n, entry: s } } return { id: r, list: o, index: -1, entry: void 0 } }, $jscomp.Map.makeIterator_ = function (e, t) { var r = e.head_, o = { next: function () { if (r) { for (; r.head != e.head_;)r = r.previous; for (; r.next != r.head;)return r = r.next, { done: !1, value: t(r) }; r = null } return { done: !0, value: void 0 } } }; return $jscomp.initSymbol(), $jscomp.initSymbolIterator(), o[Symbol.iterator] = function () { return o }, o }, $jscomp.Map.mapIndex_ = 0, $jscomp.Map.createHead = function () { var e = {}; return e.previous = e.next = e.head = e }, $jscomp.Map.getId = function (e) { if (!(e instanceof Object)) return "p_" + e; if (!($jscomp.Map.idKey in e)) try { $jscomp.Map.defineProperty(e, $jscomp.Map.idKey, { value: ++$jscomp.Map.mapIndex_ }) } catch (e) { } return $jscomp.Map.idKey in e ? e[$jscomp.Map.idKey] : "o_ " + e }, $jscomp.Map.defineProperty = Object.defineProperty ? function (e, t, r) { Object.defineProperty(e, t, { value: String(r) }) } : function (e, t, r) { e[t] = String(r) }, $jscomp.Map.Entry = function () { }, $jscomp.Map$install = function () { $jscomp.initSymbol(), $jscomp.initSymbolIterator(), $jscomp.Map$isConformant() ? $jscomp.Map = $jscomp.global.Map : ($jscomp.initSymbol(), $jscomp.initSymbolIterator(), $jscomp.Map.prototype[Symbol.iterator] = $jscomp.Map.prototype.entries, $jscomp.initSymbol(), $jscomp.Map.idKey = Symbol("map-id-key"), $jscomp.Map$install = function () { }) }, $jscomp.math = $jscomp.math || {}, $jscomp.math.clz32 = function (e) { if (0 === (e = Number(e) >>> 0)) return 32; var t = 0; return 0 == (4294901760 & e) && (e <<= 16, t += 16), 0 == (4278190080 & e) && (e <<= 8, t += 8), 0 == (4026531840 & e) && (e <<= 4, t += 4), 0 == (3221225472 & e) && (e <<= 2, t += 2), 0 == (2147483648 & e) && t++ , t }, $jscomp.math.imul = function (e, t) { e = Number(e), t = Number(t); var r = 65535 & e, o = 65535 & t; return r * o + ((e >>> 16 & 65535) * o + r * (t >>> 16 & 65535) << 16 >>> 0) | 0 }, $jscomp.math.sign = function (e) { return e = Number(e), 0 === e || isNaN(e) ? e : 0 < e ? 1 : -1 }, $jscomp.math.log10 = function (e) { return Math.log(e) / Math.LN10 }, $jscomp.math.log2 = function (e) { return Math.log(e) / Math.LN2 }, $jscomp.math.log1p = function (e) { if (.25 > (e = Number(e)) && -.25 < e) { for (var t = e, r = 1, o = e, n = 0, s = 1; n != o;)t *= e, s *= -1, o = (n = o) + s * t / ++r; return o } return Math.log(1 + e) }, $jscomp.math.expm1 = function (e) { if (.25 > (e = Number(e)) && -.25 < e) { for (var t = e, r = 1, o = e, n = 0; n != o;)t *= e / ++r, o = (n = o) + t; return o } return Math.exp(e) - 1 }, $jscomp.math.cosh = function (e) { return e = Number(e), (Math.exp(e) + Math.exp(-e)) / 2 }, $jscomp.math.sinh = function (e) { return e = Number(e), 0 === e ? e : (Math.exp(e) - Math.exp(-e)) / 2 }, $jscomp.math.tanh = function (e) { if (0 === (e = Number(e))) return e; var t = Math.exp(-2 * Math.abs(e)), t = (1 - t) / (1 + t); return 0 > e ? -t : t }, $jscomp.math.acosh = function (e) { return e = Number(e), Math.log(e + Math.sqrt(e * e - 1)) }, $jscomp.math.asinh = function (e) { if (0 === (e = Number(e))) return e; var t = Math.log(Math.abs(e) + Math.sqrt(e * e + 1)); return 0 > e ? -t : t }, $jscomp.math.atanh = function (e) { return e = Number(e), ($jscomp.math.log1p(e) - $jscomp.math.log1p(-e)) / 2 }, $jscomp.math.hypot = function (e, t, r) { e = Number(e), t = Number(t); var o, n, s, i = Math.max(Math.abs(e), Math.abs(t)); for (o = 2; o < arguments.length; o++)i = Math.max(i, Math.abs(arguments[o])); if (1e100 < i || 1e-100 > i) { for (e /= i, t /= i, s = e * e + t * t, o = 2; o < arguments.length; o++)n = Number(arguments[o]) / i, s += n * n; return Math.sqrt(s) * i } for (s = e * e + t * t, o = 2; o < arguments.length; o++)n = Number(arguments[o]), s += n * n; return Math.sqrt(s) }, $jscomp.math.trunc = function (e) { if (e = Number(e), isNaN(e) || 1 / 0 === e || -1 / 0 === e || 0 === e) return e; var t = Math.floor(Math.abs(e)); return 0 > e ? -t : t }, $jscomp.math.cbrt = function (e) { if (0 === e) return e; e = Number(e); var t = Math.pow(Math.abs(e), 1 / 3); return 0 > e ? -t : t }, $jscomp.number = $jscomp.number || {}, $jscomp.number.isFinite = function (e) { return "number" == typeof e && (!isNaN(e) && 1 / 0 !== e && -1 / 0 !== e) }, $jscomp.number.isInteger = function (e) { return !!$jscomp.number.isFinite(e) && e === Math.floor(e) }, $jscomp.number.isNaN = function (e) { return "number" == typeof e && isNaN(e) }, $jscomp.number.isSafeInteger = function (e) { return $jscomp.number.isInteger(e) && Math.abs(e) <= $jscomp.number.MAX_SAFE_INTEGER }, $jscomp.number.EPSILON = function () { return Math.pow(2, -52) }(), $jscomp.number.MAX_SAFE_INTEGER = 9007199254740991, $jscomp.number.MIN_SAFE_INTEGER = -9007199254740991, $jscomp.object = $jscomp.object || {}, $jscomp.object.assign = function (e, t) { for (var r = 1; r < arguments.length; r++) { var o = arguments[r]; if (o) for (var n in o) Object.prototype.hasOwnProperty.call(o, n) && (e[n] = o[n]) } return e }, $jscomp.object.is = function (e, t) { return e === t ? 0 !== e || 1 / e == 1 / t : e !== e && t !== t }, $jscomp.ASSUME_NO_NATIVE_SET = !1, $jscomp.Set$isConformant = function () { if ($jscomp.ASSUME_NO_NATIVE_SET) return !1; var e = $jscomp.global.Set; if (!e || !e.prototype.entries || "function" != typeof Object.seal) return !1; try { var t = Object.seal({ x: 4 }), r = new e($jscomp.makeIterator([t])); if (!r.has(t) || 1 != r.size || r.add(t) != r || 1 != r.size || r.add({ x: 4 }) != r || 2 != r.size) return !1; var o = r.entries(), n = o.next(); return !n.done && n.value[0] == t && n.value[1] == t && (n = o.next(), !n.done && n.value[0] != t && 4 == n.value[0].x && n.value[1] == n.value[0] && o.next().done) } catch (e) { return !1 } }, $jscomp.Set = function (e) { if (this.map_ = new $jscomp.Map, e) { e = $jscomp.makeIterator(e); for (var t; !(t = e.next()).done;)this.add(t.value) } this.size = this.map_.size }, $jscomp.Set.prototype.add = function (e) { return this.map_.set(e, e), this.size = this.map_.size, this }, $jscomp.Set.prototype.delete = function (e) { return e = this.map_.delete(e), this.size = this.map_.size, e }, $jscomp.Set.prototype.clear = function () { this.map_.clear(), this.size = 0 }, $jscomp.Set.prototype.has = function (e) { return this.map_.has(e) }, $jscomp.Set.prototype.entries = function () { return this.map_.entries() }, $jscomp.Set.prototype.values = function () { return this.map_.values() }, $jscomp.Set.prototype.forEach = function (e, t) { var r = this; this.map_.forEach(function (o) { return e.call(t, o, o, r) }) }, $jscomp.Set$install = function () { $jscomp.Map$install(), $jscomp.Set$isConformant() ? $jscomp.Set = $jscomp.global.Set : ($jscomp.initSymbol(), $jscomp.initSymbolIterator(), $jscomp.Set.prototype[Symbol.iterator] = $jscomp.Set.prototype.values, $jscomp.Set$install = function () { }) }, $jscomp.string = $jscomp.string || {}, $jscomp.checkStringArgs = function (e, t, r) { if (null == e) throw new TypeError("The 'this' value for String.prototype." + r + " must not be null or undefined"); if (t instanceof RegExp) throw new TypeError("First argument to String.prototype." + r + " must not be a regular expression"); return e + "" }, $jscomp.string.fromCodePoint = function (e) { for (var t = "", r = 0; r < arguments.length; r++) { var o = Number(arguments[r]); if (0 > o || 1114111 < o || o !== Math.floor(o)) throw new RangeError("invalid_code_point " + o); 65535 >= o ? t += String.fromCharCode(o) : (o -= 65536, t += String.fromCharCode(o >>> 10 & 1023 | 55296), t += String.fromCharCode(1023 & o | 56320)) } return t }, $jscomp.string.repeat = function (e) { var t = $jscomp.checkStringArgs(this, null, "repeat"); if (0 > e || 1342177279 < e) throw new RangeError("Invalid count value"); e |= 0; for (var r = ""; e;)1 & e && (r += t), (e >>>= 1) && (t += t); return r }, $jscomp.string.repeat$install = function () { String.prototype.repeat || (String.prototype.repeat = $jscomp.string.repeat) }, $jscomp.string.codePointAt = function (e) { var t = $jscomp.checkStringArgs(this, null, "codePointAt"), r = t.length; if (0 <= (e = Number(e) || 0) && e < r) { e |= 0; var o = t.charCodeAt(e); return 55296 > o || 56319 < o || e + 1 === r ? o : (e = t.charCodeAt(e + 1), 56320 > e || 57343 < e ? o : 1024 * (o - 55296) + e + 9216) } }, $jscomp.string.codePointAt$install = function () { String.prototype.codePointAt || (String.prototype.codePointAt = $jscomp.string.codePointAt) }, $jscomp.string.includes = function (e, t) { return -1 !== $jscomp.checkStringArgs(this, e, "includes").indexOf(e, t || 0) }, $jscomp.string.includes$install = function () { String.prototype.includes || (String.prototype.includes = $jscomp.string.includes) }, $jscomp.string.startsWith = function (e, t) { var r = $jscomp.checkStringArgs(this, e, "startsWith"); e += ""; for (var o = r.length, n = e.length, s = Math.max(0, Math.min(0 | t, r.length)), i = 0; i < n && s < o;)if (r[s++] != e[i++]) return !1; return i >= n }, $jscomp.string.startsWith$install = function () { String.prototype.startsWith || (String.prototype.startsWith = $jscomp.string.startsWith) }, $jscomp.string.endsWith = function (e, t) { var r = $jscomp.checkStringArgs(this, e, "endsWith"); e += "", void 0 === t && (t = r.length); for (var o = Math.max(0, Math.min(0 | t, r.length)), n = e.length; 0 < n && 0 < o;)if (r[--o] != e[--n]) return !1; return 0 >= n }, $jscomp.string.endsWith$install = function () { String.prototype.endsWith || (String.prototype.endsWith = $jscomp.string.endsWith) }; var COMPILED = !0, goog = goog || {}; goog.global = this, goog.isDef = function (e) { return void 0 !== e }, goog.exportPath_ = function (e, t, r) { e = e.split("."), r = r || goog.global, e[0] in r || !r.execScript || r.execScript("var " + e[0]); for (var o; e.length && (o = e.shift());)!e.length && goog.isDef(t) ? r[o] = t : r = r[o] ? r[o] : r[o] = {} }, goog.define = function (e, t) { var r = t; COMPILED || (goog.global.CLOSURE_UNCOMPILED_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, e) ? r = goog.global.CLOSURE_UNCOMPILED_DEFINES[e] : goog.global.CLOSURE_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, e) && (r = goog.global.CLOSURE_DEFINES[e])), goog.exportPath_(e, r) }, goog.DEBUG = !0, goog.LOCALE = "en", goog.TRUSTED_SITE = !0, goog.STRICT_MODE_COMPATIBLE = !1, goog.DISALLOW_TEST_ONLY_CODE = COMPILED && !goog.DEBUG, goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING = !1, goog.provide = function (e) { if (!COMPILED && goog.isProvided_(e)) throw Error('Namespace "' + e + '" already declared.'); goog.constructNamespace_(e) }, goog.constructNamespace_ = function (e, t) { if (!COMPILED) { delete goog.implicitNamespaces_[e]; for (var r = e; (r = r.substring(0, r.lastIndexOf("."))) && !goog.getObjectByName(r);)goog.implicitNamespaces_[r] = !0 } goog.exportPath_(e, t) }, goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/, goog.module = function (e) { if (!goog.isString(e) || !e || -1 == e.search(goog.VALID_MODULE_RE_)) throw Error("Invalid module identifier"); if (!goog.isInModuleLoader_()) throw Error("Module " + e + " has been loaded incorrectly."); if (goog.moduleLoaderState_.moduleName) throw Error("goog.module may only be called once per module."); if (goog.moduleLoaderState_.moduleName = e, !COMPILED) { if (goog.isProvided_(e)) throw Error('Namespace "' + e + '" already declared.'); delete goog.implicitNamespaces_[e] } }, goog.module.get = function (e) { return goog.module.getInternal_(e) }, goog.module.getInternal_ = function (e) { if (!COMPILED) return goog.isProvided_(e) ? e in goog.loadedModules_ ? goog.loadedModules_[e] : goog.getObjectByName(e) : null }, goog.moduleLoaderState_ = null, goog.isInModuleLoader_ = function () { return null != goog.moduleLoaderState_ }, goog.module.declareLegacyNamespace = function () { if (!COMPILED && !goog.isInModuleLoader_()) throw Error("goog.module.declareLegacyNamespace must be called from within a goog.module"); if (!COMPILED && !goog.moduleLoaderState_.moduleName) throw Error("goog.module must be called prior to goog.module.declareLegacyNamespace."); goog.moduleLoaderState_.declareLegacyNamespace = !0 }, goog.setTestOnly = function (e) { if (goog.DISALLOW_TEST_ONLY_CODE) throw e = e || "", Error("Importing test-only code into non-debug environment" + (e ? ": " + e : ".")) }, goog.forwardDeclare = function (e) { }, COMPILED || (goog.isProvided_ = function (e) { return e in goog.loadedModules_ || !goog.implicitNamespaces_[e] && goog.isDefAndNotNull(goog.getObjectByName(e)) }, goog.implicitNamespaces_ = { "goog.module": !0 }), goog.getObjectByName = function (e, t) { for (var r, o = e.split("."), n = t || goog.global; r = o.shift();) { if (!goog.isDefAndNotNull(n[r])) return null; n = n[r] } return n }, goog.globalize = function (e, t) { var r, o = t || goog.global; for (r in e) o[r] = e[r] }, goog.addDependency = function (e, t, r, o) { if (goog.DEPENDENCIES_ENABLED) { var n; e = e.replace(/\\/g, "/"); for (var s = goog.dependencies_, i = 0; n = t[i]; i++)s.nameToPath[n] = e, s.pathIsModule[e] = !!o; for (o = 0; t = r[o]; o++)e in s.requires || (s.requires[e] = {}), s.requires[e][t] = !0 } }, goog.ENABLE_DEBUG_LOADER = !0, goog.logToConsole_ = function (e) { goog.global.console && goog.global.console.error(e) }, goog.require = function (e) { if (!COMPILED) { if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_ && goog.maybeProcessDeferredDep_(e), goog.isProvided_(e)) return goog.isInModuleLoader_() ? goog.module.getInternal_(e) : null; if (goog.ENABLE_DEBUG_LOADER) { var t = goog.getPathFromDeps_(e); if (t) return goog.writeScripts_(t), null } throw e = "goog.require could not find: " + e, goog.logToConsole_(e), Error(e) } }, goog.basePath = "", goog.nullFunction = function () { }, goog.abstractMethod = function () { throw Error("unimplemented abstract method") }, goog.addSingletonGetter = function (e) { e.getInstance = function () { return e.instance_ ? e.instance_ : (goog.DEBUG && (goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = e), e.instance_ = new e) } }, goog.instantiatedSingletons_ = [], goog.LOAD_MODULE_USING_EVAL = !0, goog.SEAL_MODULE_EXPORTS = goog.DEBUG, goog.loadedModules_ = {}, goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER, goog.DEPENDENCIES_ENABLED && (goog.dependencies_ = { pathIsModule: {}, nameToPath: {}, requires: {}, visited: {}, written: {}, deferred: {} }, goog.inHtmlDocument_ = function () { var e = goog.global.document; return null != e && "write" in e }, goog.findBasePath_ = function () { if (goog.isDef(goog.global.CLOSURE_BASE_PATH)) goog.basePath = goog.global.CLOSURE_BASE_PATH; else if (goog.inHtmlDocument_()) for (var e = goog.global.document.getElementsByTagName("SCRIPT"), t = e.length - 1; 0 <= t; --t) { var r = e[t].src, o = r.lastIndexOf("?"), o = -1 == o ? r.length : o; if ("base.js" == r.substr(o - 7, 7)) { goog.basePath = r.substr(0, o - 7); break } } }, goog.importScript_ = function (e, t) { (goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_)(e, t) && (goog.dependencies_.written[e] = !0) }, goog.IS_OLD_IE_ = !(goog.global.atob || !goog.global.document || !goog.global.document.all), goog.importModule_ = function (e) { goog.importScript_("", 'goog.retrieveAndExecModule_("' + e + '");') && (goog.dependencies_.written[e] = !0) }, goog.queuedModules_ = [], goog.wrapModule_ = function (e, t) { return goog.LOAD_MODULE_USING_EVAL && goog.isDef(goog.global.JSON) ? "goog.loadModule(" + goog.global.JSON.stringify(t + "\n//# sourceURL=" + e + "\n") + ");" : 'goog.loadModule(function(exports) {"use strict";' + t + "\n;return exports});\n//# sourceURL=" + e + "\n" }, goog.loadQueuedModules_ = function () { var e = goog.queuedModules_.length; if (0 < e) { var t = goog.queuedModules_; goog.queuedModules_ = []; for (var r = 0; r < e; r++)goog.maybeProcessDeferredPath_(t[r]) } }, goog.maybeProcessDeferredDep_ = function (e) { goog.isDeferredModule_(e) && goog.allDepsAreAvailable_(e) && (e = goog.getPathFromDeps_(e), goog.maybeProcessDeferredPath_(goog.basePath + e)) }, goog.isDeferredModule_ = function (e) { return !(!(e = goog.getPathFromDeps_(e)) || !goog.dependencies_.pathIsModule[e]) && goog.basePath + e in goog.dependencies_.deferred }, goog.allDepsAreAvailable_ = function (e) { if ((e = goog.getPathFromDeps_(e)) && e in goog.dependencies_.requires) for (var t in goog.dependencies_.requires[e]) if (!goog.isProvided_(t) && !goog.isDeferredModule_(t)) return !1; return !0 }, goog.maybeProcessDeferredPath_ = function (e) { if (e in goog.dependencies_.deferred) { var t = goog.dependencies_.deferred[e]; delete goog.dependencies_.deferred[e], goog.globalEval(t) } }, goog.loadModuleFromUrl = function (e) { goog.retrieveAndExecModule_(e) }, goog.loadModule = function (e) { var t = goog.moduleLoaderState_; try { goog.moduleLoaderState_ = { moduleName: void 0, declareLegacyNamespace: !1 }; var r; if (goog.isFunction(e)) r = e.call(goog.global, {}); else { if (!goog.isString(e)) throw Error("Invalid module definition"); r = goog.loadModuleFromSource_.call(goog.global, e) } var o = goog.moduleLoaderState_.moduleName; if (!goog.isString(o) || !o) throw Error('Invalid module name "' + o + '"'); goog.moduleLoaderState_.declareLegacyNamespace ? goog.constructNamespace_(o, r) : goog.SEAL_MODULE_EXPORTS && Object.seal && Object.seal(r), goog.loadedModules_[o] = r } finally { goog.moduleLoaderState_ = t } }, goog.loadModuleFromSource_ = function (a) { return eval(a), {} }, goog.writeScriptSrcNode_ = function (e) { goog.global.document.write('<script type="text/javascript" src="' + e + '"><\/script>') }, goog.appendScriptSrcNode_ = function (e) { var t = goog.global.document, r = t.createElement("script"); r.type = "text/javascript", r.src = e, r.defer = !1, r.async = !1, t.head.appendChild(r) }, goog.writeScriptTag_ = function (e, t) { if (goog.inHtmlDocument_()) { var r = goog.global.document; if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && "complete" == r.readyState) { if (/\bdeps.js$/.test(e)) return !1; throw Error('Cannot write "' + e + '" after document load') } var o = goog.IS_OLD_IE_; return void 0 === t ? o ? (o = " onreadystatechange='goog.onScriptLoad_(this, " + ++goog.lastNonModuleScriptIndex_ + ")' ", r.write('<script type="text/javascript" src="' + e + '"' + o + "><\/script>")) : goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING ? goog.appendScriptSrcNode_(e) : goog.writeScriptSrcNode_(e) : r.write('<script type="text/javascript">' + t + "<\/script>"), !0 } return !1 }, goog.lastNonModuleScriptIndex_ = 0, goog.onScriptLoad_ = function (e, t) { return "complete" == e.readyState && goog.lastNonModuleScriptIndex_ == t && goog.loadQueuedModules_(), !0 }, goog.writeScripts_ = function (e) { function t(e) { if (!(e in n.written || e in n.visited)) { if (n.visited[e] = !0, e in n.requires) for (var s in n.requires[e]) if (!goog.isProvided_(s)) { if (!(s in n.nameToPath)) throw Error("Undefined nameToPath for " + s); t(n.nameToPath[s]) } e in o || (o[e] = !0, r.push(e)) } } var r = [], o = {}, n = goog.dependencies_; for (t(e), e = 0; e < r.length; e++) { var s = r[e]; goog.dependencies_.written[s] = !0 } var i = goog.moduleLoaderState_; for (goog.moduleLoaderState_ = null, e = 0; e < r.length; e++) { if (!(s = r[e])) throw goog.moduleLoaderState_ = i, Error("Undefined script input"); n.pathIsModule[s] ? goog.importModule_(goog.basePath + s) : goog.importScript_(goog.basePath + s) } goog.moduleLoaderState_ = i }, goog.getPathFromDeps_ = function (e) { return e in goog.dependencies_.nameToPath ? goog.dependencies_.nameToPath[e] : null }, goog.findBasePath_(), goog.global.CLOSURE_NO_DEPS || goog.importScript_(goog.basePath + "deps.js")), goog.normalizePath_ = function (e) { e = e.split("/"); for (var t = 0; t < e.length;)"." == e[t] ? e.splice(t, 1) : t && ".." == e[t] && e[t - 1] && ".." != e[t - 1] ? e.splice(--t, 2) : t++; return e.join("/") }, goog.loadFileSync_ = function (e) { if (goog.global.CLOSURE_LOAD_FILE_SYNC) return goog.global.CLOSURE_LOAD_FILE_SYNC(e); var t = new goog.global.XMLHttpRequest; return t.open("get", e, !1), t.send(), t.responseText }, goog.retrieveAndExecModule_ = function (e) { if (!COMPILED) { var t = e; e = goog.normalizePath_(e); var r = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_, o = goog.loadFileSync_(e); if (null == o) throw Error("load of " + e + "failed"); o = goog.wrapModule_(e, o), goog.IS_OLD_IE_ ? (goog.dependencies_.deferred[t] = o, goog.queuedModules_.push(t)) : r(e, o) } }, goog.typeOf = function (e) { var t = typeof e; if ("object" == t) { if (!e) return "null"; if (e instanceof Array) return "array"; if (e instanceof Object) return t; var r = Object.prototype.toString.call(e); if ("[object Window]" == r) return "object"; if ("[object Array]" == r || "number" == typeof e.length && void 0 !== e.splice && void 0 !== e.propertyIsEnumerable && !e.propertyIsEnumerable("splice")) return "array"; if ("[object Function]" == r || void 0 !== e.call && void 0 !== e.propertyIsEnumerable && !e.propertyIsEnumerable("call")) return "function" } else if ("function" == t && void 0 === e.call) return "object"; return t }, goog.isNull = function (e) { return null === e }, goog.isDefAndNotNull = function (e) { return null != e }, goog.isArray = function (e) { return "array" == goog.typeOf(e) }, goog.isArrayLike = function (e) { var t = goog.typeOf(e); return "array" == t || "object" == t && "number" == typeof e.length }, goog.isDateLike = function (e) { return goog.isObject(e) && "function" == typeof e.getFullYear }, goog.isString = function (e) { return "string" == typeof e }, goog.isBoolean = function (e) { return "boolean" == typeof e }, goog.isNumber = function (e) { return "number" == typeof e }, goog.isFunction = function (e) { return "function" == goog.typeOf(e) }, goog.isObject = function (e) { var t = typeof e; return "object" == t && null != e || "function" == t }, goog.getUid = function (e) { return e[goog.UID_PROPERTY_] || (e[goog.UID_PROPERTY_] = ++goog.uidCounter_) }, goog.hasUid = function (e) { return !!e[goog.UID_PROPERTY_] }, goog.removeUid = function (e) { null !== e && "removeAttribute" in e && e.removeAttribute(goog.UID_PROPERTY_); try { delete e[goog.UID_PROPERTY_] } catch (e) { } }, goog.UID_PROPERTY_ = "closure_uid_" + (1e9 * Math.random() >>> 0), goog.uidCounter_ = 0, goog.getHashCode = goog.getUid, goog.removeHashCode = goog.removeUid, goog.cloneObject = function (e) { var t = goog.typeOf(e); if ("object" == t || "array" == t) { if (e.clone) return e.clone(); var r, t = "array" == t ? [] : {}; for (r in e) t[r] = goog.cloneObject(e[r]); return t } return e }, goog.bindNative_ = function (e, t, r) { return e.call.apply(e.bind, arguments) }, goog.bindJs_ = function (e, t, r) { if (!e) throw Error(); if (2 < arguments.length) { var o = Array.prototype.slice.call(arguments, 2); return function () { var r = Array.prototype.slice.call(arguments); return Array.prototype.unshift.apply(r, o), e.apply(t, r) } } return function () { return e.apply(t, arguments) } }, goog.bind = function (e, t, r) { return Function.prototype.bind && -1 != Function.prototype.bind.toString().indexOf("native code") ? goog.bind = goog.bindNative_ : goog.bind = goog.bindJs_, goog.bind.apply(null, arguments) }, goog.partial = function (e, t) { var r = Array.prototype.slice.call(arguments, 1); return function () { var t = r.slice(); return t.push.apply(t, arguments), e.apply(this, t) } }, goog.mixin = function (e, t) { for (var r in t) e[r] = t[r] }, goog.now = goog.TRUSTED_SITE && Date.now || function () { return +new Date }, goog.globalEval = function (e) { if (goog.global.execScript) goog.global.execScript(e, "JavaScript"); else { if (!goog.global.eval) throw Error("goog.globalEval not available"); if (null == goog.evalWorksForGlobals_) if (goog.global.eval("var _evalTest_ = 1;"), void 0 !== goog.global._evalTest_) { try { delete goog.global._evalTest_ } catch (e) { } goog.evalWorksForGlobals_ = !0 } else goog.evalWorksForGlobals_ = !1; if (goog.evalWorksForGlobals_) goog.global.eval(e); else { var t = goog.global.document, r = t.createElement("SCRIPT"); r.type = "text/javascript", r.defer = !1, r.appendChild(t.createTextNode(e)), t.body.appendChild(r), t.body.removeChild(r) } } }, goog.evalWorksForGlobals_ = null, goog.getCssName = function (e, t) { var r = function (e) { return goog.cssNameMapping_[e] || e }, o = function (e) { e = e.split("-"); for (var t = [], o = 0; o < e.length; o++)t.push(r(e[o])); return t.join("-") }, o = goog.cssNameMapping_ ? "BY_WHOLE" == goog.cssNameMappingStyle_ ? r : o : function (e) { return e }; return t ? e + "-" + o(t) : o(e) }, goog.setCssNameMapping = function (e, t) { goog.cssNameMapping_ = e, goog.cssNameMappingStyle_ = t }, !COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING && (goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING), goog.getMsg = function (e, t) { return t && (e = e.replace(/\{\$([^}]+)}/g, function (e, r) { return null != t && r in t ? t[r] : e })), e }, goog.getMsgWithFallback = function (e, t) { return e }, goog.exportSymbol = function (e, t, r) { goog.exportPath_(e, t, r) }, goog.exportProperty = function (e, t, r) { e[t] = r }, goog.inherits = function (e, t) { function r() { } r.prototype = t.prototype, e.superClass_ = t.prototype, e.prototype = new r, e.prototype.constructor = e, e.base = function (e, r, o) { for (var n = Array(arguments.length - 2), s = 2; s < arguments.length; s++)n[s - 2] = arguments[s]; return t.prototype[r].apply(e, n) } }, goog.base = function (e, t, r) { var o = arguments.callee.caller; if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !o) throw Error("arguments.caller not defined.  goog.base() cannot be used with strict mode code. See http://www.ecma-international.org/ecma-262/5.1/#sec-C"); if (o.superClass_) { for (var n = Array(arguments.length - 1), s = 1; s < arguments.length; s++)n[s - 1] = arguments[s]; return o.superClass_.constructor.apply(e, n) } for (n = Array(arguments.length - 2), s = 2; s < arguments.length; s++)n[s - 2] = arguments[s]; for (var s = !1, i = e.constructor; i; i = i.superClass_ && i.superClass_.constructor)if (i.prototype[t] === o) s = !0; else if (s) return i.prototype[t].apply(e, n); if (e[t] === o) return e.constructor.prototype[t].apply(e, n); throw Error("goog.base called from a method of one name to a method of a different name") }, goog.scope = function (e) { e.call(goog.global) }, COMPILED || (goog.global.COMPILED = COMPILED), goog.defineClass = function (e, t) { var r = t.constructor, o = t.statics; return r && r != Object.prototype.constructor || (r = function () { throw Error("cannot instantiate an interface (no constructor defined).") }), r = goog.defineClass.createSealingConstructor_(r, e), e && goog.inherits(r, e), delete t.constructor, delete t.statics, goog.defineClass.applyProperties_(r.prototype, t), null != o && (o instanceof Function ? o(r) : goog.defineClass.applyProperties_(r, o)), r }, goog.defineClass.SEAL_CLASS_INSTANCES = goog.DEBUG, goog.defineClass.createSealingConstructor_ = function (e, t) { if (goog.defineClass.SEAL_CLASS_INSTANCES && Object.seal instanceof Function) { if (t && t.prototype && t.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]) return e; var r = function () { var t = e.apply(this, arguments) || this; return t[goog.UID_PROPERTY_] = t[goog.UID_PROPERTY_], this.constructor === r && Object.seal(t), t }; return r } return e }, goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = "constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" "), goog.defineClass.applyProperties_ = function (e, t) { for (var r in t) Object.prototype.hasOwnProperty.call(t, r) && (e[r] = t[r]); for (var o = 0; o < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length; o++)r = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[o], Object.prototype.hasOwnProperty.call(t, r) && (e[r] = t[r]) }, goog.tagUnsealableClass = function (e) { !COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES && (e.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = !0) }, goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable", goog.dom = {}, goog.dom.NodeType = { ELEMENT: 1, ATTRIBUTE: 2, TEXT: 3, CDATA_SECTION: 4, ENTITY_REFERENCE: 5, ENTITY: 6, PROCESSING_INSTRUCTION: 7, COMMENT: 8, DOCUMENT: 9, DOCUMENT_TYPE: 10, DOCUMENT_FRAGMENT: 11, NOTATION: 12 }, goog.debug = {}, goog.debug.Error = function (e) { if (Error.captureStackTrace) Error.captureStackTrace(this, goog.debug.Error); else { var t = Error().stack; t && (this.stack = t) } e && (this.message = String(e)), this.reportErrorToServer = !0 }, goog.inherits(goog.debug.Error, Error), goog.debug.Error.prototype.name = "CustomError", goog.string = {}, goog.string.DETECT_DOUBLE_ESCAPING = !1, goog.string.FORCE_NON_DOM_HTML_UNESCAPING = !1, goog.string.Unicode = { NBSP: " " }, goog.string.startsWith = function (e, t) { return 0 == e.lastIndexOf(t, 0) }, goog.string.endsWith = function (e, t) { var r = e.length - t.length; return 0 <= r && e.indexOf(t, r) == r }, goog.string.caseInsensitiveStartsWith = function (e, t) { return 0 == goog.string.caseInsensitiveCompare(t, e.substr(0, t.length)) }, goog.string.caseInsensitiveEndsWith = function (e, t) { return 0 == goog.string.caseInsensitiveCompare(t, e.substr(e.length - t.length, t.length)) }, goog.string.caseInsensitiveEquals = function (e, t) { return e.toLowerCase() == t.toLowerCase() }, goog.string.subs = function (e, t) { for (var r = e.split("%s"), o = "", n = Array.prototype.slice.call(arguments, 1); n.length && 1 < r.length;)o += r.shift() + n.shift(); return o + r.join("%s") }, goog.string.collapseWhitespace = function (e) { return e.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "") }, goog.string.isEmptyOrWhitespace = function (e) { return /^[\s\xa0]*$/.test(e) }, goog.string.isEmptyString = function (e) { return 0 == e.length }, goog.string.isEmpty = goog.string.isEmptyOrWhitespace, goog.string.isEmptyOrWhitespaceSafe = function (e) { return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(e)) }, goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe, goog.string.isBreakingWhitespace = function (e) { return !/[^\t\n\r ]/.test(e) }, goog.string.isAlpha = function (e) { return !/[^a-zA-Z]/.test(e) }, goog.string.isNumeric = function (e) { return !/[^0-9]/.test(e) }, goog.string.isAlphaNumeric = function (e) { return !/[^a-zA-Z0-9]/.test(e) }, goog.string.isSpace = function (e) { return " " == e }, goog.string.isUnicodeChar = function (e) { return 1 == e.length && " " <= e && "~" >= e || "" <= e && "�" >= e }, goog.string.stripNewlines = function (e) { return e.replace(/(\r\n|\r|\n)+/g, " ") }, goog.string.canonicalizeNewlines = function (e) { return e.replace(/(\r\n|\r|\n)/g, "\n") }, goog.string.normalizeWhitespace = function (e) { return e.replace(/\xa0|\s/g, " ") }, goog.string.normalizeSpaces = function (e) { return e.replace(/\xa0|[ \t]+/g, " ") }, goog.string.collapseBreakingSpaces = function (e) { return e.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "") }, goog.string.trim = goog.TRUSTED_SITE && String.prototype.trim ? function (e) { return e.trim() } : function (e) { return e.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "") }, goog.string.trimLeft = function (e) { return e.replace(/^[\s\xa0]+/, "") }, goog.string.trimRight = function (e) { return e.replace(/[\s\xa0]+$/, "") }, goog.string.caseInsensitiveCompare = function (e, t) { var r = String(e).toLowerCase(), o = String(t).toLowerCase(); return r < o ? -1 : r == o ? 0 : 1 }, goog.string.numberAwareCompare_ = function (e, t, r) { if (e == t) return 0; if (!e) return -1; if (!t) return 1; for (var o = e.toLowerCase().match(r), n = t.toLowerCase().match(r), s = Math.min(o.length, n.length), i = 0; i < s; i++) { r = o[i]; var a = n[i]; if (r != a) return e = parseInt(r, 10), !isNaN(e) && (t = parseInt(a, 10), !isNaN(t) && e - t) ? e - t : r < a ? -1 : 1 } return o.length != n.length ? o.length - n.length : e < t ? -1 : 1 }, goog.string.intAwareCompare = function (e, t) { return goog.string.numberAwareCompare_(e, t, /\d+|\D+/g) }, goog.string.floatAwareCompare = function (e, t) { return goog.string.numberAwareCompare_(e, t, /\d+|\.\d+|\D+/g) }, goog.string.numerateCompare = goog.string.floatAwareCompare, goog.string.urlEncode = function (e) { return encodeURIComponent(String(e)) }, goog.string.urlDecode = function (e) { return decodeURIComponent(e.replace(/\+/g, " ")) }, goog.string.newLineToBr = function (e, t) { return e.replace(/(\r\n|\r|\n)/g, t ? "<br />" : "<br>") }, goog.string.htmlEscape = function (e, t) { if (t) e = e.replace(goog.string.AMP_RE_, "&amp;").replace(goog.string.LT_RE_, "&lt;").replace(goog.string.GT_RE_, "&gt;").replace(goog.string.QUOT_RE_, "&quot;").replace(goog.string.SINGLE_QUOTE_RE_, "&#39;").replace(goog.string.NULL_RE_, "&#0;"), goog.string.DETECT_DOUBLE_ESCAPING && (e = e.replace(goog.string.E_RE_, "&#101;")); else { if (!goog.string.ALL_RE_.test(e)) return e; -1 != e.indexOf("&") && (e = e.replace(goog.string.AMP_RE_, "&amp;")), -1 != e.indexOf("<") && (e = e.replace(goog.string.LT_RE_, "&lt;")), -1 != e.indexOf(">") && (e = e.replace(goog.string.GT_RE_, "&gt;")), -1 != e.indexOf('"') && (e = e.replace(goog.string.QUOT_RE_, "&quot;")), -1 != e.indexOf("'") && (e = e.replace(goog.string.SINGLE_QUOTE_RE_, "&#39;")), -1 != e.indexOf("\0") && (e = e.replace(goog.string.NULL_RE_, "&#0;")), goog.string.DETECT_DOUBLE_ESCAPING && -1 != e.indexOf("e") && (e = e.replace(goog.string.E_RE_, "&#101;")) } return e }, goog.string.AMP_RE_ = /&/g, goog.string.LT_RE_ = /</g, goog.string.GT_RE_ = />/g, goog.string.QUOT_RE_ = /"/g, goog.string.SINGLE_QUOTE_RE_ = /'/g, goog.string.NULL_RE_ = /\x00/g, goog.string.E_RE_ = /e/g, goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/, goog.string.unescapeEntities = function (e) { return goog.string.contains(e, "&") ? !goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global ? goog.string.unescapeEntitiesUsingDom_(e) : goog.string.unescapePureXmlEntities_(e) : e }, goog.string.unescapeEntitiesWithDocument = function (e, t) { return goog.string.contains(e, "&") ? goog.string.unescapeEntitiesUsingDom_(e, t) : e }, goog.string.unescapeEntitiesUsingDom_ = function (e, t) { var r, o = { "&amp;": "&", "&lt;": "<", "&gt;": ">", "&quot;": '"' }; return r = t ? t.createElement("div") : goog.global.document.createElement("div"), e.replace(goog.string.HTML_ENTITY_PATTERN_, function (e, t) { var n = o[e]; if (n) return n; if ("#" == t.charAt(0)) { var s = Number("0" + t.substr(1)); isNaN(s) || (n = String.fromCharCode(s)) } return n || (r.innerHTML = e + " ", n = r.firstChild.nodeValue.slice(0, -1)), o[e] = n }) }, goog.string.unescapePureXmlEntities_ = function (e) { return e.replace(/&([^;]+);/g, function (e, t) { switch (t) { case "amp": return "&"; case "lt": return "<"; case "gt": return ">"; case "quot": return '"'; default: if ("#" == t.charAt(0)) { var r = Number("0" + t.substr(1)); if (!isNaN(r)) return String.fromCharCode(r) } return e } }) }, goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g, goog.string.whitespaceEscape = function (e, t) { return goog.string.newLineToBr(e.replace(/  /g, " &#160;"), t) }, goog.string.preserveSpaces = function (e) { return e.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP) }, goog.string.stripQuotes = function (e, t) { for (var r = t.length, o = 0; o < r; o++) { var n = 1 == r ? t : t.charAt(o); if (e.charAt(0) == n && e.charAt(e.length - 1) == n) return e.substring(1, e.length - 1) } return e }, goog.string.truncate = function (e, t, r) { return r && (e = goog.string.unescapeEntities(e)), e.length > t && (e = e.substring(0, t - 3) + "..."), r && (e = goog.string.htmlEscape(e)), e }, goog.string.truncateMiddle = function (e, t, r, o) { if (r && (e = goog.string.unescapeEntities(e)), o && e.length > t) { o > t && (o = t); var n = e.length - o; e = e.substring(0, t - o) + "..." + e.substring(n) } else e.length > t && (o = Math.floor(t / 2), n = e.length - o, e = e.substring(0, o + t % 2) + "..." + e.substring(n)); return r && (e = goog.string.htmlEscape(e)), e }, goog.string.specialEscapeChars_ = { "\0": "\\0", "\b": "\\b", "\f": "\\f", "\n": "\\n", "\r": "\\r", "\t": "\\t", "\v": "\\x0B", '"': '\\"', "\\": "\\\\", "<": "<" }, goog.string.jsEscapeCache_ = { "'": "\\'" }, goog.string.quote = function (e) { e = String(e); for (var t = ['"'], r = 0; r < e.length; r++) { var o = e.charAt(r), n = o.charCodeAt(0); t[r + 1] = goog.string.specialEscapeChars_[o] || (31 < n && 127 > n ? o : goog.string.escapeChar(o)) } return t.push('"'), t.join("") }, goog.string.escapeString = function (e) { for (var t = [], r = 0; r < e.length; r++)t[r] = goog.string.escapeChar(e.charAt(r)); return t.join("") }, goog.string.escapeChar = function (e) { if (e in goog.string.jsEscapeCache_) return goog.string.jsEscapeCache_[e]; if (e in goog.string.specialEscapeChars_) return goog.string.jsEscapeCache_[e] = goog.string.specialEscapeChars_[e]; var t, r = e.charCodeAt(0); return 31 < r && 127 > r ? t = e : (256 > r ? (t = "\\x", (16 > r || 256 < r) && (t += "0")) : (t = "\\u", 4096 > r && (t += "0")), t += r.toString(16).toUpperCase()), goog.string.jsEscapeCache_[e] = t }, goog.string.contains = function (e, t) { return -1 != e.indexOf(t) }, goog.string.caseInsensitiveContains = function (e, t) { return goog.string.contains(e.toLowerCase(), t.toLowerCase()) }, goog.string.countOf = function (e, t) { return e && t ? e.split(t).length - 1 : 0 }, goog.string.removeAt = function (e, t, r) { var o = e; return 0 <= t && t < e.length && 0 < r && (o = e.substr(0, t) + e.substr(t + r, e.length - t - r)), o }, goog.string.remove = function (e, t) { var r = new RegExp(goog.string.regExpEscape(t), ""); return e.replace(r, "") }, goog.string.removeAll = function (e, t) { var r = new RegExp(goog.string.regExpEscape(t), "g"); return e.replace(r, "") }, goog.string.regExpEscape = function (e) { return String(e).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08") }, goog.string.repeat = String.prototype.repeat ? function (e, t) { return e.repeat(t) } : function (e, t) { return Array(t + 1).join(e) }, goog.string.padNumber = function (e, t, r) { return e = goog.isDef(r) ? e.toFixed(r) : String(e), r = e.indexOf("."), -1 == r && (r = e.length), goog.string.repeat("0", Math.max(0, t - r)) + e }, goog.string.makeSafe = function (e) { return null == e ? "" : String(e) }, goog.string.buildString = function (e) { return Array.prototype.join.call(arguments, "") }, goog.string.getRandomString = function () { return Math.floor(2147483648 * Math.random()).toString(36) + Math.abs(Math.floor(2147483648 * Math.random()) ^ goog.now()).toString(36) }, goog.string.compareVersions = function (e, t) { for (var r = 0, o = goog.string.trim(String(e)).split("."), n = goog.string.trim(String(t)).split("."), s = Math.max(o.length, n.length), i = 0; 0 == r && i < s; i++) { var a = o[i] || "", g = n[i] || "", p = RegExp("(\\d*)(\\D*)", "g"), u = RegExp("(\\d*)(\\D*)", "g"); do { var c = p.exec(a) || ["", "", ""], l = u.exec(g) || ["", "", ""]; if (0 == c[0].length && 0 == l[0].length) break; var r = 0 == c[1].length ? 0 : parseInt(c[1], 10), h = 0 == l[1].length ? 0 : parseInt(l[1], 10), r = goog.string.compareElements_(r, h) || goog.string.compareElements_(0 == c[2].length, 0 == l[2].length) || goog.string.compareElements_(c[2], l[2]) } while (0 == r) } return r }, goog.string.compareElements_ = function (e, t) { return e < t ? -1 : e > t ? 1 : 0 }, goog.string.hashCode = function (e) { for (var t = 0, r = 0; r < e.length; ++r)t = 31 * t + e.charCodeAt(r) >>> 0; return t }, goog.string.uniqueStringCounter_ = 2147483648 * Math.random() | 0, goog.string.createUniqueString = function () { return "goog_" + goog.string.uniqueStringCounter_++ }, goog.string.toNumber = function (e) { var t = Number(e); return 0 == t && goog.string.isEmptyOrWhitespace(e) ? NaN : t }, goog.string.isLowerCamelCase = function (e) { return /^[a-z]+([A-Z][a-z]*)*$/.test(e) }, goog.string.isUpperCamelCase = function (e) { return /^([A-Z][a-z]*)+$/.test(e) }, goog.string.toCamelCase = function (e) { return String(e).replace(/\-([a-z])/g, function (e, t) { return t.toUpperCase() }) }, goog.string.toSelectorCase = function (e) { return String(e).replace(/([A-Z])/g, "-$1").toLowerCase() }, goog.string.toTitleCase = function (e, t) { var r = goog.isString(t) ? goog.string.regExpEscape(t) : "\\s"; return e.replace(new RegExp("(^" + (r ? "|[" + r + "]+" : "") + ")([a-z])", "g"), function (e, t, r) { return t + r.toUpperCase() }) }, goog.string.capitalize = function (e) { return String(e.charAt(0)).toUpperCase() + String(e.substr(1)).toLowerCase() }, goog.string.parseInt = function (e) { return isFinite(e) && (e = String(e)), goog.isString(e) ? /^\s*-?0x/i.test(e) ? parseInt(e, 16) : parseInt(e, 10) : NaN }, goog.string.splitLimit = function (e, t, r) { e = e.split(t); for (var o = []; 0 < r && e.length;)o.push(e.shift()), r--; return e.length && o.push(e.join(t)), o }, goog.string.editDistance = function (e, t) { var r = [], o = []; if (e == t) return 0; if (!e.length || !t.length) return Math.max(e.length, t.length); for (var n = 0; n < t.length + 1; n++)r[n] = n; for (n = 0; n < e.length; n++) { o[0] = n + 1; for (var s = 0; s < t.length; s++)o[s + 1] = Math.min(o[s] + 1, r[s + 1] + 1, r[s] + Number(e[n] != t[s])); for (s = 0; s < r.length; s++)r[s] = o[s] } return o[t.length] }, goog.asserts = {}, goog.asserts.ENABLE_ASSERTS = goog.DEBUG, goog.asserts.AssertionError = function (e, t) { t.unshift(e), goog.debug.Error.call(this, goog.string.subs.apply(null, t)), t.shift(), this.messagePattern = e }, goog.inherits(goog.asserts.AssertionError, goog.debug.Error), goog.asserts.AssertionError.prototype.name = "AssertionError", goog.asserts.DEFAULT_ERROR_HANDLER = function (e) { throw e }, goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER, goog.asserts.doAssertFailure_ = function (e, t, r, o) { var n = "Assertion failed"; if (r) var n = n + ": " + r, s = o; else e && (n += ": " + e, s = t); e = new goog.asserts.AssertionError("" + n, s || []), goog.asserts.errorHandler_(e) }, goog.asserts.setErrorHandler = function (e) { goog.asserts.ENABLE_ASSERTS && (goog.asserts.errorHandler_ = e) }, goog.asserts.assert = function (e, t, r) { return goog.asserts.ENABLE_ASSERTS && !e && goog.asserts.doAssertFailure_("", null, t, Array.prototype.slice.call(arguments, 2)), e }, goog.asserts.fail = function (e, t) { goog.asserts.ENABLE_ASSERTS && goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (e ? ": " + e : ""), Array.prototype.slice.call(arguments, 1))) }, goog.asserts.assertNumber = function (e, t, r) { return goog.asserts.ENABLE_ASSERTS && !goog.isNumber(e) && goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e }, goog.asserts.assertString = function (e, t, r) { return goog.asserts.ENABLE_ASSERTS && !goog.isString(e) && goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e }, goog.asserts.assertFunction = function (e, t, r) { return goog.asserts.ENABLE_ASSERTS && !goog.isFunction(e) && goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e }, goog.asserts.assertObject = function (e, t, r) { return goog.asserts.ENABLE_ASSERTS && !goog.isObject(e) && goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e }, goog.asserts.assertArray = function (e, t, r) { return goog.asserts.ENABLE_ASSERTS && !goog.isArray(e) && goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e }, goog.asserts.assertBoolean = function (e, t, r) { return goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(e) && goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e }, goog.asserts.assertElement = function (e, t, r) { return !goog.asserts.ENABLE_ASSERTS || goog.isObject(e) && e.nodeType == goog.dom.NodeType.ELEMENT || goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e }, goog.asserts.assertInstanceof = function (e, t, r, o) { return !goog.asserts.ENABLE_ASSERTS || e instanceof t || goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(t), goog.asserts.getType_(e)], r, Array.prototype.slice.call(arguments, 3)), e }; goog.asserts.assertObjectPrototypeIsIntact = function () { for (var e in Object.prototype) goog.asserts.fail(e + " should not be enumerable in Object.prototype.") }, goog.asserts.getType_ = function (e) { return e instanceof Function ? e.displayName || e.name || "unknown type name" : e instanceof Object ? e.constructor.displayName || e.constructor.name || Object.prototype.toString.call(e) : null === e ? "null" : typeof e }; var jspb = { Map: function (e, t) { this.arr_ = e, this.valueCtor_ = t, this.map_ = {}, this.arrClean = !0, 0 < this.arr_.length && this.loadFromArray_() } }; jspb.Map.prototype.loadFromArray_ = function () { for (var e = 0; e < this.arr_.length; e++) { var t = this.arr_[e], r = t[0]; this.map_[r.toString()] = new jspb.Map.Entry_(r, t[1]) } this.arrClean = !0 }, jspb.Map.prototype.toArray = function () { if (this.arrClean) { if (this.valueCtor_) { var e, t = this.map_; for (e in t) if (Object.prototype.hasOwnProperty.call(t, e)) { var r = t[e].valueWrapper; r && r.toArray() } } } else { for (this.arr_.length = 0, t = this.stringKeys_(), t.sort(), e = 0; e < t.length; e++) { var o = this.map_[t[e]]; (r = o.valueWrapper) && r.toArray(), this.arr_.push([o.key, o.value]) } this.arrClean = !0 } return this.arr_ }, jspb.Map.prototype.toObject = function (e, t) { for (var r = this.toArray(), o = [], n = 0; n < r.length; n++) { var s = this.map_[r[n][0].toString()]; this.wrapEntry_(s); var i = s.valueWrapper; i ? (goog.asserts.assert(t), o.push([s.key, t(e, i)])) : o.push([s.key, s.value]) } return o }, jspb.Map.fromObject = function (e, t, r) { t = new jspb.Map([], t); for (var o = 0; o < e.length; o++) { var n = e[o][0], s = r(e[o][1]); t.set(n, s) } return t }, jspb.Map.ArrayIteratorIterable_ = function (e) { this.idx_ = 0, this.arr_ = e }, jspb.Map.ArrayIteratorIterable_.prototype.next = function () { return this.idx_ < this.arr_.length ? { done: !1, value: this.arr_[this.idx_++] } : { done: !0, value: void 0 } }, $jscomp.initSymbol(), "undefined" != typeof Symbol && ($jscomp.initSymbol(), $jscomp.initSymbolIterator(), jspb.Map.ArrayIteratorIterable_.prototype[Symbol.iterator] = function () { return this }), jspb.Map.prototype.getLength = function () { return this.stringKeys_().length }, jspb.Map.prototype.clear = function () { this.map_ = {}, this.arrClean = !1 }, jspb.Map.prototype.del = function (e) { e = e.toString(); var t = this.map_.hasOwnProperty(e); return delete this.map_[e], this.arrClean = !1, t }, jspb.Map.prototype.getEntryList = function () { var e = [], t = this.stringKeys_(); t.sort(); for (var r = 0; r < t.length; r++) { var o = this.map_[t[r]]; e.push([o.key, o.value]) } return e }, jspb.Map.prototype.entries = function () { var e = [], t = this.stringKeys_(); t.sort(); for (var r = 0; r < t.length; r++) { var o = this.map_[t[r]]; e.push([o.key, this.wrapEntry_(o)]) } return new jspb.Map.ArrayIteratorIterable_(e) }, jspb.Map.prototype.keys = function () { var e = [], t = this.stringKeys_(); t.sort(); for (var r = 0; r < t.length; r++)e.push(this.map_[t[r]].key); return new jspb.Map.ArrayIteratorIterable_(e) }, jspb.Map.prototype.values = function () { var e = [], t = this.stringKeys_(); t.sort(); for (var r = 0; r < t.length; r++)e.push(this.wrapEntry_(this.map_[t[r]])); return new jspb.Map.ArrayIteratorIterable_(e) }, jspb.Map.prototype.forEach = function (e, t) { var r = this.stringKeys_(); r.sort(); for (var o = 0; o < r.length; o++) { var n = this.map_[r[o]]; e.call(t, this.wrapEntry_(n), n.key, this) } }, jspb.Map.prototype.set = function (e, t) { var r = new jspb.Map.Entry_(e); return this.valueCtor_ ? (r.valueWrapper = t, r.value = t.toArray()) : r.value = t, this.map_[e.toString()] = r, this.arrClean = !1, this }, jspb.Map.prototype.wrapEntry_ = function (e) { return this.valueCtor_ ? (e.valueWrapper || (e.valueWrapper = new this.valueCtor_(e.value)), e.valueWrapper) : e.value }, jspb.Map.prototype.get = function (e) { if (e = this.map_[e.toString()]) return this.wrapEntry_(e) }, jspb.Map.prototype.has = function (e) { return e.toString() in this.map_ }, jspb.Map.prototype.serializeBinary = function (e, t, r, o, n) { var s = this.stringKeys_(); s.sort(); for (var i = 0; i < s.length; i++) { var a = this.map_[s[i]]; t.beginSubMessage(e), r.call(t, 1, a.key), this.valueCtor_ ? o.call(t, 2, this.wrapEntry_(a), n) : o.call(t, 2, a.value), t.endSubMessage() } }, jspb.Map.deserializeBinary = function (e, t, r, o, n, s) { for (var i = void 0; t.nextField() && !t.isEndGroup();) { var a = t.getFieldNumber(); 1 == a ? s = r.call(t) : 2 == a && (e.valueCtor_ ? (goog.asserts.assert(n), i = new e.valueCtor_, o.call(t, i, n)) : i = o.call(t)) } goog.asserts.assert(void 0 != s), goog.asserts.assert(void 0 != i), e.set(s, i) }, jspb.Map.prototype.stringKeys_ = function () { var e, t = this.map_, r = []; for (e in t) Object.prototype.hasOwnProperty.call(t, e) && r.push(e); return r }, jspb.Map.Entry_ = function (e, t) { this.key = e, this.value = t, this.valueWrapper = void 0 }, goog.array = {}, goog.NATIVE_ARRAY_PROTOTYPES = goog.TRUSTED_SITE, goog.array.ASSUME_NATIVE_FUNCTIONS = !1, goog.array.peek = function (e) { return e[e.length - 1] }, goog.array.last = goog.array.peek, goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.indexOf) ? function (e, t, r) { return goog.asserts.assert(null != e.length), Array.prototype.indexOf.call(e, t, r) } : function (e, t, r) { if (r = null == r ? 0 : 0 > r ? Math.max(0, e.length + r) : r, goog.isString(e)) return goog.isString(t) && 1 == t.length ? e.indexOf(t, r) : -1; for (; r < e.length; r++)if (r in e && e[r] === t) return r; return -1 }, goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.lastIndexOf) ? function (e, t, r) { return goog.asserts.assert(null != e.length), Array.prototype.lastIndexOf.call(e, t, null == r ? e.length - 1 : r) } : function (e, t, r) { if (r = null == r ? e.length - 1 : r, 0 > r && (r = Math.max(0, e.length + r)), goog.isString(e)) return goog.isString(t) && 1 == t.length ? e.lastIndexOf(t, r) : -1; for (; 0 <= r; r--)if (r in e && e[r] === t) return r; return -1 }, goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.forEach) ? function (e, t, r) { goog.asserts.assert(null != e.length), Array.prototype.forEach.call(e, t, r) } : function (e, t, r) { for (var o = e.length, n = goog.isString(e) ? e.split("") : e, s = 0; s < o; s++)s in n && t.call(r, n[s], s, e) }, goog.array.forEachRight = function (e, t, r) { for (var o = e.length, n = goog.isString(e) ? e.split("") : e, o = o - 1; 0 <= o; --o)o in n && t.call(r, n[o], o, e) }, goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.filter) ? function (e, t, r) { return goog.asserts.assert(null != e.length), Array.prototype.filter.call(e, t, r) } : function (e, t, r) { for (var o = e.length, n = [], s = 0, i = goog.isString(e) ? e.split("") : e, a = 0; a < o; a++)if (a in i) { var g = i[a]; t.call(r, g, a, e) && (n[s++] = g) } return n }, goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.map) ? function (e, t, r) { return goog.asserts.assert(null != e.length), Array.prototype.map.call(e, t, r) } : function (e, t, r) { for (var o = e.length, n = Array(o), s = goog.isString(e) ? e.split("") : e, i = 0; i < o; i++)i in s && (n[i] = t.call(r, s[i], i, e)); return n }, goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduce) ? function (e, t, r, o) { return goog.asserts.assert(null != e.length), o && (t = goog.bind(t, o)), Array.prototype.reduce.call(e, t, r) } : function (e, t, r, o) { var n = r; return goog.array.forEach(e, function (r, s) { n = t.call(o, n, r, s, e) }), n }, goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduceRight) ? function (e, t, r, o) { return goog.asserts.assert(null != e.length), goog.asserts.assert(null != t), o && (t = goog.bind(t, o)), Array.prototype.reduceRight.call(e, t, r) } : function (e, t, r, o) { var n = r; return goog.array.forEachRight(e, function (r, s) { n = t.call(o, n, r, s, e) }), n }, goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.some) ? function (e, t, r) { return goog.asserts.assert(null != e.length), Array.prototype.some.call(e, t, r) } : function (e, t, r) { for (var o = e.length, n = goog.isString(e) ? e.split("") : e, s = 0; s < o; s++)if (s in n && t.call(r, n[s], s, e)) return !0; return !1 }, goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.every) ? function (e, t, r) { return goog.asserts.assert(null != e.length), Array.prototype.every.call(e, t, r) } : function (e, t, r) { for (var o = e.length, n = goog.isString(e) ? e.split("") : e, s = 0; s < o; s++)if (s in n && !t.call(r, n[s], s, e)) return !1; return !0 }, goog.array.count = function (e, t, r) { var o = 0; return goog.array.forEach(e, function (e, n, s) { t.call(r, e, n, s) && ++o }, r), o }, goog.array.find = function (e, t, r) { return t = goog.array.findIndex(e, t, r), 0 > t ? null : goog.isString(e) ? e.charAt(t) : e[t] }, goog.array.findIndex = function (e, t, r) { for (var o = e.length, n = goog.isString(e) ? e.split("") : e, s = 0; s < o; s++)if (s in n && t.call(r, n[s], s, e)) return s; return -1 }, goog.array.findRight = function (e, t, r) { return t = goog.array.findIndexRight(e, t, r), 0 > t ? null : goog.isString(e) ? e.charAt(t) : e[t] }, goog.array.findIndexRight = function (e, t, r) { for (var o = e.length, n = goog.isString(e) ? e.split("") : e, o = o - 1; 0 <= o; o--)if (o in n && t.call(r, n[o], o, e)) return o; return -1 }, goog.array.contains = function (e, t) { return 0 <= goog.array.indexOf(e, t) }, goog.array.isEmpty = function (e) { return 0 == e.length }, goog.array.clear = function (e) { if (!goog.isArray(e)) for (var t = e.length - 1; 0 <= t; t--)delete e[t]; e.length = 0 }, goog.array.insert = function (e, t) { goog.array.contains(e, t) || e.push(t) }, goog.array.insertAt = function (e, t, r) { goog.array.splice(e, r, 0, t) }, goog.array.insertArrayAt = function (e, t, r) { goog.partial(goog.array.splice, e, r, 0).apply(null, t) }, goog.array.insertBefore = function (e, t, r) { var o; 2 == arguments.length || 0 > (o = goog.array.indexOf(e, r)) ? e.push(t) : goog.array.insertAt(e, t, o) }, goog.array.remove = function (e, t) { var r, o = goog.array.indexOf(e, t); return (r = 0 <= o) && goog.array.removeAt(e, o), r }, goog.array.removeAt = function (e, t) { return goog.asserts.assert(null != e.length), 1 == Array.prototype.splice.call(e, t, 1).length }, goog.array.removeIf = function (e, t, r) { return 0 <= (t = goog.array.findIndex(e, t, r)) && (goog.array.removeAt(e, t), !0) }, goog.array.removeAllIf = function (e, t, r) { var o = 0; return goog.array.forEachRight(e, function (n, s) { t.call(r, n, s, e) && goog.array.removeAt(e, s) && o++ }), o }, goog.array.concat = function (e) { return Array.prototype.concat.apply(Array.prototype, arguments) }, goog.array.join = function (e) { return Array.prototype.concat.apply(Array.prototype, arguments) }, goog.array.toArray = function (e) { var t = e.length; if (0 < t) { for (var r = Array(t), o = 0; o < t; o++)r[o] = e[o]; return r } return [] }, goog.array.clone = goog.array.toArray, goog.array.extend = function (e, t) { for (var r = 1; r < arguments.length; r++) { var o = arguments[r]; if (goog.isArrayLike(o)) { var n = e.length || 0, s = o.length || 0; e.length = n + s; for (var i = 0; i < s; i++)e[n + i] = o[i] } else e.push(o) } }, goog.array.splice = function (e, t, r, o) { return goog.asserts.assert(null != e.length), Array.prototype.splice.apply(e, goog.array.slice(arguments, 1)) }, goog.array.slice = function (e, t, r) { return goog.asserts.assert(null != e.length), 2 >= arguments.length ? Array.prototype.slice.call(e, t) : Array.prototype.slice.call(e, t, r) }, goog.array.removeDuplicates = function (e, t, r) { t = t || e; var o = function (e) { return goog.isObject(e) ? "o" + goog.getUid(e) : (typeof e).charAt(0) + e }; r = r || o; for (var o = {}, n = 0, s = 0; s < e.length;) { var i = e[s++], a = r(i); Object.prototype.hasOwnProperty.call(o, a) || (o[a] = !0, t[n++] = i) } t.length = n }, goog.array.binarySearch = function (e, t, r) { return goog.array.binarySearch_(e, r || goog.array.defaultCompare, !1, t) }, goog.array.binarySelect = function (e, t, r) { return goog.array.binarySearch_(e, t, !0, void 0, r) }, goog.array.binarySearch_ = function (e, t, r, o, n) { for (var s, i = 0, a = e.length; i < a;) { var g, p = i + a >> 1; g = r ? t.call(n, e[p], p, e) : t(o, e[p]), 0 < g ? i = p + 1 : (a = p, s = !g) } return s ? i : ~i }, goog.array.sort = function (e, t) { e.sort(t || goog.array.defaultCompare) }, goog.array.stableSort = function (e, t) { for (var r = 0; r < e.length; r++)e[r] = { index: r, value: e[r] }; var o = t || goog.array.defaultCompare; for (goog.array.sort(e, function (e, t) { return o(e.value, t.value) || e.index - t.index }), r = 0; r < e.length; r++)e[r] = e[r].value }, goog.array.sortByKey = function (e, t, r) { var o = r || goog.array.defaultCompare; goog.array.sort(e, function (e, r) { return o(t(e), t(r)) }) }, goog.array.sortObjectsByKey = function (e, t, r) { goog.array.sortByKey(e, function (e) { return e[t] }, r) }, goog.array.isSorted = function (e, t, r) { t = t || goog.array.defaultCompare; for (var o = 1; o < e.length; o++) { var n = t(e[o - 1], e[o]); if (0 < n || 0 == n && r) return !1 } return !0 }, goog.array.equals = function (e, t, r) { if (!goog.isArrayLike(e) || !goog.isArrayLike(t) || e.length != t.length) return !1; var o = e.length; r = r || goog.array.defaultCompareEquality; for (var n = 0; n < o; n++)if (!r(e[n], t[n])) return !1; return !0 }, goog.array.compare3 = function (e, t, r) { r = r || goog.array.defaultCompare; for (var o = Math.min(e.length, t.length), n = 0; n < o; n++) { var s = r(e[n], t[n]); if (0 != s) return s } return goog.array.defaultCompare(e.length, t.length) }, goog.array.defaultCompare = function (e, t) { return e > t ? 1 : e < t ? -1 : 0 }, goog.array.inverseDefaultCompare = function (e, t) { return -goog.array.defaultCompare(e, t) }, goog.array.defaultCompareEquality = function (e, t) { return e === t }, goog.array.binaryInsert = function (e, t, r) { return 0 > (r = goog.array.binarySearch(e, t, r)) && (goog.array.insertAt(e, t, -(r + 1)), !0) }, goog.array.binaryRemove = function (e, t, r) { return 0 <= (t = goog.array.binarySearch(e, t, r)) && goog.array.removeAt(e, t) }, goog.array.bucket = function (e, t, r) { for (var o = {}, n = 0; n < e.length; n++) { var s = e[n], i = t.call(r, s, n, e); goog.isDef(i) && (o[i] || (o[i] = [])).push(s) } return o }, goog.array.toObject = function (e, t, r) { var o = {}; return goog.array.forEach(e, function (n, s) { o[t.call(r, n, s, e)] = n }), o }, goog.array.range = function (e, t, r) { var o = [], n = 0, s = e; if (r = r || 1, void 0 !== t && (n = e, s = t), 0 > r * (s - n)) return []; if (0 < r) for (e = n; e < s; e += r)o.push(e); else for (e = n; e > s; e += r)o.push(e); return o }, goog.array.repeat = function (e, t) { for (var r = [], o = 0; o < t; o++)r[o] = e; return r }, goog.array.flatten = function (e) { for (var t = [], r = 0; r < arguments.length; r++) { var o = arguments[r]; if (goog.isArray(o)) for (var n = 0; n < o.length; n += 8192)for (var s = goog.array.slice(o, n, n + 8192), s = goog.array.flatten.apply(null, s), i = 0; i < s.length; i++)t.push(s[i]); else t.push(o) } return t }, goog.array.rotate = function (e, t) { return goog.asserts.assert(null != e.length), e.length && (t %= e.length, 0 < t ? Array.prototype.unshift.apply(e, e.splice(-t, t)) : 0 > t && Array.prototype.push.apply(e, e.splice(0, -t))), e }, goog.array.moveItem = function (e, t, r) { goog.asserts.assert(0 <= t && t < e.length), goog.asserts.assert(0 <= r && r < e.length), t = Array.prototype.splice.call(e, t, 1), Array.prototype.splice.call(e, r, 0, t[0]) }, goog.array.zip = function (e) { if (!arguments.length) return []; for (var t = [], r = arguments[0].length, o = 1; o < arguments.length; o++)arguments[o].length < r && (r = arguments[o].length); for (o = 0; o < r; o++) { for (var n = [], s = 0; s < arguments.length; s++)n.push(arguments[s][o]); t.push(n) } return t }, goog.array.shuffle = function (e, t) { for (var r = t || Math.random, o = e.length - 1; 0 < o; o--) { var n = Math.floor(r() * (o + 1)), s = e[o]; e[o] = e[n], e[n] = s } }, goog.array.copyByIndex = function (e, t) { var r = []; return goog.array.forEach(t, function (t) { r.push(e[t]) }), r }, goog.crypt = {}, goog.crypt.stringToByteArray = function (e) { for (var t = [], r = 0, o = 0; o < e.length; o++) { for (var n = e.charCodeAt(o); 255 < n;)t[r++] = 255 & n, n >>= 8; t[r++] = n } return t }, goog.crypt.byteArrayToString = function (e) { if (8192 >= e.length) return String.fromCharCode.apply(null, e); for (var t = "", r = 0; r < e.length; r += 8192)var o = goog.array.slice(e, r, r + 8192), t = t + String.fromCharCode.apply(null, o); return t }, goog.crypt.byteArrayToHex = function (e) { return goog.array.map(e, function (e) { return e = e.toString(16), 1 < e.length ? e : "0" + e }).join("") }, goog.crypt.hexToByteArray = function (e) { goog.asserts.assert(0 == e.length % 2, "Key string length must be multiple of 2"); for (var t = [], r = 0; r < e.length; r += 2)t.push(parseInt(e.substring(r, r + 2), 16)); return t }, goog.crypt.stringToUtf8ByteArray = function (e) { for (var t = [], r = 0, o = 0; o < e.length; o++) { var n = e.charCodeAt(o); 128 > n ? t[r++] = n : (2048 > n ? t[r++] = n >> 6 | 192 : (55296 == (64512 & n) && o + 1 < e.length && 56320 == (64512 & e.charCodeAt(o + 1)) ? (n = 65536 + ((1023 & n) << 10) + (1023 & e.charCodeAt(++o)), t[r++] = n >> 18 | 240, t[r++] = n >> 12 & 63 | 128) : t[r++] = n >> 12 | 224, t[r++] = n >> 6 & 63 | 128), t[r++] = 63 & n | 128) } return t }, goog.crypt.utf8ByteArrayToString = function (e) { for (var t = [], r = 0, o = 0; r < e.length;) { var n = e[r++]; if (128 > n) t[o++] = String.fromCharCode(n); else if (191 < n && 224 > n) { var s = e[r++]; t[o++] = String.fromCharCode((31 & n) << 6 | 63 & s) } else if (239 < n && 365 > n) { var s = e[r++], i = e[r++], a = e[r++], n = ((7 & n) << 18 | (63 & s) << 12 | (63 & i) << 6 | 63 & a) - 65536; t[o++] = String.fromCharCode(55296 + (n >> 10)), t[o++] = String.fromCharCode(56320 + (1023 & n)) } else s = e[r++], i = e[r++], t[o++] = String.fromCharCode((15 & n) << 12 | (63 & s) << 6 | 63 & i) } return t.join("") }, goog.crypt.xorByteArray = function (e, t) { goog.asserts.assert(e.length == t.length, "XOR array lengths must match"); for (var r = [], o = 0; o < e.length; o++)r.push(e[o] ^ t[o]); return r }, goog.labs = {}, goog.labs.userAgent = {}, goog.labs.userAgent.util = {}, goog.labs.userAgent.util.getNativeUserAgentString_ = function () { var e = goog.labs.userAgent.util.getNavigator_(); return e && (e = e.userAgent) ? e : "" }, goog.labs.userAgent.util.getNavigator_ = function () { return goog.global.navigator }, goog.labs.userAgent.util.userAgent_ = goog.labs.userAgent.util.getNativeUserAgentString_(), goog.labs.userAgent.util.setUserAgent = function (e) { goog.labs.userAgent.util.userAgent_ = e || goog.labs.userAgent.util.getNativeUserAgentString_() }, goog.labs.userAgent.util.getUserAgent = function () { return goog.labs.userAgent.util.userAgent_ }, goog.labs.userAgent.util.matchUserAgent = function (e) { var t = goog.labs.userAgent.util.getUserAgent(); return goog.string.contains(t, e) }, goog.labs.userAgent.util.matchUserAgentIgnoreCase = function (e) { var t = goog.labs.userAgent.util.getUserAgent(); return goog.string.caseInsensitiveContains(t, e) }, goog.labs.userAgent.util.extractVersionTuples = function (e) { for (var t, r = RegExp("(\\w[\\w ]+)/([^\\s]+)\\s*(?:\\((.*?)\\))?", "g"), o = []; t = r.exec(e);)o.push([t[1], t[2], t[3] || void 0]); return o }, goog.labs.userAgent.platform = {}, goog.labs.userAgent.platform.isAndroid = function () { return goog.labs.userAgent.util.matchUserAgent("Android") }, goog.labs.userAgent.platform.isIpod = function () { return goog.labs.userAgent.util.matchUserAgent("iPod") }, goog.labs.userAgent.platform.isIphone = function () { return goog.labs.userAgent.util.matchUserAgent("iPhone") && !goog.labs.userAgent.util.matchUserAgent("iPod") && !goog.labs.userAgent.util.matchUserAgent("iPad") }, goog.labs.userAgent.platform.isIpad = function () { return goog.labs.userAgent.util.matchUserAgent("iPad") }, goog.labs.userAgent.platform.isIos = function () { return goog.labs.userAgent.platform.isIphone() || goog.labs.userAgent.platform.isIpad() || goog.labs.userAgent.platform.isIpod() }, goog.labs.userAgent.platform.isMacintosh = function () { return goog.labs.userAgent.util.matchUserAgent("Macintosh") }, goog.labs.userAgent.platform.isLinux = function () { return goog.labs.userAgent.util.matchUserAgent("Linux") }, goog.labs.userAgent.platform.isWindows = function () { return goog.labs.userAgent.util.matchUserAgent("Windows") }, goog.labs.userAgent.platform.isChromeOS = function () { return goog.labs.userAgent.util.matchUserAgent("CrOS") }, goog.labs.userAgent.platform.getVersion = function () { var e = goog.labs.userAgent.util.getUserAgent(), t = ""; return goog.labs.userAgent.platform.isWindows() ? (t = /Windows (?:NT|Phone) ([0-9.]+)/, t = (e = t.exec(e)) ? e[1] : "0.0") : goog.labs.userAgent.platform.isIos() ? (t = /(?:iPhone|iPod|iPad|CPU)\s+OS\s+(\S+)/, t = (e = t.exec(e)) && e[1].replace(/_/g, ".")) : goog.labs.userAgent.platform.isMacintosh() ? (t = /Mac OS X ([0-9_.]+)/, t = (e = t.exec(e)) ? e[1].replace(/_/g, ".") : "10") : goog.labs.userAgent.platform.isAndroid() ? (t = /Android\s+([^\);]+)(\)|;)/, t = (e = t.exec(e)) && e[1]) : goog.labs.userAgent.platform.isChromeOS() && (t = /(?:CrOS\s+(?:i686|x86_64)\s+([0-9.]+))/, t = (e = t.exec(e)) && e[1]), t || "" }, goog.labs.userAgent.platform.isVersionOrHigher = function (e) { return 0 <= goog.string.compareVersions(goog.labs.userAgent.platform.getVersion(), e) }, goog.object = {}, goog.object.forEach = function (e, t, r) { for (var o in e) t.call(r, e[o], o, e) }, goog.object.filter = function (e, t, r) { var o, n = {}; for (o in e) t.call(r, e[o], o, e) && (n[o] = e[o]); return n }, goog.object.map = function (e, t, r) { var o, n = {}; for (o in e) n[o] = t.call(r, e[o], o, e); return n }, goog.object.some = function (e, t, r) { for (var o in e) if (t.call(r, e[o], o, e)) return !0; return !1 }, goog.object.every = function (e, t, r) { for (var o in e) if (!t.call(r, e[o], o, e)) return !1; return !0 }, goog.object.getCount = function (e) { var t, r = 0; for (t in e) r++; return r }, goog.object.getAnyKey = function (e) { for (var t in e) return t }, goog.object.getAnyValue = function (e) { for (var t in e) return e[t] }, goog.object.contains = function (e, t) { return goog.object.containsValue(e, t) }, goog.object.getValues = function (e) { var t, r = [], o = 0; for (t in e) r[o++] = e[t]; return r }, goog.object.getKeys = function (e) { var t, r = [], o = 0; for (t in e) r[o++] = t; return r }, goog.object.getValueByKeys = function (e, t) { for (var r = goog.isArrayLike(t), o = r ? t : arguments, r = r ? 0 : 1; r < o.length && (e = e[o[r]], goog.isDef(e)); r++); return e }, goog.object.containsKey = function (e, t) { return null !== e && t in e }, goog.object.containsValue = function (e, t) { for (var r in e) if (e[r] == t) return !0; return !1 }, goog.object.findKey = function (e, t, r) { for (var o in e) if (t.call(r, e[o], o, e)) return o }, goog.object.findValue = function (e, t, r) { return (t = goog.object.findKey(e, t, r)) && e[t] }, goog.object.isEmpty = function (e) { for (var t in e) return !1; return !0 }, goog.object.clear = function (e) { for (var t in e) delete e[t] }, goog.object.remove = function (e, t) { var r; return (r = t in e) && delete e[t], r }, goog.object.add = function (e, t, r) { if (null !== e && t in e) throw Error('The object already contains the key "' + t + '"'); goog.object.set(e, t, r) }, goog.object.get = function (e, t, r) { return null !== e && t in e ? e[t] : r }, goog.object.set = function (e, t, r) { e[t] = r }, goog.object.setIfUndefined = function (e, t, r) { return t in e ? e[t] : e[t] = r }, goog.object.setWithReturnValueIfNotSet = function (e, t, r) { return t in e ? e[t] : (r = r(), e[t] = r) }, goog.object.equals = function (e, t) { for (var r in e) if (!(r in t) || e[r] !== t[r]) return !1; for (r in t) if (!(r in e)) return !1; return !0 }, goog.object.clone = function (e) { var t, r = {}; for (t in e) r[t] = e[t]; return r }, goog.object.unsafeClone = function (e) { var t = goog.typeOf(e); if ("object" == t || "array" == t) { if (goog.isFunction(e.clone)) return e.clone(); var r, t = "array" == t ? [] : {}; for (r in e) t[r] = goog.object.unsafeClone(e[r]); return t } return e }, goog.object.transpose = function (e) { var t, r = {}; for (t in e) r[e[t]] = t; return r }, goog.object.PROTOTYPE_FIELDS_ = "constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" "), goog.object.extend = function (e, t) { for (var r, o, n = 1; n < arguments.length; n++) { o = arguments[n]; for (r in o) e[r] = o[r]; for (var s = 0; s < goog.object.PROTOTYPE_FIELDS_.length; s++)r = goog.object.PROTOTYPE_FIELDS_[s], Object.prototype.hasOwnProperty.call(o, r) && (e[r] = o[r]) } }, goog.object.create = function (e) { var t = arguments.length; if (1 == t && goog.isArray(arguments[0])) return goog.object.create.apply(null, arguments[0]); if (t % 2) throw Error("Uneven number of arguments"); for (var r = {}, o = 0; o < t; o += 2)r[arguments[o]] = arguments[o + 1]; return r }, goog.object.createSet = function (e) { var t = arguments.length; if (1 == t && goog.isArray(arguments[0])) return goog.object.createSet.apply(null, arguments[0]); for (var r = {}, o = 0; o < t; o++)r[arguments[o]] = !0; return r }, goog.object.createImmutableView = function (e) { var t = e; return Object.isFrozen && !Object.isFrozen(e) && (t = Object.create(e), Object.freeze(t)), t }, goog.object.isImmutableView = function (e) { return !!Object.isFrozen && Object.isFrozen(e) }, goog.labs.userAgent.browser = {}, goog.labs.userAgent.browser.matchOpera_ = function () { return goog.labs.userAgent.util.matchUserAgent("Opera") || goog.labs.userAgent.util.matchUserAgent("OPR") }, goog.labs.userAgent.browser.matchIE_ = function () { return goog.labs.userAgent.util.matchUserAgent("Trident") || goog.labs.userAgent.util.matchUserAgent("MSIE") }, goog.labs.userAgent.browser.matchEdge_ = function () { return goog.labs.userAgent.util.matchUserAgent("Edge") }, goog.labs.userAgent.browser.matchFirefox_ = function () { return goog.labs.userAgent.util.matchUserAgent("Firefox") }, goog.labs.userAgent.browser.matchSafari_ = function () { return goog.labs.userAgent.util.matchUserAgent("Safari") && !(goog.labs.userAgent.browser.matchChrome_() || goog.labs.userAgent.browser.matchCoast_() || goog.labs.userAgent.browser.matchOpera_() || goog.labs.userAgent.browser.matchEdge_() || goog.labs.userAgent.browser.isSilk() || goog.labs.userAgent.util.matchUserAgent("Android")) }, goog.labs.userAgent.browser.matchCoast_ = function () { return goog.labs.userAgent.util.matchUserAgent("Coast") }, goog.labs.userAgent.browser.matchIosWebview_ = function () { return (goog.labs.userAgent.util.matchUserAgent("iPad") || goog.labs.userAgent.util.matchUserAgent("iPhone")) && !goog.labs.userAgent.browser.matchSafari_() && !goog.labs.userAgent.browser.matchChrome_() && !goog.labs.userAgent.browser.matchCoast_() && goog.labs.userAgent.util.matchUserAgent("AppleWebKit") }, goog.labs.userAgent.browser.matchChrome_ = function () { return (goog.labs.userAgent.util.matchUserAgent("Chrome") || goog.labs.userAgent.util.matchUserAgent("CriOS")) && !goog.labs.userAgent.browser.matchOpera_() && !goog.labs.userAgent.browser.matchEdge_() }, goog.labs.userAgent.browser.matchAndroidBrowser_ = function () { return goog.labs.userAgent.util.matchUserAgent("Android") && !(goog.labs.userAgent.browser.isChrome() || goog.labs.userAgent.browser.isFirefox() || goog.labs.userAgent.browser.isOpera() || goog.labs.userAgent.browser.isSilk()) }, goog.labs.userAgent.browser.isOpera = goog.labs.userAgent.browser.matchOpera_, goog.labs.userAgent.browser.isIE = goog.labs.userAgent.browser.matchIE_, goog.labs.userAgent.browser.isEdge = goog.labs.userAgent.browser.matchEdge_, goog.labs.userAgent.browser.isFirefox = goog.labs.userAgent.browser.matchFirefox_, goog.labs.userAgent.browser.isSafari = goog.labs.userAgent.browser.matchSafari_, goog.labs.userAgent.browser.isCoast = goog.labs.userAgent.browser.matchCoast_, goog.labs.userAgent.browser.isIosWebview = goog.labs.userAgent.browser.matchIosWebview_, goog.labs.userAgent.browser.isChrome = goog.labs.userAgent.browser.matchChrome_, goog.labs.userAgent.browser.isAndroidBrowser = goog.labs.userAgent.browser.matchAndroidBrowser_, goog.labs.userAgent.browser.isSilk = function () { return goog.labs.userAgent.util.matchUserAgent("Silk") }, goog.labs.userAgent.browser.getVersion = function () { function e(e) { return e = goog.array.find(e, o), r[e] || "" } var t = goog.labs.userAgent.util.getUserAgent(); if (goog.labs.userAgent.browser.isIE()) return goog.labs.userAgent.browser.getIEVersion_(t); var t = goog.labs.userAgent.util.extractVersionTuples(t), r = {}; goog.array.forEach(t, function (e) { r[e[0]] = e[1] }); var o = goog.partial(goog.object.containsKey, r); return goog.labs.userAgent.browser.isOpera() ? e(["Version", "Opera", "OPR"]) : goog.labs.userAgent.browser.isEdge() ? e(["Edge"]) : goog.labs.userAgent.browser.isChrome() ? e(["Chrome", "CriOS"]) : (t = t[2]) && t[1] || "" }, goog.labs.userAgent.browser.isVersionOrHigher = function (e) { return 0 <= goog.string.compareVersions(goog.labs.userAgent.browser.getVersion(), e) }, goog.labs.userAgent.browser.getIEVersion_ = function (e) { var t = /rv: *([\d\.]*)/.exec(e); if (t && t[1]) return t[1]; var t = "", r = /MSIE +([\d\.]+)/.exec(e); if (r && r[1]) if (e = /Trident\/(\d.\d)/.exec(e), "7.0" == r[1]) if (e && e[1]) switch (e[1]) { case "4.0": t = "8.0"; break; case "5.0": t = "9.0"; break; case "6.0": t = "10.0"; break; case "7.0": t = "11.0" } else t = "7.0"; else t = r[1]; return t }, goog.labs.userAgent.engine = {}, goog.labs.userAgent.engine.isPresto = function () { return goog.labs.userAgent.util.matchUserAgent("Presto") }, goog.labs.userAgent.engine.isTrident = function () { return goog.labs.userAgent.util.matchUserAgent("Trident") || goog.labs.userAgent.util.matchUserAgent("MSIE") }, goog.labs.userAgent.engine.isEdge = function () { return goog.labs.userAgent.util.matchUserAgent("Edge") }, goog.labs.userAgent.engine.isWebKit = function () { return goog.labs.userAgent.util.matchUserAgentIgnoreCase("WebKit") && !goog.labs.userAgent.engine.isEdge() }, goog.labs.userAgent.engine.isGecko = function () { return goog.labs.userAgent.util.matchUserAgent("Gecko") && !goog.labs.userAgent.engine.isWebKit() && !goog.labs.userAgent.engine.isTrident() && !goog.labs.userAgent.engine.isEdge() }, goog.labs.userAgent.engine.getVersion = function () { var e = goog.labs.userAgent.util.getUserAgent(); if (e) { var e = goog.labs.userAgent.util.extractVersionTuples(e), t = goog.labs.userAgent.engine.getEngineTuple_(e); if (t) return "Gecko" == t[0] ? goog.labs.userAgent.engine.getVersionForKey_(e, "Firefox") : t[1]; var r, e = e[0]; if (e && (r = e[2]) && (r = /Trident\/([^\s;]+)/.exec(r))) return r[1] } return "" }, goog.labs.userAgent.engine.getEngineTuple_ = function (e) { if (!goog.labs.userAgent.engine.isEdge()) return e[1]; for (var t = 0; t < e.length; t++) { var r = e[t]; if ("Edge" == r[0]) return r } }, goog.labs.userAgent.engine.isVersionOrHigher = function (e) { return 0 <= goog.string.compareVersions(goog.labs.userAgent.engine.getVersion(), e) }, goog.labs.userAgent.engine.getVersionForKey_ = function (e, t) { var r = goog.array.find(e, function (e) { return t == e[0] }); return r && r[1] || "" }, goog.userAgent = {}, goog.userAgent.ASSUME_IE = !1, goog.userAgent.ASSUME_EDGE = !1, goog.userAgent.ASSUME_GECKO = !1, goog.userAgent.ASSUME_WEBKIT = !1, goog.userAgent.ASSUME_MOBILE_WEBKIT = !1, goog.userAgent.ASSUME_OPERA = !1, goog.userAgent.ASSUME_ANY_VERSION = !1, goog.userAgent.BROWSER_KNOWN_ = goog.userAgent.ASSUME_IE || goog.userAgent.ASSUME_EDGE || goog.userAgent.ASSUME_GECKO || goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_OPERA, goog.userAgent.getUserAgentString = function () { return goog.labs.userAgent.util.getUserAgent() }, goog.userAgent.getNavigator = function () { return goog.global.navigator || null }, goog.userAgent.OPERA = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_OPERA : goog.labs.userAgent.browser.isOpera(), goog.userAgent.IE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_IE : goog.labs.userAgent.browser.isIE(); goog.userAgent.EDGE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_EDGE : goog.labs.userAgent.engine.isEdge(), goog.userAgent.EDGE_OR_IE = goog.userAgent.EDGE || goog.userAgent.IE, goog.userAgent.GECKO = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_GECKO : goog.labs.userAgent.engine.isGecko(), goog.userAgent.WEBKIT = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_MOBILE_WEBKIT : goog.labs.userAgent.engine.isWebKit(), goog.userAgent.isMobile_ = function () { return goog.userAgent.WEBKIT && goog.labs.userAgent.util.matchUserAgent("Mobile") }, goog.userAgent.MOBILE = goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.isMobile_(), goog.userAgent.SAFARI = goog.userAgent.WEBKIT, goog.userAgent.determinePlatform_ = function () { var e = goog.userAgent.getNavigator(); return e && e.platform || "" }, goog.userAgent.PLATFORM = goog.userAgent.determinePlatform_(), goog.userAgent.ASSUME_MAC = !1, goog.userAgent.ASSUME_WINDOWS = !1, goog.userAgent.ASSUME_LINUX = !1, goog.userAgent.ASSUME_X11 = !1, goog.userAgent.ASSUME_ANDROID = !1, goog.userAgent.ASSUME_IPHONE = !1, goog.userAgent.ASSUME_IPAD = !1, goog.userAgent.PLATFORM_KNOWN_ = goog.userAgent.ASSUME_MAC || goog.userAgent.ASSUME_WINDOWS || goog.userAgent.ASSUME_LINUX || goog.userAgent.ASSUME_X11 || goog.userAgent.ASSUME_ANDROID || goog.userAgent.ASSUME_IPHONE || goog.userAgent.ASSUME_IPAD, goog.userAgent.MAC = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_MAC : goog.labs.userAgent.platform.isMacintosh(), goog.userAgent.WINDOWS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_WINDOWS : goog.labs.userAgent.platform.isWindows(), goog.userAgent.isLegacyLinux_ = function () { return goog.labs.userAgent.platform.isLinux() || goog.labs.userAgent.platform.isChromeOS() }, goog.userAgent.LINUX = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_LINUX : goog.userAgent.isLegacyLinux_(), goog.userAgent.isX11_ = function () { var e = goog.userAgent.getNavigator(); return !!e && goog.string.contains(e.appVersion || "", "X11") }, goog.userAgent.X11 = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_X11 : goog.userAgent.isX11_(), goog.userAgent.ANDROID = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_ANDROID : goog.labs.userAgent.platform.isAndroid(), goog.userAgent.IPHONE = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPHONE : goog.labs.userAgent.platform.isIphone(), goog.userAgent.IPAD = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPAD : goog.labs.userAgent.platform.isIpad(), goog.userAgent.operaVersion_ = function () { var e = goog.global.opera.version; try { return e() } catch (t) { return e } }, goog.userAgent.determineVersion_ = function () { if (goog.userAgent.OPERA && goog.global.opera) return goog.userAgent.operaVersion_(); var e = "", t = goog.userAgent.getVersionRegexResult_(); return t && (e = t ? t[1] : ""), goog.userAgent.IE && (t = goog.userAgent.getDocumentMode_()) > parseFloat(e) ? String(t) : e }, goog.userAgent.getVersionRegexResult_ = function () { var e = goog.userAgent.getUserAgentString(); return goog.userAgent.GECKO ? /rv\:([^\);]+)(\)|;)/.exec(e) : goog.userAgent.EDGE ? /Edge\/([\d\.]+)/.exec(e) : goog.userAgent.IE ? /\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(e) : goog.userAgent.WEBKIT ? /WebKit\/(\S+)/.exec(e) : void 0 }, goog.userAgent.getDocumentMode_ = function () { var e = goog.global.document; return e ? e.documentMode : void 0 }, goog.userAgent.VERSION = goog.userAgent.determineVersion_(), goog.userAgent.compare = function (e, t) { return goog.string.compareVersions(e, t) }, goog.userAgent.isVersionOrHigherCache_ = {}, goog.userAgent.isVersionOrHigher = function (e) { return goog.userAgent.ASSUME_ANY_VERSION || goog.userAgent.isVersionOrHigherCache_[e] || (goog.userAgent.isVersionOrHigherCache_[e] = 0 <= goog.string.compareVersions(goog.userAgent.VERSION, e)) }, goog.userAgent.isVersion = goog.userAgent.isVersionOrHigher, goog.userAgent.isDocumentModeOrHigher = function (e) { return Number(goog.userAgent.DOCUMENT_MODE) >= e }, goog.userAgent.isDocumentMode = goog.userAgent.isDocumentModeOrHigher, goog.userAgent.DOCUMENT_MODE = function () { var e = goog.global.document, t = goog.userAgent.getDocumentMode_(); return e && goog.userAgent.IE ? t || ("CSS1Compat" == e.compatMode ? parseInt(goog.userAgent.VERSION, 10) : 5) : void 0 }(), goog.userAgent.product = {}, goog.userAgent.product.ASSUME_FIREFOX = !1, goog.userAgent.product.ASSUME_IPHONE = !1, goog.userAgent.product.ASSUME_IPAD = !1, goog.userAgent.product.ASSUME_ANDROID = !1, goog.userAgent.product.ASSUME_CHROME = !1, goog.userAgent.product.ASSUME_SAFARI = !1, goog.userAgent.product.PRODUCT_KNOWN_ = goog.userAgent.ASSUME_IE || goog.userAgent.ASSUME_EDGE || goog.userAgent.ASSUME_OPERA || goog.userAgent.product.ASSUME_FIREFOX || goog.userAgent.product.ASSUME_IPHONE || goog.userAgent.product.ASSUME_IPAD || goog.userAgent.product.ASSUME_ANDROID || goog.userAgent.product.ASSUME_CHROME || goog.userAgent.product.ASSUME_SAFARI, goog.userAgent.product.OPERA = goog.userAgent.OPERA, goog.userAgent.product.IE = goog.userAgent.IE, goog.userAgent.product.EDGE = goog.userAgent.EDGE, goog.userAgent.product.FIREFOX = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_FIREFOX : goog.labs.userAgent.browser.isFirefox(), goog.userAgent.product.isIphoneOrIpod_ = function () { return goog.labs.userAgent.platform.isIphone() || goog.labs.userAgent.platform.isIpod() }, goog.userAgent.product.IPHONE = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_IPHONE : goog.userAgent.product.isIphoneOrIpod_(), goog.userAgent.product.IPAD = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_IPAD : goog.labs.userAgent.platform.isIpad(), goog.userAgent.product.ANDROID = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_ANDROID : goog.labs.userAgent.browser.isAndroidBrowser(), goog.userAgent.product.CHROME = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_CHROME : goog.labs.userAgent.browser.isChrome(), goog.userAgent.product.isSafariDesktop_ = function () { return goog.labs.userAgent.browser.isSafari() && !goog.labs.userAgent.platform.isIos() }, goog.userAgent.product.SAFARI = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_SAFARI : goog.userAgent.product.isSafariDesktop_(), goog.crypt.base64 = {}, goog.crypt.base64.byteToCharMap_ = null, goog.crypt.base64.charToByteMap_ = null, goog.crypt.base64.byteToCharMapWebSafe_ = null, goog.crypt.base64.ENCODED_VALS_BASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", goog.crypt.base64.ENCODED_VALS = goog.crypt.base64.ENCODED_VALS_BASE + "+/=", goog.crypt.base64.ENCODED_VALS_WEBSAFE = goog.crypt.base64.ENCODED_VALS_BASE + "-_.", goog.crypt.base64.ASSUME_NATIVE_SUPPORT_ = goog.userAgent.GECKO || goog.userAgent.WEBKIT && !goog.userAgent.product.SAFARI || goog.userAgent.OPERA, goog.crypt.base64.HAS_NATIVE_ENCODE_ = goog.crypt.base64.ASSUME_NATIVE_SUPPORT_ || "function" == typeof goog.global.btoa, goog.crypt.base64.HAS_NATIVE_DECODE_ = goog.crypt.base64.ASSUME_NATIVE_SUPPORT_ || !goog.userAgent.product.SAFARI && !goog.userAgent.IE && "function" == typeof goog.global.atob, goog.crypt.base64.encodeByteArray = function (e, t) { goog.asserts.assert(goog.isArrayLike(e), "encodeByteArray takes an array as a parameter"), goog.crypt.base64.init_(); for (var r = t ? goog.crypt.base64.byteToCharMapWebSafe_ : goog.crypt.base64.byteToCharMap_, o = [], n = 0; n < e.length; n += 3) { var s = e[n], i = n + 1 < e.length, a = i ? e[n + 1] : 0, g = n + 2 < e.length, p = g ? e[n + 2] : 0, u = s >> 2, s = (3 & s) << 4 | a >> 4, a = (15 & a) << 2 | p >> 6, p = 63 & p; g || (p = 64, i || (a = 64)), o.push(r[u], r[s], r[a], r[p]) } return o.join("") }, goog.crypt.base64.encodeString = function (e, t) { return goog.crypt.base64.HAS_NATIVE_ENCODE_ && !t ? goog.global.btoa(e) : goog.crypt.base64.encodeByteArray(goog.crypt.stringToByteArray(e), t) }, goog.crypt.base64.decodeString = function (e, t) { if (goog.crypt.base64.HAS_NATIVE_DECODE_ && !t) return goog.global.atob(e); var r = ""; return goog.crypt.base64.decodeStringInternal_(e, function (e) { r += String.fromCharCode(e) }), r }, goog.crypt.base64.decodeStringToByteArray = function (e, t) { var r = []; return goog.crypt.base64.decodeStringInternal_(e, function (e) { r.push(e) }), r }, goog.crypt.base64.decodeStringToUint8Array = function (e) { goog.asserts.assert(!goog.userAgent.IE || goog.userAgent.isVersionOrHigher("10"), "Browser does not support typed arrays"); var t = new Uint8Array(Math.ceil(3 * e.length / 4)), r = 0; return goog.crypt.base64.decodeStringInternal_(e, function (e) { t[r++] = e }), t.subarray(0, r) }, goog.crypt.base64.decodeStringInternal_ = function (e, t) { function r(t) { for (; o < e.length;) { var r = e.charAt(o++), n = goog.crypt.base64.charToByteMap_[r]; if (null != n) return n; if (!goog.string.isEmptyOrWhitespace(r)) throw Error("Unknown base64 encoding at char: " + r) } return t } goog.crypt.base64.init_(); for (var o = 0; ;) { var n = r(-1), s = r(0), i = r(64), a = r(64); if (64 === a && -1 === n) break; t(n << 2 | s >> 4), 64 != i && (t(s << 4 & 240 | i >> 2), 64 != a && t(i << 6 & 192 | a)) } }, goog.crypt.base64.init_ = function () { if (!goog.crypt.base64.byteToCharMap_) { goog.crypt.base64.byteToCharMap_ = {}, goog.crypt.base64.charToByteMap_ = {}, goog.crypt.base64.byteToCharMapWebSafe_ = {}; for (var e = 0; e < goog.crypt.base64.ENCODED_VALS.length; e++)goog.crypt.base64.byteToCharMap_[e] = goog.crypt.base64.ENCODED_VALS.charAt(e), goog.crypt.base64.charToByteMap_[goog.crypt.base64.byteToCharMap_[e]] = e, goog.crypt.base64.byteToCharMapWebSafe_[e] = goog.crypt.base64.ENCODED_VALS_WEBSAFE.charAt(e), e >= goog.crypt.base64.ENCODED_VALS_BASE.length && (goog.crypt.base64.charToByteMap_[goog.crypt.base64.ENCODED_VALS_WEBSAFE.charAt(e)] = e) } }, jspb.ExtensionFieldInfo = function (e, t, r, o, n) { this.fieldIndex = e, this.fieldName = t, this.ctor = r, this.toObjectFn = o, this.isRepeated = n }, jspb.ExtensionFieldBinaryInfo = function (e, t, r, o, n, s) { this.fieldInfo = e, this.binaryReaderFn = t, this.binaryWriterFn = r, this.binaryMessageSerializeFn = o, this.binaryMessageDeserializeFn = n, this.isPacked = s }, jspb.ExtensionFieldInfo.prototype.isMessageType = function () { return !!this.ctor }, jspb.Message = function () { }, jspb.Message.GENERATE_TO_OBJECT = !0, jspb.Message.GENERATE_FROM_OBJECT = !goog.DISALLOW_TEST_ONLY_CODE, jspb.Message.GENERATE_TO_STRING = !0, jspb.Message.ASSUME_LOCAL_ARRAYS = !1, jspb.Message.SERIALIZE_EMPTY_TRAILING_FIELDS = !0, jspb.Message.SUPPORTS_UINT8ARRAY_ = "function" == typeof Uint8Array, jspb.Message.prototype.getJsPbMessageId = function () { return this.messageId_ }, jspb.Message.getIndex_ = function (e, t) { return t + e.arrayIndexOffset_ }, jspb.Message.getFieldNumber_ = function (e, t) { return t - e.arrayIndexOffset_ }, jspb.Message.initialize = function (e, t, r, o, n, s) { if (e.wrappers_ = null, t || (t = r ? [r] : []), e.messageId_ = r ? String(r) : void 0, e.arrayIndexOffset_ = 0 === r ? -1 : 0, e.array = t, jspb.Message.initPivotAndExtensionObject_(e, o), e.convertedFloatingPointFields_ = {}, jspb.Message.SERIALIZE_EMPTY_TRAILING_FIELDS || (e.repeatedFields = n), n) for (t = 0; t < n.length; t++)r = n[t], r < e.pivot_ ? (r = jspb.Message.getIndex_(e, r), e.array[r] = e.array[r] || jspb.Message.EMPTY_LIST_SENTINEL_) : (jspb.Message.maybeInitEmptyExtensionObject_(e), e.extensionObject_[r] = e.extensionObject_[r] || jspb.Message.EMPTY_LIST_SENTINEL_); if (s && s.length) for (t = 0; t < s.length; t++)jspb.Message.computeOneofCase(e, s[t]) }, jspb.Message.EMPTY_LIST_SENTINEL_ = goog.DEBUG && Object.freeze ? Object.freeze([]) : [], jspb.Message.isArray_ = function (e) { return jspb.Message.ASSUME_LOCAL_ARRAYS ? e instanceof Array : goog.isArray(e) }, jspb.Message.initPivotAndExtensionObject_ = function (e, t) { if (e.array.length) { var r = e.array.length - 1, o = e.array[r]; if (o && "object" == typeof o && !jspb.Message.isArray_(o) && !(jspb.Message.SUPPORTS_UINT8ARRAY_ && o instanceof Uint8Array)) return e.pivot_ = jspb.Message.getFieldNumber_(e, r), void (e.extensionObject_ = o) } -1 < t ? (e.pivot_ = t, e.extensionObject_ = null) : e.pivot_ = Number.MAX_VALUE }, jspb.Message.maybeInitEmptyExtensionObject_ = function (e) { var t = jspb.Message.getIndex_(e, e.pivot_); e.array[t] || (e.extensionObject_ = e.array[t] = {}) }, jspb.Message.toObjectList = function (e, t, r) { for (var o = [], n = 0; n < e.length; n++)o[n] = t.call(e[n], r, e[n]); return o }, jspb.Message.toObjectExtension = function (e, t, r, o, n) { for (var s in r) { var i = r[s], a = o.call(e, i); if (null != a) { for (var g in i.fieldName) if (i.fieldName.hasOwnProperty(g)) break; t[g] = i.toObjectFn ? i.isRepeated ? jspb.Message.toObjectList(a, i.toObjectFn, n) : i.toObjectFn(n, a) : a } } }, jspb.Message.serializeBinaryExtensions = function (e, t, r, o) { for (var n in r) { var s = r[n], i = s.fieldInfo; if (!s.binaryWriterFn) throw Error("Message extension present that was generated without binary serialization support"); var a = o.call(e, i); if (null != a) if (i.isMessageType()) { if (!s.binaryMessageSerializeFn) throw Error("Message extension present holding submessage without binary support enabled, and message is being serialized to binary format"); s.binaryWriterFn.call(t, i.fieldIndex, a, s.binaryMessageSerializeFn) } else s.binaryWriterFn.call(t, i.fieldIndex, a) } }, jspb.Message.readBinaryExtension = function (e, t, r, o, n) { var s = r[t.getFieldNumber()]; if (s) { if (r = s.fieldInfo, !s.binaryReaderFn) throw Error("Deserializing extension whose generated code does not support binary format"); var i; r.isMessageType() ? (i = new r.ctor, s.binaryReaderFn.call(t, i, s.binaryMessageDeserializeFn)) : i = s.binaryReaderFn.call(t), r.isRepeated && !s.isPacked ? (t = o.call(e, r)) ? t.push(i) : n.call(e, r, [i]) : n.call(e, r, i) } else t.skipField() }, jspb.Message.getField = function (e, t) { if (t < e.pivot_) { var r = jspb.Message.getIndex_(e, t), o = e.array[r]; return o === jspb.Message.EMPTY_LIST_SENTINEL_ ? e.array[r] = [] : o } if (e.extensionObject_) return o = e.extensionObject_[t], o === jspb.Message.EMPTY_LIST_SENTINEL_ ? e.extensionObject_[t] = [] : o }, jspb.Message.getRepeatedField = function (e, t) { if (t < e.pivot_) { var r = jspb.Message.getIndex_(e, t), o = e.array[r]; return o === jspb.Message.EMPTY_LIST_SENTINEL_ ? e.array[r] = [] : o } return o = e.extensionObject_[t], o === jspb.Message.EMPTY_LIST_SENTINEL_ ? e.extensionObject_[t] = [] : o }, jspb.Message.getOptionalFloatingPointField = function (e, t) { var r = jspb.Message.getField(e, t); return null == r ? r : +r }, jspb.Message.getRepeatedFloatingPointField = function (e, t) { var r = jspb.Message.getRepeatedField(e, t); if (e.convertedFloatingPointFields_ || (e.convertedFloatingPointFields_ = {}), !e.convertedFloatingPointFields_[t]) { for (var o = 0; o < r.length; o++)r[o] = +r[o]; e.convertedFloatingPointFields_[t] = !0 } return r }, jspb.Message.bytesAsB64 = function (e) { return null == e || goog.isString(e) ? e : jspb.Message.SUPPORTS_UINT8ARRAY_ && e instanceof Uint8Array ? goog.crypt.base64.encodeByteArray(e) : (goog.asserts.fail("Cannot coerce to b64 string: " + goog.typeOf(e)), null) }, jspb.Message.bytesAsU8 = function (e) { return null == e || e instanceof Uint8Array ? e : goog.isString(e) ? goog.crypt.base64.decodeStringToUint8Array(e) : (goog.asserts.fail("Cannot coerce to Uint8Array: " + goog.typeOf(e)), null) }, jspb.Message.bytesListAsB64 = function (e) { return jspb.Message.assertConsistentTypes_(e), !e.length || goog.isString(e[0]) ? e : goog.array.map(e, jspb.Message.bytesAsB64) }, jspb.Message.bytesListAsU8 = function (e) { return jspb.Message.assertConsistentTypes_(e), !e.length || e[0] instanceof Uint8Array ? e : goog.array.map(e, jspb.Message.bytesAsU8) }, jspb.Message.assertConsistentTypes_ = function (e) { if (goog.DEBUG && e && 1 < e.length) { var t = goog.typeOf(e[0]); goog.array.forEach(e, function (e) { goog.typeOf(e) != t && goog.asserts.fail("Inconsistent type in JSPB repeated field array. Got " + goog.typeOf(e) + " expected " + t) }) } }, jspb.Message.getFieldWithDefault = function (e, t, r) { return e = jspb.Message.getField(e, t), null == e ? r : e }, jspb.Message.getFieldProto3 = jspb.Message.getFieldWithDefault, jspb.Message.getMapField = function (e, t, r, o) { return e.wrappers_ || (e.wrappers_ = {}), t in e.wrappers_ ? e.wrappers_[t] : r ? void 0 : (r = jspb.Message.getField(e, t), r || (r = [], jspb.Message.setField(e, t, r)), e.wrappers_[t] = new jspb.Map(r, o)) }, jspb.Message.setField = function (e, t, r) { t < e.pivot_ ? e.array[jspb.Message.getIndex_(e, t)] = r : (jspb.Message.maybeInitEmptyExtensionObject_(e), e.extensionObject_[t] = r) }, jspb.Message.setProto3IntField = function (e, t, r) { jspb.Message.setFieldIgnoringDefault_(e, t, r, 0) }, jspb.Message.setProto3StringIntField = function (e, t, r) { jspb.Message.setFieldIgnoringDefault_(e, t, r, "0") }, jspb.Message.setProto3FloatField = function (e, t, r) { jspb.Message.setFieldIgnoringDefault_(e, t, r, 0) }, jspb.Message.setProto3BooleanField = function (e, t, r) { jspb.Message.setFieldIgnoringDefault_(e, t, r, !1) }, jspb.Message.setProto3StringField = function (e, t, r) { jspb.Message.setFieldIgnoringDefault_(e, t, r, "") }, jspb.Message.setProto3BytesField = function (e, t, r) { jspb.Message.setFieldIgnoringDefault_(e, t, r, "") }, jspb.Message.setProto3EnumField = function (e, t, r) { jspb.Message.setFieldIgnoringDefault_(e, t, r, 0) }, jspb.Message.setFieldIgnoringDefault_ = function (e, t, r, o) { r != o ? jspb.Message.setField(e, t, r) : e.array[jspb.Message.getIndex_(e, t)] = null }, jspb.Message.addToRepeatedField = function (e, t, r, o) { e = jspb.Message.getRepeatedField(e, t), void 0 != o ? e.splice(o, 0, r) : e.push(r) }, jspb.Message.setOneofField = function (e, t, r, o) { (r = jspb.Message.computeOneofCase(e, r)) && r !== t && void 0 !== o && (e.wrappers_ && r in e.wrappers_ && (e.wrappers_[r] = void 0), jspb.Message.setField(e, r, void 0)), jspb.Message.setField(e, t, o) }, jspb.Message.computeOneofCase = function (e, t) { for (var r, o, n = 0; n < t.length; n++) { var s = t[n], i = jspb.Message.getField(e, s); null != i && (r = s, o = i, jspb.Message.setField(e, s, void 0)) } return r ? (jspb.Message.setField(e, r, o), r) : 0 }, jspb.Message.getWrapperField = function (e, t, r, o) { if (e.wrappers_ || (e.wrappers_ = {}), !e.wrappers_[r]) { var n = jspb.Message.getField(e, r); (o || n) && (e.wrappers_[r] = new t(n)) } return e.wrappers_[r] }, jspb.Message.getRepeatedWrapperField = function (e, t, r) { return jspb.Message.wrapRepeatedField_(e, t, r), t = e.wrappers_[r], t == jspb.Message.EMPTY_LIST_SENTINEL_ && (t = e.wrappers_[r] = []), t }, jspb.Message.wrapRepeatedField_ = function (e, t, r) { if (e.wrappers_ || (e.wrappers_ = {}), !e.wrappers_[r]) { for (var o = jspb.Message.getRepeatedField(e, r), n = [], s = 0; s < o.length; s++)n[s] = new t(o[s]); e.wrappers_[r] = n } }, jspb.Message.setWrapperField = function (e, t, r) { e.wrappers_ || (e.wrappers_ = {}); var o = r ? r.toArray() : r; e.wrappers_[t] = r, jspb.Message.setField(e, t, o) }, jspb.Message.setOneofWrapperField = function (e, t, r, o) { e.wrappers_ || (e.wrappers_ = {}); var n = o ? o.toArray() : o; e.wrappers_[t] = o, jspb.Message.setOneofField(e, t, r, n) }, jspb.Message.setRepeatedWrapperField = function (e, t, r) { e.wrappers_ || (e.wrappers_ = {}), r = r || []; for (var o = [], n = 0; n < r.length; n++)o[n] = r[n].toArray(); e.wrappers_[t] = r, jspb.Message.setField(e, t, o) }, jspb.Message.addToRepeatedWrapperField = function (e, t, r, o, n) { jspb.Message.wrapRepeatedField_(e, o, t); var s = e.wrappers_[t]; return s || (s = e.wrappers_[t] = []), r = r || new o, e = jspb.Message.getRepeatedField(e, t), void 0 != n ? (s.splice(n, 0, r), e.splice(n, 0, r.toArray())) : (s.push(r), e.push(r.toArray())), r }, jspb.Message.toMap = function (e, t, r, o) { for (var n = {}, s = 0; s < e.length; s++)n[t.call(e[s])] = r ? r.call(e[s], o, e[s]) : e[s]; return n }, jspb.Message.prototype.syncMapFields_ = function () { if (this.wrappers_) for (var e in this.wrappers_) { var t = this.wrappers_[e]; if (goog.isArray(t)) for (var r = 0; r < t.length; r++)t[r] && t[r].toArray(); else t && t.toArray() } }, jspb.Message.prototype.toArray = function () { return this.syncMapFields_(), this.array }, jspb.Message.GENERATE_TO_STRING && (jspb.Message.prototype.toString = function () { return this.syncMapFields_(), this.array.toString() }), jspb.Message.prototype.getExtension = function (e) { if (this.extensionObject_) { this.wrappers_ || (this.wrappers_ = {}); var t = e.fieldIndex; if (e.isRepeated) { if (e.isMessageType()) return this.wrappers_[t] || (this.wrappers_[t] = goog.array.map(this.extensionObject_[t] || [], function (t) { return new e.ctor(t) })), this.wrappers_[t] } else if (e.isMessageType()) return !this.wrappers_[t] && this.extensionObject_[t] && (this.wrappers_[t] = new e.ctor(this.extensionObject_[t])), this.wrappers_[t]; return this.extensionObject_[t] } }, jspb.Message.prototype.setExtension = function (e, t) { this.wrappers_ || (this.wrappers_ = {}), jspb.Message.maybeInitEmptyExtensionObject_(this); var r = e.fieldIndex; return e.isRepeated ? (t = t || [], e.isMessageType() ? (this.wrappers_[r] = t, this.extensionObject_[r] = goog.array.map(t, function (e) { return e.toArray() })) : this.extensionObject_[r] = t) : e.isMessageType() ? (this.wrappers_[r] = t, this.extensionObject_[r] = t ? t.toArray() : t) : this.extensionObject_[r] = t, this }, jspb.Message.difference = function (e, t) { if (!(e instanceof t.constructor)) throw Error("Messages have different types."); var r = e.toArray(), o = t.toArray(), n = [], s = 0, i = r.length > o.length ? r.length : o.length; for (e.getJsPbMessageId() && (n[0] = e.getJsPbMessageId(), s = 1); s < i; s++)jspb.Message.compareFields(r[s], o[s]) || (n[s] = o[s]); return new e.constructor(n) }, jspb.Message.equals = function (e, t) { return e == t || !(!e || !t) && e instanceof t.constructor && jspb.Message.compareFields(e.toArray(), t.toArray()) }, jspb.Message.compareExtensions = function (e, t) { e = e || {}, t = t || {}; var r, o = {}; for (r in e) o[r] = 0; for (r in t) o[r] = 0; for (r in o) if (!jspb.Message.compareFields(e[r], t[r])) return !1; return !0 }, jspb.Message.compareFields = function (e, t) { if (e == t) return !0; if (!goog.isObject(e) || !goog.isObject(t)) return !!(goog.isNumber(e) && isNaN(e) || goog.isNumber(t) && isNaN(t)) && String(e) == String(t); if (e.constructor != t.constructor) return !1; if (jspb.Message.SUPPORTS_UINT8ARRAY_ && e.constructor === Uint8Array) { if (e.length != t.length) return !1; for (var r = 0; r < e.length; r++)if (e[r] != t[r]) return !1; return !0 } if (e.constructor === Array) { for (var o = void 0, n = void 0, s = Math.max(e.length, t.length), r = 0; r < s; r++) { var i = e[r], a = t[r]; if (i && i.constructor == Object && (goog.asserts.assert(void 0 === o), goog.asserts.assert(r === e.length - 1), o = i, i = void 0), a && a.constructor == Object && (goog.asserts.assert(void 0 === n), goog.asserts.assert(r === t.length - 1), n = a, a = void 0), !jspb.Message.compareFields(i, a)) return !1 } return !o && !n || (o = o || {}, n = n || {}, jspb.Message.compareExtensions(o, n)) } if (e.constructor === Object) return jspb.Message.compareExtensions(e, t); throw Error("Invalid type in JSPB array") }, jspb.Message.prototype.cloneMessage = function () { return jspb.Message.cloneMessage(this) }, jspb.Message.prototype.clone = function () { return jspb.Message.cloneMessage(this) }, jspb.Message.clone = function (e) { return jspb.Message.cloneMessage(e) }, jspb.Message.cloneMessage = function (e) { return new e.constructor(jspb.Message.clone_(e.toArray())) }, jspb.Message.copyInto = function (e, t) { goog.asserts.assertInstanceof(e, jspb.Message), goog.asserts.assertInstanceof(t, jspb.Message), goog.asserts.assert(e.constructor == t.constructor, "Copy source and target message should have the same type."); for (var r = jspb.Message.clone(e), o = t.toArray(), n = r.toArray(), s = o.length = 0; s < n.length; s++)o[s] = n[s]; t.wrappers_ = r.wrappers_, t.extensionObject_ = r.extensionObject_ }, jspb.Message.clone_ = function (e) { var t; if (goog.isArray(e)) { for (var r = Array(e.length), o = 0; o < e.length; o++)null != (t = e[o]) && (r[o] = "object" == typeof t ? jspb.Message.clone_(goog.asserts.assert(t)) : t); return r } if (jspb.Message.SUPPORTS_UINT8ARRAY_ && e instanceof Uint8Array) return new Uint8Array(e); r = {}; for (o in e) null != (t = e[o]) && (r[o] = "object" == typeof t ? jspb.Message.clone_(goog.asserts.assert(t)) : t); return r }, jspb.Message.registerMessageType = function (e, t) { jspb.Message.registry_[e] = t, t.messageId = e }, jspb.Message.registry_ = {}, jspb.Message.messageSetExtensions = {}, jspb.Message.messageSetExtensionsBinary = {}, jspb.arith = {}, jspb.arith.UInt64 = function (e, t) { this.lo = e, this.hi = t }, jspb.arith.UInt64.prototype.cmp = function (e) { return this.hi < e.hi || this.hi == e.hi && this.lo < e.lo ? -1 : this.hi == e.hi && this.lo == e.lo ? 0 : 1 }, jspb.arith.UInt64.prototype.rightShift = function () { return new jspb.arith.UInt64((this.lo >>> 1 | (1 & this.hi) << 31) >>> 0, this.hi >>> 1 >>> 0) }, jspb.arith.UInt64.prototype.leftShift = function () { return new jspb.arith.UInt64(this.lo << 1 >>> 0, (this.hi << 1 | this.lo >>> 31) >>> 0) }, jspb.arith.UInt64.prototype.msb = function () { return !!(2147483648 & this.hi) }, jspb.arith.UInt64.prototype.lsb = function () { return !!(1 & this.lo) }, jspb.arith.UInt64.prototype.zero = function () { return 0 == this.lo && 0 == this.hi }, jspb.arith.UInt64.prototype.add = function (e) { return new jspb.arith.UInt64((this.lo + e.lo & 4294967295) >>> 0 >>> 0, ((this.hi + e.hi & 4294967295) >>> 0) + (4294967296 <= this.lo + e.lo ? 1 : 0) >>> 0) }, jspb.arith.UInt64.prototype.sub = function (e) { return new jspb.arith.UInt64((this.lo - e.lo & 4294967295) >>> 0 >>> 0, ((this.hi - e.hi & 4294967295) >>> 0) - (0 > this.lo - e.lo ? 1 : 0) >>> 0) }, jspb.arith.UInt64.mul32x32 = function (e, t) { for (var r = 65535 & e, o = e >>> 16, n = 65535 & t, s = t >>> 16, i = r * n + 65536 * (r * s & 65535) + 65536 * (o * n & 65535), r = o * s + (r * s >>> 16) + (o * n >>> 16); 4294967296 <= i;)i -= 4294967296, r += 1; return new jspb.arith.UInt64(i >>> 0, r >>> 0) }, jspb.arith.UInt64.prototype.mul = function (e) { var t = jspb.arith.UInt64.mul32x32(this.lo, e); return e = jspb.arith.UInt64.mul32x32(this.hi, e), e.hi = e.lo, e.lo = 0, t.add(e) }, jspb.arith.UInt64.prototype.div = function (e) { if (0 == e) return []; var t = new jspb.arith.UInt64(0, 0), r = new jspb.arith.UInt64(this.lo, this.hi); e = new jspb.arith.UInt64(e, 0); for (var o = new jspb.arith.UInt64(1, 0); !e.msb();)e = e.leftShift(), o = o.leftShift(); for (; !o.zero();)0 >= e.cmp(r) && (t = t.add(o), r = r.sub(e)), e = e.rightShift(), o = o.rightShift(); return [t, r] }, jspb.arith.UInt64.prototype.toString = function () { for (var e = "", t = this; !t.zero();)var t = t.div(10), r = t[0], e = t[1].lo + e, t = r; return "" == e && (e = "0"), e }, jspb.arith.UInt64.fromString = function (e) { for (var t = new jspb.arith.UInt64(0, 0), r = new jspb.arith.UInt64(0, 0), o = 0; o < e.length; o++) { if ("0" > e[o] || "9" < e[o]) return null; var n = parseInt(e[o], 10); r.lo = n, t = t.mul(10).add(r) } return t }, jspb.arith.UInt64.prototype.clone = function () { return new jspb.arith.UInt64(this.lo, this.hi) }, jspb.arith.Int64 = function (e, t) { this.lo = e, this.hi = t }, jspb.arith.Int64.prototype.add = function (e) { return new jspb.arith.Int64((this.lo + e.lo & 4294967295) >>> 0 >>> 0, ((this.hi + e.hi & 4294967295) >>> 0) + (4294967296 <= this.lo + e.lo ? 1 : 0) >>> 0) }, jspb.arith.Int64.prototype.sub = function (e) { return new jspb.arith.Int64((this.lo - e.lo & 4294967295) >>> 0 >>> 0, ((this.hi - e.hi & 4294967295) >>> 0) - (0 > this.lo - e.lo ? 1 : 0) >>> 0) }, jspb.arith.Int64.prototype.clone = function () { return new jspb.arith.Int64(this.lo, this.hi) }, jspb.arith.Int64.prototype.toString = function () { var e = 0 != (2147483648 & this.hi), t = new jspb.arith.UInt64(this.lo, this.hi); return e && (t = new jspb.arith.UInt64(0, 0).sub(t)), (e ? "-" : "") + t.toString() }, jspb.arith.Int64.fromString = function (e) { var t = 0 < e.length && "-" == e[0]; return t && (e = e.substring(1)), null === (e = jspb.arith.UInt64.fromString(e)) ? null : (t && (e = new jspb.arith.UInt64(0, 0).sub(e)), new jspb.arith.Int64(e.lo, e.hi)) }, jspb.BinaryConstants = {}, jspb.ConstBinaryMessage = function () { }, jspb.BinaryMessage = function () { }, jspb.BinaryConstants.FieldType = { INVALID: -1, DOUBLE: 1, FLOAT: 2, INT64: 3, UINT64: 4, INT32: 5, FIXED64: 6, FIXED32: 7, BOOL: 8, STRING: 9, GROUP: 10, MESSAGE: 11, BYTES: 12, UINT32: 13, ENUM: 14, SFIXED32: 15, SFIXED64: 16, SINT32: 17, SINT64: 18, FHASH64: 30, VHASH64: 31 }, jspb.BinaryConstants.WireType = { INVALID: -1, VARINT: 0, FIXED64: 1, DELIMITED: 2, START_GROUP: 3, END_GROUP: 4, FIXED32: 5 }, jspb.BinaryConstants.FieldTypeToWireType = function (e) { var t = jspb.BinaryConstants.FieldType, r = jspb.BinaryConstants.WireType; switch (e) { case t.INT32: case t.INT64: case t.UINT32: case t.UINT64: case t.SINT32: case t.SINT64: case t.BOOL: case t.ENUM: case t.VHASH64: return r.VARINT; case t.DOUBLE: case t.FIXED64: case t.SFIXED64: case t.FHASH64: return r.FIXED64; case t.STRING: case t.MESSAGE: case t.BYTES: return r.DELIMITED; case t.FLOAT: case t.FIXED32: case t.SFIXED32: return r.FIXED32; default: return r.INVALID } }, jspb.BinaryConstants.INVALID_FIELD_NUMBER = -1, jspb.BinaryConstants.FLOAT32_EPS = 1.401298464324817e-45, jspb.BinaryConstants.FLOAT32_MIN = 1.1754943508222875e-38, jspb.BinaryConstants.FLOAT32_MAX = 3.4028234663852886e38, jspb.BinaryConstants.FLOAT64_EPS = 5e-324, jspb.BinaryConstants.FLOAT64_MIN = 2.2250738585072014e-308, jspb.BinaryConstants.FLOAT64_MAX = 1.7976931348623157e308, jspb.BinaryConstants.TWO_TO_20 = 1048576, jspb.BinaryConstants.TWO_TO_23 = 8388608, jspb.BinaryConstants.TWO_TO_31 = 2147483648, jspb.BinaryConstants.TWO_TO_32 = 4294967296, jspb.BinaryConstants.TWO_TO_52 = 4503599627370496, jspb.BinaryConstants.TWO_TO_63 = 0x8000000000000000, jspb.BinaryConstants.TWO_TO_64 = 0x10000000000000000, jspb.BinaryConstants.ZERO_HASH = "\0\0\0\0\0\0\0\0", jspb.utils = {}, jspb.utils.split64Low = 0, jspb.utils.split64High = 0, jspb.utils.splitUint64 = function (e) { var t = e >>> 0; e = Math.floor((e - t) / jspb.BinaryConstants.TWO_TO_32) >>> 0, jspb.utils.split64Low = t, jspb.utils.split64High = e }, jspb.utils.splitInt64 = function (e) { var t = 0 > e; e = Math.abs(e); var r = e >>> 0; e = Math.floor((e - r) / jspb.BinaryConstants.TWO_TO_32), e >>>= 0, t && (e = ~e >>> 0, 4294967295 < (r = 1 + (~r >>> 0)) && (r = 0, 4294967295 < ++e && (e = 0))), jspb.utils.split64Low = r, jspb.utils.split64High = e }, jspb.utils.splitZigzag64 = function (e) { var t = 0 > e; e = 2 * Math.abs(e), jspb.utils.splitUint64(e), e = jspb.utils.split64Low; var r = jspb.utils.split64High; t && (0 == e ? 0 == r ? r = e = 4294967295 : (r-- , e = 4294967295) : e--), jspb.utils.split64Low = e, jspb.utils.split64High = r }, jspb.utils.splitFloat32 = function (e) { var t = 0 > e ? 1 : 0; e = t ? -e : e; var r; 0 === e ? 0 < 1 / e ? (jspb.utils.split64High = 0, jspb.utils.split64Low = 0) : (jspb.utils.split64High = 0, jspb.utils.split64Low = 2147483648) : isNaN(e) ? (jspb.utils.split64High = 0, jspb.utils.split64Low = 2147483647) : e > jspb.BinaryConstants.FLOAT32_MAX ? (jspb.utils.split64High = 0, jspb.utils.split64Low = (t << 31 | 2139095040) >>> 0) : e < jspb.BinaryConstants.FLOAT32_MIN ? (e = Math.round(e / Math.pow(2, -149)), jspb.utils.split64High = 0, jspb.utils.split64Low = (t << 31 | e) >>> 0) : (r = Math.floor(Math.log(e) / Math.LN2), e *= Math.pow(2, -r), e = 8388607 & Math.round(e * jspb.BinaryConstants.TWO_TO_23), jspb.utils.split64High = 0, jspb.utils.split64Low = (t << 31 | r + 127 << 23 | e) >>> 0) }, jspb.utils.splitFloat64 = function (e) { var t = 0 > e ? 1 : 0; if (0 === (e = t ? -e : e)) jspb.utils.split64High = 0 < 1 / e ? 0 : 2147483648, jspb.utils.split64Low = 0; else if (isNaN(e)) jspb.utils.split64High = 2147483647, jspb.utils.split64Low = 4294967295; else if (e > jspb.BinaryConstants.FLOAT64_MAX) jspb.utils.split64High = (t << 31 | 2146435072) >>> 0, jspb.utils.split64Low = 0; else if (e < jspb.BinaryConstants.FLOAT64_MIN) { var r = e / Math.pow(2, -1074); e = r / jspb.BinaryConstants.TWO_TO_32, jspb.utils.split64High = (t << 31 | e) >>> 0, jspb.utils.split64Low = r >>> 0 } else { var o = Math.floor(Math.log(e) / Math.LN2); 1024 == o && (o = 1023), r = e * Math.pow(2, -o), e = r * jspb.BinaryConstants.TWO_TO_20 & 1048575, r = r * jspb.BinaryConstants.TWO_TO_52 >>> 0, jspb.utils.split64High = (t << 31 | o + 1023 << 20 | e) >>> 0, jspb.utils.split64Low = r } }, jspb.utils.splitHash64 = function (e) { var t = e.charCodeAt(0), r = e.charCodeAt(1), o = e.charCodeAt(2), n = e.charCodeAt(3), s = e.charCodeAt(4), i = e.charCodeAt(5), a = e.charCodeAt(6); e = e.charCodeAt(7), jspb.utils.split64Low = t + (r << 8) + (o << 16) + (n << 24) >>> 0, jspb.utils.split64High = s + (i << 8) + (a << 16) + (e << 24) >>> 0 }, jspb.utils.joinUint64 = function (e, t) { return t * jspb.BinaryConstants.TWO_TO_32 + e }; jspb.utils.joinInt64 = function (e, t) { var r = 2147483648 & t; r && (e = 1 + ~e >>> 0, t = ~t >>> 0, 0 == e && (t = t + 1 >>> 0)); var o = jspb.utils.joinUint64(e, t); return r ? -o : o }, jspb.utils.joinZigzag64 = function (e, t) { var r = 1 & e; e = (e >>> 1 | t << 31) >>> 0, t >>>= 1, r && 0 == (e = e + 1 >>> 0) && (t = t + 1 >>> 0); var o = jspb.utils.joinUint64(e, t); return r ? -o : o }, jspb.utils.joinFloat32 = function (e, t) { var r = 2 * (e >> 31) + 1, o = e >>> 23 & 255, n = 8388607 & e; return 255 == o ? n ? NaN : 1 / 0 * r : 0 == o ? r * Math.pow(2, -149) * n : r * Math.pow(2, o - 150) * (n + Math.pow(2, 23)) }, jspb.utils.joinFloat64 = function (e, t) { var r = 2 * (t >> 31) + 1, o = t >>> 20 & 2047, n = jspb.BinaryConstants.TWO_TO_32 * (1048575 & t) + e; return 2047 == o ? n ? NaN : 1 / 0 * r : 0 == o ? r * Math.pow(2, -1074) * n : r * Math.pow(2, o - 1075) * (n + jspb.BinaryConstants.TWO_TO_52) }, jspb.utils.joinHash64 = function (e, t) { return String.fromCharCode(e >>> 0 & 255, e >>> 8 & 255, e >>> 16 & 255, e >>> 24 & 255, t >>> 0 & 255, t >>> 8 & 255, t >>> 16 & 255, t >>> 24 & 255) }, jspb.utils.DIGITS = "0123456789abcdef".split(""), jspb.utils.joinUnsignedDecimalString = function (e, t) { function r(e) { for (var t = 1e7, r = 0; 7 > r; r++) { var t = t / 10, o = e / t % 10 >>> 0; (0 != o || a) && (a = !0, g += i[o]) } } if (2097151 >= t) return "" + (jspb.BinaryConstants.TWO_TO_32 * t + e); var o = (e >>> 24 | t << 8) >>> 0 & 16777215, n = t >> 16 & 65535, s = (16777215 & e) + 6777216 * o + 6710656 * n, o = o + 8147497 * n, n = 2 * n; 1e7 <= s && (o += Math.floor(s / 1e7), s %= 1e7), 1e7 <= o && (n += Math.floor(o / 1e7), o %= 1e7); var i = jspb.utils.DIGITS, a = !1, g = ""; return (n || a) && r(n), (o || a) && r(o), (s || a) && r(s), g }, jspb.utils.joinSignedDecimalString = function (e, t) { var r = 2147483648 & t; r && (e = 1 + ~e >>> 0, t = ~t + (0 == e ? 1 : 0) >>> 0); var o = jspb.utils.joinUnsignedDecimalString(e, t); return r ? "-" + o : o }, jspb.utils.hash64ToDecimalString = function (e, t) { jspb.utils.splitHash64(e); var r = jspb.utils.split64Low, o = jspb.utils.split64High; return t ? jspb.utils.joinSignedDecimalString(r, o) : jspb.utils.joinUnsignedDecimalString(r, o) }, jspb.utils.hash64ArrayToDecimalStrings = function (e, t) { for (var r = Array(e.length), o = 0; o < e.length; o++)r[o] = jspb.utils.hash64ToDecimalString(e[o], t); return r }, jspb.utils.decimalStringToHash64 = function (e) { function t(e, t) { for (var r = 0; 8 > r && (1 !== e || 0 < t); r++) { var n = e * o[r] + t; o[r] = 255 & n, t = n >>> 8 } } goog.asserts.assert(0 < e.length); var r = !1; "-" === e[0] && (r = !0, e = e.slice(1)); for (var o = [0, 0, 0, 0, 0, 0, 0, 0], n = 0; n < e.length; n++)t(10, jspb.utils.DIGITS.indexOf(e[n])); return r && (function () { for (var e = 0; 8 > e; e++)o[e] = 255 & ~o[e] }(), t(1, 1)), goog.crypt.byteArrayToString(o) }, jspb.utils.splitDecimalString = function (e) { jspb.utils.splitHash64(jspb.utils.decimalStringToHash64(e)) }, jspb.utils.hash64ToHexString = function (e) { var t = Array(18); t[0] = "0", t[1] = "x"; for (var r = 0; 8 > r; r++) { var o = e.charCodeAt(7 - r); t[2 * r + 2] = jspb.utils.DIGITS[o >> 4], t[2 * r + 3] = jspb.utils.DIGITS[15 & o] } return t.join("") }, jspb.utils.hexStringToHash64 = function (e) { e = e.toLowerCase(), goog.asserts.assert(18 == e.length), goog.asserts.assert("0" == e[0]), goog.asserts.assert("x" == e[1]); for (var t = "", r = 0; 8 > r; r++)var o = jspb.utils.DIGITS.indexOf(e[2 * r + 2]), n = jspb.utils.DIGITS.indexOf(e[2 * r + 3]), t = String.fromCharCode(16 * o + n) + t; return t }, jspb.utils.hash64ToNumber = function (e, t) { jspb.utils.splitHash64(e); var r = jspb.utils.split64Low, o = jspb.utils.split64High; return t ? jspb.utils.joinInt64(r, o) : jspb.utils.joinUint64(r, o) }, jspb.utils.numberToHash64 = function (e) { return jspb.utils.splitInt64(e), jspb.utils.joinHash64(jspb.utils.split64Low, jspb.utils.split64High) }, jspb.utils.countVarints = function (e, t, r) { for (var o = 0, n = t; n < r; n++)o += e[n] >> 7; return r - t - o }, jspb.utils.countVarintFields = function (e, t, r, o) { var n = 0; if (128 > (o = 8 * o + jspb.BinaryConstants.WireType.VARINT)) for (; t < r && e[t++] == o;)for (n++; ;) { var s = e[t++]; if (0 == (128 & s)) break } else for (; t < r;) { for (s = o; 128 < s;) { if (e[t] != (127 & s | 128)) return n; t++ , s >>= 7 } if (e[t++] != s) break; for (n++; 0 != (128 & (s = e[t++]));); } return n }, jspb.utils.countFixedFields_ = function (e, t, r, o, n) { var s = 0; if (128 > o) for (; t < r && e[t++] == o;)s++ , t += n; else for (; t < r;) { for (var i = o; 128 < i;) { if (e[t++] != (127 & i | 128)) return s; i >>= 7 } if (e[t++] != i) break; s++ , t += n } return s }, jspb.utils.countFixed32Fields = function (e, t, r, o) { return jspb.utils.countFixedFields_(e, t, r, 8 * o + jspb.BinaryConstants.WireType.FIXED32, 4) }, jspb.utils.countFixed64Fields = function (e, t, r, o) { return jspb.utils.countFixedFields_(e, t, r, 8 * o + jspb.BinaryConstants.WireType.FIXED64, 8) }, jspb.utils.countDelimitedFields = function (e, t, r, o) { var n = 0; for (o = 8 * o + jspb.BinaryConstants.WireType.DELIMITED; t < r;) { for (var s = o; 128 < s;) { if (e[t++] != (127 & s | 128)) return n; s >>= 7 } if (e[t++] != s) break; n++; for (var i = 0, a = 1; s = e[t++], i += (127 & s) * a, a *= 128, 0 != (128 & s);); t += i } return n }, jspb.utils.debugBytesToTextFormat = function (e) { var t = '"'; if (e) { e = jspb.utils.byteSourceToUint8Array(e); for (var r = 0; r < e.length; r++)t += "\\x", 16 > e[r] && (t += "0"), t += e[r].toString(16) } return t + '"' }, jspb.utils.debugScalarToTextFormat = function (e) { return goog.isString(e) ? goog.string.quote(e) : e.toString() }, jspb.utils.stringToByteArray = function (e) { for (var t = new Uint8Array(e.length), r = 0; r < e.length; r++) { var o = e.charCodeAt(r); if (255 < o) throw Error("Conversion error: string contains codepoint outside of byte range"); t[r] = o } return t }, jspb.utils.byteSourceToUint8Array = function (e) { return e.constructor === Uint8Array ? e : e.constructor === ArrayBuffer || e.constructor === Buffer || e.constructor === Array ? new Uint8Array(e) : e.constructor === String ? goog.crypt.base64.decodeStringToUint8Array(e) : (goog.asserts.fail("Type not convertible to Uint8Array."), new Uint8Array(0)) }, jspb.BinaryEncoder = function () { this.buffer_ = [] }, jspb.BinaryEncoder.prototype.length = function () { return this.buffer_.length }, jspb.BinaryEncoder.prototype.end = function () { var e = this.buffer_; return this.buffer_ = [], e }, jspb.BinaryEncoder.prototype.writeSplitVarint64 = function (e, t) { for (goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(t == Math.floor(t)), goog.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_32), goog.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_32); 0 < t || 127 < e;)this.buffer_.push(127 & e | 128), e = (e >>> 7 | t << 25) >>> 0, t >>>= 7; this.buffer_.push(e) }, jspb.BinaryEncoder.prototype.writeSplitFixed64 = function (e, t) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(t == Math.floor(t)), goog.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_32), goog.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_32), this.writeUint32(e), this.writeUint32(t) }, jspb.BinaryEncoder.prototype.writeUnsignedVarint32 = function (e) { for (goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_32); 127 < e;)this.buffer_.push(127 & e | 128), e >>>= 7; this.buffer_.push(e) }, jspb.BinaryEncoder.prototype.writeSignedVarint32 = function (e) { if (goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_31 && e < jspb.BinaryConstants.TWO_TO_31), 0 <= e) this.writeUnsignedVarint32(e); else { for (var t = 0; 9 > t; t++)this.buffer_.push(127 & e | 128), e >>= 7; this.buffer_.push(1) } }, jspb.BinaryEncoder.prototype.writeUnsignedVarint64 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_64), jspb.utils.splitInt64(e), this.writeSplitVarint64(jspb.utils.split64Low, jspb.utils.split64High) }, jspb.BinaryEncoder.prototype.writeSignedVarint64 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_63 && e < jspb.BinaryConstants.TWO_TO_63), jspb.utils.splitInt64(e), this.writeSplitVarint64(jspb.utils.split64Low, jspb.utils.split64High) }, jspb.BinaryEncoder.prototype.writeZigzagVarint32 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_31 && e < jspb.BinaryConstants.TWO_TO_31), this.writeUnsignedVarint32((e << 1 ^ e >> 31) >>> 0) }, jspb.BinaryEncoder.prototype.writeZigzagVarint64 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_63 && e < jspb.BinaryConstants.TWO_TO_63), jspb.utils.splitZigzag64(e), this.writeSplitVarint64(jspb.utils.split64Low, jspb.utils.split64High) }, jspb.BinaryEncoder.prototype.writeZigzagVarint64String = function (e) { this.writeZigzagVarint64(parseInt(e, 10)) }, jspb.BinaryEncoder.prototype.writeUint8 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(0 <= e && 256 > e), this.buffer_.push(e >>> 0 & 255) }, jspb.BinaryEncoder.prototype.writeUint16 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(0 <= e && 65536 > e), this.buffer_.push(e >>> 0 & 255), this.buffer_.push(e >>> 8 & 255) }, jspb.BinaryEncoder.prototype.writeUint32 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_32), this.buffer_.push(e >>> 0 & 255), this.buffer_.push(e >>> 8 & 255), this.buffer_.push(e >>> 16 & 255), this.buffer_.push(e >>> 24 & 255) }, jspb.BinaryEncoder.prototype.writeUint64 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_64), jspb.utils.splitUint64(e), this.writeUint32(jspb.utils.split64Low), this.writeUint32(jspb.utils.split64High) }, jspb.BinaryEncoder.prototype.writeInt8 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(-128 <= e && 128 > e), this.buffer_.push(e >>> 0 & 255) }, jspb.BinaryEncoder.prototype.writeInt16 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(-32768 <= e && 32768 > e), this.buffer_.push(e >>> 0 & 255), this.buffer_.push(e >>> 8 & 255) }, jspb.BinaryEncoder.prototype.writeInt32 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_31 && e < jspb.BinaryConstants.TWO_TO_31), this.buffer_.push(e >>> 0 & 255), this.buffer_.push(e >>> 8 & 255), this.buffer_.push(e >>> 16 & 255), this.buffer_.push(e >>> 24 & 255) }, jspb.BinaryEncoder.prototype.writeInt64 = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_63 && e < jspb.BinaryConstants.TWO_TO_63), jspb.utils.splitInt64(e), this.writeSplitFixed64(jspb.utils.split64Low, jspb.utils.split64High) }, jspb.BinaryEncoder.prototype.writeInt64String = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(+e >= -jspb.BinaryConstants.TWO_TO_63 && +e < jspb.BinaryConstants.TWO_TO_63), jspb.utils.splitHash64(jspb.utils.decimalStringToHash64(e)), this.writeSplitFixed64(jspb.utils.split64Low, jspb.utils.split64High) }, jspb.BinaryEncoder.prototype.writeFloat = function (e) { goog.asserts.assert(e >= -jspb.BinaryConstants.FLOAT32_MAX && e <= jspb.BinaryConstants.FLOAT32_MAX), jspb.utils.splitFloat32(e), this.writeUint32(jspb.utils.split64Low) }, jspb.BinaryEncoder.prototype.writeDouble = function (e) { goog.asserts.assert(e >= -jspb.BinaryConstants.FLOAT64_MAX && e <= jspb.BinaryConstants.FLOAT64_MAX), jspb.utils.splitFloat64(e), this.writeUint32(jspb.utils.split64Low), this.writeUint32(jspb.utils.split64High) }, jspb.BinaryEncoder.prototype.writeBool = function (e) { goog.asserts.assert(goog.isBoolean(e) || goog.isNumber(e)), this.buffer_.push(e ? 1 : 0) }, jspb.BinaryEncoder.prototype.writeEnum = function (e) { goog.asserts.assert(e == Math.floor(e)), goog.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_31 && e < jspb.BinaryConstants.TWO_TO_31), this.writeSignedVarint32(e) }, jspb.BinaryEncoder.prototype.writeBytes = function (e) { this.buffer_.push.apply(this.buffer_, e) }, jspb.BinaryEncoder.prototype.writeVarintHash64 = function (e) { jspb.utils.splitHash64(e), this.writeSplitVarint64(jspb.utils.split64Low, jspb.utils.split64High) }, jspb.BinaryEncoder.prototype.writeFixedHash64 = function (e) { jspb.utils.splitHash64(e), this.writeUint32(jspb.utils.split64Low), this.writeUint32(jspb.utils.split64High) }, jspb.BinaryEncoder.prototype.writeString = function (e) { for (var t = this.buffer_.length, r = 0; r < e.length; r++) { var o = e.charCodeAt(r); if (128 > o) this.buffer_.push(o); else if (2048 > o) this.buffer_.push(o >> 6 | 192), this.buffer_.push(63 & o | 128); else if (65536 > o) if (55296 <= o && 56319 >= o && r + 1 < e.length) { var n = e.charCodeAt(r + 1); 56320 <= n && 57343 >= n && (o = 1024 * (o - 55296) + n - 56320 + 65536, this.buffer_.push(o >> 18 | 240), this.buffer_.push(o >> 12 & 63 | 128), this.buffer_.push(o >> 6 & 63 | 128), this.buffer_.push(63 & o | 128), r++) } else this.buffer_.push(o >> 12 | 224), this.buffer_.push(o >> 6 & 63 | 128), this.buffer_.push(63 & o | 128) } return this.buffer_.length - t }, jspb.BinaryWriter = function () { this.blocks_ = [], this.totalLength_ = 0, this.encoder_ = new jspb.BinaryEncoder, this.bookmarks_ = [] }, jspb.BinaryWriter.prototype.appendUint8Array_ = function (e) { var t = this.encoder_.end(); this.blocks_.push(t), this.blocks_.push(e), this.totalLength_ += t.length + e.length }, jspb.BinaryWriter.prototype.beginDelimited_ = function (e) { return this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), e = this.encoder_.end(), this.blocks_.push(e), this.totalLength_ += e.length, e.push(this.totalLength_), e }, jspb.BinaryWriter.prototype.endDelimited_ = function (e) { var t = e.pop(), t = this.totalLength_ + this.encoder_.length() - t; for (goog.asserts.assert(0 <= t); 127 < t;)e.push(127 & t | 128), t >>>= 7, this.totalLength_++; e.push(t), this.totalLength_++ }, jspb.BinaryWriter.prototype.writeSerializedMessage = function (e, t, r) { this.appendUint8Array_(e.subarray(t, r)) }, jspb.BinaryWriter.prototype.maybeWriteSerializedMessage = function (e, t, r) { null != e && null != t && null != r && this.writeSerializedMessage(e, t, r) }, jspb.BinaryWriter.prototype.reset = function () { this.blocks_ = [], this.encoder_.end(), this.totalLength_ = 0, this.bookmarks_ = [] }, jspb.BinaryWriter.prototype.getResultBuffer = function () { goog.asserts.assert(0 == this.bookmarks_.length); for (var e = new Uint8Array(this.totalLength_ + this.encoder_.length()), t = this.blocks_, r = t.length, o = 0, n = 0; n < r; n++) { var s = t[n]; e.set(s, o), o += s.length } return t = this.encoder_.end(), e.set(t, o), o += t.length, goog.asserts.assert(o == e.length), this.blocks_ = [e], e }, jspb.BinaryWriter.prototype.getResultBase64String = function (e) { return goog.crypt.base64.encodeByteArray(this.getResultBuffer(), e) }, jspb.BinaryWriter.prototype.beginSubMessage = function (e) { this.bookmarks_.push(this.beginDelimited_(e)) }, jspb.BinaryWriter.prototype.endSubMessage = function () { goog.asserts.assert(0 <= this.bookmarks_.length), this.endDelimited_(this.bookmarks_.pop()) }, jspb.BinaryWriter.prototype.writeFieldHeader_ = function (e, t) { goog.asserts.assert(1 <= e && e == Math.floor(e)), this.encoder_.writeUnsignedVarint32(8 * e + t) }, jspb.BinaryWriter.prototype.writeAny = function (e, t, r) { var o = jspb.BinaryConstants.FieldType; switch (e) { case o.DOUBLE: this.writeDouble(t, r); break; case o.FLOAT: this.writeFloat(t, r); break; case o.INT64: this.writeInt64(t, r); break; case o.UINT64: this.writeUint64(t, r); break; case o.INT32: this.writeInt32(t, r); break; case o.FIXED64: this.writeFixed64(t, r); break; case o.FIXED32: this.writeFixed32(t, r); break; case o.BOOL: this.writeBool(t, r); break; case o.STRING: this.writeString(t, r); break; case o.GROUP: goog.asserts.fail("Group field type not supported in writeAny()"); break; case o.MESSAGE: goog.asserts.fail("Message field type not supported in writeAny()"); break; case o.BYTES: this.writeBytes(t, r); break; case o.UINT32: this.writeUint32(t, r); break; case o.ENUM: this.writeEnum(t, r); break; case o.SFIXED32: this.writeSfixed32(t, r); break; case o.SFIXED64: this.writeSfixed64(t, r); break; case o.SINT32: this.writeSint32(t, r); break; case o.SINT64: this.writeSint64(t, r); break; case o.FHASH64: this.writeFixedHash64(t, r); break; case o.VHASH64: this.writeVarintHash64(t, r); break; default: goog.asserts.fail("Invalid field type in writeAny()") } }, jspb.BinaryWriter.prototype.writeUnsignedVarint32_ = function (e, t) { null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeUnsignedVarint32(t)) }, jspb.BinaryWriter.prototype.writeSignedVarint32_ = function (e, t) { null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSignedVarint32(t)) }, jspb.BinaryWriter.prototype.writeUnsignedVarint64_ = function (e, t) { null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeUnsignedVarint64(t)) }, jspb.BinaryWriter.prototype.writeSignedVarint64_ = function (e, t) { null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSignedVarint64(t)) }, jspb.BinaryWriter.prototype.writeZigzagVarint32_ = function (e, t) { null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeZigzagVarint32(t)) }, jspb.BinaryWriter.prototype.writeZigzagVarint64_ = function (e, t) { null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeZigzagVarint64(t)) }, jspb.BinaryWriter.prototype.writeZigzagVarint64String_ = function (e, t) { null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeZigzagVarint64String(t)) }, jspb.BinaryWriter.prototype.writeInt32 = function (e, t) { null != t && (goog.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_31 && t < jspb.BinaryConstants.TWO_TO_31), this.writeSignedVarint32_(e, t)) }, jspb.BinaryWriter.prototype.writeInt32String = function (e, t) { if (null != t) { var r = parseInt(t, 10); goog.asserts.assert(r >= -jspb.BinaryConstants.TWO_TO_31 && r < jspb.BinaryConstants.TWO_TO_31), this.writeSignedVarint32_(e, r) } }, jspb.BinaryWriter.prototype.writeInt64 = function (e, t) { null != t && (goog.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_63 && t < jspb.BinaryConstants.TWO_TO_63), this.writeSignedVarint64_(e, t)) }, jspb.BinaryWriter.prototype.writeInt64String = function (e, t) { if (null != t) { var r = jspb.arith.Int64.fromString(t); this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSplitVarint64(r.lo, r.hi) } }, jspb.BinaryWriter.prototype.writeUint32 = function (e, t) { null != t && (goog.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_32), this.writeUnsignedVarint32_(e, t)) }, jspb.BinaryWriter.prototype.writeUint32String = function (e, t) { if (null != t) { var r = parseInt(t, 10); goog.asserts.assert(0 <= r && r < jspb.BinaryConstants.TWO_TO_32), this.writeUnsignedVarint32_(e, r) } }, jspb.BinaryWriter.prototype.writeUint64 = function (e, t) { null != t && (goog.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_64), this.writeUnsignedVarint64_(e, t)) }, jspb.BinaryWriter.prototype.writeUint64String = function (e, t) { if (null != t) { var r = jspb.arith.UInt64.fromString(t); this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSplitVarint64(r.lo, r.hi) } }, jspb.BinaryWriter.prototype.writeSint32 = function (e, t) { null != t && (goog.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_31 && t < jspb.BinaryConstants.TWO_TO_31), this.writeZigzagVarint32_(e, t)) }, jspb.BinaryWriter.prototype.writeSint64 = function (e, t) { null != t && (goog.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_63 && t < jspb.BinaryConstants.TWO_TO_63), this.writeZigzagVarint64_(e, t)) }, jspb.BinaryWriter.prototype.writeSint64String = function (e, t) { null != t && (goog.asserts.assert(+t >= -jspb.BinaryConstants.TWO_TO_63 && +t < jspb.BinaryConstants.TWO_TO_63), this.writeZigzagVarint64String_(e, t)) }, jspb.BinaryWriter.prototype.writeFixed32 = function (e, t) { null != t && (goog.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_32), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED32), this.encoder_.writeUint32(t)) }, jspb.BinaryWriter.prototype.writeFixed64 = function (e, t) { null != t && (goog.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_64), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeUint64(t)) }, jspb.BinaryWriter.prototype.writeFixed64String = function (e, t) { if (null != t) { var r = jspb.arith.UInt64.fromString(t); this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeSplitFixed64(r.lo, r.hi) } }, jspb.BinaryWriter.prototype.writeSfixed32 = function (e, t) { null != t && (goog.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_31 && t < jspb.BinaryConstants.TWO_TO_31), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED32), this.encoder_.writeInt32(t)) }, jspb.BinaryWriter.prototype.writeSfixed64 = function (e, t) { null != t && (goog.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_63 && t < jspb.BinaryConstants.TWO_TO_63), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeInt64(t)) }, jspb.BinaryWriter.prototype.writeSfixed64String = function (e, t) { if (null != t) { var r = jspb.arith.Int64.fromString(t); this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeSplitFixed64(r.lo, r.hi) } }, jspb.BinaryWriter.prototype.writeFloat = function (e, t) { null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED32), this.encoder_.writeFloat(t)) }, jspb.BinaryWriter.prototype.writeDouble = function (e, t) { null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeDouble(t)) }, jspb.BinaryWriter.prototype.writeBool = function (e, t) { null != t && (goog.asserts.assert(goog.isBoolean(t) || goog.isNumber(t)), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeBool(t)) }, jspb.BinaryWriter.prototype.writeEnum = function (e, t) { null != t && (goog.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_31 && t < jspb.BinaryConstants.TWO_TO_31), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSignedVarint32(t)) }, jspb.BinaryWriter.prototype.writeString = function (e, t) { if (null != t) { var r = this.beginDelimited_(e); this.encoder_.writeString(t), this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writeBytes = function (e, t) { if (null != t) { var r = jspb.utils.byteSourceToUint8Array(t); this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(r.length), this.appendUint8Array_(r) } }, jspb.BinaryWriter.prototype.writeMessage = function (e, t, r) { null != t && (e = this.beginDelimited_(e), r(t, this), this.endDelimited_(e)) }, jspb.BinaryWriter.prototype.writeGroup = function (e, t, r) { null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.START_GROUP), r(t, this), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.END_GROUP)) }, jspb.BinaryWriter.prototype.writeFixedHash64 = function (e, t) { null != t && (goog.asserts.assert(8 == t.length), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeFixedHash64(t)) }, jspb.BinaryWriter.prototype.writeVarintHash64 = function (e, t) { null != t && (goog.asserts.assert(8 == t.length), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeVarintHash64(t)) }, jspb.BinaryWriter.prototype.writeRepeatedInt32 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeSignedVarint32_(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedInt32String = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeInt32String(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedInt64 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeSignedVarint64_(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedInt64String = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeInt64String(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedUint32 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeUnsignedVarint32_(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedUint32String = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeUint32String(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedUint64 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeUnsignedVarint64_(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedUint64String = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeUint64String(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedSint32 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeZigzagVarint32_(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedSint64 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeZigzagVarint64_(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedSint64String = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeZigzagVarint64String_(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedFixed32 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeFixed32(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedFixed64 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeFixed64(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedFixed64String = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeFixed64String(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedSfixed32 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeSfixed32(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedSfixed64 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeSfixed64(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedSfixed64String = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeSfixed64String(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedFloat = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeFloat(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedDouble = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeDouble(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedBool = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeBool(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedEnum = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeEnum(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedString = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeString(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedBytes = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeBytes(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedMessage = function (e, t, r) { if (null != t) for (var o = 0; o < t.length; o++) { var n = this.beginDelimited_(e); r(t[o], this), this.endDelimited_(n) } }, jspb.BinaryWriter.prototype.writeRepeatedGroup = function (e, t, r) { if (null != t) for (var o = 0; o < t.length; o++)this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.START_GROUP), r(t[o], this), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.END_GROUP) }, jspb.BinaryWriter.prototype.writeRepeatedFixedHash64 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeFixedHash64(e, t[r]) }, jspb.BinaryWriter.prototype.writeRepeatedVarintHash64 = function (e, t) { if (null != t) for (var r = 0; r < t.length; r++)this.writeVarintHash64(e, t[r]) }, jspb.BinaryWriter.prototype.writePackedInt32 = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeSignedVarint32(t[o]); this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedInt32String = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeSignedVarint32(parseInt(t[o], 10)); this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedInt64 = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeSignedVarint64(t[o]); this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedInt64String = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++) { var n = jspb.arith.Int64.fromString(t[o]); this.encoder_.writeSplitVarint64(n.lo, n.hi) } this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedUint32 = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeUnsignedVarint32(t[o]); this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedUint32String = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeUnsignedVarint32(parseInt(t[o], 10)); this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedUint64 = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeUnsignedVarint64(t[o]); this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedUint64String = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++) { var n = jspb.arith.UInt64.fromString(t[o]); this.encoder_.writeSplitVarint64(n.lo, n.hi) } this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedSint32 = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeZigzagVarint32(t[o]); this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedSint64 = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeZigzagVarint64(t[o]); this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedSint64String = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeZigzagVarint64(parseInt(t[o], 10)); this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedFixed32 = function (e, t) { if (null != t && t.length) { this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(4 * t.length); for (var r = 0; r < t.length; r++)this.encoder_.writeUint32(t[r]) } }, jspb.BinaryWriter.prototype.writePackedFixed64 = function (e, t) { if (null != t && t.length) { this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length); for (var r = 0; r < t.length; r++)this.encoder_.writeUint64(t[r]) } }, jspb.BinaryWriter.prototype.writePackedFixed64String = function (e, t) { if (null != t && t.length) { this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length); for (var r = 0; r < t.length; r++) { var o = jspb.arith.UInt64.fromString(t[r]); this.encoder_.writeSplitFixed64(o.lo, o.hi) } } }, jspb.BinaryWriter.prototype.writePackedSfixed32 = function (e, t) { if (null != t && t.length) { this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(4 * t.length); for (var r = 0; r < t.length; r++)this.encoder_.writeInt32(t[r]) } }, jspb.BinaryWriter.prototype.writePackedSfixed64 = function (e, t) { if (null != t && t.length) { this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length); for (var r = 0; r < t.length; r++)this.encoder_.writeInt64(t[r]) } }, jspb.BinaryWriter.prototype.writePackedSfixed64String = function (e, t) { if (null != t && t.length) { this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length); for (var r = 0; r < t.length; r++)this.encoder_.writeInt64String(t[r]) } }, jspb.BinaryWriter.prototype.writePackedFloat = function (e, t) { if (null != t && t.length) { this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(4 * t.length); for (var r = 0; r < t.length; r++)this.encoder_.writeFloat(t[r]) } }, jspb.BinaryWriter.prototype.writePackedDouble = function (e, t) { if (null != t && t.length) { this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length); for (var r = 0; r < t.length; r++)this.encoder_.writeDouble(t[r]) } }, jspb.BinaryWriter.prototype.writePackedBool = function (e, t) { if (null != t && t.length) { this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(t.length); for (var r = 0; r < t.length; r++)this.encoder_.writeBool(t[r]) } }, jspb.BinaryWriter.prototype.writePackedEnum = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeEnum(t[o]); this.endDelimited_(r) } }, jspb.BinaryWriter.prototype.writePackedFixedHash64 = function (e, t) { if (null != t && t.length) { this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length); for (var r = 0; r < t.length; r++)this.encoder_.writeFixedHash64(t[r]) } }, jspb.BinaryWriter.prototype.writePackedVarintHash64 = function (e, t) { if (null != t && t.length) { for (var r = this.beginDelimited_(e), o = 0; o < t.length; o++)this.encoder_.writeVarintHash64(t[o]); this.endDelimited_(r) } }, jspb.BinaryIterator = function (e, t, r) { this.elements_ = this.nextMethod_ = this.decoder_ = null, this.cursor_ = 0, this.nextValue_ = null, this.atEnd_ = !0, this.init_(e, t, r) }, jspb.BinaryIterator.prototype.init_ = function (e, t, r) { e && t && (this.decoder_ = e, this.nextMethod_ = t), this.elements_ = r || null, this.cursor_ = 0, this.nextValue_ = null, this.atEnd_ = !this.decoder_ && !this.elements_, this.next() }, jspb.BinaryIterator.instanceCache_ = [], jspb.BinaryIterator.alloc = function (e, t, r) { if (jspb.BinaryIterator.instanceCache_.length) { var o = jspb.BinaryIterator.instanceCache_.pop(); return o.init_(e, t, r), o } return new jspb.BinaryIterator(e, t, r) }, jspb.BinaryIterator.prototype.free = function () { this.clear(), 100 > jspb.BinaryIterator.instanceCache_.length && jspb.BinaryIterator.instanceCache_.push(this) }, jspb.BinaryIterator.prototype.clear = function () { this.decoder_ && this.decoder_.free(), this.elements_ = this.nextMethod_ = this.decoder_ = null, this.cursor_ = 0, this.nextValue_ = null, this.atEnd_ = !0 }, jspb.BinaryIterator.prototype.get = function () { return this.nextValue_ }, jspb.BinaryIterator.prototype.atEnd = function () { return this.atEnd_ }, jspb.BinaryIterator.prototype.next = function () { var e = this.nextValue_; return this.decoder_ ? this.decoder_.atEnd() ? (this.nextValue_ = null, this.atEnd_ = !0) : this.nextValue_ = this.nextMethod_.call(this.decoder_) : this.elements_ && (this.cursor_ == this.elements_.length ? (this.nextValue_ = null, this.atEnd_ = !0) : this.nextValue_ = this.elements_[this.cursor_++]), e }, jspb.BinaryDecoder = function (e, t, r) { this.bytes_ = null, this.tempHigh_ = this.tempLow_ = this.cursor_ = this.end_ = this.start_ = 0, this.error_ = !1, e && this.setBlock(e, t, r) }, jspb.BinaryDecoder.instanceCache_ = [], jspb.BinaryDecoder.alloc = function (e, t, r) { if (jspb.BinaryDecoder.instanceCache_.length) { var o = jspb.BinaryDecoder.instanceCache_.pop(); return e && o.setBlock(e, t, r), o } return new jspb.BinaryDecoder(e, t, r) }, jspb.BinaryDecoder.prototype.free = function () { this.clear(), 100 > jspb.BinaryDecoder.instanceCache_.length && jspb.BinaryDecoder.instanceCache_.push(this) }, jspb.BinaryDecoder.prototype.clone = function () { return jspb.BinaryDecoder.alloc(this.bytes_, this.start_, this.end_ - this.start_) }, jspb.BinaryDecoder.prototype.clear = function () { this.bytes_ = null, this.cursor_ = this.end_ = this.start_ = 0, this.error_ = !1 }, jspb.BinaryDecoder.prototype.getBuffer = function () { return this.bytes_ }, jspb.BinaryDecoder.prototype.setBlock = function (e, t, r) { this.bytes_ = jspb.utils.byteSourceToUint8Array(e), this.start_ = goog.isDef(t) ? t : 0, this.end_ = goog.isDef(r) ? this.start_ + r : this.bytes_.length, this.cursor_ = this.start_ }, jspb.BinaryDecoder.prototype.getEnd = function () { return this.end_ }, jspb.BinaryDecoder.prototype.setEnd = function (e) { this.end_ = e }, jspb.BinaryDecoder.prototype.reset = function () { this.cursor_ = this.start_ }, jspb.BinaryDecoder.prototype.getCursor = function () { return this.cursor_ }, jspb.BinaryDecoder.prototype.setCursor = function (e) { this.cursor_ = e }, jspb.BinaryDecoder.prototype.advance = function (e) { this.cursor_ += e, goog.asserts.assert(this.cursor_ <= this.end_) }, jspb.BinaryDecoder.prototype.atEnd = function () { return this.cursor_ == this.end_ }, jspb.BinaryDecoder.prototype.pastEnd = function () { return this.cursor_ > this.end_ }, jspb.BinaryDecoder.prototype.getError = function () { return this.error_ || 0 > this.cursor_ || this.cursor_ > this.end_ }, jspb.BinaryDecoder.prototype.readSplitVarint64_ = function () { for (var e, t, r = 0, o = 0; 4 > o; o++)if (e = this.bytes_[this.cursor_++], r |= (127 & e) << 7 * o, 128 > e) return this.tempLow_ = r >>> 0, void (this.tempHigh_ = 0); if (e = this.bytes_[this.cursor_++], r |= (127 & e) << 28, t = 0 | (127 & e) >> 4, 128 > e) this.tempLow_ = r >>> 0, this.tempHigh_ = t >>> 0; else { for (o = 0; 5 > o; o++)if (e = this.bytes_[this.cursor_++], t |= (127 & e) << 7 * o + 3, 128 > e) return this.tempLow_ = r >>> 0, void (this.tempHigh_ = t >>> 0); goog.asserts.fail("Failed to read varint, encoding is invalid."), this.error_ = !0 } }, jspb.BinaryDecoder.prototype.skipVarint = function () { for (; 128 & this.bytes_[this.cursor_];)this.cursor_++; this.cursor_++ }, jspb.BinaryDecoder.prototype.unskipVarint = function (e) { for (; 128 < e;)this.cursor_-- , e >>>= 7; this.cursor_-- }, jspb.BinaryDecoder.prototype.readUnsignedVarint32 = function () { var e, t = this.bytes_; e = t[this.cursor_ + 0]; var r = 127 & e; return 128 > e ? (this.cursor_ += 1, goog.asserts.assert(this.cursor_ <= this.end_), r) : (e = t[this.cursor_ + 1], r |= (127 & e) << 7, 128 > e ? (this.cursor_ += 2, goog.asserts.assert(this.cursor_ <= this.end_), r) : (e = t[this.cursor_ + 2], r |= (127 & e) << 14, 128 > e ? (this.cursor_ += 3, goog.asserts.assert(this.cursor_ <= this.end_), r) : (e = t[this.cursor_ + 3], r |= (127 & e) << 21, 128 > e ? (this.cursor_ += 4, goog.asserts.assert(this.cursor_ <= this.end_), r) : (e = t[this.cursor_ + 4], r |= (15 & e) << 28, 128 > e ? (this.cursor_ += 5, goog.asserts.assert(this.cursor_ <= this.end_), r >>> 0) : (this.cursor_ += 5, 128 <= t[this.cursor_++] && 128 <= t[this.cursor_++] && 128 <= t[this.cursor_++] && 128 <= t[this.cursor_++] && 128 <= t[this.cursor_++] && goog.asserts.assert(!1), goog.asserts.assert(this.cursor_ <= this.end_), r))))) }, jspb.BinaryDecoder.prototype.readSignedVarint32 = jspb.BinaryDecoder.prototype.readUnsignedVarint32, jspb.BinaryDecoder.prototype.readUnsignedVarint32String = function () { return this.readUnsignedVarint32().toString() }, jspb.BinaryDecoder.prototype.readSignedVarint32String = function () { return this.readSignedVarint32().toString() }, jspb.BinaryDecoder.prototype.readZigzagVarint32 = function () { var e = this.readUnsignedVarint32(); return e >>> 1 ^ -(1 & e) }, jspb.BinaryDecoder.prototype.readUnsignedVarint64 = function () { return this.readSplitVarint64_(), jspb.utils.joinUint64(this.tempLow_, this.tempHigh_) }, jspb.BinaryDecoder.prototype.readUnsignedVarint64String = function () { return this.readSplitVarint64_(), jspb.utils.joinUnsignedDecimalString(this.tempLow_, this.tempHigh_) }, jspb.BinaryDecoder.prototype.readSignedVarint64 = function () { return this.readSplitVarint64_(), jspb.utils.joinInt64(this.tempLow_, this.tempHigh_) }, jspb.BinaryDecoder.prototype.readSignedVarint64String = function () { return this.readSplitVarint64_(), jspb.utils.joinSignedDecimalString(this.tempLow_, this.tempHigh_) }, jspb.BinaryDecoder.prototype.readZigzagVarint64 = function () { return this.readSplitVarint64_(), jspb.utils.joinZigzag64(this.tempLow_, this.tempHigh_) }, jspb.BinaryDecoder.prototype.readZigzagVarint64String = function () { return this.readZigzagVarint64().toString() }, jspb.BinaryDecoder.prototype.readUint8 = function () { var e = this.bytes_[this.cursor_ + 0]; return this.cursor_ += 1, goog.asserts.assert(this.cursor_ <= this.end_), e }, jspb.BinaryDecoder.prototype.readUint16 = function () { var e = this.bytes_[this.cursor_ + 0], t = this.bytes_[this.cursor_ + 1]; return this.cursor_ += 2, goog.asserts.assert(this.cursor_ <= this.end_), e << 0 | t << 8 }, jspb.BinaryDecoder.prototype.readUint32 = function () { var e = this.bytes_[this.cursor_ + 0], t = this.bytes_[this.cursor_ + 1], r = this.bytes_[this.cursor_ + 2], o = this.bytes_[this.cursor_ + 3]; return this.cursor_ += 4, goog.asserts.assert(this.cursor_ <= this.end_), (e << 0 | t << 8 | r << 16 | o << 24) >>> 0 }, jspb.BinaryDecoder.prototype.readUint64 = function () { var e = this.readUint32(), t = this.readUint32(); return jspb.utils.joinUint64(e, t) }, jspb.BinaryDecoder.prototype.readUint64String = function () { var e = this.readUint32(), t = this.readUint32(); return jspb.utils.joinUnsignedDecimalString(e, t) }, jspb.BinaryDecoder.prototype.readInt8 = function () { var e = this.bytes_[this.cursor_ + 0]; return this.cursor_ += 1, goog.asserts.assert(this.cursor_ <= this.end_), e << 24 >> 24 }, jspb.BinaryDecoder.prototype.readInt16 = function () { var e = this.bytes_[this.cursor_ + 0], t = this.bytes_[this.cursor_ + 1]; return this.cursor_ += 2, goog.asserts.assert(this.cursor_ <= this.end_), (e << 0 | t << 8) << 16 >> 16 }, jspb.BinaryDecoder.prototype.readInt32 = function () { var e = this.bytes_[this.cursor_ + 0], t = this.bytes_[this.cursor_ + 1], r = this.bytes_[this.cursor_ + 2], o = this.bytes_[this.cursor_ + 3]; return this.cursor_ += 4, goog.asserts.assert(this.cursor_ <= this.end_), e << 0 | t << 8 | r << 16 | o << 24 }; jspb.BinaryDecoder.prototype.readInt64 = function () { var e = this.readUint32(), t = this.readUint32(); return jspb.utils.joinInt64(e, t) }, jspb.BinaryDecoder.prototype.readInt64String = function () { var e = this.readUint32(), t = this.readUint32(); return jspb.utils.joinSignedDecimalString(e, t) }, jspb.BinaryDecoder.prototype.readFloat = function () { var e = this.readUint32(); return jspb.utils.joinFloat32(e, 0) }, jspb.BinaryDecoder.prototype.readDouble = function () { var e = this.readUint32(), t = this.readUint32(); return jspb.utils.joinFloat64(e, t) }, jspb.BinaryDecoder.prototype.readBool = function () { return !!this.bytes_[this.cursor_++] }, jspb.BinaryDecoder.prototype.readEnum = function () { return this.readSignedVarint32() }, jspb.BinaryDecoder.prototype.readString = function (e) { var t = this.bytes_, r = this.cursor_; e = r + e; for (var o = [], n = ""; r < e;) { var s = t[r++]; if (128 > s) o.push(s); else { if (192 > s) continue; if (224 > s) { var i = t[r++]; o.push((31 & s) << 6 | 63 & i) } else if (240 > s) { var i = t[r++], a = t[r++]; o.push((15 & s) << 12 | (63 & i) << 6 | 63 & a) } else if (248 > s) { var i = t[r++], a = t[r++], g = t[r++], s = (7 & s) << 18 | (63 & i) << 12 | (63 & a) << 6 | 63 & g, s = s - 65536; o.push(55296 + (s >> 10 & 1023), 56320 + (1023 & s)) } } 8192 <= o.length && (n += String.fromCharCode.apply(null, o), o.length = 0) } return n += goog.crypt.byteArrayToString(o), this.cursor_ = r, n }, jspb.BinaryDecoder.prototype.readStringWithLength = function () { var e = this.readUnsignedVarint32(); return this.readString(e) }, jspb.BinaryDecoder.prototype.readBytes = function (e) { if (0 > e || this.cursor_ + e > this.bytes_.length) return this.error_ = !0, goog.asserts.fail("Invalid byte length!"), new Uint8Array(0); var t = this.bytes_.subarray(this.cursor_, this.cursor_ + e); return this.cursor_ += e, goog.asserts.assert(this.cursor_ <= this.end_), t }, jspb.BinaryDecoder.prototype.readVarintHash64 = function () { return this.readSplitVarint64_(), jspb.utils.joinHash64(this.tempLow_, this.tempHigh_) }, jspb.BinaryDecoder.prototype.readFixedHash64 = function () { var e = this.bytes_, t = this.cursor_, r = e[t + 0], o = e[t + 1], n = e[t + 2], s = e[t + 3], i = e[t + 4], a = e[t + 5], g = e[t + 6], e = e[t + 7]; return this.cursor_ += 8, String.fromCharCode(r, o, n, s, i, a, g, e) }, jspb.BinaryReader = function (e, t, r) { this.decoder_ = jspb.BinaryDecoder.alloc(e, t, r), this.fieldCursor_ = this.decoder_.getCursor(), this.nextField_ = jspb.BinaryConstants.INVALID_FIELD_NUMBER, this.nextWireType_ = jspb.BinaryConstants.WireType.INVALID, this.error_ = !1, this.readCallbacks_ = null }, jspb.BinaryReader.instanceCache_ = [], jspb.BinaryReader.alloc = function (e, t, r) { if (jspb.BinaryReader.instanceCache_.length) { var o = jspb.BinaryReader.instanceCache_.pop(); return e && o.decoder_.setBlock(e, t, r), o } return new jspb.BinaryReader(e, t, r) }, jspb.BinaryReader.prototype.alloc = jspb.BinaryReader.alloc, jspb.BinaryReader.prototype.free = function () { this.decoder_.clear(), this.nextField_ = jspb.BinaryConstants.INVALID_FIELD_NUMBER, this.nextWireType_ = jspb.BinaryConstants.WireType.INVALID, this.error_ = !1, this.readCallbacks_ = null, 100 > jspb.BinaryReader.instanceCache_.length && jspb.BinaryReader.instanceCache_.push(this) }, jspb.BinaryReader.prototype.getFieldCursor = function () { return this.fieldCursor_ }, jspb.BinaryReader.prototype.getCursor = function () { return this.decoder_.getCursor() }, jspb.BinaryReader.prototype.getBuffer = function () { return this.decoder_.getBuffer() }, jspb.BinaryReader.prototype.getFieldNumber = function () { return this.nextField_ }, jspb.BinaryReader.prototype.getWireType = function () { return this.nextWireType_ }, jspb.BinaryReader.prototype.isEndGroup = function () { return this.nextWireType_ == jspb.BinaryConstants.WireType.END_GROUP }, jspb.BinaryReader.prototype.getError = function () { return this.error_ || this.decoder_.getError() }, jspb.BinaryReader.prototype.setBlock = function (e, t, r) { this.decoder_.setBlock(e, t, r), this.nextField_ = jspb.BinaryConstants.INVALID_FIELD_NUMBER, this.nextWireType_ = jspb.BinaryConstants.WireType.INVALID }, jspb.BinaryReader.prototype.reset = function () { this.decoder_.reset(), this.nextField_ = jspb.BinaryConstants.INVALID_FIELD_NUMBER, this.nextWireType_ = jspb.BinaryConstants.WireType.INVALID }, jspb.BinaryReader.prototype.advance = function (e) { this.decoder_.advance(e) }, jspb.BinaryReader.prototype.nextField = function () { if (this.decoder_.atEnd()) return !1; if (this.getError()) return goog.asserts.fail("Decoder hit an error"), !1; this.fieldCursor_ = this.decoder_.getCursor(); var e = this.decoder_.readUnsignedVarint32(), t = e >>> 3, e = 7 & e; return e != jspb.BinaryConstants.WireType.VARINT && e != jspb.BinaryConstants.WireType.FIXED32 && e != jspb.BinaryConstants.WireType.FIXED64 && e != jspb.BinaryConstants.WireType.DELIMITED && e != jspb.BinaryConstants.WireType.START_GROUP && e != jspb.BinaryConstants.WireType.END_GROUP ? (goog.asserts.fail("Invalid wire type"), this.error_ = !0, !1) : (this.nextField_ = t, this.nextWireType_ = e, !0) }, jspb.BinaryReader.prototype.unskipHeader = function () { this.decoder_.unskipVarint(this.nextField_ << 3 | this.nextWireType_) }, jspb.BinaryReader.prototype.skipMatchingFields = function () { var e = this.nextField_; for (this.unskipHeader(); this.nextField() && this.getFieldNumber() == e;)this.skipField(); this.decoder_.atEnd() || this.unskipHeader() }, jspb.BinaryReader.prototype.skipVarintField = function () { this.nextWireType_ != jspb.BinaryConstants.WireType.VARINT ? (goog.asserts.fail("Invalid wire type for skipVarintField"), this.skipField()) : this.decoder_.skipVarint() }, jspb.BinaryReader.prototype.skipDelimitedField = function () { if (this.nextWireType_ != jspb.BinaryConstants.WireType.DELIMITED) goog.asserts.fail("Invalid wire type for skipDelimitedField"), this.skipField(); else { var e = this.decoder_.readUnsignedVarint32(); this.decoder_.advance(e) } }, jspb.BinaryReader.prototype.skipFixed32Field = function () { this.nextWireType_ != jspb.BinaryConstants.WireType.FIXED32 ? (goog.asserts.fail("Invalid wire type for skipFixed32Field"), this.skipField()) : this.decoder_.advance(4) }, jspb.BinaryReader.prototype.skipFixed64Field = function () { this.nextWireType_ != jspb.BinaryConstants.WireType.FIXED64 ? (goog.asserts.fail("Invalid wire type for skipFixed64Field"), this.skipField()) : this.decoder_.advance(8) }, jspb.BinaryReader.prototype.skipGroup = function () { var e = [this.nextField_]; do { if (!this.nextField()) { goog.asserts.fail("Unmatched start-group tag: stream EOF"), this.error_ = !0; break } if (this.nextWireType_ == jspb.BinaryConstants.WireType.START_GROUP) e.push(this.nextField_); else if (this.nextWireType_ == jspb.BinaryConstants.WireType.END_GROUP && this.nextField_ != e.pop()) { goog.asserts.fail("Unmatched end-group tag"), this.error_ = !0; break } } while (0 < e.length) }, jspb.BinaryReader.prototype.skipField = function () { switch (this.nextWireType_) { case jspb.BinaryConstants.WireType.VARINT: this.skipVarintField(); break; case jspb.BinaryConstants.WireType.FIXED64: this.skipFixed64Field(); break; case jspb.BinaryConstants.WireType.DELIMITED: this.skipDelimitedField(); break; case jspb.BinaryConstants.WireType.FIXED32: this.skipFixed32Field(); break; case jspb.BinaryConstants.WireType.START_GROUP: this.skipGroup(); break; default: goog.asserts.fail("Invalid wire encoding for field.") } }, jspb.BinaryReader.prototype.registerReadCallback = function (e, t) { goog.isNull(this.readCallbacks_) && (this.readCallbacks_ = {}), goog.asserts.assert(!this.readCallbacks_[e]), this.readCallbacks_[e] = t }, jspb.BinaryReader.prototype.runReadCallback = function (e) { return goog.asserts.assert(!goog.isNull(this.readCallbacks_)), e = this.readCallbacks_[e], goog.asserts.assert(e), e(this) }, jspb.BinaryReader.prototype.readAny = function (e) { this.nextWireType_ = jspb.BinaryConstants.FieldTypeToWireType(e); var t = jspb.BinaryConstants.FieldType; switch (e) { case t.DOUBLE: return this.readDouble(); case t.FLOAT: return this.readFloat(); case t.INT64: return this.readInt64(); case t.UINT64: return this.readUint64(); case t.INT32: return this.readInt32(); case t.FIXED64: return this.readFixed64(); case t.FIXED32: return this.readFixed32(); case t.BOOL: return this.readBool(); case t.STRING: return this.readString(); case t.GROUP: goog.asserts.fail("Group field type not supported in readAny()"); case t.MESSAGE: goog.asserts.fail("Message field type not supported in readAny()"); case t.BYTES: return this.readBytes(); case t.UINT32: return this.readUint32(); case t.ENUM: return this.readEnum(); case t.SFIXED32: return this.readSfixed32(); case t.SFIXED64: return this.readSfixed64(); case t.SINT32: return this.readSint32(); case t.SINT64: return this.readSint64(); case t.FHASH64: return this.readFixedHash64(); case t.VHASH64: return this.readVarintHash64(); default: goog.asserts.fail("Invalid field type in readAny()") }return 0 }, jspb.BinaryReader.prototype.readMessage = function (e, t) { goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED); var r = this.decoder_.getEnd(), o = this.decoder_.readUnsignedVarint32(), o = this.decoder_.getCursor() + o; this.decoder_.setEnd(o), t(e, this), this.decoder_.setCursor(o), this.decoder_.setEnd(r) }, jspb.BinaryReader.prototype.readGroup = function (e, t, r) { goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.START_GROUP), goog.asserts.assert(this.nextField_ == e), r(t, this), this.error_ || this.nextWireType_ == jspb.BinaryConstants.WireType.END_GROUP || (goog.asserts.fail("Group submessage did not end with an END_GROUP tag"), this.error_ = !0) }, jspb.BinaryReader.prototype.getFieldDecoder = function () { goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED); var e = this.decoder_.readUnsignedVarint32(), t = this.decoder_.getCursor(), r = t + e, e = jspb.BinaryDecoder.alloc(this.decoder_.getBuffer(), t, e); return this.decoder_.setCursor(r), e }, jspb.BinaryReader.prototype.readInt32 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSignedVarint32() }, jspb.BinaryReader.prototype.readInt32String = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSignedVarint32String() }, jspb.BinaryReader.prototype.readInt64 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSignedVarint64() }, jspb.BinaryReader.prototype.readInt64String = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSignedVarint64String() }, jspb.BinaryReader.prototype.readUint32 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readUnsignedVarint32() }, jspb.BinaryReader.prototype.readUint32String = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readUnsignedVarint32String() }, jspb.BinaryReader.prototype.readUint64 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readUnsignedVarint64() }, jspb.BinaryReader.prototype.readUint64String = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readUnsignedVarint64String() }, jspb.BinaryReader.prototype.readSint32 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readZigzagVarint32() }, jspb.BinaryReader.prototype.readSint64 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readZigzagVarint64() }, jspb.BinaryReader.prototype.readSint64String = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readZigzagVarint64String() }, jspb.BinaryReader.prototype.readFixed32 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED32), this.decoder_.readUint32() }, jspb.BinaryReader.prototype.readFixed64 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readUint64() }, jspb.BinaryReader.prototype.readFixed64String = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readUint64String() }, jspb.BinaryReader.prototype.readSfixed32 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED32), this.decoder_.readInt32() }, jspb.BinaryReader.prototype.readSfixed32String = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED32), this.decoder_.readInt32().toString() }, jspb.BinaryReader.prototype.readSfixed64 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readInt64() }, jspb.BinaryReader.prototype.readSfixed64String = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readInt64String() }, jspb.BinaryReader.prototype.readFloat = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED32), this.decoder_.readFloat() }, jspb.BinaryReader.prototype.readDouble = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readDouble() }, jspb.BinaryReader.prototype.readBool = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), !!this.decoder_.readUnsignedVarint32() }, jspb.BinaryReader.prototype.readEnum = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSignedVarint64() }, jspb.BinaryReader.prototype.readString = function () { goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED); var e = this.decoder_.readUnsignedVarint32(); return this.decoder_.readString(e) }, jspb.BinaryReader.prototype.readBytes = function () { goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED); var e = this.decoder_.readUnsignedVarint32(); return this.decoder_.readBytes(e) }, jspb.BinaryReader.prototype.readVarintHash64 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readVarintHash64() }, jspb.BinaryReader.prototype.readFixedHash64 = function () { return goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readFixedHash64() }, jspb.BinaryReader.prototype.readPackedField_ = function (e) { goog.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED); for (var t = this.decoder_.readUnsignedVarint32(), t = this.decoder_.getCursor() + t, r = []; this.decoder_.getCursor() < t;)r.push(e.call(this.decoder_)); return r }, jspb.BinaryReader.prototype.readPackedInt32 = function () { return this.readPackedField_(this.decoder_.readSignedVarint32) }, jspb.BinaryReader.prototype.readPackedInt32String = function () { return this.readPackedField_(this.decoder_.readSignedVarint32String) }, jspb.BinaryReader.prototype.readPackedInt64 = function () { return this.readPackedField_(this.decoder_.readSignedVarint64) }, jspb.BinaryReader.prototype.readPackedInt64String = function () { return this.readPackedField_(this.decoder_.readSignedVarint64String) }, jspb.BinaryReader.prototype.readPackedUint32 = function () { return this.readPackedField_(this.decoder_.readUnsignedVarint32) }, jspb.BinaryReader.prototype.readPackedUint32String = function () { return this.readPackedField_(this.decoder_.readUnsignedVarint32String) }, jspb.BinaryReader.prototype.readPackedUint64 = function () { return this.readPackedField_(this.decoder_.readUnsignedVarint64) }, jspb.BinaryReader.prototype.readPackedUint64String = function () { return this.readPackedField_(this.decoder_.readUnsignedVarint64String) }, jspb.BinaryReader.prototype.readPackedSint32 = function () { return this.readPackedField_(this.decoder_.readZigzagVarint32) }, jspb.BinaryReader.prototype.readPackedSint64 = function () { return this.readPackedField_(this.decoder_.readZigzagVarint64) }, jspb.BinaryReader.prototype.readPackedSint64String = function () { return this.readPackedField_(this.decoder_.readZigzagVarint64String) }, jspb.BinaryReader.prototype.readPackedFixed32 = function () { return this.readPackedField_(this.decoder_.readUint32) }, jspb.BinaryReader.prototype.readPackedFixed64 = function () { return this.readPackedField_(this.decoder_.readUint64) }, jspb.BinaryReader.prototype.readPackedFixed64String = function () { return this.readPackedField_(this.decoder_.readUint64String) }, jspb.BinaryReader.prototype.readPackedSfixed32 = function () { return this.readPackedField_(this.decoder_.readInt32) }, jspb.BinaryReader.prototype.readPackedSfixed64 = function () { return this.readPackedField_(this.decoder_.readInt64) }, jspb.BinaryReader.prototype.readPackedSfixed64String = function () { return this.readPackedField_(this.decoder_.readInt64String) }, jspb.BinaryReader.prototype.readPackedFloat = function () { return this.readPackedField_(this.decoder_.readFloat) }, jspb.BinaryReader.prototype.readPackedDouble = function () { return this.readPackedField_(this.decoder_.readDouble) }, jspb.BinaryReader.prototype.readPackedBool = function () { return this.readPackedField_(this.decoder_.readBool) }, jspb.BinaryReader.prototype.readPackedEnum = function () { return this.readPackedField_(this.decoder_.readEnum) }, jspb.BinaryReader.prototype.readPackedVarintHash64 = function () { return this.readPackedField_(this.decoder_.readVarintHash64) }, jspb.BinaryReader.prototype.readPackedFixedHash64 = function () { return this.readPackedField_(this.decoder_.readFixedHash64) }, jspb.Export = {}, exports.Map = jspb.Map, exports.Message = jspb.Message, exports.BinaryReader = jspb.BinaryReader, exports.BinaryWriter = jspb.BinaryWriter, exports.ExtensionFieldInfo = jspb.ExtensionFieldInfo, exports.ExtensionFieldBinaryInfo = jspb.ExtensionFieldBinaryInfo, exports.exportSymbol = goog.exportSymbol, exports.inherits = goog.inherits, exports.object = { extend: goog.object.extend }, exports.typeOf = goog.typeOf }).call(exports, __webpack_require__(0), __webpack_require__(4).Buffer) }, function (e, t, r) { "use strict"; (function (e) { function o() { return s.TYPED_ARRAY_SUPPORT ? 2147483647 : 1073741823 } function n(e, t) { if (o() < t) throw new RangeError("Invalid typed array length"); return s.TYPED_ARRAY_SUPPORT ? (e = new Uint8Array(t), e.__proto__ = s.prototype) : (null === e && (e = new s(t)), e.length = t), e } function s(e, t, r) { if (!(s.TYPED_ARRAY_SUPPORT || this instanceof s)) return new s(e, t, r); if ("number" == typeof e) { if ("string" == typeof t) throw new Error("If encoding is specified then the first argument must be a string"); return p(this, e) } return i(this, e, t, r) } function i(e, t, r, o) { if ("number" == typeof t) throw new TypeError('"value" argument must not be a number'); return "undefined" != typeof ArrayBuffer && t instanceof ArrayBuffer ? l(e, t, r, o) : "string" == typeof t ? u(e, t, r) : h(e, t) } function a(e) { if ("number" != typeof e) throw new TypeError('"size" argument must be a number'); if (e < 0) throw new RangeError('"size" argument must not be negative') } function g(e, t, r, o) { return a(t), t <= 0 ? n(e, t) : void 0 !== r ? "string" == typeof o ? n(e, t).fill(r, o) : n(e, t).fill(r) : n(e, t) } function p(e, t) { if (a(t), e = n(e, t < 0 ? 0 : 0 | y(t)), !s.TYPED_ARRAY_SUPPORT) for (var r = 0; r < t; ++r)e[r] = 0; return e } function u(e, t, r) { if ("string" == typeof r && "" !== r || (r = "utf8"), !s.isEncoding(r)) throw new TypeError('"encoding" must be a valid string encoding'); var o = 0 | d(t, r); e = n(e, o); var i = e.write(t, r); return i !== o && (e = e.slice(0, i)), e } function c(e, t) { var r = t.length < 0 ? 0 : 0 | y(t.length); e = n(e, r); for (var o = 0; o < r; o += 1)e[o] = 255 & t[o]; return e } function l(e, t, r, o) { if (t.byteLength, r < 0 || t.byteLength < r) throw new RangeError("'offset' is out of bounds"); if (t.byteLength < r + (o || 0)) throw new RangeError("'length' is out of bounds"); return t = void 0 === r && void 0 === o ? new Uint8Array(t) : void 0 === o ? new Uint8Array(t, r) : new Uint8Array(t, r, o), s.TYPED_ARRAY_SUPPORT ? (e = t, e.__proto__ = s.prototype) : e = c(e, t), e } function h(e, t) { if (s.isBuffer(t)) { var r = 0 | y(t.length); return e = n(e, r), 0 === e.length ? e : (t.copy(e, 0, 0, r), e) } if (t) { if ("undefined" != typeof ArrayBuffer && t.buffer instanceof ArrayBuffer || "length" in t) return "number" != typeof t.length || K(t.length) ? n(e, 0) : c(e, t); if ("Buffer" === t.type && q(t.data)) return c(e, t.data) } throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.") } function y(e) { if (e >= o()) throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x" + o().toString(16) + " bytes"); return 0 | e } function f(e) { return +e != e && (e = 0), s.alloc(+e) } function d(e, t) { if (s.isBuffer(e)) return e.length; if ("undefined" != typeof ArrayBuffer && "function" == typeof ArrayBuffer.isView && (ArrayBuffer.isView(e) || e instanceof ArrayBuffer)) return e.byteLength; "string" != typeof e && (e = "" + e); var r = e.length; if (0 === r) return 0; for (var o = !1; ;)switch (t) { case "ascii": case "latin1": case "binary": return r; case "utf8": case "utf-8": case void 0: return H(e).length; case "ucs2": case "ucs-2": case "utf16le": case "utf-16le": return 2 * r; case "hex": return r >>> 1; case "base64": return Y(e).length; default: if (o) return H(e).length; t = ("" + t).toLowerCase(), o = !0 } } function b(e, t, r) { var o = !1; if ((void 0 === t || t < 0) && (t = 0), t > this.length) return ""; if ((void 0 === r || r > this.length) && (r = this.length), r <= 0) return ""; if (r >>>= 0, t >>>= 0, r <= t) return ""; for (e || (e = "utf8"); ;)switch (e) { case "hex": return R(this, t, r); case "utf8": case "utf-8": return B(this, t, r); case "ascii": return I(this, t, r); case "latin1": case "binary": return O(this, t, r); case "base64": return w(this, t, r); case "ucs2": case "ucs-2": case "utf16le": case "utf-16le": return C(this, t, r); default: if (o) throw new TypeError("Unknown encoding: " + e); e = (e + "").toLowerCase(), o = !0 } } function _(e, t, r) { var o = e[t]; e[t] = e[r], e[r] = o } function m(e, t, r, o, n) { if (0 === e.length) return -1; if ("string" == typeof r ? (o = r, r = 0) : r > 2147483647 ? r = 2147483647 : r < -2147483648 && (r = -2147483648), r = +r, isNaN(r) && (r = n ? 0 : e.length - 1), r < 0 && (r = e.length + r), r >= e.length) { if (n) return -1; r = e.length - 1 } else if (r < 0) { if (!n) return -1; r = 0 } if ("string" == typeof t && (t = s.from(t, o)), s.isBuffer(t)) return 0 === t.length ? -1 : E(e, t, r, o, n); if ("number" == typeof t) return t &= 255, s.TYPED_ARRAY_SUPPORT && "function" == typeof Uint8Array.prototype.indexOf ? n ? Uint8Array.prototype.indexOf.call(e, t, r) : Uint8Array.prototype.lastIndexOf.call(e, t, r) : E(e, [t], r, o, n); throw new TypeError("val must be string, number or Buffer") } function E(e, t, r, o, n) { function s(e, t) { return 1 === i ? e[t] : e.readUInt16BE(t * i) } var i = 1, a = e.length, g = t.length; if (void 0 !== o && ("ucs2" === (o = String(o).toLowerCase()) || "ucs-2" === o || "utf16le" === o || "utf-16le" === o)) { if (e.length < 2 || t.length < 2) return -1; i = 2, a /= 2, g /= 2, r /= 2 } var p; if (n) { var u = -1; for (p = r; p < a; p++)if (s(e, p) === s(t, -1 === u ? 0 : p - u)) { if (-1 === u && (u = p), p - u + 1 === g) return u * i } else -1 !== u && (p -= p - u), u = -1 } else for (r + g > a && (r = a - g), p = r; p >= 0; p--) { for (var c = !0, l = 0; l < g; l++)if (s(e, p + l) !== s(t, l)) { c = !1; break } if (c) return p } return -1 } function S(e, t, r, o) { r = Number(r) || 0; var n = e.length - r; o ? (o = Number(o)) > n && (o = n) : o = n; var s = t.length; if (s % 2 != 0) throw new TypeError("Invalid hex string"); o > s / 2 && (o = s / 2); for (var i = 0; i < o; ++i) { var a = parseInt(t.substr(2 * i, 2), 16); if (isNaN(a)) return i; e[r + i] = a } return i } function v(e, t, r, o) { return X(H(t, e.length - r), e, r, o) } function A(e, t, r, o) { return X(z(t), e, r, o) } function j(e, t, r, o) { return A(e, t, r, o) } function M(e, t, r, o) { return X(Y(t), e, r, o) } function T(e, t, r, o) { return X(G(t, e.length - r), e, r, o) } function w(e, t, r) { return 0 === t && r === e.length ? J.fromByteArray(e) : J.fromByteArray(e.slice(t, r)) } function B(e, t, r) { r = Math.min(e.length, r); for (var o = [], n = t; n < r;) { var s = e[n], i = null, a = s > 239 ? 4 : s > 223 ? 3 : s > 191 ? 2 : 1; if (n + a <= r) { var g, p, u, c; switch (a) { case 1: s < 128 && (i = s); break; case 2: g = e[n + 1], 128 == (192 & g) && (c = (31 & s) << 6 | 63 & g) > 127 && (i = c); break; case 3: g = e[n + 1], p = e[n + 2], 128 == (192 & g) && 128 == (192 & p) && (c = (15 & s) << 12 | (63 & g) << 6 | 63 & p) > 2047 && (c < 55296 || c > 57343) && (i = c); break; case 4: g = e[n + 1], p = e[n + 2], u = e[n + 3], 128 == (192 & g) && 128 == (192 & p) && 128 == (192 & u) && (c = (15 & s) << 18 | (63 & g) << 12 | (63 & p) << 6 | 63 & u) > 65535 && c < 1114112 && (i = c) } } null === i ? (i = 65533, a = 1) : i > 65535 && (i -= 65536, o.push(i >>> 10 & 1023 | 55296), i = 56320 | 1023 & i), o.push(i), n += a } return F(o) } function F(e) { var t = e.length; if (t <= Q) return String.fromCharCode.apply(String, e); for (var r = "", o = 0; o < t;)r += String.fromCharCode.apply(String, e.slice(o, o += Q)); return r } function I(e, t, r) { var o = ""; r = Math.min(e.length, r); for (var n = t; n < r; ++n)o += String.fromCharCode(127 & e[n]); return o } function O(e, t, r) { var o = ""; r = Math.min(e.length, r); for (var n = t; n < r; ++n)o += String.fromCharCode(e[n]); return o } function R(e, t, r) { var o = e.length; (!t || t < 0) && (t = 0), (!r || r < 0 || r > o) && (r = o); for (var n = "", s = t; s < r; ++s)n += $(e[s]); return n } function C(e, t, r) { for (var o = e.slice(t, r), n = "", s = 0; s < o.length; s += 2)n += String.fromCharCode(o[s] + 256 * o[s + 1]); return n } function D(e, t, r) { if (e % 1 != 0 || e < 0) throw new RangeError("offset is not uint"); if (e + t > r) throw new RangeError("Trying to access beyond buffer length") } function W(e, t, r, o, n, i) { if (!s.isBuffer(e)) throw new TypeError('"buffer" argument must be a Buffer instance'); if (t > n || t < i) throw new RangeError('"value" argument is out of bounds'); if (r + o > e.length) throw new RangeError("Index out of range") } function N(e, t, r, o) { t < 0 && (t = 65535 + t + 1); for (var n = 0, s = Math.min(e.length - r, 2); n < s; ++n)e[r + n] = (t & 255 << 8 * (o ? n : 1 - n)) >>> 8 * (o ? n : 1 - n) } function L(e, t, r, o) { t < 0 && (t = 4294967295 + t + 1); for (var n = 0, s = Math.min(e.length - r, 4); n < s; ++n)e[r + n] = t >>> 8 * (o ? n : 3 - n) & 255 } function P(e, t, r, o, n, s) { if (r + o > e.length) throw new RangeError("Index out of range"); if (r < 0) throw new RangeError("Index out of range") } function U(e, t, r, o, n) { return n || P(e, t, r, 4, 3.4028234663852886e38, -3.4028234663852886e38), Z.write(e, t, r, o, 23, 4), r + 4 } function x(e, t, r, o, n) { return n || P(e, t, r, 8, 1.7976931348623157e308, -1.7976931348623157e308), Z.write(e, t, r, o, 52, 8), r + 8 } function k(e) { if (e = V(e).replace(ee, ""), e.length < 2) return ""; for (; e.length % 4 != 0;)e += "="; return e } function V(e) { return e.trim ? e.trim() : e.replace(/^\s+|\s+$/g, "") } function $(e) { return e < 16 ? "0" + e.toString(16) : e.toString(16) } function H(e, t) { t = t || 1 / 0; for (var r, o = e.length, n = null, s = [], i = 0; i < o; ++i) { if ((r = e.charCodeAt(i)) > 55295 && r < 57344) { if (!n) { if (r > 56319) { (t -= 3) > -1 && s.push(239, 191, 189); continue } if (i + 1 === o) { (t -= 3) > -1 && s.push(239, 191, 189); continue } n = r; continue } if (r < 56320) { (t -= 3) > -1 && s.push(239, 191, 189), n = r; continue } r = 65536 + (n - 55296 << 10 | r - 56320) } else n && (t -= 3) > -1 && s.push(239, 191, 189); if (n = null, r < 128) { if ((t -= 1) < 0) break; s.push(r) } else if (r < 2048) { if ((t -= 2) < 0) break; s.push(r >> 6 | 192, 63 & r | 128) } else if (r < 65536) { if ((t -= 3) < 0) break; s.push(r >> 12 | 224, r >> 6 & 63 | 128, 63 & r | 128) } else { if (!(r < 1114112)) throw new Error("Invalid code point"); if ((t -= 4) < 0) break; s.push(r >> 18 | 240, r >> 12 & 63 | 128, r >> 6 & 63 | 128, 63 & r | 128) } } return s } function z(e) { for (var t = [], r = 0; r < e.length; ++r)t.push(255 & e.charCodeAt(r)); return t } function G(e, t) { for (var r, o, n, s = [], i = 0; i < e.length && !((t -= 2) < 0); ++i)r = e.charCodeAt(i), o = r >> 8, n = r % 256, s.push(n), s.push(o); return s } function Y(e) { return J.toByteArray(k(e)) } function X(e, t, r, o) { for (var n = 0; n < o && !(n + r >= t.length || n >= e.length); ++n)t[n + r] = e[n]; return n } function K(e) { return e !== e } var J = r(5), Z = r(6), q = r(7); t.Buffer = s, t.SlowBuffer = f, t.INSPECT_MAX_BYTES = 50, s.TYPED_ARRAY_SUPPORT = void 0 !== e.TYPED_ARRAY_SUPPORT ? e.TYPED_ARRAY_SUPPORT : function () { try { var e = new Uint8Array(1); return e.__proto__ = { __proto__: Uint8Array.prototype, foo: function () { return 42 } }, 42 === e.foo() && "function" == typeof e.subarray && 0 === e.subarray(1, 1).byteLength } catch (e) { return !1 } }(), t.kMaxLength = o(), s.poolSize = 8192, s._augment = function (e) { return e.__proto__ = s.prototype, e }, s.from = function (e, t, r) { return i(null, e, t, r) }, s.TYPED_ARRAY_SUPPORT && (s.prototype.__proto__ = Uint8Array.prototype, s.__proto__ = Uint8Array, "undefined" != typeof Symbol && Symbol.species && s[Symbol.species] === s && Object.defineProperty(s, Symbol.species, { value: null, configurable: !0 })), s.alloc = function (e, t, r) { return g(null, e, t, r) }, s.allocUnsafe = function (e) { return p(null, e) }, s.allocUnsafeSlow = function (e) { return p(null, e) }, s.isBuffer = function (e) { return !(null == e || !e._isBuffer) }, s.compare = function (e, t) { if (!s.isBuffer(e) || !s.isBuffer(t)) throw new TypeError("Arguments must be Buffers"); if (e === t) return 0; for (var r = e.length, o = t.length, n = 0, i = Math.min(r, o); n < i; ++n)if (e[n] !== t[n]) { r = e[n], o = t[n]; break } return r < o ? -1 : o < r ? 1 : 0 }, s.isEncoding = function (e) { switch (String(e).toLowerCase()) { case "hex": case "utf8": case "utf-8": case "ascii": case "latin1": case "binary": case "base64": case "ucs2": case "ucs-2": case "utf16le": case "utf-16le": return !0; default: return !1 } }, s.concat = function (e, t) { if (!q(e)) throw new TypeError('"list" argument must be an Array of Buffers'); if (0 === e.length) return s.alloc(0); var r; if (void 0 === t) for (t = 0, r = 0; r < e.length; ++r)t += e[r].length; var o = s.allocUnsafe(t), n = 0; for (r = 0; r < e.length; ++r) { var i = e[r]; if (!s.isBuffer(i)) throw new TypeError('"list" argument must be an Array of Buffers'); i.copy(o, n), n += i.length } return o }, s.byteLength = d, s.prototype._isBuffer = !0, s.prototype.swap16 = function () { var e = this.length; if (e % 2 != 0) throw new RangeError("Buffer size must be a multiple of 16-bits"); for (var t = 0; t < e; t += 2)_(this, t, t + 1); return this }, s.prototype.swap32 = function () { var e = this.length; if (e % 4 != 0) throw new RangeError("Buffer size must be a multiple of 32-bits"); for (var t = 0; t < e; t += 4)_(this, t, t + 3), _(this, t + 1, t + 2); return this }, s.prototype.swap64 = function () { var e = this.length; if (e % 8 != 0) throw new RangeError("Buffer size must be a multiple of 64-bits"); for (var t = 0; t < e; t += 8)_(this, t, t + 7), _(this, t + 1, t + 6), _(this, t + 2, t + 5), _(this, t + 3, t + 4); return this }, s.prototype.toString = function () { var e = 0 | this.length; return 0 === e ? "" : 0 === arguments.length ? B(this, 0, e) : b.apply(this, arguments) }, s.prototype.equals = function (e) { if (!s.isBuffer(e)) throw new TypeError("Argument must be a Buffer"); return this === e || 0 === s.compare(this, e) }, s.prototype.inspect = function () { var e = "", r = t.INSPECT_MAX_BYTES; return this.length > 0 && (e = this.toString("hex", 0, r).match(/.{2}/g).join(" "), this.length > r && (e += " ... ")), "<Buffer " + e + ">" }, s.prototype.compare = function (e, t, r, o, n) { if (!s.isBuffer(e)) throw new TypeError("Argument must be a Buffer"); if (void 0 === t && (t = 0), void 0 === r && (r = e ? e.length : 0), void 0 === o && (o = 0), void 0 === n && (n = this.length), t < 0 || r > e.length || o < 0 || n > this.length) throw new RangeError("out of range index"); if (o >= n && t >= r) return 0; if (o >= n) return -1; if (t >= r) return 1; if (t >>>= 0, r >>>= 0, o >>>= 0, n >>>= 0, this === e) return 0; for (var i = n - o, a = r - t, g = Math.min(i, a), p = this.slice(o, n), u = e.slice(t, r), c = 0; c < g; ++c)if (p[c] !== u[c]) { i = p[c], a = u[c]; break } return i < a ? -1 : a < i ? 1 : 0 }, s.prototype.includes = function (e, t, r) { return -1 !== this.indexOf(e, t, r) }, s.prototype.indexOf = function (e, t, r) { return m(this, e, t, r, !0) }, s.prototype.lastIndexOf = function (e, t, r) { return m(this, e, t, r, !1) }, s.prototype.write = function (e, t, r, o) { if (void 0 === t) o = "utf8", r = this.length, t = 0; else if (void 0 === r && "string" == typeof t) o = t, r = this.length, t = 0; else { if (!isFinite(t)) throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported"); t |= 0, isFinite(r) ? (r |= 0, void 0 === o && (o = "utf8")) : (o = r, r = void 0) } var n = this.length - t; if ((void 0 === r || r > n) && (r = n), e.length > 0 && (r < 0 || t < 0) || t > this.length) throw new RangeError("Attempt to write outside buffer bounds"); o || (o = "utf8"); for (var s = !1; ;)switch (o) { case "hex": return S(this, e, t, r); case "utf8": case "utf-8": return v(this, e, t, r); case "ascii": return A(this, e, t, r); case "latin1": case "binary": return j(this, e, t, r); case "base64": return M(this, e, t, r); case "ucs2": case "ucs-2": case "utf16le": case "utf-16le": return T(this, e, t, r); default: if (s) throw new TypeError("Unknown encoding: " + o); o = ("" + o).toLowerCase(), s = !0 } }, s.prototype.toJSON = function () { return { type: "Buffer", data: Array.prototype.slice.call(this._arr || this, 0) } }; var Q = 4096; s.prototype.slice = function (e, t) { var r = this.length; e = ~~e, t = void 0 === t ? r : ~~t, e < 0 ? (e += r) < 0 && (e = 0) : e > r && (e = r), t < 0 ? (t += r) < 0 && (t = 0) : t > r && (t = r), t < e && (t = e); var o; if (s.TYPED_ARRAY_SUPPORT) o = this.subarray(e, t), o.__proto__ = s.prototype; else { var n = t - e; o = new s(n, void 0); for (var i = 0; i < n; ++i)o[i] = this[i + e] } return o }, s.prototype.readUIntLE = function (e, t, r) { e |= 0, t |= 0, r || D(e, t, this.length); for (var o = this[e], n = 1, s = 0; ++s < t && (n *= 256);)o += this[e + s] * n; return o }, s.prototype.readUIntBE = function (e, t, r) { e |= 0, t |= 0, r || D(e, t, this.length); for (var o = this[e + --t], n = 1; t > 0 && (n *= 256);)o += this[e + --t] * n; return o }, s.prototype.readUInt8 = function (e, t) { return t || D(e, 1, this.length), this[e] }, s.prototype.readUInt16LE = function (e, t) { return t || D(e, 2, this.length), this[e] | this[e + 1] << 8 }, s.prototype.readUInt16BE = function (e, t) { return t || D(e, 2, this.length), this[e] << 8 | this[e + 1] }, s.prototype.readUInt32LE = function (e, t) { return t || D(e, 4, this.length), (this[e] | this[e + 1] << 8 | this[e + 2] << 16) + 16777216 * this[e + 3] }, s.prototype.readUInt32BE = function (e, t) { return t || D(e, 4, this.length), 16777216 * this[e] + (this[e + 1] << 16 | this[e + 2] << 8 | this[e + 3]) }, s.prototype.readIntLE = function (e, t, r) { e |= 0, t |= 0, r || D(e, t, this.length); for (var o = this[e], n = 1, s = 0; ++s < t && (n *= 256);)o += this[e + s] * n; return n *= 128, o >= n && (o -= Math.pow(2, 8 * t)), o }, s.prototype.readIntBE = function (e, t, r) { e |= 0, t |= 0, r || D(e, t, this.length); for (var o = t, n = 1, s = this[e + --o]; o > 0 && (n *= 256);)s += this[e + --o] * n; return n *= 128, s >= n && (s -= Math.pow(2, 8 * t)), s }, s.prototype.readInt8 = function (e, t) { return t || D(e, 1, this.length), 128 & this[e] ? -1 * (255 - this[e] + 1) : this[e] }, s.prototype.readInt16LE = function (e, t) { t || D(e, 2, this.length); var r = this[e] | this[e + 1] << 8; return 32768 & r ? 4294901760 | r : r }, s.prototype.readInt16BE = function (e, t) { t || D(e, 2, this.length); var r = this[e + 1] | this[e] << 8; return 32768 & r ? 4294901760 | r : r }, s.prototype.readInt32LE = function (e, t) { return t || D(e, 4, this.length), this[e] | this[e + 1] << 8 | this[e + 2] << 16 | this[e + 3] << 24 }, s.prototype.readInt32BE = function (e, t) { return t || D(e, 4, this.length), this[e] << 24 | this[e + 1] << 16 | this[e + 2] << 8 | this[e + 3] }, s.prototype.readFloatLE = function (e, t) { return t || D(e, 4, this.length), Z.read(this, e, !0, 23, 4) }, s.prototype.readFloatBE = function (e, t) { return t || D(e, 4, this.length), Z.read(this, e, !1, 23, 4) }, s.prototype.readDoubleLE = function (e, t) { return t || D(e, 8, this.length), Z.read(this, e, !0, 52, 8) }, s.prototype.readDoubleBE = function (e, t) { return t || D(e, 8, this.length), Z.read(this, e, !1, 52, 8) }, s.prototype.writeUIntLE = function (e, t, r, o) { if (e = +e, t |= 0, r |= 0, !o) { W(this, e, t, r, Math.pow(2, 8 * r) - 1, 0) } var n = 1, s = 0; for (this[t] = 255 & e; ++s < r && (n *= 256);)this[t + s] = e / n & 255; return t + r }, s.prototype.writeUIntBE = function (e, t, r, o) { if (e = +e, t |= 0, r |= 0, !o) { W(this, e, t, r, Math.pow(2, 8 * r) - 1, 0) } var n = r - 1, s = 1; for (this[t + n] = 255 & e; --n >= 0 && (s *= 256);)this[t + n] = e / s & 255; return t + r }, s.prototype.writeUInt8 = function (e, t, r) { return e = +e, t |= 0, r || W(this, e, t, 1, 255, 0), s.TYPED_ARRAY_SUPPORT || (e = Math.floor(e)), this[t] = 255 & e, t + 1 }, s.prototype.writeUInt16LE = function (e, t, r) { return e = +e, t |= 0, r || W(this, e, t, 2, 65535, 0), s.TYPED_ARRAY_SUPPORT ? (this[t] = 255 & e, this[t + 1] = e >>> 8) : N(this, e, t, !0), t + 2 }, s.prototype.writeUInt16BE = function (e, t, r) { return e = +e, t |= 0, r || W(this, e, t, 2, 65535, 0), s.TYPED_ARRAY_SUPPORT ? (this[t] = e >>> 8, this[t + 1] = 255 & e) : N(this, e, t, !1), t + 2 }, s.prototype.writeUInt32LE = function (e, t, r) { return e = +e, t |= 0, r || W(this, e, t, 4, 4294967295, 0), s.TYPED_ARRAY_SUPPORT ? (this[t + 3] = e >>> 24, this[t + 2] = e >>> 16, this[t + 1] = e >>> 8, this[t] = 255 & e) : L(this, e, t, !0), t + 4 }, s.prototype.writeUInt32BE = function (e, t, r) { return e = +e, t |= 0, r || W(this, e, t, 4, 4294967295, 0), s.TYPED_ARRAY_SUPPORT ? (this[t] = e >>> 24, this[t + 1] = e >>> 16, this[t + 2] = e >>> 8, this[t + 3] = 255 & e) : L(this, e, t, !1), t + 4 }, s.prototype.writeIntLE = function (e, t, r, o) { if (e = +e, t |= 0, !o) { var n = Math.pow(2, 8 * r - 1); W(this, e, t, r, n - 1, -n) } var s = 0, i = 1, a = 0; for (this[t] = 255 & e; ++s < r && (i *= 256);)e < 0 && 0 === a && 0 !== this[t + s - 1] && (a = 1), this[t + s] = (e / i >> 0) - a & 255; return t + r }, s.prototype.writeIntBE = function (e, t, r, o) { if (e = +e, t |= 0, !o) { var n = Math.pow(2, 8 * r - 1); W(this, e, t, r, n - 1, -n) } var s = r - 1, i = 1, a = 0; for (this[t + s] = 255 & e; --s >= 0 && (i *= 256);)e < 0 && 0 === a && 0 !== this[t + s + 1] && (a = 1), this[t + s] = (e / i >> 0) - a & 255; return t + r }, s.prototype.writeInt8 = function (e, t, r) { return e = +e, t |= 0, r || W(this, e, t, 1, 127, -128), s.TYPED_ARRAY_SUPPORT || (e = Math.floor(e)), e < 0 && (e = 255 + e + 1), this[t] = 255 & e, t + 1 }, s.prototype.writeInt16LE = function (e, t, r) { return e = +e, t |= 0, r || W(this, e, t, 2, 32767, -32768), s.TYPED_ARRAY_SUPPORT ? (this[t] = 255 & e, this[t + 1] = e >>> 8) : N(this, e, t, !0), t + 2 }, s.prototype.writeInt16BE = function (e, t, r) { return e = +e, t |= 0, r || W(this, e, t, 2, 32767, -32768), s.TYPED_ARRAY_SUPPORT ? (this[t] = e >>> 8, this[t + 1] = 255 & e) : N(this, e, t, !1), t + 2 }, s.prototype.writeInt32LE = function (e, t, r) { return e = +e, t |= 0, r || W(this, e, t, 4, 2147483647, -2147483648), s.TYPED_ARRAY_SUPPORT ? (this[t] = 255 & e, this[t + 1] = e >>> 8, this[t + 2] = e >>> 16, this[t + 3] = e >>> 24) : L(this, e, t, !0), t + 4 }, s.prototype.writeInt32BE = function (e, t, r) { return e = +e, t |= 0, r || W(this, e, t, 4, 2147483647, -2147483648), e < 0 && (e = 4294967295 + e + 1), s.TYPED_ARRAY_SUPPORT ? (this[t] = e >>> 24, this[t + 1] = e >>> 16, this[t + 2] = e >>> 8, this[t + 3] = 255 & e) : L(this, e, t, !1), t + 4 }, s.prototype.writeFloatLE = function (e, t, r) { return U(this, e, t, !0, r) }, s.prototype.writeFloatBE = function (e, t, r) { return U(this, e, t, !1, r) }, s.prototype.writeDoubleLE = function (e, t, r) { return x(this, e, t, !0, r) }, s.prototype.writeDoubleBE = function (e, t, r) { return x(this, e, t, !1, r) }, s.prototype.copy = function (e, t, r, o) { if (r || (r = 0), o || 0 === o || (o = this.length), t >= e.length && (t = e.length), t || (t = 0), o > 0 && o < r && (o = r), o === r) return 0; if (0 === e.length || 0 === this.length) return 0; if (t < 0) throw new RangeError("targetStart out of bounds"); if (r < 0 || r >= this.length) throw new RangeError("sourceStart out of bounds"); if (o < 0) throw new RangeError("sourceEnd out of bounds"); o > this.length && (o = this.length), e.length - t < o - r && (o = e.length - t + r); var n, i = o - r; if (this === e && r < t && t < o) for (n = i - 1; n >= 0; --n)e[n + t] = this[n + r]; else if (i < 1e3 || !s.TYPED_ARRAY_SUPPORT) for (n = 0; n < i; ++n)e[n + t] = this[n + r]; else Uint8Array.prototype.set.call(e, this.subarray(r, r + i), t); return i }, s.prototype.fill = function (e, t, r, o) { if ("string" == typeof e) { if ("string" == typeof t ? (o = t, t = 0, r = this.length) : "string" == typeof r && (o = r, r = this.length), 1 === e.length) { var n = e.charCodeAt(0); n < 256 && (e = n) } if (void 0 !== o && "string" != typeof o) throw new TypeError("encoding must be a string"); if ("string" == typeof o && !s.isEncoding(o)) throw new TypeError("Unknown encoding: " + o) } else "number" == typeof e && (e &= 255); if (t < 0 || this.length < t || this.length < r) throw new RangeError("Out of range index"); if (r <= t) return this; t >>>= 0, r = void 0 === r ? this.length : r >>> 0, e || (e = 0); var i; if ("number" == typeof e) for (i = t; i < r; ++i)this[i] = e; else { var a = s.isBuffer(e) ? e : H(new s(e, o).toString()), g = a.length; for (i = 0; i < r - t; ++i)this[i + t] = a[i % g] } return this }; var ee = /[^+\/0-9A-Za-z-_]/g }).call(t, r(0)) }, function (e, t, r) { "use strict"; function o(e) { var t = e.length; if (t % 4 > 0) throw new Error("Invalid string. Length must be a multiple of 4"); var r = e.indexOf("="); return -1 === r && (r = t), [r, r === t ? 0 : 4 - r % 4] } function n(e) { var t = o(e), r = t[0], n = t[1]; return 3 * (r + n) / 4 - n } function s(e, t, r) { return 3 * (t + r) / 4 - r } function i(e) { for (var t, r = o(e), n = r[0], i = r[1], a = new l(s(e, n, i)), g = 0, p = i > 0 ? n - 4 : n, u = 0; u < p; u += 4)t = c[e.charCodeAt(u)] << 18 | c[e.charCodeAt(u + 1)] << 12 | c[e.charCodeAt(u + 2)] << 6 | c[e.charCodeAt(u + 3)], a[g++] = t >> 16 & 255, a[g++] = t >> 8 & 255, a[g++] = 255 & t; return 2 === i && (t = c[e.charCodeAt(u)] << 2 | c[e.charCodeAt(u + 1)] >> 4, a[g++] = 255 & t), 1 === i && (t = c[e.charCodeAt(u)] << 10 | c[e.charCodeAt(u + 1)] << 4 | c[e.charCodeAt(u + 2)] >> 2, a[g++] = t >> 8 & 255, a[g++] = 255 & t), a } function a(e) { return u[e >> 18 & 63] + u[e >> 12 & 63] + u[e >> 6 & 63] + u[63 & e] } function g(e, t, r) { for (var o, n = [], s = t; s < r; s += 3)o = (e[s] << 16 & 16711680) + (e[s + 1] << 8 & 65280) + (255 & e[s + 2]), n.push(a(o)); return n.join("") } function p(e) { for (var t, r = e.length, o = r % 3, n = [], s = 0, i = r - o; s < i; s += 16383)n.push(g(e, s, s + 16383 > i ? i : s + 16383)); return 1 === o ? (t = e[r - 1], n.push(u[t >> 2] + u[t << 4 & 63] + "==")) : 2 === o && (t = (e[r - 2] << 8) + e[r - 1], n.push(u[t >> 10] + u[t >> 4 & 63] + u[t << 2 & 63] + "=")), n.join("") } t.byteLength = n, t.toByteArray = i, t.fromByteArray = p; for (var u = [], c = [], l = "undefined" != typeof Uint8Array ? Uint8Array : Array, h = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", y = 0, f = h.length; y < f; ++y)u[y] = h[y], c[h.charCodeAt(y)] = y; c["-".charCodeAt(0)] = 62, c["_".charCodeAt(0)] = 63 }, function (e, t) { t.read = function (e, t, r, o, n) { var s, i, a = 8 * n - o - 1, g = (1 << a) - 1, p = g >> 1, u = -7, c = r ? n - 1 : 0, l = r ? -1 : 1, h = e[t + c]; for (c += l, s = h & (1 << -u) - 1, h >>= -u, u += a; u > 0; s = 256 * s + e[t + c], c += l, u -= 8); for (i = s & (1 << -u) - 1, s >>= -u, u += o; u > 0; i = 256 * i + e[t + c], c += l, u -= 8); if (0 === s) s = 1 - p; else { if (s === g) return i ? NaN : 1 / 0 * (h ? -1 : 1); i += Math.pow(2, o), s -= p } return (h ? -1 : 1) * i * Math.pow(2, s - o) }, t.write = function (e, t, r, o, n, s) { var i, a, g, p = 8 * s - n - 1, u = (1 << p) - 1, c = u >> 1, l = 23 === n ? Math.pow(2, -24) - Math.pow(2, -77) : 0, h = o ? 0 : s - 1, y = o ? 1 : -1, f = t < 0 || 0 === t && 1 / t < 0 ? 1 : 0; for (t = Math.abs(t), isNaN(t) || t === 1 / 0 ? (a = isNaN(t) ? 1 : 0, i = u) : (i = Math.floor(Math.log(t) / Math.LN2), t * (g = Math.pow(2, -i)) < 1 && (i-- , g *= 2), t += i + c >= 1 ? l / g : l * Math.pow(2, 1 - c), t * g >= 2 && (i++ , g /= 2), i + c >= u ? (a = 0, i = u) : i + c >= 1 ? (a = (t * g - 1) * Math.pow(2, n), i += c) : (a = t * Math.pow(2, c - 1) * Math.pow(2, n), i = 0)); n >= 8; e[r + h] = 255 & a, h += y, a /= 256, n -= 8); for (i = i << n | a, p += n; p > 0; e[r + h] = 255 & i, h += y, i /= 256, p -= 8); e[r + h - y] |= 128 * f } }, function (e, t) { var r = {}.toString; e.exports = Array.isArray || function (e) { return "[object Array]" == r.call(e) } }]);
