/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.indices.cache.query.terms.TermsLookup;
import org.elasticsearch.search.internal.SearchContext;

public class TermsQueryParser
implements QueryParser {
    public static final String NAME = "terms";
    private static final ParseField MIN_SHOULD_MATCH_FIELD = new ParseField("min_match", "min_should_match").withAllDeprecated("Use [bool] query instead");
    private static final ParseField DISABLE_COORD_FIELD = new ParseField("disable_coord", new String[0]).withAllDeprecated("Use [bool] query instead");
    private static final ParseField EXECUTION_FIELD = new ParseField("execution", new String[0]).withAllDeprecated("execution is deprecated and has no effect");
    private Client client;

    @Inject
    public TermsQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "in"};
    }

    @Inject(optional=true)
    public void setClient(Client client) {
        this.client = client;
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String queryName = null;
        String currentFieldName = null;
        String lookupIndex = parseContext.index().name();
        String lookupType = null;
        String lookupId = null;
        String lookupPath = null;
        String lookupRouting = null;
        String minShouldMatch = null;
        boolean disableCoord = false;
        ArrayList<Object> terms = new ArrayList<Object>();
        String fieldName = null;
        float boost = 1.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_ARRAY) {
                if (fieldName != null) {
                    throw new QueryParsingException(parseContext, "[terms] query does not support multiple fields", new Object[0]);
                }
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    Object value = parser.objectBytes();
                    if (value == null) {
                        throw new QueryParsingException(parseContext, "No value specified for terms query", new Object[0]);
                    }
                    terms.add(value);
                }
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if ("index".equals(currentFieldName)) {
                        lookupIndex = parser.text();
                        continue;
                    }
                    if ("type".equals(currentFieldName)) {
                        lookupType = parser.text();
                        continue;
                    }
                    if ("id".equals(currentFieldName)) {
                        lookupId = parser.text();
                        continue;
                    }
                    if ("path".equals(currentFieldName)) {
                        lookupPath = parser.text();
                        continue;
                    }
                    if ("routing".equals(currentFieldName)) {
                        lookupRouting = parser.textOrNull();
                        continue;
                    }
                    throw new QueryParsingException(parseContext, "[terms] query does not support [" + currentFieldName + "] within lookup element", new Object[0]);
                }
                if (lookupType == null) {
                    throw new QueryParsingException(parseContext, "[terms] query lookup element requires specifying the type", new Object[0]);
                }
                if (lookupId == null) {
                    throw new QueryParsingException(parseContext, "[terms] query lookup element requires specifying the id", new Object[0]);
                }
                if (lookupPath != null) continue;
                throw new QueryParsingException(parseContext, "[terms] query lookup element requires specifying the path", new Object[0]);
            }
            if (!token.isValue() || parseContext.parseFieldMatcher().match(currentFieldName, EXECUTION_FIELD)) continue;
            if (parseContext.parseFieldMatcher().match(currentFieldName, MIN_SHOULD_MATCH_FIELD)) {
                if (minShouldMatch != null) {
                    throw new IllegalArgumentException("[" + currentFieldName + "] is not allowed in a filter context for the [" + NAME + "] query");
                }
                minShouldMatch = parser.textOrNull();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, DISABLE_COORD_FIELD)) {
                disableCoord = parser.booleanValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[terms] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldName == null) {
            throw new QueryParsingException(parseContext, "terms query requires a field name, followed by array of terms", new Object[0]);
        }
        MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
        if (fieldType != null) {
            fieldName = fieldType.names().indexName();
        }
        if (lookupId != null) {
            TermsLookup lookup = new TermsLookup(lookupIndex, lookupType, lookupId, lookupRouting, lookupPath, parseContext);
            GetRequest getRequest = new GetRequest(lookup.getIndex(), lookup.getType(), lookup.getId()).preference("_local").routing(lookup.getRouting());
            getRequest.copyContextAndHeadersFrom(SearchContext.current());
            GetResponse getResponse = this.client.get(getRequest).actionGet();
            if (getResponse.isExists()) {
                List<Object> list = XContentMapValues.extractRawValues(lookup.getPath(), getResponse.getSourceAsMap());
                terms.addAll(list);
            }
        }
        if (terms.isEmpty()) {
            return Queries.newMatchNoDocsQuery();
        }
        if (parseContext.isFilter()) {
            if (fieldType != null) {
                query = fieldType.termsQuery(terms, parseContext);
            } else {
                BytesRef[] filterValues = new BytesRef[terms.size()];
                for (int i = 0; i < filterValues.length; ++i) {
                    filterValues[i] = BytesRefs.toBytesRef(terms.get(i));
                }
                query = new TermsQuery(fieldName, filterValues);
            }
        } else {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.setDisableCoord(disableCoord);
            for (Object e : terms) {
                if (fieldType != null) {
                    bq.add(fieldType.termQuery(e, parseContext), BooleanClause.Occur.SHOULD);
                    continue;
                }
                bq.add((Query)new TermQuery(new Term(fieldName, BytesRefs.toBytesRef(e))), BooleanClause.Occur.SHOULD);
            }
            query = Queries.applyMinimumShouldMatch(bq.build(), minShouldMatch);
        }
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

