/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketscript;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketscript.BucketScriptParser;
import org.elasticsearch.search.aggregations.pipeline.bucketscript.BucketScriptPipelineAggregator;

public class BucketScriptBuilder
extends PipelineAggregatorBuilder<BucketScriptBuilder> {
    private String format;
    private BucketHelpers.GapPolicy gapPolicy;
    private Script script;
    private Map<String, String> bucketsPathsMap;

    public BucketScriptBuilder(String name) {
        super(name, BucketScriptPipelineAggregator.TYPE.name());
    }

    public BucketScriptBuilder script(Script script) {
        this.script = script;
        return this;
    }

    public BucketScriptBuilder format(String format) {
        this.format = format;
        return this;
    }

    public BucketScriptBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketScriptBuilder setBucketsPathsMap(Map<String, String> bucketsPathsMap) {
        this.bucketsPathsMap = bucketsPathsMap;
        return this;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        if (this.script != null) {
            builder.field(Script.ScriptField.SCRIPT.getPreferredName(), this.script);
        }
        if (this.format != null) {
            builder.field(BucketScriptParser.FORMAT.getPreferredName(), this.format);
        }
        if (this.gapPolicy != null) {
            builder.field(BucketScriptParser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        }
        if (this.bucketsPathsMap != null) {
            builder.field(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName(), (Object)this.bucketsPathsMap);
        }
        return builder;
    }
}

