/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.MultiTermQueryConstantScoreWrapper;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.FrequencyTrackingRingBuffer;

public final class XUsageTrackingQueryCachingPolicy
implements QueryCachingPolicy {
    private static final int SENTINEL = Integer.MIN_VALUE;
    private final QueryCachingPolicy.CacheOnLargeSegments segmentPolicy;
    private final FrequencyTrackingRingBuffer recentlyUsedFilters;

    static boolean isCostly(Query query) {
        return query instanceof MultiTermQuery || query instanceof MultiTermQueryConstantScoreWrapper || query instanceof TermsQuery;
    }

    static boolean isCheap(Query query) {
        return query instanceof TermQuery;
    }

    public XUsageTrackingQueryCachingPolicy(int minIndexSize, float minSizeRatio, int historySize) {
        this(new QueryCachingPolicy.CacheOnLargeSegments(minIndexSize, minSizeRatio), historySize);
    }

    public XUsageTrackingQueryCachingPolicy() {
        this(QueryCachingPolicy.CacheOnLargeSegments.DEFAULT, 256);
    }

    private XUsageTrackingQueryCachingPolicy(QueryCachingPolicy.CacheOnLargeSegments segmentPolicy, int historySize) {
        this.segmentPolicy = segmentPolicy;
        this.recentlyUsedFilters = new FrequencyTrackingRingBuffer(historySize, Integer.MIN_VALUE);
    }

    protected int minFrequencyToCache(Query query) {
        if (XUsageTrackingQueryCachingPolicy.isCostly(query)) {
            return 2;
        }
        if (XUsageTrackingQueryCachingPolicy.isCheap(query)) {
            return 20;
        }
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUse(Query query) {
        assert (!(query instanceof BoostQuery));
        assert (!(query instanceof ConstantScoreQuery));
        int hashCode = query.hashCode();
        XUsageTrackingQueryCachingPolicy xUsageTrackingQueryCachingPolicy = this;
        synchronized (xUsageTrackingQueryCachingPolicy) {
            this.recentlyUsedFilters.add(hashCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int frequency(Query query) {
        assert (!(query instanceof BoostQuery));
        assert (!(query instanceof ConstantScoreQuery));
        int hashCode = query.hashCode();
        XUsageTrackingQueryCachingPolicy xUsageTrackingQueryCachingPolicy = this;
        synchronized (xUsageTrackingQueryCachingPolicy) {
            return this.recentlyUsedFilters.frequency(hashCode);
        }
    }

    public boolean shouldCache(Query query, LeafReaderContext context) throws IOException {
        int minFrequency;
        DisjunctionMaxQuery dmq;
        BooleanQuery bq;
        if (query instanceof MatchAllDocsQuery || query instanceof MatchNoDocsQuery) {
            return false;
        }
        if (query instanceof BooleanQuery && (bq = (BooleanQuery)query).clauses().isEmpty()) {
            return false;
        }
        if (query instanceof DisjunctionMaxQuery && (dmq = (DisjunctionMaxQuery)query).getDisjuncts().isEmpty()) {
            return false;
        }
        if (!this.segmentPolicy.shouldCache(query, context)) {
            return false;
        }
        int frequency = this.frequency(query);
        return frequency >= (minFrequency = this.minFrequencyToCache(query));
    }
}

