/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.plugins.PluginInfo;

public class PluginsAndModules
implements Streamable,
ToXContent {
    private List<PluginInfo> plugins = new ArrayList<PluginInfo>();
    private List<PluginInfo> modules = new ArrayList<PluginInfo>();

    public List<PluginInfo> getPluginInfos() {
        ArrayList<PluginInfo> plugins = new ArrayList<PluginInfo>(this.plugins);
        Collections.sort(plugins, new Comparator<PluginInfo>(){

            @Override
            public int compare(PluginInfo p1, PluginInfo p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        return plugins;
    }

    public List<PluginInfo> getModuleInfos() {
        ArrayList<PluginInfo> modules = new ArrayList<PluginInfo>(this.modules);
        Collections.sort(modules, new Comparator<PluginInfo>(){

            @Override
            public int compare(PluginInfo p1, PluginInfo p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        return modules;
    }

    public void addPlugin(PluginInfo info) {
        this.plugins.add(info);
    }

    public void addModule(PluginInfo info) {
        this.modules.add(info);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (!this.plugins.isEmpty() || !this.modules.isEmpty()) {
            throw new IllegalStateException("instance is already populated");
        }
        int plugins_size = in.readInt();
        for (int i = 0; i < plugins_size; ++i) {
            this.plugins.add(PluginInfo.readFromStream(in));
        }
        if (in.getVersion().onOrAfter(Version.V_2_2_0)) {
            int modules_size = in.readInt();
            for (int i = 0; i < modules_size; ++i) {
                this.modules.add(PluginInfo.readFromStream(in));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_2_2_0)) {
            out.writeInt(this.plugins.size() + this.modules.size());
            for (PluginInfo plugin : this.getPluginInfos()) {
                plugin.writeTo(out);
            }
            for (PluginInfo module : this.getModuleInfos()) {
                module.writeTo(out);
            }
        } else {
            out.writeInt(this.plugins.size());
            for (PluginInfo plugin : this.getPluginInfos()) {
                plugin.writeTo(out);
            }
            out.writeInt(this.modules.size());
            for (PluginInfo module : this.getModuleInfos()) {
                module.writeTo(out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("plugins");
        for (PluginInfo pluginInfo : this.getPluginInfos()) {
            pluginInfo.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray("modules");
        for (PluginInfo moduleInfo : this.getModuleInfos()) {
            moduleInfo.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

