/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class SnapshotShardsStats
implements ToXContent {
    private int initializingShards;
    private int startedShards;
    private int finalizingShards;
    private int doneShards;
    private int failedShards;
    private int totalShards;

    SnapshotShardsStats(Collection<SnapshotIndexShardStatus> shards) {
        block7: for (SnapshotIndexShardStatus shard : shards) {
            ++this.totalShards;
            switch (shard.getStage()) {
                case INIT: {
                    ++this.initializingShards;
                    continue block7;
                }
                case STARTED: {
                    ++this.startedShards;
                    continue block7;
                }
                case FINALIZE: {
                    ++this.finalizingShards;
                    continue block7;
                }
                case DONE: {
                    ++this.doneShards;
                    continue block7;
                }
                case FAILURE: {
                    ++this.failedShards;
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unknown stage type " + (Object)((Object)shard.getStage()));
        }
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getStartedShards() {
        return this.startedShards;
    }

    public int getFinalizingShards() {
        return this.finalizingShards;
    }

    public int getDoneShards() {
        return this.doneShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.SHARDS_STATS);
        builder.field(Fields.INITIALIZING, this.getInitializingShards());
        builder.field(Fields.STARTED, this.getStartedShards());
        builder.field(Fields.FINALIZING, this.getFinalizingShards());
        builder.field(Fields.DONE, this.getDoneShards());
        builder.field(Fields.FAILED, this.getFailedShards());
        builder.field(Fields.TOTAL, this.getTotalShards());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString SHARDS_STATS = new XContentBuilderString("shards_stats");
        static final XContentBuilderString INITIALIZING = new XContentBuilderString("initializing");
        static final XContentBuilderString STARTED = new XContentBuilderString("started");
        static final XContentBuilderString FINALIZING = new XContentBuilderString("finalizing");
        static final XContentBuilderString DONE = new XContentBuilderString("done");
        static final XContentBuilderString FAILED = new XContentBuilderString("failed");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");

        Fields() {
        }
    }
}

