/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class AcknowledgedRequest<T extends MasterNodeRequest<T>>
extends MasterNodeRequest<T>
implements AckedRequest {
    public static final TimeValue DEFAULT_ACK_TIMEOUT = TimeValue.timeValueSeconds(30L);
    protected TimeValue timeout = DEFAULT_ACK_TIMEOUT;

    protected AcknowledgedRequest() {
    }

    protected AcknowledgedRequest(ActionRequest request) {
        super(request);
    }

    public final T timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, this.timeout, this.getClass().getSimpleName() + ".timeout");
        return (T)this;
    }

    public final T timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public final TimeValue timeout() {
        return this.timeout;
    }

    protected void readTimeout(StreamInput in) throws IOException {
        this.timeout = TimeValue.readTimeValue(in);
    }

    protected void writeTimeout(StreamOutput out) throws IOException {
        this.timeout.writeTo(out);
    }

    @Override
    public TimeValue ackTimeout() {
        return this.timeout;
    }
}

