/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors.dfs;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.action.termvectors.dfs.DfsOnlyRequest;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;

public class ShardDfsOnlyRequest
extends BroadcastShardRequest {
    private ShardSearchTransportRequest shardSearchRequest = new ShardSearchTransportRequest();

    public ShardDfsOnlyRequest() {
    }

    ShardDfsOnlyRequest(ShardRouting shardRouting, int numberOfShards, @Nullable String[] filteringAliases, long nowInMillis, DfsOnlyRequest request) {
        super(shardRouting.shardId(), request);
        this.shardSearchRequest = new ShardSearchTransportRequest(request.getSearchRequest(), shardRouting, numberOfShards, filteringAliases, nowInMillis);
    }

    public ShardSearchRequest getShardSearchRequest() {
        return this.shardSearchRequest;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardSearchRequest.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardSearchRequest.writeTo(out);
    }
}

