/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.util.concurrent.TimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.node.settings.NodeSettingsService;

public class MappingUpdatedAction
extends AbstractComponent {
    public static final String INDICES_MAPPING_DYNAMIC_TIMEOUT = "indices.mapping.dynamic_timeout";
    private IndicesAdminClient client;
    private volatile TimeValue dynamicMappingUpdateTimeout;

    @Inject
    public MappingUpdatedAction(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.dynamicMappingUpdateTimeout = settings.getAsTime(INDICES_MAPPING_DYNAMIC_TIMEOUT, TimeValue.timeValueSeconds(30L));
        nodeSettingsService.addListener(new ApplySettings());
    }

    public void setClient(Client client) {
        this.client = client.admin().indices();
    }

    private PutMappingRequestBuilder updateMappingRequest(String index, String type, Mapping mappingUpdate, TimeValue timeout) {
        if (type.equals("_default_")) {
            throw new IllegalArgumentException("_default_ mapping should not be updated");
        }
        return (PutMappingRequestBuilder)((PutMappingRequestBuilder)this.client.preparePutMapping(index).setType(type).setSource(mappingUpdate.toString()).setMasterNodeTimeout(timeout)).setTimeout(timeout);
    }

    public void updateMappingOnMaster(String index, String type, Mapping mappingUpdate, final TimeValue timeout, final MappingUpdateListener listener) {
        PutMappingRequestBuilder request = this.updateMappingRequest(index, type, mappingUpdate, timeout);
        if (listener == null) {
            request.execute();
        } else {
            ActionListener<PutMappingResponse> actionListener = new ActionListener<PutMappingResponse>(){

                @Override
                public void onResponse(PutMappingResponse response) {
                    if (response.isAcknowledged()) {
                        listener.onMappingUpdate();
                    } else {
                        listener.onFailure(new TimeoutException("Failed to acknowledge the mapping response within [" + timeout + "]"));
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    listener.onFailure(e);
                }
            };
            request.execute(actionListener);
        }
    }

    public void updateMappingOnMasterAsynchronously(String index, String type, Mapping mappingUpdate) throws Throwable {
        this.updateMappingOnMaster(index, type, mappingUpdate, this.dynamicMappingUpdateTimeout, null);
    }

    public void updateMappingOnMasterSynchronously(String index, String type, Mapping mappingUpdate) throws Throwable {
        this.updateMappingOnMasterSynchronously(index, type, mappingUpdate, this.dynamicMappingUpdateTimeout);
    }

    public void updateMappingOnMasterSynchronously(String index, String type, Mapping mappingUpdate, TimeValue timeout) throws Throwable {
        if (!((PutMappingResponse)this.updateMappingRequest(index, type, mappingUpdate, timeout).get()).isAcknowledged()) {
            throw new TimeoutException("Failed to acknowledge mapping update within [" + timeout + "]");
        }
    }

    public static interface MappingUpdateListener {
        public void onMappingUpdate();

        public void onFailure(Throwable var1);
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue newValue;
            TimeValue current = MappingUpdatedAction.this.dynamicMappingUpdateTimeout;
            if (!current.equals(newValue = settings.getAsTime(MappingUpdatedAction.INDICES_MAPPING_DYNAMIC_TIMEOUT, current))) {
                MappingUpdatedAction.this.logger.info("updating indices.mapping.dynamic_timeout from [{}] to [{}]", current, newValue);
                MappingUpdatedAction.this.dynamicMappingUpdateTimeout = newValue;
            }
        }
    }
}

