/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.common.inject.Initializable;
import org.elasticsearch.common.inject.Initializables;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.MembersInjectorImpl;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.spi.InjectionPoint;

class Initializer {
    private final Thread creatingThread = Thread.currentThread();
    private final CountDownLatch ready = new CountDownLatch(1);
    private final Map<Object, InjectableReference<?>> pendingInjection = Maps.newIdentityHashMap();

    Initializer() {
    }

    public <T> Initializable<T> requestInjection(InjectorImpl injector, T instance, Object source, Set<InjectionPoint> injectionPoints) {
        Preconditions.checkNotNull((Object)source);
        if (instance == null || injectionPoints.isEmpty() && !injector.membersInjectorStore.hasTypeListeners()) {
            return Initializables.of(instance);
        }
        InjectableReference<T> initializable = new InjectableReference<T>(injector, instance, source);
        this.pendingInjection.put(instance, initializable);
        return initializable;
    }

    void validateOustandingInjections(Errors errors) {
        for (InjectableReference<?> reference : this.pendingInjection.values()) {
            try {
                reference.validate(errors);
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
        }
    }

    void injectAll(Errors errors) {
        for (InjectableReference<?> reference : new ArrayList(this.pendingInjection.values())) {
            try {
                reference.get(errors);
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
        }
        if (!this.pendingInjection.isEmpty()) {
            throw new AssertionError((Object)("Failed to satisfy " + this.pendingInjection));
        }
        this.ready.countDown();
    }

    private class InjectableReference<T>
    implements Initializable<T> {
        private final InjectorImpl injector;
        private final T instance;
        private final Object source;
        private MembersInjectorImpl<T> membersInjector;

        public InjectableReference(InjectorImpl injector, T instance, Object source) {
            this.injector = injector;
            this.instance = Preconditions.checkNotNull(instance, (Object)"instance");
            this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
        }

        public void validate(Errors errors) throws ErrorsException {
            TypeLiteral<?> type = TypeLiteral.get(this.instance.getClass());
            this.membersInjector = this.injector.membersInjectorStore.get(type, errors.withSource(this.source));
        }

        @Override
        public T get(Errors errors) throws ErrorsException {
            if (Initializer.this.ready.getCount() == 0L) {
                return this.instance;
            }
            if (Thread.currentThread() != Initializer.this.creatingThread) {
                try {
                    Initializer.this.ready.await();
                    return this.instance;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (Initializer.this.pendingInjection.remove(this.instance) != null) {
                this.membersInjector.injectAndNotify(this.instance, errors.withSource(this.source));
            }
            return this.instance;
        }

        public String toString() {
            return this.instance.toString();
        }
    }
}

