/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.discovery.zen.ping.PingContextProvider;
import org.elasticsearch.discovery.zen.ping.ZenPing;

public class ZenPingService
extends AbstractLifecycleComponent<ZenPing>
implements ZenPing {
    private List<ZenPing> zenPings = Collections.emptyList();

    @Inject
    public ZenPingService(Settings settings, Set<ZenPing> zenPings) {
        super(settings);
        this.zenPings = Collections.unmodifiableList(new ArrayList<ZenPing>(zenPings));
    }

    public List<ZenPing> zenPings() {
        return this.zenPings;
    }

    @Override
    public void setPingContextProvider(PingContextProvider contextProvider) {
        if (this.lifecycle.started()) {
            throw new IllegalStateException("Can't set nodes provider when started");
        }
        for (ZenPing zenPing : this.zenPings) {
            zenPing.setPingContextProvider(contextProvider);
        }
    }

    @Override
    protected void doStart() {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.start();
        }
    }

    @Override
    protected void doStop() {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.stop();
        }
    }

    @Override
    protected void doClose() {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.close();
        }
    }

    public ZenPing.PingResponse[] pingAndWait(TimeValue timeout) {
        final AtomicReference response = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.ping(new ZenPing.PingListener(){

            @Override
            public void onPing(ZenPing.PingResponse[] pings) {
                response.set(pings);
                latch.countDown();
            }
        }, timeout);
        try {
            latch.await();
            return (ZenPing.PingResponse[])response.get();
        }
        catch (InterruptedException e) {
            this.logger.trace("pingAndWait interrupted", new Object[0]);
            return null;
        }
    }

    @Override
    public void ping(ZenPing.PingListener listener, TimeValue timeout) {
        List<ZenPing> zenPings = this.zenPings;
        CompoundPingListener compoundPingListener = new CompoundPingListener(listener, zenPings);
        for (ZenPing zenPing : zenPings) {
            try {
                zenPing.ping(compoundPingListener, timeout);
            }
            catch (EsRejectedExecutionException ex) {
                this.logger.debug("Ping execution rejected", ex, new Object[0]);
                compoundPingListener.onPing(null);
            }
        }
    }

    private static class CompoundPingListener
    implements ZenPing.PingListener {
        private final ZenPing.PingListener listener;
        private final AtomicInteger counter;
        private ZenPing.PingCollection responses = new ZenPing.PingCollection();

        private CompoundPingListener(ZenPing.PingListener listener, List<? extends ZenPing> zenPings) {
            this.listener = listener;
            this.counter = new AtomicInteger(zenPings.size());
        }

        @Override
        public void onPing(ZenPing.PingResponse[] pings) {
            if (pings != null) {
                this.responses.addPings(pings);
            }
            if (this.counter.decrementAndGet() == 0) {
                this.listener.onPing(this.responses.toArray());
            }
        }
    }
}

