/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ExtensionPoint;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.cache.query.index.IndexQueryCache;
import org.elasticsearch.index.cache.query.none.NoneQueryCache;

public class IndexCacheModule
extends AbstractModule {
    public static final String INDEX_QUERY_CACHE = "index";
    public static final String NONE_QUERY_CACHE = "none";
    public static final String QUERY_CACHE_TYPE = "index.queries.cache.type";
    public static final String QUERY_CACHE_EVERYTHING = "index.queries.cache.everything";
    public static final String QUERY_CACHE_TERM_QUERIES = "index.queries.cache.term_queries";
    private final Settings indexSettings;
    private final ExtensionPoint.SelectedType<QueryCache> queryCaches;

    public IndexCacheModule(Settings settings) {
        this.indexSettings = settings;
        this.queryCaches = new ExtensionPoint.SelectedType<QueryCache>("query_cache", QueryCache.class);
        this.registerQueryCache(INDEX_QUERY_CACHE, IndexQueryCache.class);
        this.registerQueryCache(NONE_QUERY_CACHE, NoneQueryCache.class);
    }

    public void registerQueryCache(String name, Class<? extends QueryCache> clazz) {
        this.queryCaches.registerExtension(name, clazz);
    }

    @Override
    protected void configure() {
        this.queryCaches.bindType(this.binder(), this.indexSettings, QUERY_CACHE_TYPE, INDEX_QUERY_CACHE);
        this.bind(BitsetFilterCache.class).asEagerSingleton();
        this.bind(IndexCache.class).asEagerSingleton();
    }
}

