/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.mapper.internal.IdFieldMapper;
import org.elasticsearch.index.mapper.internal.IndexFieldMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.mapper.internal.RoutingFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.mapper.internal.TTLFieldMapper;
import org.elasticsearch.index.mapper.internal.TimestampFieldMapper;
import org.elasticsearch.index.mapper.internal.TypeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.SearchContext;

public class DocumentMapper
implements ToXContent {
    private final MapperService mapperService;
    private final String type;
    private final Text typeText;
    private final CompressedXContent mappingSource;
    private final Mapping mapping;
    private final DocumentParser documentParser;
    private final DocumentFieldMappers fieldMappers;
    private final Map<String, ObjectMapper> objectMappers;
    private final boolean hasNestedObjects;

    public DocumentMapper(MapperService mapperService, Mapping mapping) {
        this.mapperService = mapperService;
        this.type = mapping.root().name();
        this.typeText = new Text(this.type);
        this.mapping = mapping;
        this.documentParser = new DocumentParser(mapperService.indexSettings(), mapperService.documentMapperParser(), this);
        if (this.metadataMapper(ParentFieldMapper.class).active()) {
            this.metadataMapper(RoutingFieldMapper.class).markAsRequired();
        }
        ArrayList<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
        for (MetadataFieldMapper metadataMapper : this.mapping.metadataMappers) {
            if (!(metadataMapper instanceof FieldMapper)) continue;
            newFieldMappers.add(metadataMapper);
        }
        MapperUtils.collect(this.mapping.root, newObjectMappers, newFieldMappers);
        AnalysisService analysisService = mapperService.analysisService();
        this.fieldMappers = new DocumentFieldMappers(newFieldMappers, (Analyzer)analysisService.defaultIndexAnalyzer(), (Analyzer)analysisService.defaultSearchAnalyzer(), (Analyzer)analysisService.defaultSearchQuoteAnalyzer());
        HashMap<String, ObjectMapper> builder = new HashMap<String, ObjectMapper>();
        for (ObjectMapper objectMapper : newObjectMappers) {
            ObjectMapper previous = builder.put(objectMapper.fullPath(), objectMapper);
            if (previous == null) continue;
            throw new IllegalStateException("duplicate key " + objectMapper.fullPath() + " encountered");
        }
        boolean hasNestedObjects = false;
        this.objectMappers = Collections.unmodifiableMap(builder);
        for (ObjectMapper objectMapper : newObjectMappers) {
            if (!objectMapper.nested().isNested()) continue;
            hasNestedObjects = true;
        }
        this.hasNestedObjects = hasNestedObjects;
        try {
            this.mappingSource = new CompressedXContent(this, XContentType.JSON, ToXContent.EMPTY_PARAMS);
        }
        catch (Exception e) {
            throw new ElasticsearchGenerationException("failed to serialize source for type [" + this.type + "]", e);
        }
    }

    public Mapping mapping() {
        return this.mapping;
    }

    public String type() {
        return this.type;
    }

    public Text typeText() {
        return this.typeText;
    }

    public ImmutableMap<String, Object> meta() {
        return this.mapping.meta;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.mapping.root;
    }

    public UidFieldMapper uidMapper() {
        return this.metadataMapper(UidFieldMapper.class);
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping.metadataMapper(type);
    }

    public IndexFieldMapper indexMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public TypeFieldMapper typeMapper() {
        return this.metadataMapper(TypeFieldMapper.class);
    }

    public SourceFieldMapper sourceMapper() {
        return this.metadataMapper(SourceFieldMapper.class);
    }

    public AllFieldMapper allFieldMapper() {
        return this.metadataMapper(AllFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.metadataMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public ParentFieldMapper parentFieldMapper() {
        return this.metadataMapper(ParentFieldMapper.class);
    }

    public TimestampFieldMapper timestampFieldMapper() {
        return this.metadataMapper(TimestampFieldMapper.class);
    }

    public TTLFieldMapper TTLFieldMapper() {
        return this.metadataMapper(TTLFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public Query typeFilter() {
        return this.typeMapper().fieldType().termQuery(this.type, null);
    }

    public boolean hasNestedObjects() {
        return this.hasNestedObjects;
    }

    public DocumentFieldMappers mappers() {
        return this.fieldMappers;
    }

    public Map<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public ParsedDocument parse(String index, String type, String id, BytesReference source) throws MapperParsingException {
        return this.parse(SourceToParse.source(source).index(index).type(type).id(id));
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source);
    }

    public ObjectMapper findNestedObjectMapper(int nestedDocId, SearchContext sc, LeafReaderContext context) throws IOException {
        ObjectMapper nestedObjectMapper = null;
        for (ObjectMapper objectMapper : this.objectMappers().values()) {
            Weight nestedWeight;
            Scorer scorer;
            Query filter;
            if (!objectMapper.nested().isNested() || (filter = objectMapper.nestedTypeFilter()) == null || (scorer = (nestedWeight = filter.createWeight((IndexSearcher)sc.searcher(), false)).scorer(context)) == null || scorer.iterator().advance(nestedDocId) != nestedDocId) continue;
            if (nestedObjectMapper == null) {
                nestedObjectMapper = objectMapper;
                continue;
            }
            if (nestedObjectMapper.fullPath().length() >= objectMapper.fullPath().length()) continue;
            nestedObjectMapper = objectMapper;
        }
        return nestedObjectMapper;
    }

    public ObjectMapper findParentObjectMapper(ObjectMapper objectMapper) {
        int indexOfLastDot = objectMapper.fullPath().lastIndexOf(46);
        if (indexOfLastDot != -1) {
            String parentNestObjectPath = objectMapper.fullPath().substring(0, indexOfLastDot);
            return this.objectMappers().get(parentNestObjectPath);
        }
        return null;
    }

    public Map<String, Object> transformSourceAsMap(Map<String, Object> sourceAsMap) {
        return DocumentParser.transformSourceAsMap(this.mapping, sourceAsMap);
    }

    public boolean isParent(String type) {
        return this.mapperService.getParentTypes().contains(type);
    }

    public DocumentMapper merge(Mapping mapping, boolean updateAllTypes) {
        Mapping merged = this.mapping.merge(mapping, updateAllTypes);
        return new DocumentMapper(this.mapperService, merged);
    }

    public DocumentMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        Mapping updated = this.mapping.updateFieldType(fullNameToFieldType);
        if (updated == this.mapping) {
            return this;
        }
        assert (updated == updated.updateFieldType(fullNameToFieldType)) : "updateFieldType operation is not idempotent";
        return new DocumentMapper(this.mapperService, updated);
    }

    public void close() {
        this.documentParser.close();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.mapping.toXContent(builder, params);
    }

    private static class ScriptTransform
    implements Mapping.SourceTransform {
        private final ScriptService scriptService;
        private final Script script;

        public ScriptTransform(ScriptService scriptService, Script script) {
            this.scriptService = scriptService;
            this.script = script;
        }

        @Override
        public Map<String, Object> transformSourceAsMap(Map<String, Object> sourceAsMap) {
            try {
                ExecutableScript executable = this.scriptService.executable(this.script, ScriptContext.Standard.MAPPING, null, Collections.emptyMap());
                Map ctx = new HashMap<String, Map<String, Object>>(1);
                ctx.put("_source", sourceAsMap);
                executable.setNextVar("ctx", ctx);
                executable.run();
                ctx = (Map)executable.unwrap(ctx);
                return (Map)ctx.get("_source");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to execute script", e);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.script.toXContent(builder, params);
        }
    }

    public static class Builder {
        private Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        private List<Mapping.SourceTransform> sourceTransforms = new ArrayList<Mapping.SourceTransform>(1);
        private final RootObjectMapper rootObjectMapper;
        private ImmutableMap<String, Object> meta = ImmutableMap.of();
        private final Mapper.BuilderContext builderContext;

        public Builder(RootObjectMapper.Builder builder, MapperService mapperService) {
            Settings indexSettings = mapperService.indexSettings();
            this.builderContext = new Mapper.BuilderContext(indexSettings, new ContentPath(1));
            this.rootObjectMapper = (RootObjectMapper)builder.build(this.builderContext);
            String type = this.rootObjectMapper.name();
            DocumentMapper existingMapper = mapperService.documentMapper(type);
            for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : mapperService.mapperRegistry.getMetadataMapperParsers().entrySet()) {
                MetadataFieldMapper metadataMapper;
                MetadataFieldMapper existingMetadataMapper;
                String name = entry.getKey();
                MetadataFieldMapper metadataFieldMapper = existingMetadataMapper = existingMapper == null ? null : (MetadataFieldMapper)existingMapper.mappers().getMapper(name);
                if (existingMetadataMapper == null) {
                    MetadataFieldMapper.TypeParser parser = entry.getValue();
                    metadataMapper = parser.getDefault(indexSettings, mapperService.fullName(name), builder.name());
                } else {
                    metadataMapper = existingMetadataMapper;
                }
                this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            }
        }

        public Builder meta(ImmutableMap<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder put(MetadataFieldMapper.Builder<?, ?> mapper) {
            MetadataFieldMapper metadataMapper = (MetadataFieldMapper)mapper.build(this.builderContext);
            this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            return this;
        }

        public Builder transform(ScriptService scriptService, Script script) {
            this.sourceTransforms.add(new ScriptTransform(scriptService, script));
            return this;
        }

        @Deprecated
        public Builder transform(ScriptService scriptService, String script, ScriptService.ScriptType scriptType, String language, Map<String, Object> parameters) {
            this.sourceTransforms.add(new ScriptTransform(scriptService, new Script(script, scriptType, language, parameters)));
            return this;
        }

        public DocumentMapper build(MapperService mapperService) {
            Objects.requireNonNull(this.rootObjectMapper, "Mapper builder must have the root object mapper set");
            Mapping mapping = new Mapping(Version.indexCreated(mapperService.indexSettings()), this.rootObjectMapper, this.metadataMappers.values().toArray(new MetadataFieldMapper[this.metadataMappers.values().size()]), this.sourceTransforms.toArray(new Mapping.SourceTransform[this.sourceTransforms.size()]), this.meta);
            return new DocumentMapper(mapperService, mapping);
        }
    }
}

