/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.Closeable;
import org.apache.lucene.store.StoreRateLimiting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.FsDirectoryService;
import org.elasticsearch.indices.store.IndicesStore;

public class IndexStore
extends AbstractIndexComponent
implements Closeable {
    public static final String INDEX_STORE_THROTTLE_TYPE = "index.store.throttle.type";
    public static final String INDEX_STORE_THROTTLE_MAX_BYTES_PER_SEC = "index.store.throttle.max_bytes_per_sec";
    private final IndexSettingsService settingsService;
    protected final IndicesStore indicesStore;
    private volatile String rateLimitingType;
    private volatile ByteSizeValue rateLimitingThrottle;
    private volatile boolean nodeRateLimiting;
    private final StoreRateLimiting rateLimiting = new StoreRateLimiting();
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public IndexStore(Index index, IndexSettingsService settingsService, IndicesStore indicesStore) {
        super(index, settingsService.getSettings());
        Settings indexSettings = settingsService.getSettings();
        this.indicesStore = indicesStore;
        this.rateLimitingType = indexSettings.get(INDEX_STORE_THROTTLE_TYPE, "none");
        if (this.rateLimitingType.equalsIgnoreCase("node")) {
            this.nodeRateLimiting = true;
        } else {
            this.nodeRateLimiting = false;
            this.rateLimiting.setType(this.rateLimitingType);
        }
        this.rateLimitingThrottle = indexSettings.getAsBytesSize(INDEX_STORE_THROTTLE_MAX_BYTES_PER_SEC, new ByteSizeValue(0L));
        this.rateLimiting.setMaxRate(this.rateLimitingThrottle);
        this.logger.debug("using index.store.throttle.type [{}], with index.store.throttle.max_bytes_per_sec [{}]", this.rateLimitingType, this.rateLimitingThrottle);
        this.settingsService = settingsService;
        this.settingsService.addListener(this.applySettings);
    }

    @Override
    public void close() {
        this.settingsService.removeListener(this.applySettings);
    }

    public StoreRateLimiting rateLimiting() {
        return this.nodeRateLimiting ? this.indicesStore.rateLimiting() : this.rateLimiting;
    }

    public Class<? extends DirectoryService> shardDirectory() {
        return FsDirectoryService.class;
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            ByteSizeValue rateLimitingThrottle;
            String rateLimitingType = settings.get(IndexStore.INDEX_STORE_THROTTLE_TYPE, IndexStore.this.rateLimitingType);
            if (!rateLimitingType.equals(IndexStore.this.rateLimitingType)) {
                IndexStore.this.logger.info("updating index.store.throttle.type from [{}] to [{}]", IndexStore.this.rateLimitingType, rateLimitingType);
                if (rateLimitingType.equalsIgnoreCase("node")) {
                    IndexStore.this.rateLimitingType = rateLimitingType;
                    IndexStore.this.nodeRateLimiting = true;
                } else {
                    StoreRateLimiting.Type.fromString(rateLimitingType);
                    IndexStore.this.rateLimitingType = rateLimitingType;
                    IndexStore.this.nodeRateLimiting = false;
                    IndexStore.this.rateLimiting.setType(rateLimitingType);
                }
            }
            if (!(rateLimitingThrottle = settings.getAsBytesSize(IndexStore.INDEX_STORE_THROTTLE_MAX_BYTES_PER_SEC, IndexStore.this.rateLimitingThrottle)).equals(IndexStore.this.rateLimitingThrottle)) {
                IndexStore.this.logger.info("updating index.store.throttle.max_bytes_per_sec from [{}] to [{}], note, type is [{}]", IndexStore.this.rateLimitingThrottle, rateLimitingThrottle, IndexStore.this.rateLimitingType);
                IndexStore.this.rateLimitingThrottle = rateLimitingThrottle;
                IndexStore.this.rateLimiting.setMaxRate(rateLimitingThrottle);
            }
        }
    }
}

