/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.VerifyingIndexOutput;

@Deprecated
class LegacyVerification {
    LegacyVerification() {
    }

    static class LengthVerifyingIndexOutput
    extends VerifyingIndexOutput {
        final long length;
        long written;

        public LengthVerifyingIndexOutput(IndexOutput out, long length) {
            super(out);
            this.length = length;
        }

        @Override
        public void verify() throws IOException {
            if (this.written != this.length) {
                throw new CorruptIndexException("expected length=" + this.length + " != actual length: " + this.written + " : file truncated?", this.out.toString());
            }
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.out.writeByte(b);
            ++this.written;
        }

        @Override
        public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
            this.out.writeBytes(bytes, offset, length);
            this.written += (long)length;
        }
    }

    static class Adler32VerifyingIndexOutput
    extends VerifyingIndexOutput {
        final String adler32;
        final long length;
        final Checksum checksum = new BufferedChecksum((Checksum)new Adler32());
        long written;

        public Adler32VerifyingIndexOutput(IndexOutput out, String adler32, long length) {
            super(out);
            this.adler32 = adler32;
            this.length = length;
        }

        @Override
        public void verify() throws IOException {
            if (this.written != this.length) {
                throw new CorruptIndexException("expected length=" + this.length + " != actual length: " + this.written + " : file truncated?", this.out.toString());
            }
            String actualChecksum = Store.digestToString(this.checksum.getValue());
            if (!this.adler32.equals(actualChecksum)) {
                throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + this.adler32 + " actual=" + actualChecksum, this.out.toString());
            }
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.out.writeByte(b);
            this.checksum.update(b);
            ++this.written;
        }

        @Override
        public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
            this.out.writeBytes(bytes, offset, length);
            this.checksum.update(bytes, offset, length);
            this.written += (long)length;
        }
    }
}

