/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.suggest.stats;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class SuggestStats
implements Streamable,
ToXContent {
    private long suggestCount;
    private long suggestTimeInMillis;
    private long current;

    public SuggestStats() {
    }

    SuggestStats(long suggestCount, long suggestTimeInMillis, long current) {
        this.suggestCount = suggestCount;
        this.suggestTimeInMillis = suggestTimeInMillis;
        this.current = current;
    }

    public long getCount() {
        return this.suggestCount;
    }

    public long getTimeInMillis() {
        return this.suggestTimeInMillis;
    }

    public TimeValue getTime() {
        return new TimeValue(this.getTimeInMillis());
    }

    public long getCurrent() {
        return this.current;
    }

    public void add(SuggestStats suggestStats) {
        if (suggestStats != null) {
            this.suggestCount += suggestStats.getCount();
            this.suggestTimeInMillis += suggestStats.getTimeInMillis();
            this.current += suggestStats.getCurrent();
        }
    }

    public static SuggestStats readSuggestStats(StreamInput in) throws IOException {
        SuggestStats stats = new SuggestStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.suggestCount = in.readVLong();
        this.suggestTimeInMillis = in.readVLong();
        this.current = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.suggestCount);
        out.writeVLong(this.suggestTimeInMillis);
        out.writeVLong(this.current);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.SUGGEST);
        builder.field(Fields.TOTAL, this.suggestCount);
        builder.timeValueField(Fields.TIME_IN_MILLIS, Fields.TIME, this.suggestTimeInMillis);
        builder.field(Fields.CURRENT, this.current);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString SUGGEST = new XContentBuilderString("suggest");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString TIME_IN_MILLIS = new XContentBuilderString("time_in_millis");
        static final XContentBuilderString CURRENT = new XContentBuilderString("current");

        Fields() {
        }
    }
}

