/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.SearchContext;

public abstract class AggregatorFactory {
    protected String name;
    protected String type;
    protected AggregatorFactory parent;
    protected AggregatorFactories factories = AggregatorFactories.EMPTY;
    protected Map<String, Object> metaData;

    public AggregatorFactory(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public AggregatorFactory subFactories(AggregatorFactories subFactories) {
        this.factories = subFactories;
        this.factories.setParent(this);
        return this;
    }

    public String name() {
        return this.name;
    }

    public final void validate() {
        this.doValidate();
        this.factories.validate();
    }

    public AggregatorFactory parent() {
        return this.parent;
    }

    protected abstract Aggregator createInternal(AggregationContext var1, Aggregator var2, boolean var3, List<PipelineAggregator> var4, Map<String, Object> var5) throws IOException;

    public final Aggregator create(AggregationContext context, Aggregator parent, boolean collectsFromSingleBucket) throws IOException {
        return this.createInternal(context, parent, collectsFromSingleBucket, this.factories.createPipelineAggregators(), this.metaData);
    }

    public void doValidate() {
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    protected static Aggregator asMultiBucketAggregator(final AggregatorFactory factory, final AggregationContext context, final Aggregator parent) throws IOException {
        final Aggregator first = factory.create(context, parent, true);
        final BigArrays bigArrays = context.bigArrays();
        return new Aggregator(){
            ObjectArray<Aggregator> aggregators;
            ObjectArray<LeafBucketCollector> collectors;
            {
                context.searchContext().addReleasable(this, SearchContext.Lifetime.PHASE);
                this.aggregators = bigArrays.newObjectArray(1L);
                this.aggregators.set(0L, first);
                this.collectors = bigArrays.newObjectArray(1L);
            }

            @Override
            public String name() {
                return first.name();
            }

            @Override
            public AggregationContext context() {
                return first.context();
            }

            @Override
            public Aggregator parent() {
                return first.parent();
            }

            public boolean needsScores() {
                return first.needsScores();
            }

            @Override
            public Aggregator subAggregator(String name) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void preCollection() throws IOException {
                for (long i = 0L; i < this.aggregators.size(); ++i) {
                    Aggregator aggregator = this.aggregators.get(i);
                    if (aggregator == null) continue;
                    aggregator.preCollection();
                }
            }

            @Override
            public void postCollection() throws IOException {
                for (long i = 0L; i < this.aggregators.size(); ++i) {
                    Aggregator aggregator = this.aggregators.get(i);
                    if (aggregator == null) continue;
                    aggregator.postCollection();
                }
            }

            @Override
            public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx) {
                for (long i = 0L; i < this.collectors.size(); ++i) {
                    this.collectors.set(i, null);
                }
                return new LeafBucketCollector(){
                    Scorer scorer;

                    @Override
                    public void setScorer(Scorer scorer) throws IOException {
                        this.scorer = scorer;
                    }

                    @Override
                    public void collect(int doc, long bucket) throws IOException {
                        aggregators = bigArrays.grow(aggregators, bucket + 1L);
                        collectors = bigArrays.grow(collectors, bucket + 1L);
                        LeafBucketCollector collector = collectors.get(bucket);
                        if (collector == null) {
                            Aggregator aggregator = aggregators.get(bucket);
                            if (aggregator == null) {
                                aggregator = factory.create(context, parent, true);
                                aggregator.preCollection();
                                aggregators.set(bucket, aggregator);
                            }
                            collector = aggregator.getLeafCollector(ctx);
                            collector.setScorer(this.scorer);
                            collectors.set(bucket, collector);
                        }
                        collector.collect(doc, 0L);
                    }
                };
            }

            @Override
            public InternalAggregation buildAggregation(long bucket) throws IOException {
                Aggregator aggregator;
                if (bucket < this.aggregators.size() && (aggregator = this.aggregators.get(bucket)) != null) {
                    return aggregator.buildAggregation(0L);
                }
                return this.buildEmptyAggregation();
            }

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return first.buildEmptyAggregation();
            }

            @Override
            public void close() {
                Releasables.close(this.aggregators, this.collectors);
            }
        };
    }
}

