/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Comparators;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;

class InternalOrder
extends Terms.Order {
    private static final byte COUNT_DESC_ID = 1;
    private static final byte COUNT_ASC_ID = 2;
    private static final byte TERM_DESC_ID = 3;
    private static final byte TERM_ASC_ID = 4;
    public static final InternalOrder COUNT_DESC = new InternalOrder(1, "_count", false, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            return Long.compare(o2.getDocCount(), o1.getDocCount());
        }
    });
    public static final InternalOrder COUNT_ASC = new InternalOrder(2, "_count", true, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            return Long.compare(o1.getDocCount(), o2.getDocCount());
        }
    });
    public static final InternalOrder TERM_DESC = new InternalOrder(3, "_term", false, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            return o2.compareTerm(o1);
        }
    });
    public static final InternalOrder TERM_ASC = new InternalOrder(4, "_term", true, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            return o1.compareTerm(o2);
        }
    });
    final byte id;
    final String key;
    final boolean asc;
    protected final Comparator<Terms.Bucket> comparator;

    public static boolean isCountDesc(Terms.Order order) {
        CompoundOrder compoundOrder;
        if (order == COUNT_DESC) {
            return true;
        }
        return order instanceof CompoundOrder && (compoundOrder = (CompoundOrder)order).orderElements.size() == 2 && compoundOrder.orderElements.get(0) == COUNT_DESC && compoundOrder.orderElements.get(1) == TERM_ASC;
    }

    InternalOrder(byte id, String key, boolean asc, Comparator<Terms.Bucket> comparator) {
        this.id = id;
        this.key = key;
        this.asc = asc;
        this.comparator = comparator;
    }

    @Override
    byte id() {
        return this.id;
    }

    @Override
    protected Comparator<Terms.Bucket> comparator(Aggregator aggregator) {
        return this.comparator;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(this.key, this.asc ? "asc" : "desc").endObject();
    }

    public static Terms.Order validate(Terms.Order order, Aggregator termsAggregator) {
        if (order instanceof CompoundOrder) {
            for (Terms.Order innerOrder : ((CompoundOrder)order).orderElements) {
                InternalOrder.validate(innerOrder, termsAggregator);
            }
            return order;
        }
        if (!(order instanceof Aggregation)) {
            return order;
        }
        AggregationPath path = ((Aggregation)order).path();
        path.validate(termsAggregator);
        return order;
    }

    public static class Streams {
        public static void writeOrder(Terms.Order order, StreamOutput out) throws IOException {
            if (order instanceof Aggregation) {
                out.writeByte(order.id());
                Aggregation aggregationOrder = (Aggregation)order;
                out.writeBoolean(((MultiBucketsAggregation.Bucket.SubAggregationComparator)aggregationOrder.comparator).asc());
                AggregationPath path = ((Aggregation)order).path();
                out.writeString(path.toString());
            } else if (order instanceof CompoundOrder) {
                CompoundOrder compoundOrder = (CompoundOrder)order;
                out.writeByte(order.id());
                out.writeVInt(compoundOrder.orderElements.size());
                for (Terms.Order innerOrder : compoundOrder.orderElements) {
                    Streams.writeOrder(innerOrder, out);
                }
            } else {
                out.writeByte(order.id());
            }
        }

        public static Terms.Order readOrder(StreamInput in) throws IOException {
            return Streams.readOrder(in, true);
        }

        public static Terms.Order readOrder(StreamInput in, boolean absoluteOrder) throws IOException {
            byte id = in.readByte();
            switch (id) {
                case 1: {
                    return absoluteOrder ? new CompoundOrder(Collections.singletonList(COUNT_DESC)) : COUNT_DESC;
                }
                case 2: {
                    return absoluteOrder ? new CompoundOrder(Collections.singletonList(COUNT_ASC)) : COUNT_ASC;
                }
                case 3: {
                    return TERM_DESC;
                }
                case 4: {
                    return TERM_ASC;
                }
                case 0: {
                    boolean asc = in.readBoolean();
                    String key = in.readString();
                    return new Aggregation(key, asc);
                }
                case -1: {
                    int size = in.readVInt();
                    ArrayList<Terms.Order> compoundOrder = new ArrayList<Terms.Order>(size);
                    for (int i = 0; i < size; ++i) {
                        compoundOrder.add(Streams.readOrder(in, false));
                    }
                    return new CompoundOrder(compoundOrder, absoluteOrder);
                }
            }
            throw new RuntimeException("unknown terms order");
        }
    }

    static class CompoundOrder
    extends Terms.Order {
        static final byte ID = -1;
        private final List<Terms.Order> orderElements;

        public CompoundOrder(List<Terms.Order> compoundOrder) {
            this(compoundOrder, true);
        }

        public CompoundOrder(List<Terms.Order> compoundOrder, boolean absoluteOrdering) {
            this.orderElements = new LinkedList<Terms.Order>(compoundOrder);
            Terms.Order lastElement = compoundOrder.get(compoundOrder.size() - 1);
            if (absoluteOrdering && TERM_ASC != lastElement && TERM_DESC != lastElement) {
                this.orderElements.add(Terms.Order.term(true));
            }
        }

        @Override
        byte id() {
            return -1;
        }

        List<Terms.Order> orderElements() {
            return Collections.unmodifiableList(this.orderElements);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (Terms.Order order : this.orderElements) {
                order.toXContent(builder, params);
            }
            return builder.endArray();
        }

        @Override
        protected Comparator<Terms.Bucket> comparator(Aggregator aggregator) {
            return new CompoundOrderComparator(this.orderElements, aggregator);
        }

        public static class CompoundOrderComparator
        implements Comparator<Terms.Bucket> {
            private List<Terms.Order> compoundOrder;
            private Aggregator aggregator;

            public CompoundOrderComparator(List<Terms.Order> compoundOrder, Aggregator aggregator) {
                this.compoundOrder = compoundOrder;
                this.aggregator = aggregator;
            }

            @Override
            public int compare(Terms.Bucket o1, Terms.Bucket o2) {
                int result = 0;
                Iterator<Terms.Order> itr = this.compoundOrder.iterator();
                while (itr.hasNext() && result == 0) {
                    result = itr.next().comparator(this.aggregator).compare(o1, o2);
                }
                return result;
            }
        }
    }

    static class Aggregation
    extends InternalOrder {
        static final byte ID = 0;

        Aggregation(String key, boolean asc) {
            super((byte)0, key, asc, new MultiBucketsAggregation.Bucket.SubAggregationComparator<Terms.Bucket>(key, asc));
        }

        AggregationPath path() {
            return ((MultiBucketsAggregation.Bucket.SubAggregationComparator)this.comparator).path();
        }

        @Override
        protected Comparator<Terms.Bucket> comparator(Aggregator termsAggregator) {
            if (termsAggregator == null) {
                return this.comparator;
            }
            AggregationPath path = this.path();
            final Aggregator aggregator = path.resolveAggregator(termsAggregator);
            final String key = path.lastPathElement().key;
            if (aggregator instanceof SingleBucketAggregator) {
                assert (key == null) : "this should be picked up before the aggregation is executed - on validate";
                return new Comparator<Terms.Bucket>(){

                    @Override
                    public int compare(Terms.Bucket o1, Terms.Bucket o2) {
                        int mul = Aggregation.this.asc ? 1 : -1;
                        int v1 = ((SingleBucketAggregator)aggregator).bucketDocCount(((InternalTerms.Bucket)o1).bucketOrd);
                        int v2 = ((SingleBucketAggregator)aggregator).bucketDocCount(((InternalTerms.Bucket)o2).bucketOrd);
                        return mul * (v1 - v2);
                    }
                };
            }
            assert (!(aggregator instanceof BucketsAggregator)) : "this should be picked up before the aggregation is executed - on validate";
            if (aggregator instanceof NumericMetricsAggregator.MultiValue) {
                assert (key != null) : "this should be picked up before the aggregation is executed - on validate";
                return new Comparator<Terms.Bucket>(){

                    @Override
                    public int compare(Terms.Bucket o1, Terms.Bucket o2) {
                        double v1 = ((NumericMetricsAggregator.MultiValue)aggregator).metric(key, ((InternalTerms.Bucket)o1).bucketOrd);
                        double v2 = ((NumericMetricsAggregator.MultiValue)aggregator).metric(key, ((InternalTerms.Bucket)o2).bucketOrd);
                        return Comparators.compareDiscardNaN(v1, v2, Aggregation.this.asc);
                    }
                };
            }
            return new Comparator<Terms.Bucket>(){

                @Override
                public int compare(Terms.Bucket o1, Terms.Bucket o2) {
                    double v1 = ((NumericMetricsAggregator.SingleValue)aggregator).metric(((InternalTerms.Bucket)o1).bucketOrd);
                    double v2 = ((NumericMetricsAggregator.SingleValue)aggregator).metric(((InternalTerms.Bucket)o2).bucketOrd);
                    return Comparators.compareDiscardNaN(v1, v2, Aggregation.this.asc);
                }
            };
        }
    }
}

