/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.MissingValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class AggregationContext {
    private final SearchContext searchContext;

    public AggregationContext(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    public SearchContext searchContext() {
        return this.searchContext;
    }

    public PageCacheRecycler pageCacheRecycler() {
        return this.searchContext.pageCacheRecycler();
    }

    public BigArrays bigArrays() {
        return this.searchContext.bigArrays();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public <VS extends ValuesSource> VS valuesSource(ValuesSourceConfig<VS> config, SearchContext context) throws IOException {
        Object vs;
        assert (config.valid()) : "value source config is invalid - must have either a field context or a script or marked as unmapped";
        if (config.unmapped) {
            if (config.missing == null) {
                vs = null;
            } else if (ValuesSource.Numeric.class.isAssignableFrom(config.valueSourceType)) {
                vs = ValuesSource.Numeric.EMPTY;
            } else if (ValuesSource.GeoPoint.class.isAssignableFrom(config.valueSourceType)) {
                vs = ValuesSource.GeoPoint.EMPTY;
            } else {
                if (!ValuesSource.class.isAssignableFrom(config.valueSourceType) && !ValuesSource.Bytes.class.isAssignableFrom(config.valueSourceType) && !ValuesSource.Bytes.WithOrdinals.class.isAssignableFrom(config.valueSourceType)) throw new SearchParseException(this.searchContext, "Can't deal with unmapped ValuesSource type " + config.valueSourceType, null);
                vs = ValuesSource.Bytes.WithOrdinals.EMPTY;
            }
        } else {
            vs = this.originalValuesSource(config);
        }
        if (config.missing == null) {
            return (VS)vs;
        }
        if (vs instanceof ValuesSource.Bytes) {
            BytesRef missing = new BytesRef((CharSequence)config.missing.toString());
            if (!(vs instanceof ValuesSource.Bytes.WithOrdinals)) return (VS)MissingValues.replaceMissing((ValuesSource.Bytes)vs, missing);
            return (VS)MissingValues.replaceMissing((ValuesSource.Bytes.WithOrdinals)vs, missing);
        }
        if (vs instanceof ValuesSource.Numeric) {
            Number missing = null;
            if (config.missing instanceof Number) {
                missing = (Number)config.missing;
                return (VS)MissingValues.replaceMissing((ValuesSource.Numeric)vs, missing);
            }
            if (config.fieldContext != null && config.fieldContext.fieldType() instanceof DateFieldMapper.DateFieldType) {
                DateFieldMapper.DateFieldType fieldType = (DateFieldMapper.DateFieldType)config.fieldContext.fieldType();
                try {
                    missing = fieldType.dateTimeFormatter().parser().parseDateTime(config.missing.toString()).getMillis();
                    return (VS)MissingValues.replaceMissing((ValuesSource.Numeric)vs, missing);
                }
                catch (IllegalArgumentException e) {
                    throw new SearchParseException(context, "Expected a date value in [missing] but got [" + config.missing + "]", null, e);
                }
            }
            try {
                missing = Double.parseDouble(config.missing.toString());
                return (VS)MissingValues.replaceMissing((ValuesSource.Numeric)vs, missing);
            }
            catch (NumberFormatException e) {
                throw new SearchParseException(context, "Expected a numeric value in [missing] but got [" + config.missing + "]", null, e);
            }
        }
        if (!(vs instanceof ValuesSource.GeoPoint)) throw new SearchParseException(this.searchContext, "Can't apply missing values on a " + vs.getClass(), null);
        GeoPoint missing = GeoUtils.parseGeoPoint(config.missing.toString(), new GeoPoint());
        return (VS)MissingValues.replaceMissing((ValuesSource.GeoPoint)vs, missing);
    }

    private <VS extends ValuesSource> VS originalValuesSource(ValuesSourceConfig<VS> config) throws IOException {
        if (config.fieldContext == null) {
            if (ValuesSource.Numeric.class.isAssignableFrom(config.valueSourceType)) {
                return (VS)this.numericScript(config);
            }
            if (ValuesSource.Bytes.class.isAssignableFrom(config.valueSourceType)) {
                return (VS)this.bytesScript(config);
            }
            throw new AggregationExecutionException("value source of type [" + config.valueSourceType.getSimpleName() + "] is not supported by scripts");
        }
        if (ValuesSource.Numeric.class.isAssignableFrom(config.valueSourceType)) {
            return (VS)this.numericField(config);
        }
        if (ValuesSource.GeoPoint.class.isAssignableFrom(config.valueSourceType)) {
            return (VS)this.geoPointField(config);
        }
        return (VS)this.bytesField(config);
    }

    private ValuesSource.Numeric numericScript(ValuesSourceConfig<?> config) throws IOException {
        return new ValuesSource.Numeric.Script(config.script, config.scriptValueType);
    }

    private ValuesSource.Numeric numericField(ValuesSourceConfig<?> config) throws IOException {
        if (!(config.fieldContext.indexFieldData() instanceof IndexNumericFieldData)) {
            throw new IllegalArgumentException("Expected numeric type on field [" + config.fieldContext.field() + "], but got [" + config.fieldContext.fieldType().typeName() + "]");
        }
        ValuesSource.Numeric dataSource = new ValuesSource.Numeric.FieldData((IndexNumericFieldData)config.fieldContext.indexFieldData());
        if (config.script != null) {
            dataSource = new ValuesSource.Numeric.WithScript(dataSource, config.script);
        }
        return dataSource;
    }

    private ValuesSource bytesField(ValuesSourceConfig<?> config) throws IOException {
        IndexFieldData<?> indexFieldData = config.fieldContext.indexFieldData();
        ValuesSource.Bytes dataSource = indexFieldData instanceof ParentChildIndexFieldData ? new ValuesSource.Bytes.ParentChild((ParentChildIndexFieldData)indexFieldData) : (indexFieldData instanceof IndexOrdinalsFieldData ? new ValuesSource.Bytes.WithOrdinals.FieldData((IndexOrdinalsFieldData)indexFieldData) : new ValuesSource.Bytes.FieldData(indexFieldData));
        if (config.script != null) {
            dataSource = new ValuesSource.WithScript(dataSource, config.script);
        }
        return dataSource;
    }

    private ValuesSource.Bytes bytesScript(ValuesSourceConfig<?> config) throws IOException {
        return new ValuesSource.Bytes.Script(config.script);
    }

    private ValuesSource.GeoPoint geoPointField(ValuesSourceConfig<?> config) throws IOException {
        if (!(config.fieldContext.indexFieldData() instanceof IndexGeoPointFieldData)) {
            throw new IllegalArgumentException("Expected geo_point type on field [" + config.fieldContext.field() + "], but got [" + config.fieldContext.fieldType().typeName() + "]");
        }
        return new ValuesSource.GeoPoint.Fielddata((IndexGeoPointFieldData)config.fieldContext.indexFieldData());
    }
}

