/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.element;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.ColumnCast;
import com.alibaba.datax.common.exception.CommonErrorCode;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class DateColumn
extends Column {
    private DateType subType = DateType.DATETIME;

    public DateColumn() {
        this((Long)null);
    }

    public DateColumn(Long stamp) {
        super(stamp, Column.Type.DATE, null == stamp ? 0 : 8);
    }

    public DateColumn(Date date) {
        this(date == null ? null : Long.valueOf(date.getTime()));
    }

    public DateColumn(java.sql.Date date) {
        this(date == null ? null : Long.valueOf(date.getTime()));
        this.setSubType(DateType.DATE);
    }

    public DateColumn(Time time) {
        this(time == null ? null : Long.valueOf(time.getTime()));
        this.setSubType(DateType.TIME);
    }

    public DateColumn(Timestamp ts) {
        this(ts == null ? null : Long.valueOf(ts.getTime()));
        this.setSubType(DateType.DATETIME);
    }

    @Override
    public Long asLong() {
        return (Long)this.getRawData();
    }

    @Override
    public String asString() {
        try {
            return ColumnCast.date2String(this);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Date[%s]\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aString .", this.toString()));
        }
    }

    @Override
    public Date asDate() {
        if (null == this.getRawData()) {
            return null;
        }
        return new Date((Long)this.getRawData());
    }

    @Override
    public byte[] asBytes() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Date\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBytes .");
    }

    @Override
    public Boolean asBoolean() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Date\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBoolean .");
    }

    @Override
    public Double asDouble() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Date\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aDouble .");
    }

    @Override
    public BigInteger asBigInteger() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Date\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBigInteger .");
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Date\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBigDecimal .");
    }

    public DateType getSubType() {
        return this.subType;
    }

    public void setSubType(DateType subType) {
        this.subType = subType;
    }

    public static enum DateType {
        DATE,
        TIME,
        DATETIME;

    }
}

