/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.statistics;

import com.alibaba.datax.common.statistics.PerfTrace;
import com.alibaba.datax.common.util.HostUtils;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfRecord
implements Comparable<PerfRecord> {
    private static Logger perf = LoggerFactory.getLogger(PerfRecord.class);
    private static String datetimeFormat = "yyyy-MM-dd HH:mm:ss";
    private final int taskGroupId;
    private final int taskId;
    private final PHASE phase;
    private volatile ACTION action;
    private volatile Date startTime;
    private volatile long elapsedTimeInNs = -1L;
    private volatile long count = 0L;
    private volatile long size = 0L;
    private volatile long startTimeInNs;
    private volatile boolean isReport = false;

    public PerfRecord(int taskGroupId, int taskId, PHASE phase) {
        this.taskGroupId = taskGroupId;
        this.taskId = taskId;
        this.phase = phase;
    }

    public static void addPerfRecord(int taskGroupId, int taskId, PHASE phase, long startTime, long elapsedTimeInNs) {
        if (PerfTrace.getInstance().isEnable()) {
            PerfRecord perfRecord = new PerfRecord(taskGroupId, taskId, phase);
            perfRecord.elapsedTimeInNs = elapsedTimeInNs;
            perfRecord.action = ACTION.end;
            perfRecord.startTime = new Date(startTime);
            PerfTrace.getInstance().tracePerfRecord(perfRecord);
            perf.info(perfRecord.toString());
        }
    }

    public void start() {
        if (PerfTrace.getInstance().isEnable()) {
            this.startTime = new Date();
            this.startTimeInNs = System.nanoTime();
            this.action = ACTION.start;
            PerfTrace.getInstance().tracePerfRecord(this);
            perf.info(this.toString());
        }
    }

    public void addCount(long count) {
        this.count += count;
    }

    public void addSize(long size) {
        this.size += size;
    }

    public void end() {
        if (PerfTrace.getInstance().isEnable()) {
            this.elapsedTimeInNs = System.nanoTime() - this.startTimeInNs;
            this.action = ACTION.end;
            PerfTrace.getInstance().tracePerfRecord(this);
            perf.info(this.toString());
        }
    }

    public void end(long elapsedTimeInNs) {
        if (PerfTrace.getInstance().isEnable()) {
            this.elapsedTimeInNs = elapsedTimeInNs;
            this.action = ACTION.end;
            PerfTrace.getInstance().tracePerfRecord(this);
            perf.info(this.toString());
        }
    }

    public String toString() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", new Object[]{this.getInstId(), this.taskGroupId, this.taskId, this.phase, this.action, DateFormatUtils.format((Date)this.startTime, (String)datetimeFormat), this.elapsedTimeInNs, this.count, this.size, this.getHostIP()});
    }

    @Override
    public int compareTo(PerfRecord o) {
        if (o == null) {
            return 1;
        }
        return this.elapsedTimeInNs > o.elapsedTimeInNs ? 1 : (this.elapsedTimeInNs == o.elapsedTimeInNs ? 0 : -1);
    }

    public int hashCode() {
        long jobId = this.getInstId();
        int result = (int)(jobId ^ jobId >>> 32);
        result = 31 * result + this.taskGroupId;
        result = 31 * result + this.taskId;
        result = 31 * result + this.phase.toInt();
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PerfRecord)) {
            return false;
        }
        PerfRecord dst = (PerfRecord)o;
        if (this.getInstId() != dst.getInstId()) {
            return false;
        }
        if (this.taskGroupId != dst.taskGroupId) {
            return false;
        }
        if (this.taskId != dst.taskId) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals((Object)dst.phase) : dst.phase != null) {
            return false;
        }
        return !(this.startTime != null ? !this.startTime.equals(dst.startTime) : dst.startTime != null);
    }

    public PerfRecord copy() {
        PerfRecord copy = new PerfRecord(this.taskGroupId, this.getTaskId(), this.phase);
        copy.action = this.action;
        copy.startTime = this.startTime;
        copy.elapsedTimeInNs = this.elapsedTimeInNs;
        copy.count = this.count;
        copy.size = this.size;
        return copy;
    }

    public int getTaskGroupId() {
        return this.taskGroupId;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public PHASE getPhase() {
        return this.phase;
    }

    public ACTION getAction() {
        return this.action;
    }

    public long getElapsedTimeInNs() {
        return this.elapsedTimeInNs;
    }

    public long getCount() {
        return this.count;
    }

    public long getSize() {
        return this.size;
    }

    public long getInstId() {
        return PerfTrace.getInstance().getInstId();
    }

    public String getHostIP() {
        return HostUtils.IP;
    }

    public String getHostName() {
        return HostUtils.HOSTNAME;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public long getStartTimeInMs() {
        return this.startTime.getTime();
    }

    public long getStartTimeInNs() {
        return this.startTimeInNs;
    }

    public String getDatetime() {
        if (this.startTime == null) {
            return "null time";
        }
        return DateFormatUtils.format((Date)this.startTime, (String)datetimeFormat);
    }

    public boolean isReport() {
        return this.isReport;
    }

    public void setIsReport(boolean isReport) {
        this.isReport = isReport;
    }

    public static enum ACTION {
        start,
        end;

    }

    public static enum PHASE {
        TASK_TOTAL(0),
        READ_TASK_INIT(1),
        READ_TASK_PREPARE(2),
        READ_TASK_DATA(3),
        READ_TASK_POST(4),
        READ_TASK_DESTROY(5),
        WRITE_TASK_INIT(6),
        WRITE_TASK_PREPARE(7),
        WRITE_TASK_DATA(8),
        WRITE_TASK_POST(9),
        WRITE_TASK_DESTROY(10),
        SQL_QUERY(100),
        RESULT_NEXT_ALL(101),
        ODPS_BLOCK_CLOSE(102),
        WAIT_READ_TIME(103),
        WAIT_WRITE_TIME(104),
        TRANSFORMER_TIME(201);

        private int val;

        private PHASE(int val) {
            this.val = val;
        }

        public int toInt() {
            return this.val;
        }
    }
}

