/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import java.util.EnumSet;

public enum ClusterBlockLevel {
    READ(0),
    WRITE(1),
    METADATA_READ(2),
    METADATA_WRITE(3);

    public static final EnumSet<ClusterBlockLevel> ALL;
    public static final EnumSet<ClusterBlockLevel> READ_WRITE;
    private final int id;

    private ClusterBlockLevel(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    static ClusterBlockLevel fromId(int id) {
        if (id == 0) {
            return READ;
        }
        if (id == 1) {
            return WRITE;
        }
        if (id == 2) {
            return METADATA_READ;
        }
        if (id == 3) {
            return METADATA_WRITE;
        }
        throw new IllegalArgumentException("No cluster block level matching [" + id + "]");
    }

    static {
        ALL = EnumSet.of(READ, WRITE, METADATA_READ, METADATA_WRITE);
        READ_WRITE = EnumSet.of(READ, WRITE);
    }
}

