/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.shard.ShardId;

public class IndexFailedEngineException
extends EngineException {
    private final String type;
    private final String id;

    public IndexFailedEngineException(ShardId shardId, String type, String id, Throwable cause) {
        super(shardId, "Index failed for [" + type + "#" + id + "]", cause);
        Objects.requireNonNull(type, "type must not be null");
        Objects.requireNonNull(id, "id must not be null");
        this.type = type;
        this.id = id;
    }

    public IndexFailedEngineException(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.id = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }
}

