/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.nio.file.Path;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogWriter;
import org.elasticsearch.indices.memory.IndexingMemoryController;
import org.elasticsearch.threadpool.ThreadPool;

public final class TranslogConfig {
    public static final String INDEX_TRANSLOG_DURABILITY = "index.translog.durability";
    public static final String INDEX_TRANSLOG_FS_TYPE = "index.translog.fs.type";
    public static final String INDEX_TRANSLOG_BUFFER_SIZE = "index.translog.fs.buffer_size";
    public static final String INDEX_TRANSLOG_SYNC_INTERVAL = "index.translog.sync_interval";
    private final TimeValue syncInterval;
    private final BigArrays bigArrays;
    private final ThreadPool threadPool;
    private final boolean syncOnEachOperation;
    private volatile int bufferSize;
    private volatile Translog.TranslogGeneration translogGeneration;
    private volatile Translog.Durabilty durabilty = Translog.Durabilty.REQUEST;
    private volatile TranslogWriter.Type type;
    private final Settings indexSettings;
    private final ShardId shardId;
    private final Path translogPath;

    public TranslogConfig(ShardId shardId, Path translogPath, Settings indexSettings, Translog.Durabilty durabilty, BigArrays bigArrays, @Nullable ThreadPool threadPool) {
        this.indexSettings = indexSettings;
        this.shardId = shardId;
        this.translogPath = translogPath;
        this.durabilty = durabilty;
        this.threadPool = threadPool;
        this.bigArrays = bigArrays;
        this.type = TranslogWriter.Type.fromString(indexSettings.get(INDEX_TRANSLOG_FS_TYPE, TranslogWriter.Type.BUFFERED.name()));
        this.bufferSize = (int)indexSettings.getAsBytesSize(INDEX_TRANSLOG_BUFFER_SIZE, IndexingMemoryController.INACTIVE_SHARD_TRANSLOG_BUFFER).bytes();
        this.syncInterval = indexSettings.getAsTime(INDEX_TRANSLOG_SYNC_INTERVAL, TimeValue.timeValueSeconds(5L));
        this.syncOnEachOperation = this.syncInterval.millis() > 0L && threadPool != null ? false : this.syncInterval.millis() == 0L;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Translog.Durabilty getDurabilty() {
        return this.durabilty;
    }

    public void setDurabilty(Translog.Durabilty durabilty) {
        this.durabilty = durabilty;
    }

    public TranslogWriter.Type getType() {
        return this.type;
    }

    public void setType(TranslogWriter.Type type) {
        this.type = type;
    }

    public boolean isSyncOnEachOperation() {
        return this.syncOnEachOperation;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public TimeValue getSyncInterval() {
        return this.syncInterval;
    }

    public Settings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BigArrays getBigArrays() {
        return this.bigArrays;
    }

    public Path getTranslogPath() {
        return this.translogPath;
    }

    public Translog.TranslogGeneration getTranslogGeneration() {
        return this.translogGeneration;
    }

    public void setTranslogGeneration(Translog.TranslogGeneration translogGeneration) {
        this.translogGeneration = translogGeneration;
    }
}

