/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import com.ning.compress.lzf.ChunkDecoder;
import com.ning.compress.lzf.util.ChunkDecoderFactory;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedIndexInput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.lzf.LZFCompressedIndexInput;
import org.elasticsearch.common.compress.lzf.LZFCompressedStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.jboss.netty.buffer.ChannelBuffer;

@Deprecated
public class LZFCompressor
implements Compressor {
    static final byte[] LUCENE_HEADER = new byte[]{76, 90, 70, 0};
    private ChunkDecoder decoder = ChunkDecoderFactory.safeInstance();

    public LZFCompressor() {
        Loggers.getLogger(LZFCompressor.class).debug("using decoder[{}] ", this.decoder.getClass().getSimpleName());
    }

    @Override
    public boolean isCompressed(BytesReference bytes) {
        return bytes.length() >= 3 && bytes.get(0) == 90 && bytes.get(1) == 86 && (bytes.get(2) == 1 || bytes.get(2) == 0);
    }

    @Override
    public boolean isCompressed(ChannelBuffer buffer) {
        int offset = buffer.readerIndex();
        return buffer.readableBytes() >= 3 && buffer.getByte(offset) == 90 && buffer.getByte(offset + 1) == 86 && (buffer.getByte(offset + 2) == 1 || buffer.getByte(offset + 2) == 0);
    }

    @Override
    public boolean isCompressed(IndexInput in) throws IOException {
        long currentPointer = in.getFilePointer();
        if (in.length() - currentPointer < (long)LUCENE_HEADER.length) {
            return false;
        }
        for (int i = 0; i < LUCENE_HEADER.length; ++i) {
            if (in.readByte() == LUCENE_HEADER[i]) continue;
            in.seek(currentPointer);
            return false;
        }
        in.seek(currentPointer);
        return true;
    }

    @Override
    public StreamInput streamInput(StreamInput in) throws IOException {
        return new LZFCompressedStreamInput(in, this.decoder);
    }

    @Override
    public StreamOutput streamOutput(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("LZF is only here for back compat, no write support");
    }

    @Override
    public CompressedIndexInput indexInput(IndexInput in) throws IOException {
        return new LZFCompressedIndexInput(in, this.decoder);
    }
}

