/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

@Deprecated
public class FilteredQueryParser
implements QueryParser {
    public static final String NAME = "filtered";
    private final DeprecationLogger deprecationLogger;

    @Inject
    public FilteredQueryParser() {
        ESLogger logger = Loggers.getLogger(this.getClass());
        this.deprecationLogger = new DeprecationLogger(logger);
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        this.deprecationLogger.deprecated("The [filtered] query is deprecated, please use a [bool] query instead with a [must] clause for the query part and a [filter] clause for the filter part.", new Object[0]);
        XContentParser parser = parseContext.parser();
        Query query = Queries.newMatchAllQuery();
        Query filter = null;
        boolean filterFound = false;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    continue;
                }
                if ("filter".equals(currentFieldName)) {
                    filterFound = true;
                    filter = parseContext.parseInnerFilter();
                    continue;
                }
                throw new QueryParsingException(parseContext, "[filtered] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue() || "strategy".equals(currentFieldName)) continue;
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext, "[filtered] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (query == null) {
            return null;
        }
        BooleanQuery filteredQuery = Queries.filtered(query, filter);
        filteredQuery.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, (Query)filteredQuery);
        }
        return filteredQuery;
    }
}

