/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.support;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;

public abstract class AbstractBlobContainer
implements BlobContainer {
    private final BlobPath path;

    protected AbstractBlobContainer(BlobPath path) {
        this.path = path;
    }

    @Override
    public BlobPath path() {
        return this.path;
    }

    @Override
    public void deleteBlobsByPrefix(String blobNamePrefix) throws IOException {
        Map<String, BlobMetaData> blobs = this.listBlobsByPrefix(blobNamePrefix);
        for (BlobMetaData blob : blobs.values()) {
            this.deleteBlob(blob.name());
        }
    }

    @Override
    public void deleteBlobs(Collection<String> blobNames) throws IOException {
        for (String blob : blobNames) {
            this.deleteBlob(blob);
        }
    }
}

