/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.util.Callback;

public abstract class Streams {
    public static final int BUFFER_SIZE = 8192;

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return Streams.copy(in, out, new byte[8192]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No InputStream specified");
        Preconditions.checkNotNull((Object)out, (Object)"No OutputStream specified");
        try {
            int bytesRead;
            long byteCount = 0L;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += (long)bytesRead;
            }
            out.flush();
            long l = byteCount;
            return l;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(byte[] in, OutputStream out) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No input byte array specified");
        Preconditions.checkNotNull((Object)out, (Object)"No OutputStream specified");
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No Reader specified");
        Preconditions.checkNotNull((Object)out, (Object)"No Writer specified");
        try {
            int bytesRead;
            int byteCount = 0;
            char[] buffer = new char[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String in, Writer out) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No input String specified");
        Preconditions.checkNotNull((Object)out, (Object)"No Writer specified");
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        Streams.copy(in, (Writer)out);
        return out.toString();
    }

    public static int readFully(Reader reader, char[] dest) throws IOException {
        return Streams.readFully(reader, dest, 0, dest.length);
    }

    public static int readFully(Reader reader, char[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static int readFully(InputStream reader, byte[] dest) throws IOException {
        return Streams.readFully(reader, dest, 0, dest.length);
    }

    public static int readFully(InputStream reader, byte[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static List<String> readAllLines(InputStream input) throws IOException {
        final ArrayList<String> lines = new ArrayList<String>();
        Streams.readAllLines(input, new Callback<String>(){

            @Override
            public void handle(String line) {
                lines.add(line);
            }
        });
        return lines;
    }

    public static void readAllLines(InputStream input, Callback<String> callback) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, Charsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                callback.handle(line);
            }
        }
    }
}

