/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.NamedWriteable;

public class NamedWriteableRegistry {
    private final Map<Class<?>, InnerRegistry<?>> registry = new HashMap();

    public synchronized <T> void registerPrototype(Class<T> categoryClass, NamedWriteable<? extends T> namedWriteable) {
        InnerRegistry<Object> innerRegistry = this.registry.get(categoryClass);
        if (innerRegistry == null) {
            innerRegistry = new InnerRegistry(categoryClass);
            this.registry.put(categoryClass, innerRegistry);
        }
        ((InnerRegistry)innerRegistry).registerPrototype(namedWriteable);
    }

    public synchronized <T> NamedWriteable<? extends T> getPrototype(Class<T> categoryClass, String name) {
        InnerRegistry<?> innerRegistry = this.registry.get(categoryClass);
        if (innerRegistry == null) {
            throw new IllegalArgumentException("unknown named writeable category [" + categoryClass.getName() + "]");
        }
        return ((InnerRegistry)innerRegistry).getPrototype(name);
    }

    private static class InnerRegistry<T> {
        private final Map<String, NamedWriteable<? extends T>> registry = new HashMap<String, NamedWriteable<? extends T>>();
        private final Class<T> categoryClass;

        private InnerRegistry(Class<T> categoryClass) {
            this.categoryClass = categoryClass;
        }

        private void registerPrototype(NamedWriteable<? extends T> namedWriteable) {
            NamedWriteable<T> existingNamedWriteable = this.registry.get(namedWriteable.getWriteableName());
            if (existingNamedWriteable != null) {
                throw new IllegalArgumentException("named writeable of type [" + namedWriteable.getClass().getName() + "] with name [" + namedWriteable.getWriteableName() + "] " + "is already registered by type [" + existingNamedWriteable.getClass().getName() + "] within category [" + this.categoryClass.getName() + "]");
            }
            this.registry.put(namedWriteable.getWriteableName(), namedWriteable);
        }

        private NamedWriteable<? extends T> getPrototype(String name) {
            NamedWriteable<? extends T> namedWriteable = this.registry.get(name);
            if (namedWriteable == null) {
                throw new IllegalArgumentException("unknown named writeable with name [" + name + "] within category [" + this.categoryClass.getName() + "]");
            }
            return namedWriteable;
        }
    }
}

