/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.ObjectFloatHashMap;
import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.nio.file.Path;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.TransportNodesListGatewayMetaState;

public class Gateway
extends AbstractComponent
implements ClusterStateListener {
    private final ClusterService clusterService;
    private final NodeEnvironment nodeEnv;
    private final GatewayMetaState metaState;
    private final TransportNodesListGatewayMetaState listGatewayMetaState;
    private final String initialMeta;
    private final ClusterName clusterName;

    @Inject
    public Gateway(Settings settings, ClusterService clusterService, NodeEnvironment nodeEnv, GatewayMetaState metaState, TransportNodesListGatewayMetaState listGatewayMetaState, ClusterName clusterName) {
        super(settings);
        this.clusterService = clusterService;
        this.nodeEnv = nodeEnv;
        this.metaState = metaState;
        this.listGatewayMetaState = listGatewayMetaState;
        this.clusterName = clusterName;
        clusterService.addLast(this);
        this.initialMeta = settings.get("gateway.initial_meta", settings.get("gateway.local.initial_meta", settings.get("discovery.zen.minimum_master_nodes", "1")));
    }

    public void performStateRecovery(GatewayStateRecoveredListener listener) throws GatewayException {
        ObjectHashSet nodesIds = new ObjectHashSet(this.clusterService.state().nodes().masterNodes().keys());
        this.logger.trace("performing state recovery from {}", nodesIds);
        TransportNodesListGatewayMetaState.NodesGatewayMetaState nodesState = this.listGatewayMetaState.list((String[])nodesIds.toArray(String.class), null).actionGet();
        int requiredAllocation = this.calcRequiredAllocations(this.initialMeta, nodesIds.size());
        if (nodesState.failures().length > 0) {
            for (FailedNodeException failedNodeException : nodesState.failures()) {
                this.logger.warn("failed to fetch state from node", failedNodeException, new Object[0]);
            }
        }
        ObjectFloatHashMap indices = new ObjectFloatHashMap();
        MetaData electedGlobalState = null;
        int found = 0;
        for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState) {
            if (nodeState.metaData() == null) continue;
            ++found;
            if (electedGlobalState == null) {
                electedGlobalState = nodeState.metaData();
            } else if (nodeState.metaData().version() > electedGlobalState.version()) {
                electedGlobalState = nodeState.metaData();
            }
            for (ObjectCursor cursor : nodeState.metaData().indices().values()) {
                indices.addTo((Object)((IndexMetaData)cursor.value).getIndex(), 1.0f);
            }
        }
        if (found < requiredAllocation) {
            listener.onFailure("found [" + found + "] metadata states, required [" + requiredAllocation + "]");
            return;
        }
        MetaData.Builder metaDataBuilder = MetaData.builder(electedGlobalState).removeAllIndices();
        assert (!indices.containsKey(null));
        Object[] keys = indices.keys;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            String index = (String)keys[i];
            IndexMetaData electedIndexMetaData = null;
            int indexMetaDataCount = 0;
            for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState) {
                IndexMetaData indexMetaData;
                if (nodeState.metaData() == null || (indexMetaData = nodeState.metaData().index(index)) == null) continue;
                if (electedIndexMetaData == null) {
                    electedIndexMetaData = indexMetaData;
                } else if (indexMetaData.getVersion() > electedIndexMetaData.getVersion()) {
                    electedIndexMetaData = indexMetaData;
                }
                ++indexMetaDataCount;
            }
            if (electedIndexMetaData == null) continue;
            if (indexMetaDataCount < requiredAllocation) {
                this.logger.debug("[{}] found [{}], required [{}], not adding", index, indexMetaDataCount, requiredAllocation);
            }
            metaDataBuilder.put(electedIndexMetaData, false);
        }
        ClusterState.Builder builder = ClusterState.builder(this.clusterName);
        builder.metaData(metaDataBuilder);
        listener.onSuccess(builder.build());
    }

    protected int calcRequiredAllocations(String setting, int nodeCount) {
        int requiredAllocation = 1;
        try {
            if ("quorum".equals(setting)) {
                if (nodeCount > 2) {
                    requiredAllocation = nodeCount / 2 + 1;
                }
            } else if ("quorum-1".equals(setting) || "half".equals(setting)) {
                if (nodeCount > 2) {
                    requiredAllocation = (1 + nodeCount) / 2;
                }
            } else if ("one".equals(setting)) {
                requiredAllocation = 1;
            } else if ("full".equals(setting) || "all".equals(setting)) {
                requiredAllocation = nodeCount;
            } else if ("full-1".equals(setting) || "all-1".equals(setting)) {
                if (nodeCount > 1) {
                    requiredAllocation = nodeCount - 1;
                }
            } else {
                requiredAllocation = Integer.parseInt(setting);
            }
        }
        catch (Exception e) {
            this.logger.warn("failed to derived initial_meta from value {}", setting);
        }
        return requiredAllocation;
    }

    public void reset() throws Exception {
        try {
            Object[] dataPaths = this.nodeEnv.nodeDataPaths();
            this.logger.trace("removing node data paths: [{}]", dataPaths);
            IOUtils.rm((Path[])dataPaths);
        }
        catch (Exception ex) {
            this.logger.debug("failed to delete shard locations", ex, new Object[0]);
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        this.metaState.clusterChanged(event);
    }

    public static interface GatewayStateRecoveredListener {
        public void onSuccess(ClusterState var1);

        public void onFailure(String var1);
    }
}

