/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;

public class RangeQueryBuilder
extends MultiTermQueryBuilder
implements BoostableQueryBuilder<RangeQueryBuilder> {
    private final String name;
    private Object from;
    private Object to;
    private String timeZone;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private float boost = -1.0f;
    private String queryName;
    private String format;

    public RangeQueryBuilder(String name) {
        this.name = name;
    }

    public RangeQueryBuilder from(Object from) {
        this.from = from;
        return this;
    }

    public RangeQueryBuilder from(String from) {
        this.from = from;
        return this;
    }

    public RangeQueryBuilder from(int from) {
        this.from = from;
        return this;
    }

    public RangeQueryBuilder from(long from) {
        this.from = from;
        return this;
    }

    public RangeQueryBuilder from(float from) {
        this.from = Float.valueOf(from);
        return this;
    }

    public RangeQueryBuilder from(double from) {
        this.from = from;
        return this;
    }

    public RangeQueryBuilder gt(String from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(Object from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(int from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(long from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(float from) {
        this.from = Float.valueOf(from);
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(double from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gte(String from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(Object from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(int from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(long from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(float from) {
        this.from = Float.valueOf(from);
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(double from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder to(Object to) {
        this.to = to;
        return this;
    }

    public RangeQueryBuilder to(String to) {
        this.to = to;
        return this;
    }

    public RangeQueryBuilder to(int to) {
        this.to = to;
        return this;
    }

    public RangeQueryBuilder to(long to) {
        this.to = to;
        return this;
    }

    public RangeQueryBuilder to(float to) {
        this.to = Float.valueOf(to);
        return this;
    }

    public RangeQueryBuilder to(double to) {
        this.to = to;
        return this;
    }

    public RangeQueryBuilder lt(String to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(Object to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(int to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(long to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(float to) {
        this.to = Float.valueOf(to);
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(double to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lte(String to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(Object to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(int to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(long to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(float to) {
        this.to = Float.valueOf(to);
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(double to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public RangeQueryBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    @Override
    public RangeQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public RangeQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public RangeQueryBuilder timeZone(String timezone) {
        this.timeZone = timezone;
        return this;
    }

    public RangeQueryBuilder format(String format) {
        this.format = format;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("range");
        builder.startObject(this.name);
        builder.field("from", this.from);
        builder.field("to", this.to);
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone);
        }
        if (this.format != null) {
            builder.field("format", this.format);
        }
        builder.field("include_lower", this.includeLower);
        builder.field("include_upper", this.includeUpper);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

