/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class OsStats
implements Streamable,
ToXContent {
    long timestamp;
    Short cpuPercent = null;
    double loadAverage = -1.0;
    Mem mem = null;
    Swap swap = null;

    OsStats() {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Short getCpuPercent() {
        return this.cpuPercent;
    }

    public double getLoadAverage() {
        return this.loadAverage;
    }

    public Mem getMem() {
        return this.mem;
    }

    public Swap getSwap() {
        return this.swap;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.OS);
        builder.field(Fields.TIMESTAMP, this.getTimestamp());
        if (this.getCpuPercent() != null) {
            builder.field(Fields.PERCENT, (Object)this.getCpuPercent());
        }
        builder.field(Fields.LOAD_AVERAGE, this.getLoadAverage());
        if (this.mem != null) {
            builder.startObject(Fields.MEM);
            builder.byteSizeField(Fields.TOTAL_IN_BYTES, Fields.TOTAL, this.mem.getTotal());
            builder.byteSizeField(Fields.FREE_IN_BYTES, Fields.FREE, this.mem.getFree());
            builder.byteSizeField(Fields.USED_IN_BYTES, Fields.USED, this.mem.getUsed());
            builder.field(Fields.FREE_PERCENT, (int)this.mem.getFreePercent());
            builder.field(Fields.USED_PERCENT, (int)this.mem.getUsedPercent());
            builder.endObject();
        }
        if (this.swap != null) {
            builder.startObject(Fields.SWAP);
            builder.byteSizeField(Fields.TOTAL_IN_BYTES, Fields.TOTAL, this.swap.getTotal());
            builder.byteSizeField(Fields.FREE_IN_BYTES, Fields.FREE, this.swap.getFree());
            builder.byteSizeField(Fields.USED_IN_BYTES, Fields.USED, this.swap.getUsed());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static OsStats readOsStats(StreamInput in) throws IOException {
        OsStats stats = new OsStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_2_2_0)) {
            this.cpuPercent = in.readBoolean() ? Short.valueOf(in.readShort()) : null;
        }
        this.loadAverage = in.readDouble();
        if (in.readBoolean()) {
            this.mem = Mem.readMem(in);
        }
        if (in.readBoolean()) {
            this.swap = Swap.readSwap(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
            out.writeBoolean(this.cpuPercent != null);
            if (this.cpuPercent != null) {
                out.writeShort(this.cpuPercent);
            }
        }
        out.writeDouble(this.loadAverage);
        if (this.mem == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mem.writeTo(out);
        }
        if (this.swap == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.swap.writeTo(out);
        }
    }

    private static short calculatePercentage(long used, long max) {
        return max <= 0L ? (short)0 : (short)Math.round(100.0 * (double)used / (double)max);
    }

    public static class Mem
    implements Streamable {
        long total = -1L;
        long free = -1L;

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.total = in.readLong();
            this.free = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
            out.writeLong(this.free);
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.total - this.free);
        }

        public short getUsedPercent() {
            return OsStats.calculatePercentage(this.getUsed().bytes(), this.getTotal().bytes());
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public short getFreePercent() {
            return OsStats.calculatePercentage(this.getFree().bytes(), this.getTotal().bytes());
        }
    }

    public static class Swap
    implements Streamable {
        long total = -1L;
        long free = -1L;

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.total - this.free);
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        public static Swap readSwap(StreamInput in) throws IOException {
            Swap swap = new Swap();
            swap.readFrom(in);
            return swap;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.total = in.readLong();
            this.free = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
            out.writeLong(this.free);
        }
    }

    static final class Fields {
        static final XContentBuilderString OS = new XContentBuilderString("os");
        static final XContentBuilderString TIMESTAMP = new XContentBuilderString("timestamp");
        static final XContentBuilderString PERCENT = new XContentBuilderString("cpu_percent");
        static final XContentBuilderString LOAD_AVERAGE = new XContentBuilderString("load_average");
        static final XContentBuilderString MEM = new XContentBuilderString("mem");
        static final XContentBuilderString SWAP = new XContentBuilderString("swap");
        static final XContentBuilderString FREE = new XContentBuilderString("free");
        static final XContentBuilderString FREE_IN_BYTES = new XContentBuilderString("free_in_bytes");
        static final XContentBuilderString USED = new XContentBuilderString("used");
        static final XContentBuilderString USED_IN_BYTES = new XContentBuilderString("used_in_bytes");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_IN_BYTES = new XContentBuilderString("total_in_bytes");
        static final XContentBuilderString FREE_PERCENT = new XContentBuilderString("free_percent");
        static final XContentBuilderString USED_PERCENT = new XContentBuilderString("used_percent");

        Fields() {
        }
    }
}

